// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: HeapParameters.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import org.graalvm.compiler.options.*;
import org.graalvm.compiler.options.OptionType;

public class HeapParameters_OptionDescriptors implements OptionDescriptors {
    @Override
    public OptionDescriptor get(String value) {
        switch (value) {
        // CheckStyle: stop line length check
        case "AlignedHeapChunkSize": {
            return OptionDescriptor.create(
                /*name*/ "AlignedHeapChunkSize",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of an aligned chunk.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "AlignedHeapChunkSize",
                /*option*/ HeapParameters.Options.AlignedHeapChunkSize,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "CollectYoungGenerationSeparately": {
            return OptionDescriptor.create(
                /*name*/ "CollectYoungGenerationSeparately",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Determines if a full GC collects the young generation separately or together with the old generation.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "CollectYoungGenerationSeparately",
                /*option*/ HeapParameters.Options.CollectYoungGenerationSeparately,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LargeArrayThreshold": {
            return OptionDescriptor.create(
                /*name*/ "LargeArrayThreshold",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Long.class,
                /*help*/ "The size at or above which an array will be allocated in its own unaligned chunk.  0 implies (AlignedHeapChunkSize / 8).",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "LargeArrayThreshold",
                /*option*/ HeapParameters.Options.LargeArrayThreshold,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxHeapFree": {
            return OptionDescriptor.create(
                /*name*/ "MaxHeapFree",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Long.class,
                /*help*/ "The maximum free bytes reserved for allocations, in bytes (0 for automatic according to GC policy).",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "MaxHeapFree",
                /*option*/ HeapParameters.Options.MaxHeapFree,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxSurvivorSpaces": {
            return OptionDescriptor.create(
                /*name*/ "MaxSurvivorSpaces",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Maximum number of survivor spaces.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "MaxSurvivorSpaces",
                /*option*/ HeapParameters.Options.MaxSurvivorSpaces,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumHeapSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumHeapSizePercent",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum heap size as percent of physical memory",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "MaximumHeapSizePercent",
                /*option*/ HeapParameters.Options.MaximumHeapSizePercent,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumYoungGenerationSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumYoungGenerationSizePercent",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum size of the young generation as a percentage of the maximum heap size",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "MaximumYoungGenerationSizePercent",
                /*option*/ HeapParameters.Options.MaximumYoungGenerationSizePercent,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "TraceHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "TraceHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Trace heap chunks during collections, if +VerboseGC and +PrintHeapShape.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "TraceHeapChunks",
                /*option*/ HeapParameters.Options.TraceHeapChunks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fill unused memory chunks with a sentinel value.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "ZapChunks",
                /*option*/ HeapParameters.Options.ZapChunks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapConsumedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapConsumedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "After use, Fill memory chunks with a sentinel value.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "ZapConsumedHeapChunks",
                /*option*/ HeapParameters.Options.ZapConsumedHeapChunks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapProducedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapProducedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Before use, fill memory chunks with a sentinel value.",
                /*declaringClass*/ HeapParameters.Options.class,
                /*fieldName*/ "ZapProducedHeapChunks",
                /*option*/ HeapParameters.Options.ZapProducedHeapChunks,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<OptionDescriptor>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 11;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlignedHeapChunkSize");
                    case 1: return get("CollectYoungGenerationSeparately");
                    case 2: return get("LargeArrayThreshold");
                    case 3: return get("MaxHeapFree");
                    case 4: return get("MaxSurvivorSpaces");
                    case 5: return get("MaximumHeapSizePercent");
                    case 6: return get("MaximumYoungGenerationSizePercent");
                    case 7: return get("TraceHeapChunks");
                    case 8: return get("ZapChunks");
                    case 9: return get("ZapConsumedHeapChunks");
                    case 10: return get("ZapProducedHeapChunks");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
