/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.graal.meta;

import com.oracle.svm.graal.meta.SubstrateType;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;

public class SubstrateSignature
implements Signature {
    private Object parameterTypes;
    private SubstrateType returnType;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public SubstrateSignature() {
    }

    public SubstrateSignature(SubstrateType[] parameterTypes, SubstrateType returnType) {
        this.setTypes(parameterTypes, returnType);
    }

    public void setTypes(SubstrateType[] parameterTypes, SubstrateType returnType) {
        this.parameterTypes = parameterTypes.length == 0 ? null : (parameterTypes.length == 1 ? parameterTypes[0] : parameterTypes);
        this.returnType = returnType;
    }

    @Platforms(value={Platform.HOSTED_ONLY.class})
    public Object getRawParameterTypes() {
        return this.parameterTypes;
    }

    public int getParameterCount(boolean withReceiver) {
        int result = this.parameterTypes == null ? 0 : (this.parameterTypes instanceof SubstrateType ? 1 : ((SubstrateType[])this.parameterTypes).length);
        if (withReceiver) {
            ++result;
        }
        return result;
    }

    public SubstrateType getParameterType(int index, ResolvedJavaType accessingClass) {
        if (this.parameterTypes instanceof SubstrateType) {
            assert (index == 0);
            return (SubstrateType)this.parameterTypes;
        }
        return ((SubstrateType[])this.parameterTypes)[index];
    }

    public SubstrateType getReturnType(ResolvedJavaType accessingClass) {
        return this.returnType;
    }
}

