/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.HostVM;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.constraints.UnsupportedFeatureException;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.AnalysisUniverse;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.graal.pointsto.phases.InlineBeforeAnalysisPolicy;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.RuntimeAssertionsSupport;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.annotate.NeverInline;
import com.oracle.svm.core.annotate.UnknownClass;
import com.oracle.svm.core.annotate.UnknownObjectField;
import com.oracle.svm.core.annotate.UnknownPrimitiveField;
import com.oracle.svm.core.classinitialization.EnsureClassInitializedNode;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallLinkage;
import com.oracle.svm.core.graal.meta.SubstrateForeignCallsProvider;
import com.oracle.svm.core.graal.stackvalue.StackValueNode;
import com.oracle.svm.core.graal.thread.VMThreadLocalAccess;
import com.oracle.svm.core.heap.StoredContinuation;
import com.oracle.svm.core.heap.Target_java_lang_ref_Reference;
import com.oracle.svm.core.hub.DynamicHub;
import com.oracle.svm.core.hub.HubType;
import com.oracle.svm.core.hub.ReferenceType;
import com.oracle.svm.core.jdk.ClassLoaderSupport;
import com.oracle.svm.core.jdk.RecordSupport;
import com.oracle.svm.core.jdk.SealedClassSupport;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.LocatableMultiOptionValue;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.HostedStringDeduplication;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.BootLoaderSupport;
import com.oracle.svm.hosted.ClassLoaderFeature;
import com.oracle.svm.hosted.ImageSingletonsSupportImpl;
import com.oracle.svm.hosted.ModuleAccess;
import com.oracle.svm.hosted.NativeImageOptions;
import com.oracle.svm.hosted.NativeImageSystemClassLoader;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.code.InliningUtilities;
import com.oracle.svm.hosted.meta.HostedType;
import com.oracle.svm.hosted.phases.AnalysisGraphBuilderPhase;
import com.oracle.svm.hosted.phases.ImplicitAssertionsPhase;
import com.oracle.svm.hosted.phases.InlineBeforeAnalysisPolicyImpl;
import com.oracle.svm.hosted.substitute.UnsafeAutomaticSubstitutionProcessor;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.core.common.spi.ForeignCallsProvider;
import org.graalvm.compiler.debug.MethodFilter;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.java.GraphBuilderPhase;
import org.graalvm.compiler.nodes.StaticDeoptimizingNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.extended.UnsafeAccessNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.IntrinsicContext;
import org.graalvm.compiler.nodes.java.AccessFieldNode;
import org.graalvm.compiler.nodes.spi.CoreProviders;
import org.graalvm.compiler.options.Option;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.compiler.phases.OptimisticOptimizations;
import org.graalvm.compiler.phases.common.BoxNodeIdentityPhase;
import org.graalvm.compiler.phases.common.CanonicalizerPhase;
import org.graalvm.compiler.serviceprovider.JavaVersionUtil;
import org.graalvm.compiler.virtual.phases.ea.PartialEscapePhase;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.function.RelocatedPointer;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.util.GuardedAnnotationAccess;

public class SVMHost
implements HostVM {
    private final ConcurrentHashMap<AnalysisType, DynamicHub> typeToHub = new ConcurrentHashMap();
    private final ConcurrentHashMap<DynamicHub, AnalysisType> hubToType = new ConcurrentHashMap();
    private final Map<String, EnumSet<AnalysisType.UsageKind>> forbiddenTypes;
    private final Platform platform;
    private final OptionValues options;
    private final ClassLoader classLoader;
    private final ClassInitializationSupport classInitializationSupport;
    private final HostedStringDeduplication stringTable;
    private final UnsafeAutomaticSubstitutionProcessor automaticSubstitutions;
    private final List<BiConsumer<Feature.DuringAnalysisAccess, Class<?>>> classReachabilityListeners;
    private ConcurrentMap<AnalysisMethod, StructuredGraph> analysisGraphs;
    private final ConcurrentMap<AnalysisMethod, Boolean> containsStackValueNode = new ConcurrentHashMap<AnalysisMethod, Boolean>();
    private final ConcurrentMap<AnalysisMethod, Boolean> classInitializerSideEffect = new ConcurrentHashMap<AnalysisMethod, Boolean>();
    private final ConcurrentMap<AnalysisMethod, Set<AnalysisType>> initializedClasses = new ConcurrentHashMap<AnalysisMethod, Set<AnalysisType>>();
    private final ConcurrentMap<AnalysisMethod, Boolean> analysisTrivialMethods = new ConcurrentHashMap<AnalysisMethod, Boolean>();
    private static final Method getNestHostMethod = JavaVersionUtil.JAVA_SPEC >= 11 ? ReflectionUtil.lookupMethod(Class.class, (String)"getNestHost", (Class[])new Class[0]) : null;
    private final boolean parseOnce = SubstrateOptions.parseOnce();
    private final List<BiConsumer<AnalysisMethod, StructuredGraph>> methodAfterParsingHooks = new CopyOnWriteArrayList<BiConsumer<AnalysisMethod, StructuredGraph>>();
    private final InlineBeforeAnalysisPolicy<?> inlineBeforeAnalysisPolicy = new InlineBeforeAnalysisPolicyImpl();

    public SVMHost(OptionValues options, ClassLoader classLoader, ClassInitializationSupport classInitializationSupport, UnsafeAutomaticSubstitutionProcessor automaticSubstitutions, Platform platform) {
        this.options = options;
        this.classLoader = classLoader;
        this.classInitializationSupport = classInitializationSupport;
        this.stringTable = HostedStringDeduplication.singleton();
        this.classReachabilityListeners = new ArrayList();
        this.forbiddenTypes = SVMHost.setupForbiddenTypes(options);
        this.automaticSubstitutions = automaticSubstitutions;
        this.platform = platform;
    }

    private static Map<String, EnumSet<AnalysisType.UsageKind>> setupForbiddenTypes(OptionValues options) {
        List forbiddenTypesOptionValues = ((LocatableMultiOptionValue.Strings)SubstrateOptions.ReportAnalysisForbiddenType.getValue(options)).values();
        HashMap<String, EnumSet<AnalysisType.UsageKind>> forbiddenTypes = new HashMap<String, EnumSet<AnalysisType.UsageKind>>();
        for (String forbiddenTypesOptionValue : forbiddenTypesOptionValues) {
            EnumSet<AnalysisType.UsageKind> usageKinds;
            String[] typeNameUsageKind = forbiddenTypesOptionValue.split(":", 2);
            if (typeNameUsageKind.length == 1) {
                usageKinds = EnumSet.allOf(AnalysisType.UsageKind.class);
            } else {
                String[] usageKindValues;
                usageKinds = EnumSet.noneOf(AnalysisType.UsageKind.class);
                for (String usageKindValue : usageKindValues = typeNameUsageKind[1].split(",")) {
                    usageKinds.add(AnalysisType.UsageKind.valueOf((String)usageKindValue));
                }
            }
            forbiddenTypes.put(typeNameUsageKind[0], usageKinds);
        }
        return forbiddenTypes.isEmpty() ? null : forbiddenTypes;
    }

    public void checkForbidden(AnalysisType type, AnalysisType.UsageKind kind) {
        if (this.forbiddenTypes == null) {
            return;
        }
        for (AnalysisType cur = type; cur != null; cur = cur.getSuperclass()) {
            EnumSet<AnalysisType.UsageKind> forbiddenType = this.forbiddenTypes.get(cur.getWrapped().toJavaName());
            if (forbiddenType == null || !forbiddenType.contains(kind)) continue;
            throw new UnsupportedFeatureException("Forbidden type " + cur.getWrapped().toJavaName() + (cur.equals((Object)type) ? "" : " (superclass of " + type.getWrapped().toJavaName() + ")") + " UsageKind: " + kind);
        }
    }

    public OptionValues options() {
        return this.options;
    }

    public GraphBuilderPhase.Instance createGraphBuilderPhase(HostedProviders providers, GraphBuilderConfiguration graphBuilderConfig, OptimisticOptimizations optimisticOpts, IntrinsicContext initialIntrinsicContext) {
        return new AnalysisGraphBuilderPhase((CoreProviders)providers, graphBuilderConfig, optimisticOpts, initialIntrinsicContext, providers.getWordTypes());
    }

    public String inspectServerContentPath() {
        return (String)PointstoOptions.InspectServerContentPath.getValue(this.options);
    }

    public void warn(String message) {
        System.err.println("warning: " + message);
    }

    public String getImageName() {
        return (String)SubstrateOptions.Name.getValue(this.options);
    }

    public boolean isRelocatedPointer(Object originalObject) {
        return originalObject instanceof RelocatedPointer;
    }

    public void clearInThread() {
    }

    public void installInThread(Object vmConfig) {
        Thread.currentThread().setContextClassLoader(this.classLoader);
        assert (vmConfig == ImageSingletonsSupportImpl.HostedManagement.get());
    }

    public Object getConfiguration() {
        return ImageSingletonsSupportImpl.HostedManagement.getAndAssertExists();
    }

    public void registerType(AnalysisType analysisType) {
        DynamicHub hub = this.createHub(analysisType);
        DynamicHub existing = this.typeToHub.put(analysisType, hub);
        assert (existing == null);
        existing = this.hubToType.put(hub, analysisType);
        assert (existing == null);
    }

    public void initializeType(AnalysisType analysisType) {
        Package packageValue;
        ClassLoader runtimeClassLoader;
        if (!analysisType.isReachable()) {
            throw VMError.shouldNotReachHere("Registering and initializing a type that was not yet marked as reachable: " + analysisType);
        }
        this.classInitializationSupport.maybeInitializeHosted((ResolvedJavaType)analysisType);
        Class javaClass = analysisType.getJavaClass();
        ClassLoader classloader = javaClass.getClassLoader();
        if (classloader == null) {
            classloader = BootLoaderSupport.getBootLoader();
        }
        if ((runtimeClassLoader = ClassLoaderFeature.getRuntimeClassLoader(classloader)) != null && (packageValue = javaClass.getPackage()) != null) {
            DynamicHub typeHub = this.typeToHub.get(analysisType);
            String packageName = typeHub.getPackageName();
            ClassLoaderSupport.registerPackage(runtimeClassLoader, packageName, packageValue);
        }
        this.automaticSubstitutions.computeSubstitutions(this, GraalAccess.getOriginalProviders().getMetaAccess().lookupJavaType(analysisType.getJavaClass()), this.options);
    }

    public boolean isInitialized(AnalysisType type) {
        boolean shouldInitializeAtRuntime = this.classInitializationSupport.shouldInitializeAtRuntime((ResolvedJavaType)type);
        assert (shouldInitializeAtRuntime || type.getWrapped().isInitialized()) : "Types that are not marked for runtime initializations must have been initialized: " + type;
        return !shouldInitializeAtRuntime;
    }

    public GraphBuilderConfiguration updateGraphBuilderConfiguration(GraphBuilderConfiguration config, AnalysisMethod method) {
        return config.withRetainLocalVariables(this.retainLocalVariables());
    }

    private boolean retainLocalVariables() {
        if (this.parseOnce) {
            return SubstrateOptions.Optimize.getValue() <= 0;
        }
        return true;
    }

    public Optional<AnalysisMethod> handleForeignCall(ForeignCallDescriptor foreignCallDescriptor, ForeignCallsProvider foreignCallsProvider) {
        SubstrateForeignCallsProvider foreignCalls = (SubstrateForeignCallsProvider)foreignCallsProvider;
        Optional<AnalysisMethod> targetMethod = Optional.empty();
        if (foreignCalls.getForeignCalls().size() > 0) {
            SubstrateForeignCallLinkage linkage = foreignCalls.lookupForeignCall(foreignCallDescriptor);
            targetMethod = Optional.of((AnalysisMethod)linkage.getMethod());
        }
        return targetMethod;
    }

    public DynamicHub dynamicHub(ResolvedJavaType type) {
        AnalysisType aType;
        if (type instanceof AnalysisType) {
            aType = (AnalysisType)type;
        } else if (type instanceof HostedType) {
            aType = ((HostedType)type).getWrapped();
        } else {
            throw VMError.shouldNotReachHere("Found unsupported type: " + type);
        }
        return this.typeToHub.get(aType);
    }

    public AnalysisType lookupType(DynamicHub hub) {
        assert (hub != null) : "Hub must not be null";
        return this.hubToType.get(hub);
    }

    private DynamicHub createHub(AnalysisType type) {
        DynamicHub superHub = null;
        if (type.isInstanceClass() && type.getSuperclass() != null || type.isArray()) {
            superHub = this.dynamicHub((ResolvedJavaType)type.getSuperclass());
        }
        DynamicHub componentHub = null;
        if (type.isArray()) {
            componentHub = this.dynamicHub((ResolvedJavaType)type.getComponentType());
        }
        Class javaClass = type.getJavaClass();
        int modifiers = javaClass.getModifiers();
        ClassLoader hubClassLoader = javaClass.getClassLoader();
        String className = type.toClassName().intern();
        String sourceFileName = this.stringTable.deduplicate(type.getSourceFileName(), true);
        Class nestHost = null;
        if (JavaVersionUtil.JAVA_SPEC >= 11) {
            try {
                nestHost = (Class)getNestHostMethod.invoke((Object)javaClass, new Object[0]);
            }
            catch (ReflectiveOperationException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
        }
        boolean isHidden = SubstrateUtil.isHiddenClass(javaClass);
        boolean isRecord = RecordSupport.singleton().isRecord(javaClass);
        boolean assertionStatus = RuntimeAssertionsSupport.singleton().desiredAssertionStatus(javaClass);
        boolean isSealed = SealedClassSupport.singleton().isSealed(javaClass);
        DynamicHub dynamicHub = new DynamicHub(javaClass, className, SVMHost.computeHubType(type), SVMHost.computeReferenceType(type), SVMHost.isLocalClass(javaClass), SVMHost.isAnonymousClass(javaClass), superHub, componentHub, sourceFileName, modifiers, hubClassLoader, isHidden, isRecord, nestHost, assertionStatus, type.hasDefaultMethods(), type.declaresDefaultMethods(), isSealed);
        if (JavaVersionUtil.JAVA_SPEC > 8) {
            ModuleAccess.extractAndSetModule(dynamicHub, javaClass);
        }
        return dynamicHub;
    }

    private static Object isLocalClass(Class<?> javaClass) {
        try {
            return javaClass.isLocalClass();
        }
        catch (InternalError e) {
            return e;
        }
        catch (LinkageError e) {
            if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                return e;
            }
            return SVMHost.unsupportedMethod(javaClass, "isLocalClass");
        }
    }

    private static Object isAnonymousClass(Class<?> javaClass) {
        try {
            return javaClass.isAnonymousClass();
        }
        catch (InternalError e) {
            return e;
        }
        catch (LinkageError e) {
            if (NativeImageOptions.AllowIncompleteClasspath.getValue().booleanValue()) {
                return e;
            }
            return SVMHost.unsupportedMethod(javaClass, "isAnonymousClass");
        }
    }

    private static Object unsupportedMethod(Class<?> javaClass, String methodName) {
        String message = "Discovered a type for which " + methodName + " can't be called: " + javaClass.getTypeName() + ". To avoid this issue at build time use the " + SubstrateOptionsParser.commandArgument(NativeImageOptions.AllowIncompleteClasspath, "+") + " option. The LinkageError will then be reported at run time when this method is called for the first time.";
        throw new UnsupportedFeatureException(message);
    }

    public static boolean isUnknownClass(ResolvedJavaType resolvedJavaType) {
        return resolvedJavaType.getAnnotation(UnknownClass.class) != null;
    }

    public static boolean isUnknownObjectField(ResolvedJavaField resolvedJavaField) {
        return resolvedJavaField.getAnnotation(UnknownObjectField.class) != null;
    }

    public static boolean isUnknownPrimitiveField(AnalysisField field) {
        return field.getAnnotation(UnknownPrimitiveField.class) != null;
    }

    public void registerClassReachabilityListener(BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener) {
        this.classReachabilityListeners.add(listener);
    }

    public void notifyClassReachabilityListener(AnalysisUniverse universe, Feature.DuringAnalysisAccess access) {
        for (AnalysisType type : universe.getTypes()) {
            if (!type.isReachable() || type.getReachabilityListenerNotified()) continue;
            type.setReachabilityListenerNotified(true);
            for (BiConsumer<Feature.DuringAnalysisAccess, Class<?>> listener : this.classReachabilityListeners) {
                listener.accept(access, type.getJavaClass());
            }
        }
    }

    public ClassInitializationSupport getClassInitializationSupport() {
        return this.classInitializationSupport;
    }

    public UnsafeAutomaticSubstitutionProcessor getAutomaticSubstitutionProcessor() {
        return this.automaticSubstitutions;
    }

    private static HubType computeHubType(AnalysisType type) {
        if (type.isArray()) {
            if (type.getComponentType().isPrimitive() || type.getComponentType().isWordType()) {
                return HubType.TypeArray;
            }
            return HubType.ObjectArray;
        }
        if (type.isInstanceClass()) {
            if (Reference.class.isAssignableFrom(type.getJavaClass())) {
                return HubType.InstanceReference;
            }
            if (type.getJavaClass().equals(StoredContinuation.class)) {
                return HubType.StoredContinuation;
            }
            assert (!Target_java_lang_ref_Reference.class.isAssignableFrom(type.getJavaClass())) : "should not see substitution type here";
            return HubType.Instance;
        }
        return HubType.Other;
    }

    private static ReferenceType computeReferenceType(AnalysisType type) {
        Class clazz = type.getJavaClass();
        if (PhantomReference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Phantom;
        }
        if (WeakReference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Weak;
        }
        if (SoftReference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Soft;
        }
        if (Reference.class.isAssignableFrom(clazz)) {
            return ReferenceType.Other;
        }
        return ReferenceType.None;
    }

    public void checkType(ResolvedJavaType type, AnalysisUniverse universe) {
        Class originalClass = OriginalClassProvider.getJavaClass((SnippetReflectionProvider)universe.getOriginalSnippetReflection(), (ResolvedJavaType)type);
        ClassLoader originalClassLoader = originalClass.getClassLoader();
        if (NativeImageSystemClassLoader.singleton().isDisallowedClassLoader(originalClassLoader)) {
            String message = "Class " + originalClass.getName() + " was loaded by " + originalClassLoader + " and not by the current image class loader " + this.classLoader + ". ";
            message = message + "This usually means that some objects from a previous build leaked in the current build. ";
            message = message + "This can happen when using the image build server. ";
            message = message + "To fix the issue you must reset all static state from the bootclasspath and application classpath that points to the application objects. ";
            message = message + "If the offending code is in JDK code please file a bug with GraalVM. ";
            throw new UnsupportedFeatureException(message);
        }
    }

    public void addMethodAfterParsingHook(BiConsumer<AnalysisMethod, StructuredGraph> methodAfterParsingHook) {
        this.methodAfterParsingHooks.add(methodAfterParsingHook);
    }

    public void methodAfterParsingHook(BigBang bb, AnalysisMethod method, StructuredGraph graph) {
        if (graph != null) {
            graph.setGuardsStage(StructuredGraph.GuardsStage.FIXED_DEOPTS);
            if (this.parseOnce) {
                this.optimizeAfterParsing(bb, graph);
            }
            for (BiConsumer<AnalysisMethod, StructuredGraph> methodAfterParsingHook : this.methodAfterParsingHooks) {
                methodAfterParsingHook.accept(method, graph);
            }
        }
    }

    protected void optimizeAfterParsing(BigBang bb, StructuredGraph graph) {
        new ImplicitAssertionsPhase().apply(graph, bb.getProviders());
        new BoxNodeIdentityPhase().apply(graph, (Object)bb.getProviders());
        new PartialEscapePhase(false, false, CanonicalizerPhase.create(), null, this.options).apply(graph, (Object)bb.getProviders());
        CanonicalizerPhase.create().apply(graph, (Object)bb.getProviders());
    }

    public void methodBeforeTypeFlowCreationHook(PointsToAnalysis bb, AnalysisMethod method, StructuredGraph graph) {
        ValueNode receiver;
        if (method.isEntryPoint() && !Modifier.isStatic(graph.method().getModifiers()) && (receiver = graph.start().stateAfter().localAt(0)) != null && receiver.hasUsages()) {
            bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, "Entry point is non-static and uses its receiver: " + method.format("%r %H.%n(%p)"));
        }
        if (!NativeImageOptions.ReportUnsupportedElementsAtRuntime.getValue().booleanValue()) {
            for (Node n : graph.getNodes()) {
                StaticDeoptimizingNode node;
                if (!(n instanceof StaticDeoptimizingNode) || (node = (StaticDeoptimizingNode)n).getReason() != DeoptimizationReason.JavaSubroutineMismatch) continue;
                bb.getUnsupportedFeatures().addMessage(method.format("%H.%n(%p)"), method, "The bytecodes of the method " + method.format("%H.%n(%p)") + " contain a JSR/RET structure that could not be simplified by the compiler. The JSR bytecode is unused and deprecated since Java 6. Please recompile your application with a newer Java compiler." + System.lineSeparator() + "To diagnose the issue, you can add the option " + SubstrateOptionsParser.commandArgument(NativeImageOptions.ReportUnsupportedElementsAtRuntime, "+") + ". The error is then reported at run time when the JSR/RET is executed.");
            }
        }
        if (this.analysisGraphs != null) {
            this.analysisGraphs.put(method, graph);
        }
        if (InliningUtilities.isTrivialMethod(graph)) {
            this.analysisTrivialMethods.put(method, true);
        }
        for (Node n : graph.getNodes()) {
            if (n instanceof StackValueNode) {
                this.containsStackValueNode.put(method, true);
            }
            this.checkClassInitializerSideEffect(bb, method, n);
        }
    }

    private void checkClassInitializerSideEffect(PointsToAnalysis bb, AnalysisMethod method, Node n) {
        if (n instanceof AccessFieldNode) {
            ResolvedJavaField field = ((AccessFieldNode)n).field();
            if (!(!field.isStatic() || method.isClassInitializer() && field.getDeclaringClass().equals(method.getDeclaringClass()))) {
                this.classInitializerSideEffect.put(method, true);
            }
        } else if (n instanceof UnsafeAccessNode || n instanceof VMThreadLocalAccess) {
            this.classInitializerSideEffect.put(method, true);
        } else if (n instanceof EnsureClassInitializedNode) {
            ResolvedJavaType type = ((EnsureClassInitializedNode)n).constantTypeOrNull((CoreProviders)bb.getProviders());
            if (type != null) {
                this.initializedClasses.computeIfAbsent(method, k -> new HashSet()).add((AnalysisType)type);
            } else {
                this.classInitializerSideEffect.put(method, true);
            }
        }
    }

    public void keepAnalysisGraphs() {
        if (this.analysisGraphs == null) {
            this.analysisGraphs = new ConcurrentHashMap<AnalysisMethod, StructuredGraph>();
        }
    }

    public StructuredGraph getAnalysisGraph(AnalysisMethod method) {
        VMError.guarantee(this.analysisGraphs != null, "Keeping of analysis graphs must be enabled manually");
        return (StructuredGraph)this.analysisGraphs.get(method);
    }

    public boolean containsStackValueNode(AnalysisMethod method) {
        return this.containsStackValueNode.containsKey(method);
    }

    public boolean hasClassInitializerSideEffect(AnalysisMethod method) {
        return this.classInitializerSideEffect.containsKey(method);
    }

    public Set<AnalysisType> getInitializedClasses(AnalysisMethod method) {
        Set result = (Set)this.initializedClasses.get(method);
        if (result != null) {
            return result;
        }
        return Collections.emptySet();
    }

    public boolean isAnalysisTrivialMethod(AnalysisMethod method) {
        return this.analysisTrivialMethods.containsKey(method);
    }

    public boolean hasNeverInlineDirective(ResolvedJavaMethod method) {
        if (GuardedAnnotationAccess.isAnnotationPresent((AnnotatedElement)method, NeverInline.class)) {
            return true;
        }
        List neverInline = SubstrateOptions.NeverInline.getValue().values();
        return neverInline != null && neverInline.stream().anyMatch(re -> MethodFilter.parse((String)re).matches((JavaMethod)method));
    }

    public InlineBeforeAnalysisPolicy<?> inlineBeforeAnalysisPolicy() {
        return this.inlineBeforeAnalysisPolicy;
    }

    public boolean skipInterface(AnalysisUniverse universe, ResolvedJavaType interfaceType, ResolvedJavaType implementingType) {
        if (!this.platformSupported(universe, (AnnotatedElement)interfaceType)) {
            String message = "The interface " + interfaceType.toJavaName(true) + " is not available in the current platform, but used by " + implementingType.toJavaName(true) + ". GraalVM before version 21.2 ignored such interfaces, but this was an oversight.";
            String commandArgument = SubstrateOptionsParser.commandArgument(Options.PlatformInterfaceCompatibilityMode, "+");
            if (Options.PlatformInterfaceCompatibilityMode.getValue().booleanValue()) {
                System.out.println("Warning: " + message + " The interface is filtered because the compatibility option " + commandArgument + " is used. This option will be removed in a future GraalVM version.");
                return true;
            }
            throw new UnsupportedFeatureException(message + " The old behavior can be temporarily restored using the option " + commandArgument + ". This option will be removed in a future GraalVM version.");
        }
        return false;
    }

    public boolean platformSupported(AnalysisUniverse universe, AnnotatedElement element) {
        Package p;
        if (element instanceof ResolvedJavaType && (p = OriginalClassProvider.getJavaClass((SnippetReflectionProvider)universe.getOriginalSnippetReflection(), (ResolvedJavaType)((ResolvedJavaType)element)).getPackage()) != null && !this.platformSupported(universe, p)) {
            return false;
        }
        if (element instanceof Class && (p = ((Class)element).getPackage()) != null && !this.platformSupported(universe, p)) {
            return false;
        }
        Platforms platformsAnnotation = (Platforms)GuardedAnnotationAccess.getAnnotation((AnnotatedElement)element, Platforms.class);
        if (this.platform == null || platformsAnnotation == null) {
            return true;
        }
        for (Class platformGroup : platformsAnnotation.value()) {
            if (!platformGroup.isInstance(this.platform)) continue;
            return true;
        }
        return false;
    }

    public static class Options {
        @Option(help={"Enable the behavior of old GraalVM versions. When enabled, interfaces not available for the current platform are filtered."})
        public static final HostedOptionKey<Boolean> PlatformInterfaceCompatibilityMode = new HostedOptionKey<Boolean>(false);
    }
}

