/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.code;

import com.oracle.graal.pointsto.infrastructure.GraphProvider;
import com.oracle.graal.pointsto.infrastructure.UniverseMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.HostedProviders;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.hosted.code.FactoryMethodSupport;
import com.oracle.svm.hosted.code.NonBytecodeStaticMethod;
import com.oracle.svm.hosted.meta.HostedMethod;
import com.oracle.svm.hosted.phases.HostedGraphKit;
import jdk.vm.ci.meta.ConstantPool;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import jdk.vm.ci.meta.Signature;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.nodes.CallTargetNode;
import org.graalvm.compiler.nodes.Invoke;
import org.graalvm.compiler.nodes.InvokeWithExceptionNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.AbstractNewObjectNode;
import org.graalvm.nativeimage.ImageSingletons;

public final class FactoryMethod
extends NonBytecodeStaticMethod {
    private final ResolvedJavaMethod targetConstructor;

    FactoryMethod(ResolvedJavaMethod targetConstructor, ResolvedJavaType declaringClass, Signature signature, ConstantPool constantPool) {
        super(SubstrateUtil.uniqueShortName(targetConstructor), declaringClass, signature, constantPool);
        this.targetConstructor = targetConstructor;
        assert (targetConstructor.isConstructor());
        assert (!(targetConstructor instanceof AnalysisMethod) && !(targetConstructor instanceof HostedMethod));
    }

    public StructuredGraph buildGraph(DebugContext debug, ResolvedJavaMethod method, HostedProviders providers, GraphProvider.Purpose purpose) {
        FactoryMethodSupport support = (FactoryMethodSupport)ImageSingletons.lookup(FactoryMethodSupport.class);
        UniverseMetaAccess metaAccess = (UniverseMetaAccess)providers.getMetaAccess();
        ResolvedJavaMethod universeTargetConstructor = this.lookupMethodInUniverse(metaAccess, this.targetConstructor);
        HostedGraphKit kit = new HostedGraphKit(debug, providers, method);
        AbstractNewObjectNode newInstance = support.createNewInstance(kit, universeTargetConstructor.getDeclaringClass(), true);
        ValueNode[] originalArgs = kit.loadArguments(method.toParameterTypes()).toArray(new ValueNode[0]);
        ValueNode[] invokeArgs = new ValueNode[originalArgs.length + 1];
        invokeArgs[0] = newInstance;
        System.arraycopy(originalArgs, 0, invokeArgs, 1, originalArgs.length);
        InvokeWithExceptionNode invoke = kit.createInvokeWithExceptionAndUnwind(universeTargetConstructor, CallTargetNode.InvokeKind.Special, kit.getFrameState(), kit.bci(), invokeArgs);
        if (support.inlineConstructor(universeTargetConstructor)) {
            kit.inline((Invoke)invoke, "Constructor in FactoryMethod", "FactoryMethod");
        }
        kit.createReturn((ValueNode)newInstance, newInstance.getStackKind());
        return kit.finalizeGraph();
    }

    private ResolvedJavaMethod lookupMethodInUniverse(UniverseMetaAccess metaAccess, ResolvedJavaMethod method) {
        ResolvedJavaMethod universeMethod = method;
        MetaAccessProvider wrappedMetaAccess = metaAccess.getWrapped();
        if (wrappedMetaAccess instanceof UniverseMetaAccess) {
            universeMethod = this.lookupMethodInUniverse((UniverseMetaAccess)wrappedMetaAccess, universeMethod);
        }
        return metaAccess.getUniverse().lookup((JavaMethod)universeMethod);
    }
}

