/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.annotate.AlwaysInline;
import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.code.CodeInfoDecoderCounters;
import com.oracle.svm.core.code.CodeInfoQueryResult;
import com.oracle.svm.core.code.FrameInfoDecoder;
import com.oracle.svm.core.code.FrameInfoQueryResult;
import com.oracle.svm.core.code.ReusableTypeReader;
import com.oracle.svm.core.code.SimpleCodeInfoQueryResult;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.ByteArrayReader;
import com.oracle.svm.core.util.NonmovableByteArrayReader;
import com.oracle.svm.core.util.VMError;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.compiler.core.common.util.TypeConversion;
import org.graalvm.compiler.core.common.util.TypeReader;
import org.graalvm.nativeimage.ImageSingletons;

public final class CodeInfoDecoder {
    private static final int INVALID_SIZE_ENCODING = 0;
    static final int FRAME_SIZE_METHOD_START = 1;
    static final int FRAME_SIZE_ENTRY_POINT = 2;
    static final int FRAME_SIZE_HAS_CALLEE_SAVED_REGISTERS = 4;
    static final int FRAME_SIZE_STATUS_MASK = 7;
    static final int DELTA_END_OF_TABLE = 0;
    static final int FS_BITS = 2;
    static final int FS_SHIFT = 0;
    static final int FS_MASK_IN_PLACE = 3;
    static final int FS_NO_CHANGE = 0;
    static final int FS_SIZE_S1 = 1;
    static final int FS_SIZE_S2 = 2;
    static final int FS_SIZE_S4 = 3;
    static final int[] FS_MEM_SIZE = new int[]{0, 1, 2, 4};
    static final int EX_BITS = 2;
    static final int EX_SHIFT = 2;
    static final int EX_MASK_IN_PLACE = 12;
    static final int EX_NO_HANDLER = 0;
    static final int EX_OFFSET_S1 = 1;
    static final int EX_OFFSET_S2 = 2;
    static final int EX_OFFSET_S4 = 3;
    static final int[] EX_MEM_SIZE = new int[]{0, 1, 2, 4};
    static final int RM_BITS = 2;
    static final int RM_SHIFT = 4;
    static final int RM_MASK_IN_PLACE = 48;
    static final int RM_NO_MAP = 0;
    static final int RM_EMPTY_MAP = 1;
    static final int RM_INDEX_U2 = 2;
    static final int RM_INDEX_U4 = 3;
    static final int[] RM_MEM_SIZE = new int[]{0, 0, 2, 4};
    static final int FI_BITS = 2;
    static final int FI_SHIFT = 6;
    static final int FI_MASK_IN_PLACE = 192;
    static final int FI_NO_DEOPT = 0;
    static final int FI_DEOPT_ENTRY_INDEX_S4 = 1;
    static final int FI_INFO_ONLY_INDEX_S4 = 2;
    static final int[] FI_MEM_SIZE = new int[]{0, 4, 4, 0};
    private static final int TOTAL_BITS = 8;
    private static final byte IP_OFFSET;
    private static final byte FS_OFFSET;
    private static final byte[] EX_OFFSET;
    private static final byte[] RM_OFFSET;
    private static final byte[] FI_OFFSET;
    private static final byte[] MEM_SIZE;

    private CodeInfoDecoder() {
    }

    static long lookupCodeInfoEntryOffset(CodeInfo info, long ip) {
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = CodeInfoDecoder.loadEntryOffset(info, ip);
        do {
            int entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
            if (entryIP == ip) {
                return entryOffset;
            }
            entryIP = CodeInfoDecoder.advanceIP(info, entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        return -1L;
    }

    static void lookupCodeInfo(CodeInfo info, long ip, CodeInfoQueryResult codeInfoQueryResult) {
        long sizeEncoding = CodeInfoDecoder.initialSizeEncoding();
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = CodeInfoDecoder.loadEntryOffset(info, ip);
        do {
            int entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
            sizeEncoding = CodeInfoDecoder.updateSizeEncoding(info, entryOffset, entryFlags, sizeEncoding);
            if (entryIP == ip) {
                codeInfoQueryResult.encodedFrameSize = sizeEncoding;
                codeInfoQueryResult.exceptionOffset = CodeInfoDecoder.loadExceptionOffset(info, entryOffset, entryFlags);
                codeInfoQueryResult.referenceMapIndex = CodeInfoDecoder.loadReferenceMapIndex(info, entryOffset, entryFlags);
                codeInfoQueryResult.frameInfo = CodeInfoDecoder.loadFrameInfo(info, entryOffset, entryFlags);
                return;
            }
            entryIP = CodeInfoDecoder.advanceIP(info, entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        codeInfoQueryResult.encodedFrameSize = sizeEncoding;
        codeInfoQueryResult.exceptionOffset = 0L;
        codeInfoQueryResult.referenceMapIndex = -1L;
        codeInfoQueryResult.frameInfo = CodeInfoQueryResult.NO_FRAME_INFO;
    }

    static void lookupCodeInfo(CodeInfo info, long ip, SimpleCodeInfoQueryResult codeInfoQueryResult) {
        long sizeEncoding = CodeInfoDecoder.initialSizeEncoding();
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = CodeInfoDecoder.loadEntryOffset(info, ip);
        do {
            int entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
            sizeEncoding = CodeInfoDecoder.updateSizeEncoding(info, entryOffset, entryFlags, sizeEncoding);
            if (entryIP == ip) {
                codeInfoQueryResult.setEncodedFrameSize(sizeEncoding);
                codeInfoQueryResult.setExceptionOffset(CodeInfoDecoder.loadExceptionOffset(info, entryOffset, entryFlags));
                codeInfoQueryResult.setReferenceMapIndex(CodeInfoDecoder.loadReferenceMapIndex(info, entryOffset, entryFlags));
                return;
            }
            entryIP = CodeInfoDecoder.advanceIP(info, entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        codeInfoQueryResult.setEncodedFrameSize(sizeEncoding);
        codeInfoQueryResult.setExceptionOffset(0L);
        codeInfoQueryResult.setReferenceMapIndex(-1L);
    }

    static long lookupDeoptimizationEntrypoint(CodeInfo info, long method, long encodedBci, CodeInfoQueryResult codeInfo) {
        int entryFlags;
        long entryOffset;
        long entryIP;
        long sizeEncoding;
        block7: {
            sizeEncoding = CodeInfoDecoder.initialSizeEncoding();
            entryIP = CodeInfoDecoder.lookupEntryIP(method);
            entryOffset = CodeInfoDecoder.loadEntryOffset(info, method);
            do {
                entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
                sizeEncoding = CodeInfoDecoder.updateSizeEncoding(info, entryOffset, entryFlags, sizeEncoding);
                if (entryIP == method) break block7;
                entryIP = CodeInfoDecoder.advanceIP(info, entryOffset, entryIP);
                entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
            } while (entryIP <= method);
            return -1L;
        }
        assert (entryIP == method);
        assert (CodeInfoDecoder.decodeMethodStart(CodeInfoDecoder.loadEntryFlags(info, entryOffset), sizeEncoding));
        do {
            if (CodeInfoDecoder.decodeMethodStart(entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset), sizeEncoding = CodeInfoDecoder.updateSizeEncoding(info, entryOffset, entryFlags, sizeEncoding)) && entryIP != method) {
                return -1L;
            }
            if (CodeInfoDecoder.isDeoptEntryPoint(info, entryOffset, entryFlags, encodedBci)) {
                codeInfo.encodedFrameSize = sizeEncoding;
                codeInfo.exceptionOffset = CodeInfoDecoder.loadExceptionOffset(info, entryOffset, entryFlags);
                codeInfo.referenceMapIndex = CodeInfoDecoder.loadReferenceMapIndex(info, entryOffset, entryFlags);
                codeInfo.frameInfo = CodeInfoDecoder.loadFrameInfo(info, entryOffset, entryFlags);
                assert (codeInfo.frameInfo.isDeoptEntry() && codeInfo.frameInfo.getCaller() == null) : "Deoptimization entry must not have inlined frames";
                return entryIP;
            }
            entryIP = CodeInfoDecoder.advanceIP(info, entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (!CodeInfoDecoder.endOfTable(entryIP));
        return -1L;
    }

    static long lookupStackReferenceMapIndex(CodeInfo info, long ip) {
        long entryIP = CodeInfoDecoder.lookupEntryIP(ip);
        long entryOffset = CodeInfoDecoder.loadEntryOffset(info, ip);
        do {
            int entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
            if (entryIP == ip) {
                return CodeInfoDecoder.loadReferenceMapIndex(info, entryOffset, entryFlags);
            }
            entryIP = CodeInfoDecoder.advanceIP(info, entryOffset, entryIP);
            entryOffset = CodeInfoDecoder.advanceOffset(entryOffset, entryFlags);
        } while (entryIP <= ip);
        return -1L;
    }

    static long indexGranularity() {
        return Options.CodeInfoIndexGranularity.getValue().intValue();
    }

    static long lookupEntryIP(long ip) {
        return Long.divideUnsigned(ip, CodeInfoDecoder.indexGranularity()) * CodeInfoDecoder.indexGranularity();
    }

    private static long loadEntryOffset(CodeInfo info, long ip) {
        CodeInfoDecoder.counters().lookupEntryOffsetCount.inc();
        long index = Long.divideUnsigned(ip, CodeInfoDecoder.indexGranularity());
        return NonmovableByteArrayReader.getU4(CodeInfoAccess.getCodeInfoIndex(info), index * 4L);
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    static int loadEntryFlags(CodeInfo info, long curOffset) {
        CodeInfoDecoder.counters().loadEntryFlagsCount.inc();
        return NonmovableByteArrayReader.getU1(CodeInfoAccess.getCodeInfoEncodings(info), curOffset);
    }

    private static int initialSizeEncoding() {
        return 0;
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    private static long updateSizeEncoding(CodeInfo info, long entryOffset, int entryFlags, long sizeEncoding) {
        switch (CodeInfoDecoder.extractFS(entryFlags)) {
            case 0: {
                return sizeEncoding;
            }
            case 1: {
                return NonmovableByteArrayReader.getS1(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetFS(entryOffset, entryFlags));
            }
            case 2: {
                return NonmovableByteArrayReader.getS2(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetFS(entryOffset, entryFlags));
            }
            case 3: {
                return NonmovableByteArrayReader.getS4(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetFS(entryOffset, entryFlags));
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static long loadExceptionOffset(CodeInfo info, long entryOffset, int entryFlags) {
        switch (CodeInfoDecoder.extractEX(entryFlags)) {
            case 0: {
                return 0L;
            }
            case 1: {
                return NonmovableByteArrayReader.getS1(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetEX(entryOffset, entryFlags));
            }
            case 2: {
                return NonmovableByteArrayReader.getS2(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetEX(entryOffset, entryFlags));
            }
            case 3: {
                return NonmovableByteArrayReader.getS4(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetEX(entryOffset, entryFlags));
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static long loadReferenceMapIndex(CodeInfo info, long entryOffset, int entryFlags) {
        switch (CodeInfoDecoder.extractRM(entryFlags)) {
            case 0: {
                return -1L;
            }
            case 1: {
                return 0L;
            }
            case 2: {
                return NonmovableByteArrayReader.getU2(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetRM(entryOffset, entryFlags));
            }
            case 3: {
                return NonmovableByteArrayReader.getU4(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetRM(entryOffset, entryFlags));
            }
        }
        throw VMError.shouldNotReachHere();
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    static boolean decodeIsEntryPoint(long sizeEncoding) {
        assert (sizeEncoding != 0L);
        return (sizeEncoding & 2L) != 0L;
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    static boolean decodeHasCalleeSavedRegisters(long sizeEncoding) {
        assert (sizeEncoding != 0L);
        return (sizeEncoding & 4L) != 0L;
    }

    @Uninterruptible(reason="called from uninterruptible code", mayBeInlined=true)
    static long decodeTotalFrameSize(long sizeEncoding) {
        assert (sizeEncoding != 0L);
        return sizeEncoding & 0xFFFFFFFFFFFFFFF8L;
    }

    private static boolean decodeMethodStart(int entryFlags, long sizeEncoding) {
        assert (sizeEncoding != (long)CodeInfoDecoder.initialSizeEncoding());
        switch (CodeInfoDecoder.extractFS(entryFlags)) {
            case 0: {
                return false;
            }
            case 1: 
            case 2: 
            case 3: {
                return (sizeEncoding & 1L) != 0L;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    private static boolean isDeoptEntryPoint(CodeInfo info, long entryOffset, int entryFlags, long encodedBci) {
        switch (CodeInfoDecoder.extractFI(entryFlags)) {
            case 0: {
                return false;
            }
            case 1: {
                int frameInfoIndex = NonmovableByteArrayReader.getS4(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetFI(entryOffset, entryFlags));
                return FrameInfoDecoder.isFrameInfoMatch(frameInfoIndex, CodeInfoAccess.getFrameInfoEncodings(info), encodedBci);
            }
            case 2: {
                return false;
            }
        }
        throw VMError.shouldNotReachHere();
    }

    static boolean initFrameInfoReader(CodeInfo info, long entryOffset, ReusableTypeReader frameInfoReader) {
        int entryFlags = CodeInfoDecoder.loadEntryFlags(info, entryOffset);
        int frameInfoIndex = NonmovableByteArrayReader.getS4(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetFI(entryOffset, entryFlags));
        frameInfoReader.setByteIndex(frameInfoIndex);
        frameInfoReader.setData(CodeInfoAccess.getFrameInfoEncodings(info));
        return CodeInfoDecoder.extractFI(entryFlags) != 0;
    }

    private static FrameInfoQueryResult loadFrameInfo(CodeInfo info, long entryOffset, int entryFlags) {
        boolean isDeoptEntry;
        switch (CodeInfoDecoder.extractFI(entryFlags)) {
            case 0: {
                return CodeInfoQueryResult.NO_FRAME_INFO;
            }
            case 1: {
                isDeoptEntry = true;
                break;
            }
            case 2: {
                isDeoptEntry = false;
                break;
            }
            default: {
                throw VMError.shouldNotReachHere();
            }
        }
        int frameInfoIndex = NonmovableByteArrayReader.getS4(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetFI(entryOffset, entryFlags));
        return FrameInfoDecoder.decodeFrameInfo(isDeoptEntry, (TypeReader)new ReusableTypeReader(CodeInfoAccess.getFrameInfoEncodings(info), frameInfoIndex), info, FrameInfoDecoder.HeapBasedFrameInfoQueryResultAllocator, FrameInfoDecoder.HeapBasedValueInfoAllocator);
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    private static long advanceIP(CodeInfo info, long entryOffset, long entryIP) {
        int deltaIP = NonmovableByteArrayReader.getU1(CodeInfoAccess.getCodeInfoEncodings(info), CodeInfoDecoder.offsetIP(entryOffset));
        if (deltaIP == 0) {
            return Long.MAX_VALUE;
        }
        assert (deltaIP > 0);
        return entryIP + (long)deltaIP;
    }

    private static boolean endOfTable(long entryIP) {
        return entryIP == Long.MAX_VALUE;
    }

    static int extractFS(int entryFlags) {
        return (entryFlags & 3) >> 0;
    }

    static int extractEX(int entryFlags) {
        return (entryFlags & 0xC) >> 2;
    }

    static int extractRM(int entryFlags) {
        return (entryFlags & 0x30) >> 4;
    }

    static int extractFI(int entryFlags) {
        return (entryFlags & 0xC0) >> 6;
    }

    private static long offsetIP(long entryOffset) {
        return entryOffset + (long)IP_OFFSET;
    }

    private static long offsetFS(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractFS(entryFlags) != 0);
        return entryOffset + (long)FS_OFFSET;
    }

    private static long offsetEX(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractEX(entryFlags) != 0);
        return entryOffset + (long)ByteArrayReader.getU1(EX_OFFSET, entryFlags);
    }

    private static long offsetRM(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractRM(entryFlags) != 0 && CodeInfoDecoder.extractRM(entryFlags) != 1);
        return entryOffset + (long)ByteArrayReader.getU1(RM_OFFSET, entryFlags);
    }

    private static long offsetFI(long entryOffset, int entryFlags) {
        assert (CodeInfoDecoder.extractFI(entryFlags) != 0);
        return entryOffset + (long)ByteArrayReader.getU1(FI_OFFSET, entryFlags);
    }

    @AlwaysInline(value="Make IP-lookup loop call free")
    private static long advanceOffset(long entryOffset, int entryFlags) {
        CodeInfoDecoder.counters().advanceOffset.inc();
        return entryOffset + (long)ByteArrayReader.getU1(MEM_SIZE, entryFlags);
    }

    @Fold
    static CodeInfoDecoderCounters counters() {
        return (CodeInfoDecoderCounters)ImageSingletons.lookup(CodeInfoDecoderCounters.class);
    }

    static {
        int maxFlag = 256;
        IP_OFFSET = 1;
        FS_OFFSET = (byte)2;
        EX_OFFSET = new byte[maxFlag];
        RM_OFFSET = new byte[maxFlag];
        FI_OFFSET = new byte[maxFlag];
        MEM_SIZE = new byte[maxFlag];
        for (int i = 0; i < maxFlag; ++i) {
            CodeInfoDecoder.EX_OFFSET[i] = TypeConversion.asU1((long)(FS_OFFSET + FS_MEM_SIZE[CodeInfoDecoder.extractFS(i)]));
            CodeInfoDecoder.RM_OFFSET[i] = TypeConversion.asU1((long)(EX_OFFSET[i] + EX_MEM_SIZE[CodeInfoDecoder.extractEX(i)]));
            CodeInfoDecoder.FI_OFFSET[i] = TypeConversion.asU1((long)(RM_OFFSET[i] + RM_MEM_SIZE[CodeInfoDecoder.extractRM(i)]));
            CodeInfoDecoder.MEM_SIZE[i] = TypeConversion.asU1((long)(FI_OFFSET[i] + FI_MEM_SIZE[CodeInfoDecoder.extractFI(i)]));
        }
    }

    public static class Options {
        public static final HostedOptionKey<Integer> CodeInfoIndexGranularity = new HostedOptionKey<Integer>(256);
    }
}

