/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk;

import com.oracle.svm.core.threadlocal.FastThreadLocalFactory;
import com.oracle.svm.core.threadlocal.FastThreadLocalObject;
import java.security.AccessControlContext;
import java.util.ArrayDeque;
import java.util.Objects;

class PrivilegedStack {
    private static final FastThreadLocalObject<ArrayDeque<StackElement>> stack;

    PrivilegedStack() {
    }

    private static ArrayDeque<StackElement> getStack() {
        if (stack.get() == null) {
            PrivilegedStack.initializeStack();
        }
        return stack.get();
    }

    private static void initializeStack() {
        ArrayDeque tmp = new ArrayDeque();
        stack.set(tmp);
    }

    public static void push(AccessControlContext context, Class<?> caller) {
        PrivilegedStack.getStack().push(new StackElement(context, caller));
    }

    public static void pop() {
        PrivilegedStack.getStack().pop();
    }

    public static AccessControlContext peekContext() {
        return Objects.requireNonNull(PrivilegedStack.getStack().peek()).getContext();
    }

    public static Class<?> peekCaller() {
        return Objects.requireNonNull(PrivilegedStack.getStack().peek()).getCaller();
    }

    public static int length() {
        return PrivilegedStack.getStack().size();
    }

    static {
        Class<ArrayDeque> cls = ArrayDeque.class;
        stack = FastThreadLocalFactory.createObject(cls, "AccessControlContextStack");
    }

    public static class StackElement {
        protected AccessControlContext context;
        protected Class<?> caller;

        StackElement(AccessControlContext context, Class<?> caller) {
            this.context = context;
            this.caller = caller;
        }

        public AccessControlContext getContext() {
            return this.context;
        }

        public Class<?> getCaller() {
            return this.caller;
        }
    }
}

