/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.jdk.resources;

import com.oracle.svm.core.jdk.resources.NativeImageResourceDirectoryStream;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributes;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileAttributesView;
import com.oracle.svm.core.jdk.resources.NativeImageResourceFileSystem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.ReadOnlyFileSystemException;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class NativeImageResourcePath
implements Path {
    private final NativeImageResourceFileSystem fileSystem;
    private final byte[] path;
    private volatile int[] offsets;
    private byte[] resolved;
    private int hashcode = 0;

    public NativeImageResourcePath(NativeImageResourceFileSystem fileSystem, byte[] resourcePath) {
        this(fileSystem, resourcePath, false);
    }

    public NativeImageResourcePath(NativeImageResourceFileSystem fileSystem, byte[] resourcePath, boolean normalized) {
        this.fileSystem = fileSystem;
        this.path = normalized ? resourcePath : this.normalize(resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initOffsets() {
        if (this.offsets == null) {
            int count = 0;
            int index = 0;
            while (index < this.path.length) {
                byte c;
                if ((c = this.path[index++]) == 47) continue;
                ++count;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            int[] result = new int[count];
            count = 0;
            index = 0;
            while (index < this.path.length) {
                byte m = this.path[index];
                if (m == 47) {
                    ++index;
                    continue;
                }
                result[count++] = index++;
                while (index < this.path.length && this.path[index] != 47) {
                    ++index;
                }
            }
            NativeImageResourcePath nativeImageResourcePath = this;
            synchronized (nativeImageResourcePath) {
                if (this.offsets == null) {
                    this.offsets = result;
                }
            }
        }
    }

    @Override
    public NativeImageResourceFileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    public boolean isAbsolute() {
        return this.path.length > 0 && this.path[0] == 47;
    }

    @Override
    public NativeImageResourcePath getRoot() {
        if (this.isAbsolute()) {
            return new NativeImageResourcePath(this.fileSystem, new byte[]{this.path[0]});
        }
        return null;
    }

    @Override
    public Path getFileName() {
        this.initOffsets();
        int nbOffsets = this.offsets.length;
        if (nbOffsets == 0) {
            return null;
        }
        if (nbOffsets == 1 && this.path[0] != 47) {
            return this;
        }
        int offset = this.offsets[nbOffsets - 1];
        int length = this.path.length - offset;
        byte[] newPath = new byte[length];
        System.arraycopy(this.path, offset, newPath, 0, length);
        return new NativeImageResourcePath(this.fileSystem, newPath);
    }

    @Override
    public NativeImageResourcePath getParent() {
        this.initOffsets();
        int nbOffsets = this.offsets.length;
        if (nbOffsets == 0) {
            return null;
        }
        int length = this.offsets[nbOffsets - 1] - 1;
        if (length <= 0) {
            return this.getRoot();
        }
        byte[] newPath = new byte[length];
        System.arraycopy(this.path, 0, newPath, 0, length);
        return new NativeImageResourcePath(this.fileSystem, newPath);
    }

    @Override
    public int getNameCount() {
        this.initOffsets();
        return this.offsets.length;
    }

    @Override
    public Path getName(int index) {
        this.initOffsets();
        if (index < 0 || index >= this.offsets.length) {
            throw new IllegalArgumentException();
        }
        int begin = this.offsets[index];
        int len = index == this.offsets.length - 1 ? this.path.length - begin : this.offsets[index + 1] - begin - 1;
        byte[] result = new byte[len];
        System.arraycopy(this.path, begin, result, 0, len);
        return new NativeImageResourcePath(this.fileSystem, result);
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        this.initOffsets();
        if (beginIndex < 0 || beginIndex >= this.offsets.length || endIndex > this.offsets.length || beginIndex >= endIndex) {
            throw new IllegalArgumentException();
        }
        int begin = this.offsets[beginIndex];
        int len = endIndex == this.offsets.length ? this.path.length - begin : this.offsets[endIndex] - begin - 1;
        byte[] result = new byte[len];
        System.arraycopy(this.path, begin, result, 0, len);
        return new NativeImageResourcePath(this.fileSystem, result);
    }

    @Override
    public boolean startsWith(Path other) {
        NativeImageResourcePath p1 = this;
        NativeImageResourcePath p2 = NativeImageResourcePath.checkPath(other);
        if (p1.isAbsolute() != p2.isAbsolute() || p1.path.length < p2.path.length) {
            return false;
        }
        int length = p2.path.length;
        for (int idx = 0; idx < length; ++idx) {
            if (p1.path[idx] == p2.path[idx]) continue;
            return false;
        }
        return p1.path.length == p2.path.length || p2.path[length - 1] == 47 || p1.path[length] == 47;
    }

    @Override
    public boolean startsWith(String other) {
        return this.startsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public boolean endsWith(Path other) {
        int i2;
        NativeImageResourcePath p1 = this;
        NativeImageResourcePath p2 = NativeImageResourcePath.checkPath(other);
        int i1 = p1.path.length - 1;
        if (i1 > 0 && p1.path[i1] == 47) {
            --i1;
        }
        if ((i2 = p2.path.length - 1) > 0 && p2.path[i2] == 47) {
            --i2;
        }
        if (i2 == -1) {
            return i1 == -1;
        }
        if (p2.isAbsolute() && (!this.isAbsolute() || i2 != i1) || i1 < i2) {
            return false;
        }
        while (i2 >= 0) {
            if (p2.path[i2] != p1.path[i1]) {
                return false;
            }
            --i2;
            --i1;
        }
        return p2.path[i2 + 1] == 47;
    }

    @Override
    public boolean endsWith(String other) {
        return this.endsWith(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path normalize() {
        byte[] p = this.getResolved();
        if (p == this.path) {
            return this;
        }
        return new NativeImageResourcePath(this.fileSystem, p, true);
    }

    @Override
    public Path resolve(Path other) {
        byte[] result;
        NativeImageResourcePath p1 = this;
        NativeImageResourcePath p2 = NativeImageResourcePath.checkPath(other);
        if (p2.isAbsolute()) {
            return p2;
        }
        if (p1.path[p1.path.length - 1] == 47) {
            result = new byte[p1.path.length + p2.path.length];
            System.arraycopy(p1.path, 0, result, 0, p1.path.length);
            System.arraycopy(p2.path, 0, result, p1.path.length, p2.path.length);
        } else {
            result = new byte[p1.path.length + 1 + p2.path.length];
            System.arraycopy(p1.path, 0, result, 0, p1.path.length);
            result[p1.path.length] = 47;
            System.arraycopy(p2.path, 0, result, p1.path.length + 1, p2.path.length);
        }
        return new NativeImageResourcePath(this.fileSystem, result);
    }

    private static NativeImageResourcePath checkPath(Path paramPath) {
        if (paramPath == null) {
            throw new NullPointerException();
        }
        if (!(paramPath instanceof NativeImageResourcePath)) {
            throw new ProviderMismatchException();
        }
        return (NativeImageResourcePath)paramPath;
    }

    @Override
    public Path resolve(String other) {
        return this.resolve(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path resolveSibling(Path other) {
        if (other == null) {
            throw new NullPointerException();
        }
        NativeImageResourcePath parent = this.getParent();
        return parent == null ? other : parent.resolve(other);
    }

    @Override
    public Path resolveSibling(String other) {
        return this.resolveSibling(this.getFileSystem().getPath(other, new String[0]));
    }

    @Override
    public Path relativize(Path other) {
        int nbCommon;
        NativeImageResourcePath p1 = this;
        NativeImageResourcePath p2 = NativeImageResourcePath.checkPath(other);
        if (p2.equals(p1)) {
            return new NativeImageResourcePath(this.fileSystem, new byte[0], true);
        }
        if (p1.isAbsolute() != p2.isAbsolute()) {
            throw new IllegalArgumentException();
        }
        int nbNames1 = p1.getNameCount();
        int nbNames2 = p2.getNameCount();
        int l = Math.min(nbNames1, nbNames2);
        for (nbCommon = 0; nbCommon < l && NativeImageResourcePath.equalsNameAt(p1, p2, nbCommon); ++nbCommon) {
        }
        int nbUp = nbNames1 - nbCommon;
        int length = nbUp * 3 - 1;
        if (nbCommon < nbNames2) {
            length += p2.path.length - p2.offsets[nbCommon] + 1;
        }
        byte[] result = new byte[length];
        int idx = 0;
        while (nbUp-- > 0) {
            result[idx++] = 46;
            result[idx++] = 46;
            if (idx >= length) continue;
            result[idx++] = 47;
        }
        if (nbCommon < nbNames2) {
            System.arraycopy(p2.path, p2.offsets[nbCommon], result, idx, p2.path.length - p2.offsets[nbCommon]);
        }
        return new NativeImageResourcePath(this.fileSystem, result);
    }

    @Override
    public URI toUri() {
        try {
            return new URI("resource", this.fileSystem.getResourcePath().toUri() + "!" + this.fileSystem.getString(this.toAbsolutePath().path), null);
        }
        catch (URISyntaxException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public NativeImageResourcePath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        byte[] result = new byte[this.path.length + 1];
        result[0] = 47;
        System.arraycopy(this.path, 0, result, 1, this.path.length);
        return new NativeImageResourcePath(this.fileSystem, result, true);
    }

    @Override
    public Path toRealPath(LinkOption ... options) throws IOException {
        NativeImageResourcePath absolute = new NativeImageResourcePath(this.fileSystem, this.getResolvedPath()).toAbsolutePath();
        this.fileSystem.provider().checkAccess(absolute, new AccessMode[0]);
        return absolute;
    }

    @Override
    public File toFile() {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?>[] events, WatchEvent.Modifier ... modifiers) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public WatchKey register(WatchService watcher, WatchEvent.Kind<?> ... events) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Path> iterator() {
        return new Iterator<Path>(){
            private int i = 0;

            @Override
            public boolean hasNext() {
                return this.i < NativeImageResourcePath.this.getNameCount();
            }

            @Override
            public Path next() {
                if (this.i < NativeImageResourcePath.this.getNameCount()) {
                    Path result = NativeImageResourcePath.this.getName(this.i);
                    ++this.i;
                    return result;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new ReadOnlyFileSystemException();
            }
        };
    }

    @Override
    public int compareTo(Path other) {
        NativeImageResourcePath p1 = this;
        NativeImageResourcePath p2 = NativeImageResourcePath.checkPath(other);
        byte[] a1 = p1.path;
        byte[] a2 = p2.path;
        int l1 = a1.length;
        int l2 = a2.length;
        int l = Math.min(l1, l2);
        for (int i = 0; i < l; ++i) {
            int b1 = a1[i] & 0xFF;
            int b2 = a2[i] & 0xFF;
            if (b1 == b2) continue;
            return b1 - b2;
        }
        return l1 - l2;
    }

    @Override
    public int hashCode() {
        int h = this.hashcode;
        if (h == 0) {
            this.hashcode = h = Arrays.hashCode(this.path);
        }
        return h;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof NativeImageResourcePath && this.fileSystem == ((NativeImageResourcePath)obj).fileSystem && this.compareTo((Path)obj) == 0;
    }

    @Override
    public String toString() {
        return this.fileSystem.getString(this.path);
    }

    SeekableByteChannel newByteChannel(Set<? extends OpenOption> options) throws IOException {
        return this.fileSystem.newByteChannel(this.getResolvedPath(), options);
    }

    DirectoryStream<Path> newDirectoryStream(DirectoryStream.Filter<? super Path> filter) throws IOException {
        return new NativeImageResourceDirectoryStream(this, filter);
    }

    NativeImageResourceFileAttributes getAttributes() throws NoSuchFileException {
        NativeImageResourceFileAttributes nativeImageResourceFileAttributes = this.fileSystem.getFileAttributes(this.getResolvedPath());
        if (nativeImageResourceFileAttributes == null) {
            throw new NoSuchFileException(this.toString());
        }
        return nativeImageResourceFileAttributes;
    }

    Map<String, Object> readAttributes(String attributes) throws IOException {
        String attrs;
        String view;
        int colonPos = attributes.indexOf(58);
        if (colonPos == -1) {
            view = "basic";
            attrs = attributes;
        } else {
            view = attributes.substring(0, colonPos++);
            attrs = attributes.substring(colonPos);
        }
        NativeImageResourceFileAttributesView raw = NativeImageResourceFileAttributesView.get(this, view);
        if (raw == null) {
            throw new UnsupportedOperationException("View is not supported!");
        }
        return raw.readAttributes(attrs);
    }

    byte[] getResolvedPath() {
        byte[] r = this.resolved;
        if (r == null) {
            r = this.isAbsolute() ? this.getResolved() : this.toAbsolutePath().getResolvedPath();
            if (r[0] == 47) {
                r = Arrays.copyOfRange(r, 1, r.length);
            }
            this.resolved = r;
        }
        return this.resolved;
    }

    private byte[] normalize(byte[] resourcePath) {
        if (resourcePath.length == 0) {
            return resourcePath;
        }
        int i = 0;
        for (int j = 0; j < resourcePath.length; ++j) {
            int k = resourcePath[j];
            if (k == 92) {
                return this.normalize(resourcePath, j);
            }
            if (k == 47 && i == 47) {
                return this.normalize(resourcePath, j - 1);
            }
            if (k == 0) {
                throw new InvalidPathException(this.fileSystem.getString(resourcePath), "Path: nul character not allowed");
            }
            i = k;
        }
        return resourcePath;
    }

    private byte[] normalize(byte[] resourcePath, int index) {
        int i;
        byte[] arrayOfByte = new byte[resourcePath.length];
        for (i = 0; i < index; ++i) {
            arrayOfByte[i] = resourcePath[i];
        }
        int j = i;
        int k = 0;
        while (i < resourcePath.length) {
            int m;
            if ((m = resourcePath[i++]) == 92) {
                m = 47;
            }
            if (m == 47 && k == 47) continue;
            if (m == 0) {
                throw new InvalidPathException(this.fileSystem.getString(resourcePath), "Path: nul character not allowed");
            }
            arrayOfByte[j++] = (byte)m;
            k = m;
        }
        if (j > 1 && arrayOfByte[j - 1] == 47) {
            --j;
        }
        return j == arrayOfByte.length ? arrayOfByte : Arrays.copyOf(arrayOfByte, j);
    }

    private byte[] getResolved() {
        if (this.path.length == 0) {
            return this.path;
        }
        for (byte c : this.path) {
            if (c != 46) continue;
            return NativeImageResourcePath.getResolved(this);
        }
        return this.path;
    }

    public static byte[] getResolved(NativeImageResourcePath p) {
        int nc = p.getNameCount();
        byte[] path = p.path;
        int[] offsets = p.offsets;
        byte[] to = new byte[path.length];
        int[] lastM = new int[nc];
        int lastMOff = -1;
        int m = 0;
        for (int i = 0; i < nc; ++i) {
            int len;
            int n = offsets[i];
            int n2 = len = i == offsets.length - 1 ? path.length - n : offsets[i + 1] - n - 1;
            if (len == 1 && path[n] == 46) {
                if (m != 0 || path[0] != 47) continue;
                to[m++] = 47;
                continue;
            }
            if (len == 2 && path[n] == 46 && path[n + 1] == 46) {
                if (lastMOff >= 0) {
                    m = lastM[lastMOff--];
                    continue;
                }
                if (path[0] == 47) {
                    if (m != 0) continue;
                    to[m++] = 47;
                    continue;
                }
                if (m != 0 && to[m - 1] != 47) {
                    to[m++] = 47;
                }
                while (len-- > 0) {
                    to[m++] = path[n++];
                }
                continue;
            }
            if (m == 0 && path[0] == 47 || m != 0 && to[m - 1] != 47) {
                to[m++] = 47;
            }
            lastM[++lastMOff] = m;
            while (len-- > 0) {
                to[m++] = path[n++];
            }
        }
        if (m > 1 && to[m - 1] == 47) {
            --m;
        }
        return m == to.length ? to : Arrays.copyOf(to, m);
    }

    private static boolean equalsNameAt(NativeImageResourcePath p1, NativeImageResourcePath p2, int index) {
        int beg1 = p1.offsets[index];
        int len1 = index == p1.offsets.length - 1 ? p1.path.length - beg1 : p1.offsets[index + 1] - beg1 - 1;
        int beg2 = p2.offsets[index];
        int len2 = index == p2.offsets.length - 1 ? p2.path.length - beg2 : p2.offsets[index + 1] - beg2 - 1;
        if (len1 != len2) {
            return false;
        }
        for (int n = 0; n < len1; ++n) {
            if (p1.path[beg1 + n] == p2.path[beg2 + n]) continue;
            return false;
        }
        return true;
    }

    boolean exists() {
        return this.fileSystem.exists(this.getResolvedPath());
    }

    FileStore getFileStore() throws IOException {
        if (this.exists()) {
            return NativeImageResourceFileSystem.getFileStore(this);
        }
        throw new NoSuchFileException(this.fileSystem.getString(this.path));
    }

    boolean isSameFile(Path other) throws IOException {
        if (this.equals(other)) {
            return true;
        }
        if (other == null || this.getFileSystem() != other.getFileSystem()) {
            return false;
        }
        this.checkAccess(new AccessMode[0]);
        ((NativeImageResourcePath)other).checkAccess(new AccessMode[0]);
        return Arrays.equals(this.getResolvedPath(), ((NativeImageResourcePath)other).getResolvedPath());
    }

    void checkAccess(AccessMode ... modes) throws IOException {
        boolean x = false;
        block4: for (AccessMode mode : modes) {
            switch (mode) {
                case READ: 
                case WRITE: {
                    continue block4;
                }
                case EXECUTE: {
                    x = true;
                    continue block4;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        this.fileSystem.checkAccess(this.getResolvedPath());
        if (x) {
            throw new AccessDeniedException(this.toString());
        }
    }

    void setAttribute(String attribute, Object value) throws IOException {
        String attr;
        String type;
        int colonPos = attribute.indexOf(58);
        if (colonPos == -1) {
            type = "basic";
            attr = attribute;
        } else {
            type = attribute.substring(0, colonPos++);
            attr = attribute.substring(colonPos);
        }
        NativeImageResourceFileAttributesView view = NativeImageResourceFileAttributesView.get(this, type);
        if (view == null) {
            throw new UnsupportedOperationException("View is not supported");
        }
        view.setAttribute(attr, value);
    }

    void setTimes(FileTime lastModifiedTime, FileTime lastAccessTime, FileTime createTime) throws NoSuchFileException {
        this.fileSystem.setTimes(this.getResolvedPath(), lastModifiedTime, lastAccessTime, createTime);
    }

    void createDirectory() throws IOException {
        this.fileSystem.createDirectory(this.getResolvedPath());
    }

    void delete() throws IOException {
        this.fileSystem.deleteFile(this.getResolvedPath(), true);
    }

    boolean deleteIfExists() throws IOException {
        return this.fileSystem.deleteFile(this.getResolvedPath(), false);
    }

    void move(NativeImageResourcePath target, CopyOption ... options) throws IOException {
        if (Files.isSameFile(this.fileSystem.getResourcePath(), target.fileSystem.getResourcePath())) {
            this.fileSystem.copyFile(true, this.getResolvedPath(), target.getResolvedPath(), options);
        } else {
            this.copyToTarget(target, options);
            this.delete();
        }
    }

    void copy(NativeImageResourcePath target, CopyOption ... options) throws IOException {
        if (Files.isSameFile(this.fileSystem.getResourcePath(), target.fileSystem.getResourcePath())) {
            this.fileSystem.copyFile(false, this.getResolvedPath(), target.getResolvedPath(), options);
        } else {
            this.copyToTarget(target, options);
        }
    }

    private void copyToTarget(NativeImageResourcePath target, CopyOption ... options) throws IOException {
        boolean exists;
        boolean replaceExisting = false;
        boolean copyAttrs = false;
        for (CopyOption opt : options) {
            if (opt == StandardCopyOption.REPLACE_EXISTING) {
                replaceExisting = true;
                continue;
            }
            if (opt != StandardCopyOption.COPY_ATTRIBUTES) continue;
            copyAttrs = true;
        }
        NativeImageResourceFileAttributes nativeImageResourceFileAttributes = this.getAttributes();
        if (replaceExisting) {
            try {
                target.deleteIfExists();
                exists = false;
            }
            catch (DirectoryNotEmptyException x) {
                exists = true;
            }
        } else {
            exists = target.exists();
        }
        if (exists) {
            throw new FileAlreadyExistsException(target.toString());
        }
        if (nativeImageResourceFileAttributes.isDirectory()) {
            target.createDirectory();
        } else {
            try (InputStream is = this.fileSystem.newInputStream(this.getResolvedPath());
                 OutputStream os = target.newOutputStream(new OpenOption[0]);){
                int n;
                byte[] buf = new byte[8192];
                while ((n = is.read(buf)) != -1) {
                    os.write(buf, 0, n);
                }
            }
        }
        if (copyAttrs) {
            BasicFileAttributeView attributeView = NativeImageResourceFileAttributesView.get(target, BasicFileAttributeView.class);
            try {
                attributeView.setTimes(nativeImageResourceFileAttributes.lastModifiedTime(), nativeImageResourceFileAttributes.lastAccessTime(), nativeImageResourceFileAttributes.creationTime());
            }
            catch (IOException e) {
                try {
                    target.delete();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw e;
            }
        }
    }

    InputStream newInputStream(OpenOption ... options) throws IOException {
        if (options.length > 0) {
            for (OpenOption opt : options) {
                if (opt == StandardOpenOption.READ) continue;
                throw new UnsupportedOperationException("'" + opt + "' not allowed");
            }
        }
        return this.fileSystem.newInputStream(this.getResolvedPath());
    }

    OutputStream newOutputStream(OpenOption ... options) throws IOException {
        if (options.length == 0) {
            return this.fileSystem.newOutputStream(this.getResolvedPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.WRITE);
        }
        return this.fileSystem.newOutputStream(this.getResolvedPath(), options);
    }

    FileChannel newFileChannel(Set<? extends OpenOption> options, FileAttribute<?> ... attrs) throws IOException {
        return this.fileSystem.newFileChannel(this.getResolvedPath(), options, attrs);
    }

    boolean isHidden() {
        return false;
    }
}

