/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.option;

import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.jdk.RuntimeSupport;
import com.oracle.svm.core.option.RuntimeOptionKey;
import java.util.Objects;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.nativeimage.ImageSingletons;

public class ImmutableRuntimeOptionKey<T>
extends RuntimeOptionKey<T> {
    public ImmutableRuntimeOptionKey(T defaultValue, RuntimeOptionKey.RuntimeOptionKeyFlag ... flags) {
        super(defaultValue, flags);
    }

    public void update(EconomicMap<OptionKey<?>, Object> values, Object newValue) {
        if (!SubstrateUtil.HOSTED && !((RuntimeSupport)ImageSingletons.lookup(RuntimeSupport.class)).isUninitialized() && this.isDifferentValue(values, newValue)) {
            Object value = values.get((Object)this);
            throw new IllegalStateException("The runtime option '" + this.getName() + "' is immutable and can only be set during startup. Current value: " + value + ", new value: " + newValue);
        }
        super.update(values, newValue);
    }

    private boolean isDifferentValue(EconomicMap<OptionKey<?>, Object> values, Object newValue) {
        if (!values.containsKey((Object)this) && !Objects.equals(this.getDefaultValue(), newValue)) {
            return true;
        }
        Object value = values.get((Object)this);
        return !Objects.equals(value, newValue);
    }
}

