/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.headers.darwin;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.posix.headers.PosixDirectives;
import com.oracle.svm.core.util.VMError;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.c.CContext;
import org.graalvm.nativeimage.c.function.CFunction;
import org.graalvm.nativeimage.c.struct.CField;
import org.graalvm.nativeimage.c.struct.CStruct;
import org.graalvm.word.PointerBase;

@CContext(value=PosixDirectives.class)
public class DarwinStat {
    @CFunction(value="fstat$INODE64")
    @Platforms(value={Platform.DARWIN_AMD64.class})
    public static native int fstat_amd64(int var0, stat var1);

    @CFunction(value="fstat")
    @Platforms(value={Platform.DARWIN_AARCH64.class})
    public static native int fstat_aarch64(int var0, stat var1);

    @Platforms(value={Platform.DARWIN.class})
    public static int fstat(int fd, stat buf) {
        if (Platform.includedIn(Platform.AMD64.class)) {
            return DarwinStat.fstat_amd64(fd, buf);
        }
        if (Platform.includedIn(Platform.AARCH64.class)) {
            return DarwinStat.fstat_aarch64(fd, buf);
        }
        throw VMError.shouldNotReachHere();
    }

    public static class NoTransitions {
        @CFunction(value="fstat$INODE64", transition=CFunction.Transition.NO_TRANSITION)
        @Platforms(value={Platform.DARWIN_AMD64.class})
        public static native int fstat_amd64(int var0, stat var1);

        @CFunction(value="fstat", transition=CFunction.Transition.NO_TRANSITION)
        @Platforms(value={Platform.DARWIN_AARCH64.class})
        public static native int fstat_aarch64(int var0, stat var1);

        @Platforms(value={Platform.DARWIN.class})
        @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
        public static int fstat(int fd, stat buf) {
            if (Platform.includedIn(Platform.AMD64.class)) {
                return NoTransitions.fstat_amd64(fd, buf);
            }
            if (Platform.includedIn(Platform.AARCH64.class)) {
                return NoTransitions.fstat_aarch64(fd, buf);
            }
            throw VMError.shouldNotReachHere();
        }
    }

    @CStruct(addStructKeyword=true)
    public static interface stat
    extends PointerBase {
        @CField
        public long st_size();
    }
}

