/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.posix.linux.libc;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.c.libc.LibCBase;
import com.oracle.svm.core.option.APIOption;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import java.util.ServiceLoader;
import org.graalvm.collections.UnmodifiableEconomicMap;
import org.graalvm.compiler.options.OptionKey;
import org.graalvm.compiler.options.OptionValues;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public class LibCFeature
implements Feature {
    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return LibCBase.isPlatformEquivalent(Platform.LINUX.class);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess access) {
        String targetLibC = LibCOptions.UseLibC.getValue();
        ServiceLoader<LibCBase> loader = ServiceLoader.load(LibCBase.class);
        for (LibCBase libc : loader) {
            if (!libc.getName().equals(targetLibC)) continue;
            libc.checkIfLibCSupported();
            ImageSingletons.add(LibCBase.class, (Object)libc);
            return;
        }
        throw UserError.abort("Unknown libc %s selected. Please use one of the available libc implementations.", targetLibC);
    }

    public static class LibCOptions {
        @APIOption(name={"libc"})
        public static final HostedOptionKey<String> UseLibC = new HostedOptionKey<String>(null){

            public String getValueOrDefault(UnmodifiableEconomicMap<OptionKey<?>, Object> values) {
                if (!values.containsKey((Object)this)) {
                    return Platform.includedIn(Platform.ANDROID.class) ? "bionic" : "glibc";
                }
                return (String)values.get((Object)this);
            }

            public String getValue(OptionValues values) {
                assert (this.checkDescriptorExists());
                return this.getValueOrDefault(values.getMap());
            }
        };
    }
}

