/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.reflect;

import com.oracle.svm.core.jdk.InternalVMMethod;
import com.oracle.svm.core.reflect.SubstrateMethodAccessor;
import com.oracle.svm.core.util.VMError;
import java.lang.reflect.Executable;
import jdk.internal.reflect.ConstructorAccessor;
import org.graalvm.nativeimage.c.function.CFunctionPointer;

@InternalVMMethod
public final class SubstrateConstructorAccessor
implements ConstructorAccessor {
    private final Executable member;
    private final CFunctionPointer newInstanceFunctionPointer;

    public SubstrateConstructorAccessor(Executable member, CFunctionPointer newInstanceFunctionPointer) {
        this.member = member;
        this.newInstanceFunctionPointer = newInstanceFunctionPointer;
    }

    @Override
    public Object newInstance(Object[] args) {
        SubstrateMethodAccessor.MethodInvokeFunctionPointer functionPointer = (SubstrateMethodAccessor.MethodInvokeFunctionPointer)this.newInstanceFunctionPointer;
        if (functionPointer.isNull()) {
            throw this.newInstanceError();
        }
        return functionPointer.invoke(false, null, args);
    }

    private RuntimeException newInstanceError() {
        throw VMError.shouldNotReachHere("No SubstrateConstructorAccessor.newInstanceFunctionPointer for " + this.member);
    }
}

