/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.thread;

import com.oracle.svm.core.annotate.Uninterruptible;
import com.oracle.svm.core.thread.ParkEventConsCell;
import com.oracle.svm.core.thread.ParkEventList;
import org.graalvm.nativeimage.ImageSingletons;

public abstract class ParkEvent {
    protected boolean isSleepEvent;
    private ParkEventConsCell consCell;

    protected ParkEvent() {
    }

    protected abstract void reset();

    protected abstract void condWait();

    protected abstract void condTimedWait(long var1);

    protected abstract void unpark();

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    ParkEventConsCell consumeConsCell() {
        assert (this.consCell != null) : "Consuming null cons cell.";
        ParkEventConsCell result = this.consCell;
        this.consCell = null;
        return result;
    }

    static ParkEvent acquire(boolean isSleepEvent) {
        ParkEvent result = ParkEventList.getSingleton().pop();
        if (result == null) {
            result = ((ParkEventFactory)ImageSingletons.lookup(ParkEventFactory.class)).create();
        }
        result.consCell = new ParkEventConsCell(result);
        result.isSleepEvent = isSleepEvent;
        result.reset();
        return result;
    }

    @Uninterruptible(reason="Called from uninterruptible code.", mayBeInlined=true)
    static void release(ParkEvent event) {
        ParkEventList.getSingleton().push(event);
    }

    public static interface ParkEventFactory {
        public ParkEvent create();
    }
}

