/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.windows;

import com.oracle.svm.core.Isolates;
import com.oracle.svm.core.jdk.JNIPlatformNativeLibrarySupport;
import com.oracle.svm.core.jdk.Jvm;
import com.oracle.svm.core.jdk.NativeLibrarySupport;
import com.oracle.svm.core.jdk.PlatformNativeLibrarySupport;
import com.oracle.svm.core.log.Log;
import com.oracle.svm.core.windows.Target_java_io_WinNTFileSystem;
import com.oracle.svm.core.windows.WindowsUtils;
import com.oracle.svm.core.windows.headers.FileAPI;
import com.oracle.svm.core.windows.headers.LibLoaderAPI;
import com.oracle.svm.core.windows.headers.WinBase;
import com.oracle.svm.core.windows.headers.WinSock;
import java.io.FileDescriptor;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.c.type.CCharPointer;
import org.graalvm.nativeimage.c.type.CTypeConversion;
import org.graalvm.word.PointerBase;
import org.graalvm.word.WordFactory;

class WindowsNativeLibrarySupport
extends JNIPlatformNativeLibrarySupport {
    WindowsNativeLibrarySupport() {
    }

    static void initialize() {
        ImageSingletons.add(PlatformNativeLibrarySupport.class, (Object)new WindowsNativeLibrarySupport());
    }

    @Override
    public boolean initializeBuiltinLibraries() {
        try {
            this.loadJavaLibrary();
            WindowsNativeLibrarySupport.loadNetLibrary();
        }
        catch (UnsatisfiedLinkError e) {
            Log.log().string("System.loadLibrary failed, " + e).newline();
            return false;
        }
        return true;
    }

    @Override
    protected void loadJavaLibrary() {
        super.loadJavaLibrary();
        Target_java_io_WinNTFileSystem.initIDs();
        WindowsUtils.setHandle(FileDescriptor.in, FileAPI.GetStdHandle(FileAPI.STD_INPUT_HANDLE()));
        WindowsUtils.setHandle(FileDescriptor.out, FileAPI.GetStdHandle(FileAPI.STD_OUTPUT_HANDLE()));
        WindowsUtils.setHandle(FileDescriptor.err, FileAPI.GetStdHandle(FileAPI.STD_ERROR_HANDLE()));
    }

    private static void loadNetLibrary() {
        if (Isolates.isCurrentFirst()) {
            WinSock.init();
            System.loadLibrary("net");
        } else {
            NativeLibrarySupport.singleton().registerInitializedBuiltinLibrary("net");
        }
    }

    @Override
    public WindowsNativeLibrary createLibrary(String canonical, boolean builtIn) {
        return new WindowsNativeLibrary(canonical, builtIn);
    }

    @Override
    public PointerBase findBuiltinSymbol(String name) {
        try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
            WinBase.HMODULE builtinHandle = LibLoaderAPI.GetModuleHandleA((CCharPointer)WordFactory.nullPointer());
            PointerBase pointerBase = LibLoaderAPI.GetProcAddress(builtinHandle, symbol.get());
            return pointerBase;
        }
    }

    class WindowsNativeLibrary
    implements PlatformNativeLibrarySupport.NativeLibrary {
        private final String canonicalIdentifier;
        private final boolean builtin;
        private WinBase.HMODULE dlhandle;
        private boolean loaded = false;

        WindowsNativeLibrary(String canonicalIdentifier, boolean builtin) {
            this.canonicalIdentifier = canonicalIdentifier;
            this.builtin = builtin;
        }

        @Override
        public String getCanonicalIdentifier() {
            return this.canonicalIdentifier;
        }

        @Override
        public boolean isBuiltin() {
            return this.builtin;
        }

        @Override
        public boolean load() {
            assert (!this.loaded);
            this.loaded = this.doLoad();
            return this.loaded;
        }

        private boolean doLoad() {
            Jvm.initialize();
            if (this.builtin) {
                return true;
            }
            assert (this.dlhandle.isNull());
            try (CTypeConversion.CCharPointerHolder dllPathPin = CTypeConversion.toCString((CharSequence)this.canonicalIdentifier);){
                CCharPointer dllPathPtr = dllPathPin.get();
                this.dlhandle = LibLoaderAPI.LoadLibraryA(dllPathPtr);
            }
            return this.dlhandle.isNonNull();
        }

        @Override
        public boolean isLoaded() {
            return this.loaded;
        }

        @Override
        public PointerBase findSymbol(String name) {
            if (this.builtin) {
                return WindowsNativeLibrarySupport.this.findBuiltinSymbol(name);
            }
            assert (this.dlhandle.isNonNull());
            try (CTypeConversion.CCharPointerHolder symbol = CTypeConversion.toCString((CharSequence)name);){
                PointerBase pointerBase = LibLoaderAPI.GetProcAddress(this.dlhandle, symbol.get());
                return pointerBase;
            }
        }
    }
}

