/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.classinitialization;

import com.oracle.graal.pointsto.constraints.UnsupportedFeatures;
import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.reports.ReportUtils;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.SubstrateOptions;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.LinkAtBuildTimeSupport;
import com.oracle.svm.hosted.classinitialization.ClassInitializationConfiguration;
import com.oracle.svm.hosted.classinitialization.ClassInitializationOptions;
import com.oracle.svm.hosted.classinitialization.ClassInitializationSupport;
import com.oracle.svm.hosted.classinitialization.ClassOrPackageConfig;
import com.oracle.svm.hosted.classinitialization.EarlyClassInitializerAnalysis;
import com.oracle.svm.hosted.classinitialization.InitKind;
import java.lang.reflect.Proxy;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import jdk.internal.misc.Unsafe;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public class ConfigurableClassInitialization
implements ClassInitializationSupport {
    private final ClassInitializationConfiguration classInitializationConfiguration = new ClassInitializationConfiguration();
    private final ConcurrentMap<Class<?>, InitKind> classInitKinds = new ConcurrentHashMap();
    private static final Map<Class<?>, StackTraceElement[]> initializedClasses = new ConcurrentHashMap();
    private static final Map<Object, StackTraceElement[]> instantiatedObjects = Collections.synchronizedMap(new IdentityHashMap());
    private boolean configurationSealed;
    final ImageClassLoader loader;
    private UnsupportedFeatures unsupportedFeatures;
    protected MetaAccessProvider metaAccess;
    private final EarlyClassInitializerAnalysis earlyClassInitializerAnalysis;
    private Set<Class<?>> provenSafeEarly = Collections.synchronizedSet(new HashSet());
    private Set<Class<?>> provenSafeLate = Collections.synchronizedSet(new HashSet());

    public ConfigurableClassInitialization(MetaAccessProvider metaAccess, ImageClassLoader loader) {
        this.metaAccess = metaAccess;
        this.loader = loader;
        this.earlyClassInitializerAnalysis = new EarlyClassInitializerAnalysis(this);
    }

    @Override
    public void setConfigurationSealed(boolean sealed) {
        this.configurationSealed = sealed;
        if (this.configurationSealed && ClassInitializationOptions.PrintClassInitialization.getValue().booleanValue()) {
            List<ClassOrPackageConfig> allConfigs = this.classInitializationConfiguration.allConfigs();
            allConfigs.sort(Comparator.comparing(ClassOrPackageConfig::getName));
            String path = Paths.get(Paths.get(SubstrateOptions.Path.getValue(), new String[0]).toString(), "reports").toAbsolutePath().toString();
            ReportUtils.report((String)"class initialization configuration", (String)path, (String)"class_initialization_configuration", (String)"csv", writer -> {
                writer.println("Class or Package Name, Initialization Kind, Reasons");
                for (ClassOrPackageConfig config : allConfigs) {
                    writer.append(config.getName()).append(", ").append(config.getKind().toString()).append(", ").append(String.join((CharSequence)" and ", config.getReasons())).append(System.lineSeparator());
                }
            });
        }
    }

    @Override
    public void setUnsupportedFeatures(UnsupportedFeatures unsupportedFeatures) {
        this.unsupportedFeatures = unsupportedFeatures;
    }

    private InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz, true, null);
    }

    @Override
    public InitKind specifiedInitKindFor(Class<?> clazz) {
        return (InitKind)((Object)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getLeft());
    }

    @Override
    public boolean canBeProvenSafe(Class<?> clazz) {
        InitKind initKind = this.specifiedInitKindFor(clazz);
        return initKind == null || initKind.isRunTime() && this.isStrictlyDefined(clazz) == false;
    }

    private Boolean isStrictlyDefined(Class<?> clazz) {
        return (Boolean)this.classInitializationConfiguration.lookupKind(clazz.getTypeName()).getRight();
    }

    @Override
    public Set<Class<?>> classesWithKind(InitKind kind) {
        return this.classInitKinds.entrySet().stream().filter(e -> e.getValue() == kind).map(Map.Entry::getKey).collect(Collectors.toSet());
    }

    @Override
    public boolean shouldInitializeAtRuntime(ResolvedJavaType type) {
        return this.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.getJavaClass(type)) != InitKind.BUILD_TIME;
    }

    @Override
    public boolean shouldInitializeAtRuntime(Class<?> clazz) {
        return this.computeInitKindAndMaybeInitializeClass(clazz) != InitKind.BUILD_TIME;
    }

    @Override
    public void maybeInitializeHosted(ResolvedJavaType type) {
        this.computeInitKindAndMaybeInitializeClass(ConfigurableClassInitialization.getJavaClass(type));
    }

    private InitKind ensureClassInitialized(Class<?> clazz, boolean allowErrors) {
        try {
            Unsafe.getUnsafe().ensureClassInitialized(clazz);
            return InitKind.BUILD_TIME;
        }
        catch (NoClassDefFoundError ex) {
            if (allowErrors) {
                return InitKind.RUN_TIME;
            }
            if (!LinkAtBuildTimeSupport.singleton().linkAtBuildTime(clazz)) {
                System.out.println("Warning: class initialization of class " + clazz.getTypeName() + " failed with exception " + ex.getClass().getTypeName() + (String)(ex.getMessage() == null ? "" : ": " + ex.getMessage()) + ". This class will be initialized at run time. " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz));
                return InitKind.RUN_TIME;
            }
            return this.reportInitializationError("Class initialization of " + clazz.getTypeName() + " failed. " + LinkAtBuildTimeSupport.singleton().errorMessageFor(clazz) + " " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz), clazz, ex);
        }
        catch (Throwable t) {
            if (allowErrors) {
                return InitKind.RUN_TIME;
            }
            return this.reportInitializationError("Class initialization of " + clazz.getTypeName() + " failed. " + ConfigurableClassInitialization.instructionsToInitializeAtRuntime(clazz), clazz, t);
        }
    }

    private InitKind reportInitializationError(String msg, Class<?> clazz, Throwable t) {
        if (this.unsupportedFeatures != null) {
            this.unsupportedFeatures.addMessage(clazz.getTypeName(), null, msg, null, t);
            return InitKind.RUN_TIME;
        }
        throw UserError.abort(t, "%s", msg);
    }

    private static String instructionsToInitializeAtRuntime(Class<?> clazz) {
        return "Use the option " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, clazz.getTypeName(), "initialize-at-run-time") + " to explicitly request delayed initialization of this class.";
    }

    static Class<?> getJavaClass(ResolvedJavaType type) {
        return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)type);
    }

    public void initializeAtRunTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, true);
            this.initializeAtRunTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RUN_TIME, reason, false);
        }
    }

    public void initializeAtBuildTime(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, true);
            this.initializeAtBuildTime(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.BUILD_TIME, reason, false);
        }
    }

    public void rerunInitialization(String name, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        Class<?> clazz = this.loader.findClass(name).get();
        if (clazz != null) {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, true);
            this.rerunInitialization(clazz, reason);
        } else {
            this.classInitializationConfiguration.insert(name, InitKind.RERUN, reason, false);
        }
    }

    public void initializeAtRunTime(Class<?> clazz, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RUN_TIME, reason, true);
        this.setSubclassesAsRunTime(clazz);
        ConfigurableClassInitialization.checkEagerInitialization(clazz);
        if (!Unsafe.getUnsafe().shouldBeInitialized(clazz)) {
            throw UserError.abort("The class %1$s has already been initialized (%2$s); it is too late to register %1$s for build-time initialization. %3$s", clazz.getTypeName(), reason, ConfigurableClassInitialization.classInitializationErrorMessage(clazz, "Try avoiding this conflict by avoiding to initialize the class that caused initialization of " + clazz.getTypeName() + " or by not marking " + clazz.getTypeName() + " for build-time initialization."));
        }
        this.computeInitKindAndMaybeInitializeClass(clazz, false, null);
        InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RUN_TIME);
        if (previousKind == InitKind.BUILD_TIME) {
            throw UserError.abort("Class is already initialized, so it is too late to register delaying class initialization: %s for reason: %s", clazz.getTypeName(), reason);
        }
        if (previousKind == InitKind.RERUN) {
            throw UserError.abort("Class is registered both for delaying and rerunning the class initializer: %s for reason: %s", clazz.getTypeName(), reason);
        }
    }

    private static boolean isClassListedInStringOption(String option, Class<?> clazz) {
        return Arrays.asList(option.split(",")).contains(clazz.getName());
    }

    private static boolean isClassInitializationTracked(Class<?> clazz) {
        return SubstrateOptions.TraceClassInitialization.hasBeenSet() && ConfigurableClassInitialization.isClassListedInStringOption(SubstrateOptions.TraceClassInitialization.getValue(), clazz);
    }

    private static boolean isObjectInstantiationForClassTracked(Class<?> clazz) {
        return SubstrateOptions.TraceObjectInstantiation.hasBeenSet() && ConfigurableClassInitialization.isClassListedInStringOption(SubstrateOptions.TraceObjectInstantiation.getValue(), clazz);
    }

    private static String classInitializationErrorMessage(Class<?> clazz, String action) {
        if (!ConfigurableClassInitialization.isClassInitializationTracked(clazz)) {
            return "To see why " + clazz.getName() + " got initialized use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceClassInitialization, clazz.getName());
        }
        if (initializedClasses.containsKey(clazz)) {
            StackTraceElement[] trace = initializedClasses.get(clazz);
            String culprit = null;
            for (StackTraceElement stackTraceElement : trace) {
                if (!stackTraceElement.getMethodName().equals("<clinit>")) continue;
                culprit = stackTraceElement.getClassName();
            }
            if (culprit != null) {
                return culprit + " caused initialization of this class with the following trace: \n" + ConfigurableClassInitialization.classInitializationTrace(clazz);
            }
            return clazz.getTypeName() + " has been initialized through the following trace:\n" + ConfigurableClassInitialization.classInitializationTrace(clazz);
        }
        return clazz.getTypeName() + " has been initialized without the native-image initialization instrumentation and the stack trace can't be tracked. " + action;
    }

    @Override
    public String objectInstantiationTraceMessage(Object obj, String action) {
        if (!ConfigurableClassInitialization.isObjectInstantiationForClassTracked(obj.getClass())) {
            return " To see how this object got instantiated use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceObjectInstantiation, obj.getClass().getName()) + ".";
        }
        if (instantiatedObjects.containsKey(obj)) {
            String culprit = null;
            StackTraceElement[] trace = instantiatedObjects.get(obj);
            boolean containsLambdaMetaFactory = false;
            for (StackTraceElement stackTraceElement : trace) {
                if (stackTraceElement.getMethodName().equals("<clinit>")) {
                    culprit = stackTraceElement.getClassName();
                }
                if (!stackTraceElement.getClassName().equals("java.lang.invoke.LambdaMetafactory")) continue;
                containsLambdaMetaFactory = true;
            }
            if (containsLambdaMetaFactory) {
                return " Object was instantiated through a lambda (https://github.com/oracle/graal/issues/1218). Try marking " + obj.getClass().getTypeName() + " for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, obj.getClass().getTypeName(), "initialize-at-build-time") + ".";
            }
            if (culprit != null) {
                return " Object has been initialized by the " + culprit + " class initializer with a trace: \n " + ConfigurableClassInitialization.getTraceString(instantiatedObjects.get(obj)) + ". " + action;
            }
            return " Object has been initialized through the following trace:\n" + ConfigurableClassInitialization.getTraceString(instantiatedObjects.get(obj)) + ". " + action;
        }
        return " Object has been initialized without the native-image initialization instrumentation and the stack trace can't be tracked.";
    }

    @Override
    public String reasonForClass(Class<?> clazz) {
        InitKind initKind = (InitKind)((Object)this.classInitKinds.get(clazz));
        String reason = this.classInitializationConfiguration.lookupReason(clazz.getTypeName());
        if (initKind == InitKind.BUILD_TIME && this.provenSafeEarly.contains(clazz)) {
            return "class proven as side-effect free before analysis";
        }
        if (initKind == InitKind.BUILD_TIME && this.provenSafeLate.contains(clazz)) {
            return "class proven as side-effect free after analysis";
        }
        if (initKind.isRunTime()) {
            return "classes are initialized at run time by default";
        }
        if (reason != null) {
            return reason;
        }
        throw VMError.shouldNotReachHere("Must be either proven or specified");
    }

    private static String classInitializationTrace(Class<?> clazz) {
        return ConfigurableClassInitialization.getTraceString(initializedClasses.get(clazz));
    }

    public static Map<Class<?>, StackTraceElement[]> getInitializedClasses() {
        return initializedClasses;
    }

    public static String getTraceString(StackTraceElement[] trace) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < trace.length; ++i) {
            StackTraceElement stackTraceElement = trace[i];
            b.append("\tat ").append(stackTraceElement.toString()).append("\n");
        }
        return b.toString();
    }

    public void rerunInitialization(Class<?> clazz, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.RERUN, reason, true);
        ConfigurableClassInitialization.checkEagerInitialization(clazz);
        try {
            Unsafe.getUnsafe().ensureClassInitialized(clazz);
        }
        catch (Throwable ex) {
            throw UserError.abort(ex, "Class initialization failed for %s. The class is requested for re-running (reason: %s)", clazz.getTypeName(), reason);
        }
        this.computeInitKindAndMaybeInitializeClass(clazz, false, null);
        InitKind previousKind = this.classInitKinds.put(clazz, InitKind.RERUN);
        if (previousKind != null) {
            if (previousKind == InitKind.BUILD_TIME) {
                throw UserError.abort("The information that the class should be initialized during image building has already been used, so it is too late to register the class initializer of %s for re-running. The reason for re-run request is %s", clazz.getTypeName(), reason);
            }
            if (previousKind.isRunTime()) {
                throw UserError.abort("Class or a superclass is already registered for delaying the class initializer, so it is too late to register the class initializer of %s for re-running. The reason for re-run request is %s", clazz.getTypeName(), reason);
            }
        }
    }

    public void initializeAtBuildTime(Class<?> aClass, String reason) {
        UserError.guarantee(!this.configurationSealed, "The class initialization configuration can be changed only before the phase analysis.", new Object[0]);
        this.classInitializationConfiguration.insert(aClass.getTypeName(), InitKind.BUILD_TIME, reason, true);
        this.forceInitializeHosted(aClass, reason, false);
    }

    private void setSubclassesAsRunTime(Class<?> clazz) {
        if (clazz.isInterface() && !this.metaAccess.lookupJavaType(clazz).declaresDefaultMethods()) {
            return;
        }
        this.loader.findSubclasses(clazz, false).stream().filter(c -> !c.equals(clazz)).filter(c -> !c.isInterface() || this.metaAccess.lookupJavaType(c).declaresDefaultMethods()).forEach(c -> this.classInitializationConfiguration.insert(c.getTypeName(), InitKind.RUN_TIME, "subtype of " + clazz.getTypeName(), true));
    }

    public void reportClassInitialized(Class<?> clazz, StackTraceElement[] stackTrace) {
        assert (SubstrateOptions.TraceClassInitialization.hasBeenSet());
        initializedClasses.put(clazz, ConfigurableClassInitialization.relevantStackTrace(stackTrace));
    }

    public void reportObjectInstantiated(Object o, StackTraceElement[] stackTrace) {
        assert (SubstrateOptions.TraceObjectInstantiation.hasBeenSet());
        instantiatedObjects.putIfAbsent(o, ConfigurableClassInitialization.relevantStackTrace(stackTrace));
    }

    private static StackTraceElement[] relevantStackTrace(StackTraceElement[] stack) {
        ArrayList<StackTraceElement> filteredStack = new ArrayList<StackTraceElement>();
        int lastClinit = 0;
        boolean containsLambdaMetaFactory = false;
        for (int i = 0; i < stack.length; ++i) {
            StackTraceElement stackTraceElement = stack[i];
            if ("<clinit>".equals(stackTraceElement.getMethodName())) {
                lastClinit = i;
            }
            if (stackTraceElement.getClassName().equals("java.lang.invoke.LambdaMetafactory")) {
                containsLambdaMetaFactory = true;
            }
            filteredStack.add(stackTraceElement);
        }
        ArrayList<StackTraceElement> finalStack = lastClinit != 0 && !containsLambdaMetaFactory ? filteredStack.subList(0, lastClinit + 1) : filteredStack;
        return finalStack.toArray(new StackTraceElement[0]);
    }

    @Override
    public void forceInitializeHosted(Class<?> clazz, String reason, boolean allowInitializationErrors) {
        if (clazz == null) {
            return;
        }
        this.classInitializationConfiguration.insert(clazz.getTypeName(), InitKind.BUILD_TIME, reason, true);
        InitKind initKind = this.ensureClassInitialized(clazz, allowInitializationErrors);
        this.classInitKinds.put(clazz, initKind);
        this.forceInitializeHosted(clazz.getSuperclass(), "super type of " + clazz.getTypeName(), allowInitializationErrors);
        this.forceInitializeInterfaces(clazz.getInterfaces(), "super type of " + clazz.getTypeName());
    }

    private void forceInitializeInterfaces(Class<?>[] interfaces, String reason) {
        for (Class<?> iface : interfaces) {
            if (this.metaAccess.lookupJavaType(iface).declaresDefaultMethods()) {
                this.classInitializationConfiguration.insert(iface.getTypeName(), InitKind.BUILD_TIME, reason, true);
                this.ensureClassInitialized(iface, false);
                this.classInitKinds.put(iface, InitKind.BUILD_TIME);
            }
            this.forceInitializeInterfaces(iface.getInterfaces(), "super type of " + iface.getTypeName());
        }
    }

    @Override
    public boolean checkDelayedInitialization() {
        HashSet<Class> illegalyInitialized = new HashSet<Class>();
        for (Map.Entry entry : this.classInitKinds.entrySet()) {
            if (!((InitKind)((Object)entry.getValue())).isRunTime() || Unsafe.getUnsafe().shouldBeInitialized((Class)entry.getKey())) continue;
            illegalyInitialized.add((Class)entry.getKey());
        }
        if (illegalyInitialized.size() > 0) {
            StringBuilder detailedMessage = new StringBuilder("Classes that should be initialized at run time got initialized during image building:\n ");
            illegalyInitialized.forEach(c -> {
                InitKind specifiedKind = this.specifiedInitKindFor((Class<?>)c);
                if (specifiedKind == null) {
                    detailedMessage.append(c.getTypeName()).append(" was unintentionally initialized at build time. ");
                    detailedMessage.append(ConfigurableClassInitialization.classInitializationErrorMessage(c, "Try marking this class for build-time initialization with " + SubstrateOptionsParser.commandArgument(ClassInitializationOptions.ClassInitialization, c.getTypeName(), "initialize-at-build-time"))).append("\n");
                } else {
                    assert (specifiedKind.isRunTime()) : "Specified kind must be the same as actual kind for type " + c.getTypeName();
                    String reason = this.classInitializationConfiguration.lookupReason(c.getTypeName());
                    detailedMessage.append(c.getTypeName()).append(" the class was requested to be initialized at run time (").append(reason).append("). ").append(ConfigurableClassInitialization.classInitializationErrorMessage(c, "Try avoiding to initialize the class that caused initialization of " + c.getTypeName())).append("\n");
                }
            });
            if (!SubstrateOptions.TraceClassInitialization.hasBeenSet()) {
                String traceClassInitArguments = illegalyInitialized.stream().map(Class::getName).collect(Collectors.joining(","));
                System.out.println("To see how the classes got initialized, use " + SubstrateOptionsParser.commandArgument(SubstrateOptions.TraceClassInitialization, traceClassInitArguments));
            }
            throw UserError.abort("%s", detailedMessage);
        }
        return true;
    }

    private static void checkEagerInitialization(Class<?> clazz) {
        if (clazz.isPrimitive() || clazz.isArray()) {
            throw UserError.abort("Primitive types and array classes are initialized at build time because initialization is side-effect free. It is not possible (and also not useful) to register them for run time initialization. Culprit: %s", clazz.getTypeName());
        }
        if (clazz.isAnnotation()) {
            throw UserError.abort("Class initialization of annotation classes cannot be delayed to runtime. Culprit: %s", clazz.getTypeName());
        }
    }

    InitKind computeInitKindAndMaybeInitializeClass(Class<?> clazz, boolean memoize, Set<Class<?>> earlyClassInitializerAnalyzedClasses) {
        InitKind existing = (InitKind)((Object)this.classInitKinds.get(clazz));
        if (existing != null) {
            return existing;
        }
        if (clazz.isAnnotation()) {
            this.forceInitializeHosted(clazz, "all annotations are initialized", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.isEnum() && !Unsafe.getUnsafe().shouldBeInitialized(clazz)) {
            if (memoize) {
                this.forceInitializeHosted(clazz, "enums referred in annotations must be initialized", false);
            }
            return InitKind.BUILD_TIME;
        }
        if (clazz.isPrimitive()) {
            this.forceInitializeHosted(clazz, "primitive types are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.isArray()) {
            this.forceInitializeHosted(clazz, "arrays are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        if (Proxy.isProxyClass(clazz) && ConfigurableClassInitialization.isProxyFromAnnotation(clazz)) {
            this.forceInitializeHosted(clazz, "proxy classes are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        if (clazz.getTypeName().contains("$$StringConcat")) {
            this.forceInitializeHosted(clazz, "string concatenation classes are initialized at build time", false);
            return InitKind.BUILD_TIME;
        }
        InitKind specifiedInitKind = this.specifiedInitKindFor(clazz);
        InitKind clazzResult = specifiedInitKind != null ? specifiedInitKind : InitKind.RUN_TIME;
        InitKind superResult = InitKind.BUILD_TIME;
        if (clazz.getSuperclass() != null) {
            superResult = superResult.max(this.computeInitKindAndMaybeInitializeClass(clazz.getSuperclass(), memoize, earlyClassInitializerAnalyzedClasses));
        }
        superResult = superResult.max(this.processInterfaces(clazz, memoize, earlyClassInitializerAnalyzedClasses));
        if (memoize && superResult != InitKind.RUN_TIME && clazzResult == InitKind.RUN_TIME && this.canBeProvenSafe(clazz) && this.earlyClassInitializerAnalysis.canInitializeWithoutSideEffects(clazz, earlyClassInitializerAnalyzedClasses) && (clazzResult = this.ensureClassInitialized(clazz, true)) == InitKind.BUILD_TIME) {
            this.addProvenEarly(clazz);
        }
        InitKind result = superResult.max(clazzResult);
        if (memoize) {
            if (!result.isRunTime()) {
                result = result.max(this.ensureClassInitialized(clazz, false));
            }
            result = this.classInitKinds.merge(clazz, result, InitKind::min);
        }
        return result;
    }

    private InitKind processInterfaces(Class<?> clazz, boolean memoizeEager, Set<Class<?>> earlyClassInitializerAnalyzedClasses) {
        InitKind result = InitKind.BUILD_TIME;
        for (Class<?> iface : clazz.getInterfaces()) {
            result = this.metaAccess.lookupJavaType(iface).declaresDefaultMethods() ? result.max(this.computeInitKindAndMaybeInitializeClass(iface, memoizeEager, earlyClassInitializerAnalyzedClasses)) : result.max(this.processInterfaces(iface, memoizeEager, earlyClassInitializerAnalyzedClasses));
        }
        return result;
    }

    private static boolean isProxyFromAnnotation(Class<?> clazz) {
        for (Class<?> interfaces : clazz.getInterfaces()) {
            if (!interfaces.isAnnotation()) continue;
            return true;
        }
        return false;
    }

    void addProvenEarly(Class<?> clazz) {
        this.provenSafeEarly.add(clazz);
    }

    @Override
    public void setProvenSafeLate(Set<Class<?>> classes) {
        this.provenSafeLate = new HashSet(classes);
    }
}

