/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.fieldfolding;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.option.SubstrateOptionsParser;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.fieldfolding.StaticFinalFieldFoldingNodePlugin;
import com.oracle.svm.hosted.meta.HostedField;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.ResolvedJavaField;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.NodePlugin;
import org.graalvm.compiler.nodes.java.StoreFieldNode;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
final class StaticFinalFieldFoldingFeature
implements GraalFeature {
    BigBang bb;
    final Map<AnalysisField, JavaConstant> foldedFieldValues = new ConcurrentHashMap<AnalysisField, JavaConstant>();
    Map<AnalysisField, Integer> fieldCheckIndexMap;
    boolean[] fieldInitializationStatus;

    StaticFinalFieldFoldingFeature() {
    }

    public static StaticFinalFieldFoldingFeature singleton() {
        return (StaticFinalFieldFoldingFeature)ImageSingletons.lookup(StaticFinalFieldFoldingFeature.class);
    }

    public boolean isInConfiguration(Feature.IsInConfigurationAccess access) {
        return Options.OptStaticFinalFieldFolding.getValue();
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        access.getHostVM().addMethodAfterParsingListener(this::onAnalysisMethodParsed);
    }

    @Override
    public void registerGraphBuilderPlugins(Providers providers, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        if (reason != ParsingReason.JITCompilation) {
            plugins.appendNodePlugin((NodePlugin)new StaticFinalFieldFoldingNodePlugin(this));
        }
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess a) {
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)a;
        this.bb = access.getBigBang();
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.bb = null;
        ArrayList<AnalysisField> foldedFields = new ArrayList<AnalysisField>(this.foldedFieldValues.keySet());
        foldedFields.sort(Comparator.comparing(field -> field.format("%H.%n")));
        this.fieldCheckIndexMap = new HashMap<AnalysisField, Integer>();
        int fieldCheckIndex = 0;
        for (AnalysisField field2 : foldedFields) {
            this.fieldCheckIndexMap.put(field2, fieldCheckIndex);
            ++fieldCheckIndex;
        }
        this.fieldInitializationStatus = new boolean[fieldCheckIndex];
    }

    public void afterHeapLayout(Feature.AfterHeapLayoutAccess access) {
        for (Map.Entry<AnalysisField, Integer> entry : this.fieldCheckIndexMap.entrySet()) {
            if (!entry.getKey().getDeclaringClass().isInitialized()) continue;
            this.fieldInitializationStatus[entry.getValue().intValue()] = true;
        }
    }

    void onAnalysisMethodParsed(AnalysisMethod method, StructuredGraph graph) {
        boolean isClassInitializer = method.isClassInitializer();
        HashMap<AnalysisField, JavaConstant> optimizableFields = isClassInitializer ? new HashMap<AnalysisField, JavaConstant>() : null;
        HashSet<AnalysisField> ineligibleFields = isClassInitializer ? new HashSet<AnalysisField>() : null;
        for (Node n : graph.getNodes()) {
            StoreFieldNode node;
            AnalysisField field;
            if (!(n instanceof StoreFieldNode) || !(field = (AnalysisField)(node = (StoreFieldNode)n).field()).isStatic() || !field.isFinal()) continue;
            if (isClassInitializer && field.getDeclaringClass().equals((Object)method.getDeclaringClass())) {
                StaticFinalFieldFoldingFeature.analyzeStoreInClassInitializer(node, field, optimizableFields, ineligibleFields);
                continue;
            }
            this.analyzeStoreOutsideClassInitializer(method, field);
        }
        if (optimizableFields != null && !optimizableFields.isEmpty()) {
            this.foldedFieldValues.putAll(optimizableFields);
        }
    }

    private static void analyzeStoreInClassInitializer(StoreFieldNode node, AnalysisField field, Map<AnalysisField, JavaConstant> optimizableFields, Set<AnalysisField> ineligibleFields) {
        if (field.isSynthetic() && field.getName().startsWith("$assertionsDisabled")) {
            return;
        }
        if (node.value().isJavaConstant() && !ineligibleFields.contains(field)) {
            JavaConstant existingValue = optimizableFields.get(field);
            JavaConstant newValue = node.value().asJavaConstant();
            if (existingValue == null || existingValue.equals(newValue)) {
                optimizableFields.put(field, newValue);
                return;
            }
        }
        ineligibleFields.add(field);
        optimizableFields.remove(field);
    }

    private void analyzeStoreOutsideClassInitializer(AnalysisMethod method, AnalysisField field) {
        if (field.getDeclaringClass().getClassInitializer() != null) {
            field.getDeclaringClass().getClassInitializer().ensureGraphParsed(this.bb);
        }
        if (this.foldedFieldValues.containsKey(field)) {
            throw new UnsupportedOperationException("The static final field optimization found a static final field that is initialized both inside and outside of its class initializer. Field " + field.format("%H.%n") + " is stored in method " + method.format("%H.%n(%p)") + ". This violates the Java bytecode specification. You can use " + SubstrateOptionsParser.commandArgument(Options.OptStaticFinalFieldFolding, "-") + " to disable the optimization.");
        }
    }

    static AnalysisField toAnalysisField(ResolvedJavaField field) {
        if (field instanceof HostedField) {
            return ((HostedField)field).wrapped;
        }
        return (AnalysisField)field;
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> OptStaticFinalFieldFolding = new HostedOptionKey<Boolean>(true);
    }
}

