/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.substitute;

import com.oracle.graal.pointsto.infrastructure.OriginalFieldProvider;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.annotate.Delete;
import com.oracle.svm.core.annotate.InjectAccessors;
import com.oracle.svm.core.meta.ReadableJavaField;
import com.oracle.svm.util.ClassUtil;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;

public class AnnotatedField
implements ReadableJavaField,
OriginalFieldProvider {
    private final ResolvedJavaField original;
    private final Annotation injectedAnnotation;

    static Annotation[] appendAnnotationTo(Annotation[] array, Annotation element) {
        Annotation[] result = Arrays.copyOf(array, array.length + 1);
        result[result.length - 1] = element;
        return result;
    }

    public AnnotatedField(ResolvedJavaField original, Annotation injectedAnnotation) {
        this.original = original;
        this.injectedAnnotation = injectedAnnotation;
    }

    public Annotation[] getAnnotations() {
        return AnnotatedField.appendAnnotationTo(this.original.getAnnotations(), this.injectedAnnotation);
    }

    public Annotation[] getDeclaredAnnotations() {
        return AnnotatedField.appendAnnotationTo(this.original.getDeclaredAnnotations(), this.injectedAnnotation);
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        if (annotationClass.isInstance(this.injectedAnnotation)) {
            return (T)((Annotation)annotationClass.cast(this.injectedAnnotation));
        }
        return (T)this.original.getAnnotation(annotationClass);
    }

    @Override
    public JavaConstant readValue(MetaAccessProvider metaAccess, JavaConstant receiver) {
        return ReadableJavaField.readFieldValue(metaAccess, GraalAccess.getOriginalProviders().getConstantReflection(), this.original, receiver);
    }

    @Override
    public boolean allowConstantFolding() {
        assert (this.injectedAnnotation instanceof Delete || this.injectedAnnotation instanceof InjectAccessors) : "Unknown annotation @" + ClassUtil.getUnqualifiedName(this.injectedAnnotation.annotationType()) + ", should constant folding be permitted?";
        return false;
    }

    @Override
    public boolean injectFinalForRuntimeCompilation() {
        return ReadableJavaField.injectFinalForRuntimeCompilation(this.original);
    }

    public String getName() {
        return this.original.getName();
    }

    public JavaType getType() {
        return this.original.getType();
    }

    public int getModifiers() {
        return this.original.getModifiers();
    }

    public int getOffset() {
        return this.original.getOffset();
    }

    public boolean isInternal() {
        return this.original.isInternal();
    }

    public boolean isSynthetic() {
        return this.original.isSynthetic();
    }

    public ResolvedJavaType getDeclaringClass() {
        return this.original.getDeclaringClass();
    }

    public String toString() {
        return "InjectedAnnotationField<original " + this.original.toString() + ", annotation: " + this.injectedAnnotation + ">";
    }

    public Field getJavaField() {
        return OriginalFieldProvider.getJavaField((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaField)this.original);
    }
}

