/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.jni.access;

import com.oracle.graal.pointsto.BigBang;
import com.oracle.graal.pointsto.meta.AnalysisField;
import com.oracle.graal.pointsto.meta.AnalysisMethod;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.configure.ConditionalElement;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ReflectionConfigurationParser;
import com.oracle.svm.core.jni.JNIRuntimeAccess;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.hosted.ConditionalConfigurationRegistry;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ProgressReporter;
import com.oracle.svm.hosted.c.NativeLibraries;
import com.oracle.svm.hosted.code.CEntryPointData;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.hosted.meta.MaterializedConstantFields;
import com.oracle.svm.hosted.substitute.SubstitutionReflectivityFilter;
import com.oracle.svm.jni.JNIJavaCallTrampolines;
import com.oracle.svm.jni.JNISupport;
import com.oracle.svm.jni.access.JNIAccessibleClass;
import com.oracle.svm.jni.access.JNIAccessibleField;
import com.oracle.svm.jni.access.JNIAccessibleMethod;
import com.oracle.svm.jni.access.JNIAccessibleMethodDescriptor;
import com.oracle.svm.jni.access.JNINativeLinkage;
import com.oracle.svm.jni.access.JNIReflectionDictionary;
import com.oracle.svm.jni.hosted.JNICallTrampolineMethod;
import com.oracle.svm.jni.hosted.JNIFieldAccessorMethod;
import com.oracle.svm.jni.hosted.JNIJavaCallWrapperMethod;
import com.oracle.svm.util.ReflectionUtil;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.vm.ci.meta.JavaField;
import jdk.vm.ci.meta.JavaMethod;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.MetaAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import org.graalvm.compiler.api.replacements.Fold;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.impl.ConfigurationCondition;
import org.graalvm.nativeimage.impl.ReflectionRegistry;

public class JNIAccessFeature
implements Feature {
    private boolean sealed = false;
    private NativeLibraries nativeLibraries;
    private final Map<String, JNICallTrampolineMethod> trampolineMethods = new ConcurrentHashMap<String, JNICallTrampolineMethod>();
    private int loadedConfigurations;
    private final Set<Class<?>> newClasses = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Set<Executable> newMethods = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Map<Field, Boolean> newFields = new ConcurrentHashMap<Field, Boolean>();
    private final Map<JNINativeLinkage, JNINativeLinkage> newLinkages = new ConcurrentHashMap<JNINativeLinkage, JNINativeLinkage>();
    private final Map<JNINativeLinkage, JNINativeLinkage> nativeLinkages = new ConcurrentHashMap<JNINativeLinkage, JNINativeLinkage>();

    @Fold
    public static JNIAccessFeature singleton() {
        return (JNIAccessFeature)ImageSingletons.lookup(JNIAccessFeature.class);
    }

    private void abortIfSealed() {
        UserError.guarantee(!this.sealed, "Classes, methods and fields must be registered for JNI access before the analysis has completed.", new Object[0]);
    }

    public void afterRegistration(Feature.AfterRegistrationAccess arg) {
        FeatureImpl.AfterRegistrationAccessImpl access = (FeatureImpl.AfterRegistrationAccessImpl)arg;
        JNIReflectionDictionary.initialize();
        JNIRuntimeAccessibilitySupportImpl registry = new JNIRuntimeAccessibilitySupportImpl();
        ImageSingletons.add(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport.class, (Object)registry);
        ReflectionConfigurationParser<ConditionalElement<Class<?>>> parser = ConfigurationParserUtils.create(registry, access.getImageClassLoader());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, access.getImageClassLoader(), "JNI", ConfigurationFiles.Options.JNIConfigurationFiles, ConfigurationFiles.Options.JNIConfigurationResources, ConfigurationFile.JNI.getFileName());
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess arg) {
        if (!ImageSingletons.contains(JNIFieldAccessorMethod.Factory.class)) {
            ImageSingletons.add(JNIFieldAccessorMethod.Factory.class, (Object)new JNIFieldAccessorMethod.Factory());
        }
        if (!ImageSingletons.contains(JNISupport.class)) {
            ImageSingletons.add(JNISupport.class, (Object)new JNISupport());
        }
        FeatureImpl.BeforeAnalysisAccessImpl access = (FeatureImpl.BeforeAnalysisAccessImpl)arg;
        this.nativeLibraries = access.getNativeLibraries();
        for (JNIJavaCallWrapperMethod.CallVariant variant : JNIJavaCallWrapperMethod.CallVariant.values()) {
            JNIAccessFeature.registerJavaCallTrampoline(access, variant, false);
            JNIAccessFeature.registerJavaCallTrampoline(access, variant, true);
        }
        JNIAccessFeature.getConditionalConfigurationRegistry().flushConditionalConfiguration(access);
    }

    private static ConditionalConfigurationRegistry getConditionalConfigurationRegistry() {
        return (ConditionalConfigurationRegistry)ImageSingletons.lookup(JNIRuntimeAccess.JNIRuntimeAccessibilitySupport.class);
    }

    private static void registerJavaCallTrampoline(FeatureImpl.BeforeAnalysisAccessImpl access, JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        MetaAccessProvider originalMetaAccess = access.getMetaAccess().getWrapped();
        ResolvedJavaField field = JNIAccessibleMethod.getCallWrapperField(originalMetaAccess, variant, nonVirtual);
        access.getUniverse().lookup((JavaType)field.getDeclaringClass()).registerAsReachable();
        access.registerAsAccessed(access.getUniverse().lookup((JavaField)field));
        String name = JNIJavaCallTrampolines.getTrampolineName(variant, nonVirtual);
        Method method = ReflectionUtil.lookupMethod(JNIJavaCallTrampolines.class, (String)name, (Class[])new Class[0]);
        access.registerAsCompiled(method, true);
    }

    public JNICallTrampolineMethod getCallTrampolineMethod(JNIJavaCallWrapperMethod.CallVariant variant, boolean nonVirtual) {
        String name = JNIJavaCallTrampolines.getTrampolineName(variant, nonVirtual);
        return this.getCallTrampolineMethod(name);
    }

    public JNICallTrampolineMethod getCallTrampolineMethod(String trampolineName) {
        JNICallTrampolineMethod trampoline = this.trampolineMethods.get(trampolineName);
        assert (trampoline != null);
        return trampoline;
    }

    public JNICallTrampolineMethod getOrCreateCallTrampolineMethod(MetaAccessProvider metaAccess, String trampolineName) {
        return this.trampolineMethods.computeIfAbsent(trampolineName, name -> {
            Method reflectionMethod = ReflectionUtil.lookupMethod(JNIJavaCallTrampolines.class, (String)name, (Class[])new Class[0]);
            boolean nonVirtual = JNIJavaCallTrampolines.isNonVirtual(name);
            ResolvedJavaField field = JNIAccessibleMethod.getCallWrapperField(metaAccess, JNIJavaCallTrampolines.getVariant(name), nonVirtual);
            ResolvedJavaMethod method = metaAccess.lookupJavaMethod((Executable)reflectionMethod);
            return new JNICallTrampolineMethod(method, field, nonVirtual);
        });
    }

    public JNINativeLinkage makeLinkage(String declaringClass, String name, String descriptor) {
        UserError.guarantee(!this.sealed, "All linkages for JNI calls must be created before the analysis has completed.%nOffending class: %s name: %s descriptor: %s", declaringClass, name, descriptor);
        JNINativeLinkage key = new JNINativeLinkage(declaringClass, name, descriptor);
        if (Options.PrintJNIMethods.getValue().booleanValue()) {
            System.out.println("Creating a new JNINativeLinkage: " + key.toString());
        }
        return this.nativeLinkages.computeIfAbsent(key, linkage -> {
            this.newLinkages.put((JNINativeLinkage)linkage, (JNINativeLinkage)linkage);
            return linkage;
        });
    }

    private boolean wereElementsAdded() {
        return !this.newClasses.isEmpty() || !this.newMethods.isEmpty() || !this.newFields.isEmpty() || !this.newLinkages.isEmpty();
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        JNIAccessFeature.getConditionalConfigurationRegistry().flushConditionalConfiguration(a);
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        if (!this.wereElementsAdded()) {
            return;
        }
        for (Class<?> clazz : this.newClasses) {
            JNIAccessFeature.addClass(clazz, access);
        }
        this.newClasses.clear();
        for (Executable method : this.newMethods) {
            this.addMethod(method, access);
        }
        this.newMethods.clear();
        this.newFields.forEach((field, writable) -> JNIAccessFeature.addField(field, writable, access));
        this.newFields.clear();
        JNIReflectionDictionary.singleton().addLinkages(this.newLinkages);
        this.newLinkages.clear();
        access.requireAnalysisIteration();
    }

    private static JNIAccessibleClass addClass(Class<?> classObj, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstitutionReflectivityFilter.shouldExclude(classObj, access.getMetaAccess(), access.getUniverse())) {
            return null;
        }
        return JNIReflectionDictionary.singleton().addClassIfAbsent(classObj, c -> {
            AnalysisType analysisClass = access.getMetaAccess().lookupJavaType(classObj);
            if (analysisClass.isInterface() || analysisClass.isInstanceClass() && analysisClass.isAbstract()) {
                analysisClass.registerAsReachable();
            } else {
                analysisClass.registerAsAllocated(null);
            }
            return new JNIAccessibleClass(classObj);
        });
    }

    private void addMethod(Executable method, FeatureImpl.DuringAnalysisAccessImpl access) {
        if (SubstitutionReflectivityFilter.shouldExclude(method, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(method.getDeclaringClass(), access);
        JNIAccessibleMethodDescriptor descriptor = JNIAccessibleMethodDescriptor.of(method);
        jniClass.addMethodIfAbsent(descriptor, d -> {
            MetaAccessProvider wrappedMetaAccess = access.getMetaAccess().getWrapped();
            JNIJavaCallWrapperMethod varargsCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VARARGS, false, wrappedMetaAccess, this.nativeLibraries);
            JNIJavaCallWrapperMethod arrayCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.ARRAY, false, wrappedMetaAccess, this.nativeLibraries);
            JNIJavaCallWrapperMethod valistCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VA_LIST, false, wrappedMetaAccess, this.nativeLibraries);
            Stream<JNIJavaCallWrapperMethod> wrappers = Stream.of(varargsCallWrapper, arrayCallWrapper, valistCallWrapper);
            JNIJavaCallWrapperMethod varargsNonvirtualCallWrapper = null;
            JNIJavaCallWrapperMethod arrayNonvirtualCallWrapper = null;
            JNIJavaCallWrapperMethod valistNonvirtualCallWrapper = null;
            if (!Modifier.isStatic(method.getModifiers()) && !Modifier.isAbstract(method.getModifiers())) {
                varargsNonvirtualCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VARARGS, true, wrappedMetaAccess, this.nativeLibraries);
                arrayNonvirtualCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.ARRAY, true, wrappedMetaAccess, this.nativeLibraries);
                valistNonvirtualCallWrapper = new JNIJavaCallWrapperMethod(method, JNIJavaCallWrapperMethod.CallVariant.VA_LIST, true, wrappedMetaAccess, this.nativeLibraries);
                wrappers = Stream.concat(wrappers, Stream.of(varargsNonvirtualCallWrapper, arrayNonvirtualCallWrapper, valistNonvirtualCallWrapper));
            }
            JNIAccessibleMethod jniMethod = new JNIAccessibleMethod((JNIAccessibleMethodDescriptor)d, method.getModifiers(), jniClass, varargsCallWrapper, arrayCallWrapper, valistCallWrapper, varargsNonvirtualCallWrapper, arrayNonvirtualCallWrapper, valistNonvirtualCallWrapper);
            CEntryPointData unpublished = CEntryPointData.createCustomUnpublished();
            wrappers.forEach(wrapper -> {
                AnalysisMethod analysisWrapper = access.getUniverse().lookup((JavaMethod)wrapper);
                access.getBigBang().addRootMethod(analysisWrapper, true);
                analysisWrapper.registerAsEntryPoint((Object)unpublished);
            });
            return jniMethod;
        });
    }

    private static void addField(Field reflField, boolean writable, FeatureImpl.DuringAnalysisAccessImpl access) {
        access.getMetaAccess().lookupJavaType(reflField.getDeclaringClass()).registerAsReachable();
        if (SubstitutionReflectivityFilter.shouldExclude(reflField, access.getMetaAccess(), access.getUniverse())) {
            return;
        }
        JNIAccessibleClass jniClass = JNIAccessFeature.addClass(reflField.getDeclaringClass(), access);
        AnalysisField field = access.getMetaAccess().lookupJavaField(reflField);
        jniClass.addFieldIfAbsent(field.getName(), name -> new JNIAccessibleField(jniClass, (String)name, field.getJavaKind(), field.getModifiers()));
        field.registerAsJNIAccessed();
        field.registerAsRead(null);
        if (writable) {
            field.registerAsWritten(null);
            AnalysisType fieldType = field.getType();
            if (fieldType.isArray() && !access.isReachable(fieldType)) {
                access.registerReachabilityHandler(a -> fieldType.registerAsAllocated(null), ((AnalysisType)fieldType.getElementalType()).getJavaClass());
            }
        } else if (field.isStatic() && field.isFinal()) {
            MaterializedConstantFields.singleton().register(field);
        }
        BigBang bb = access.getBigBang();
        bb.registerAsJNIAccessed(field, writable);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        this.sealed = true;
        if (this.wereElementsAdded()) {
            this.abortIfSealed();
        }
        int numClasses = 0;
        int numFields = 0;
        int numMethods = 0;
        for (JNIAccessibleClass clazz : JNIReflectionDictionary.singleton().getClasses()) {
            ++numClasses;
            for (JNIAccessibleField f : clazz.getFields()) {
                ++numFields;
            }
            for (JNIAccessibleMethod m : clazz.getMethods()) {
                ++numMethods;
            }
        }
        ProgressReporter.singleton().setJNIInfo(numClasses, numFields, numMethods);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess a) {
        FallbackFeature.FallbackImageRequest jniFallback;
        if (ImageSingletons.contains(FallbackFeature.class) && (jniFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).jniFallback) != null && this.loadedConfigurations == 0) {
            throw jniFallback;
        }
        FeatureImpl.CompilationAccessImpl access = (FeatureImpl.CompilationAccessImpl)a;
        for (JNIAccessibleClass clazz : JNIReflectionDictionary.singleton().getClasses()) {
            for (JNIAccessibleField field : clazz.getFields()) {
                field.finishBeforeCompilation(access);
            }
            for (JNIAccessibleMethod method : clazz.getMethods()) {
                method.finishBeforeCompilation(access);
                access.registerAsImmutable(method);
            }
        }
    }

    private class JNIRuntimeAccessibilitySupportImpl
    extends ConditionalConfigurationRegistry
    implements JNIRuntimeAccess.JNIRuntimeAccessibilitySupport,
    ReflectionRegistry {
        private JNIRuntimeAccessibilitySupportImpl() {
        }

        public void register(ConfigurationCondition condition, boolean unsafeAllocated, Class<?> clazz) {
            assert (!unsafeAllocated) : "unsafeAllocated can be only set via Unsafe.allocateInstance, not via JNI.";
            JNIAccessFeature.this.abortIfSealed();
            this.registerConditionalConfiguration(condition, () -> JNIAccessFeature.this.newClasses.add(clazz));
        }

        public void register(ConfigurationCondition condition, boolean queriedOnly, Executable ... methods) {
            JNIAccessFeature.this.abortIfSealed();
            this.registerConditionalConfiguration(condition, () -> JNIAccessFeature.this.newMethods.addAll(Arrays.asList(methods)));
        }

        public void register(ConfigurationCondition condition, boolean finalIsWritable, Field ... fields) {
            JNIAccessFeature.this.abortIfSealed();
            this.registerConditionalConfiguration(condition, () -> this.registerFields(finalIsWritable, fields));
        }

        private void registerFields(boolean finalIsWritable, Field[] fields) {
            for (Field field : fields) {
                boolean writable = finalIsWritable || !Modifier.isFinal(field.getModifiers());
                JNIAccessFeature.this.newFields.put(field, writable);
            }
        }
    }

    public static class Options {
        public static final HostedOptionKey<Boolean> PrintJNIMethods = new HostedOptionKey<Boolean>(false);
    }
}

