/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.reflect.proxy.hosted;

import com.oracle.svm.core.annotate.AutomaticFeature;
import com.oracle.svm.core.configure.ConfigurationFile;
import com.oracle.svm.core.configure.ConfigurationFiles;
import com.oracle.svm.core.configure.ProxyConfigurationParser;
import com.oracle.svm.core.jdk.proxy.DynamicProxyRegistry;
import com.oracle.svm.hosted.ConfigurationTypeResolver;
import com.oracle.svm.hosted.FallbackFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.ImageClassLoader;
import com.oracle.svm.hosted.config.ConfigurationParserUtils;
import com.oracle.svm.reflect.hosted.ReflectionFeature;
import com.oracle.svm.reflect.proxy.DynamicProxySupport;
import com.oracle.svm.reflect.proxy.hosted.ProxyRegistry;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticFeature
public final class DynamicProxyFeature
implements Feature {
    private int loadedConfigurations;
    private Field proxyCacheField;

    public List<Class<? extends Feature>> getRequiredFeatures() {
        return Collections.singletonList(ReflectionFeature.class);
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        ImageClassLoader imageClassLoader = access.getImageClassLoader();
        DynamicProxySupport dynamicProxySupport = new DynamicProxySupport(imageClassLoader.getClassLoader());
        ImageSingletons.add(DynamicProxyRegistry.class, (Object)dynamicProxySupport);
        ConfigurationTypeResolver typeResolver = new ConfigurationTypeResolver("resource configuration", imageClassLoader);
        ProxyRegistry proxyRegistry = new ProxyRegistry(typeResolver, dynamicProxySupport, imageClassLoader);
        ImageSingletons.add(ProxyRegistry.class, (Object)proxyRegistry);
        ProxyConfigurationParser parser = new ProxyConfigurationParser(proxyRegistry, ConfigurationFiles.Options.StrictConfiguration.getValue());
        this.loadedConfigurations = ConfigurationParserUtils.parseAndRegisterConfigurations(parser, imageClassLoader, "dynamic proxy", ConfigurationFiles.Options.DynamicProxyConfigurationFiles, ConfigurationFiles.Options.DynamicProxyConfigurationResources, ConfigurationFile.DYNAMIC_PROXY.getFileName());
        this.proxyCacheField = access.findField((Class)DynamicProxySupport.class, "proxyCache");
    }

    private static ProxyRegistry proxyRegistry() {
        return (ProxyRegistry)ImageSingletons.lookup(ProxyRegistry.class);
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        DynamicProxyFeature.proxyRegistry().flushConditionalConfiguration(access);
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        access.rescanField(ImageSingletons.lookup(DynamicProxyRegistry.class), this.proxyCacheField);
        DynamicProxyFeature.proxyRegistry().flushConditionalConfiguration(a);
    }

    public void beforeCompilation(Feature.BeforeCompilationAccess access) {
        if (!ImageSingletons.contains(FallbackFeature.class)) {
            return;
        }
        FallbackFeature.FallbackImageRequest proxyFallback = ((FallbackFeature)ImageSingletons.lookup(FallbackFeature.class)).proxyFallback;
        if (proxyFallback != null && this.loadedConfigurations == 0) {
            throw proxyFallback;
        }
    }
}

