/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.truffle;

import com.oracle.graal.pointsto.infrastructure.OriginalClassProvider;
import com.oracle.graal.pointsto.meta.AnalysisMetaAccess;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.util.GraalAccess;
import com.oracle.svm.core.ParsingReason;
import com.oracle.svm.core.configure.ResourcesRegistry;
import com.oracle.svm.core.graal.GraalFeature;
import com.oracle.svm.core.util.UserError;
import com.oracle.svm.core.util.VMError;
import com.oracle.svm.graal.hosted.GraalObjectReplacer;
import com.oracle.svm.graal.hosted.GraalProviderObjectReplacements;
import com.oracle.svm.graal.hosted.RuntimeGraalSetup;
import com.oracle.svm.graal.hosted.SubstrateRuntimeGraalSetup;
import com.oracle.svm.graal.meta.SubstrateType;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.snippets.SubstrateGraphBuilderPlugins;
import com.oracle.svm.truffle.Target_com_oracle_truffle_api_staticobject_StaticShape_Builder;
import com.oracle.svm.truffle.TruffleFeature;
import com.oracle.svm.truffle.api.SubstrateTruffleRuntime;
import com.oracle.svm.util.ReflectionUtil;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.Truffle;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import com.oracle.truffle.api.instrumentation.TruffleInstrument;
import com.oracle.truffle.api.library.DefaultExportProvider;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeClass;
import com.oracle.truffle.api.nodes.NodeCloneable;
import com.oracle.truffle.api.nodes.NodeFieldAccessor;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.Layout;
import com.oracle.truffle.api.profiles.Profile;
import com.oracle.truffle.api.staticobject.StaticShape;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BooleanSupplier;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.JavaType;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.api.replacements.SnippetReflectionProvider;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderConfiguration;
import org.graalvm.compiler.nodes.graphbuilderconf.GraphBuilderContext;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugin;
import org.graalvm.compiler.nodes.graphbuilderconf.InvocationPlugins;
import org.graalvm.compiler.phases.util.Providers;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.hosted.Feature;
import org.graalvm.nativeimage.hosted.RuntimeClassInitialization;
import org.graalvm.nativeimage.hosted.RuntimeReflection;
import org.graalvm.nativeimage.impl.ConfigurationCondition;

public final class TruffleBaseFeature
implements GraalFeature {
    private ClassLoader imageClassLoader;
    private AnalysisMetaAccess metaAccess;
    private GraalObjectReplacer graalObjectReplacer;
    private final Set<Class<?>> registeredClasses = new HashSet();
    private boolean profilingEnabled;
    private boolean needsAllEncodings;
    private Field layoutInfoMapField;
    private Field layoutMapField;
    private Field libraryFactoryCacheField;
    private final Set<Class<?>> dynamicObjectClasses = new HashSet();

    private static void initializeTruffleReflectively(ClassLoader imageClassLoader) {
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.Accessor", "getTVMCI", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "initializeNativeImageState", Collections.singletonList(ClassLoader.class), imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "initializeNativeImageState", Collections.emptyList(), new Object[0]);
    }

    public static void removeTruffleLanguage(String mimeType) {
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "removeLanguageFromNativeImage", Collections.singletonList(String.class), mimeType);
    }

    static <T> T invokeStaticMethod(String className, String methodName, Collection<Class<?>> parameterTypes, Object ... args) {
        try {
            Class<?> clazz = Class.forName(className);
            Method method = ReflectionUtil.lookupMethod(clazz, (String)methodName, (Class[])parameterTypes.toArray(new Class[0]));
            return (T)method.invoke(null, args);
        }
        catch (ReflectiveOperationException e) {
            throw VMError.shouldNotReachHere(e);
        }
    }

    public void afterRegistration(Feature.AfterRegistrationAccess a) {
        this.imageClassLoader = a.getApplicationClassLoader();
        TruffleRuntime runtime = Truffle.getRuntime();
        UserError.guarantee(runtime != null, "TruffleRuntime not available via Truffle.getRuntime()", new Object[0]);
        UserError.guarantee(runtime instanceof SubstrateTruffleRuntime || runtime instanceof DefaultTruffleRuntime, "Unsupported TruffleRuntime %s (only SubstrateTruffleRuntime or DefaultTruffleRuntime allowed)", runtime.getClass().getName());
        RuntimeClassInitialization.initializeAtBuildTime((String[])new String[]{"com.oracle.graalvm.locator", "Truffle classes are always initialized at build time"});
        for (TruffleLanguage.Provider provider : ServiceLoader.load(TruffleLanguage.Provider.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{provider.getClass()});
        }
        for (TruffleInstrument.Provider provider : ServiceLoader.load(TruffleInstrument.Provider.class)) {
            RuntimeClassInitialization.initializeAtBuildTime((Class[])new Class[]{provider.getClass()});
        }
        TruffleBaseFeature.initializeTruffleReflectively(this.imageClassLoader);
        this.needsAllEncodings = (Boolean)TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "getNeedsAllEncodings", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory", "reinitializeNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.TruffleLogger$LoggerCache", "getInstance", Collections.emptyList(), new Object[0]);
        this.profilingEnabled = false;
    }

    public void setProfilingEnabled(boolean profilingEnabled) {
        this.profilingEnabled = profilingEnabled;
    }

    public void cleanup() {
        TruffleRuntime runtime = Truffle.getRuntime();
        if (!(runtime instanceof DefaultTruffleRuntime) && !(runtime instanceof SubstrateTruffleRuntime)) {
            throw VMError.shouldNotReachHere("Only SubstrateTruffleRuntime and DefaultTruffleRuntime supported");
        }
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.PolyglotFastThreadLocals", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.LanguageCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.polyglot.InstrumentCache", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "resetPreInitializedEngine", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.TruffleLocator", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.ThreadLocalHandshake", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory", "resetNativeImageState", Collections.singletonList(ClassLoader.class), this.imageClassLoader);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.source.Source", "resetNativeImageState", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.object.LayoutImpl", "resetNativeImageState", Collections.emptyList(), new Object[0]);
    }

    @Override
    public void registerInvocationPlugins(Providers providers, SnippetReflectionProvider snippetReflection, GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
        StaticObjectSupport.registerInvocationPlugins(plugins, reason);
        InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), Profile.class);
        r.register((InvocationPlugin)new InvocationPlugin.RequiredInvocationPlugin("isProfilingEnabled", new Type[0]){

            public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver) {
                b.addPush(JavaKind.Boolean, (ValueNode)ConstantNode.forBoolean((boolean)TruffleBaseFeature.this.profilingEnabled));
                return true;
            }
        });
        if (reason != ParsingReason.JITCompilation) {
            r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), CompilerDirectives.class);
            SubstrateGraphBuilderPlugins.registerCastExact(r);
        }
    }

    public void duringSetup(Feature.DuringSetupAccess access) {
        if (!ImageSingletons.contains(TruffleFeature.class) && Truffle.getRuntime() instanceof SubstrateTruffleRuntime) {
            VMError.shouldNotReachHere("TruffleFeature is required for SubstrateTruffleRuntime.");
        }
        FeatureImpl.DuringSetupAccessImpl config = (FeatureImpl.DuringSetupAccessImpl)access;
        this.metaAccess = ((FeatureImpl.DuringSetupAccessImpl)access).getMetaAccess();
        if (!ImageSingletons.contains(RuntimeGraalSetup.class)) {
            ImageSingletons.add(RuntimeGraalSetup.class, (Object)new SubstrateRuntimeGraalSetup());
        }
        GraalProviderObjectReplacements providerReplacements = ((RuntimeGraalSetup)ImageSingletons.lookup(RuntimeGraalSetup.class)).getProviderObjectReplacements(this.metaAccess);
        this.graalObjectReplacer = new GraalObjectReplacer(config.getUniverse(), this.metaAccess, providerReplacements);
        access.registerObjectReplacer(this::replaceNodeFieldAccessor);
        this.layoutInfoMapField = config.findField("com.oracle.truffle.object.DefaultLayout$LayoutInfo", "LAYOUT_INFO_MAP");
        this.layoutMapField = config.findField("com.oracle.truffle.object.DefaultLayout", "LAYOUT_MAP");
        this.libraryFactoryCacheField = config.findField("com.oracle.truffle.api.library.LibraryFactory$ResolvedDispatch", "CACHE");
    }

    private Object replaceNodeFieldAccessor(Object source) {
        if (source instanceof NodeFieldAccessor || source instanceof NodeFieldAccessor[] && ((NodeFieldAccessor[])source).length > 0) {
            throw VMError.shouldNotReachHere("Cannot have NodeFieldAccessor in image, they must be created lazily");
        }
        if (source instanceof NodeClass && !(source instanceof SubstrateType)) {
            NodeClass nodeClass = (NodeClass)source;
            SubstrateType replacement = this.graalObjectReplacer.createType((JavaType)this.metaAccess.lookupJavaType(nodeClass.getType()));
            assert (replacement != null);
            return replacement;
        }
        return source;
    }

    public void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
        StaticObjectSupport.beforeAnalysis(access);
        FeatureImpl.BeforeAnalysisAccessImpl config = (FeatureImpl.BeforeAnalysisAccessImpl)access;
        config.registerHierarchyForReflectiveInstantiation(DefaultExportProvider.class);
        config.registerHierarchyForReflectiveInstantiation(TruffleInstrument.class);
        TruffleBaseFeature.registerDynamicObjectFields(config);
        config.registerSubtypeReachabilityHandler(TruffleBaseFeature::registerTruffleLibrariesAsInHeap, LibraryFactory.class);
        config.registerSubtypeReachabilityHandler(TruffleBaseFeature::registerTruffleLibrariesAsInHeap, LibraryExport.class);
        if (this.needsAllEncodings) {
            ((ResourcesRegistry)ImageSingletons.lookup(ResourcesRegistry.class)).addResources(ConfigurationCondition.alwaysTrue(), "org/graalvm/shadowed/org/jcodings/tables/.*bin$");
        }
    }

    public static void preInitializeEngine() {
        TruffleBaseFeature.invokeStaticMethod("org.graalvm.polyglot.Engine$ImplHolder", "preInitializeEngine", Collections.emptyList(), new Object[0]);
        TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.impl.ThreadLocalHandshake", "resetNativeImageState", Collections.emptyList(), new Object[0]);
    }

    private static void registerTruffleLibrariesAsInHeap(Feature.DuringAnalysisAccess access, Class<?> clazz) {
        assert (access.isReachable(clazz)) : clazz;
        assert (LibraryFactory.class.isAssignableFrom(clazz) || LibraryExport.class.isAssignableFrom(clazz)) : clazz;
        if (!Modifier.isAbstract(clazz.getModifiers())) {
            access.registerAsInHeap(clazz);
        }
    }

    public void duringAnalysis(Feature.DuringAnalysisAccess a) {
        FeatureImpl.DuringAnalysisAccessImpl access = (FeatureImpl.DuringAnalysisAccessImpl)a;
        StaticObjectSupport.duringAnalysis(a);
        for (Class clazz : access.reachableSubtypes((Class)Node.class)) {
            this.registerUnsafeAccess(access, clazz.asSubclass(Node.class));
            AnalysisType type = access.getMetaAccess().lookupJavaType(clazz);
            if (!type.isInstantiated()) continue;
            this.graalObjectReplacer.createType((JavaType)type);
        }
        for (AnalysisType type : access.getBigBang().getUniverse().getTypes()) {
            if (!a.isReachable(type.getJavaClass())) continue;
            TruffleBaseFeature.initializeTruffleLibrariesAtBuildTime(type);
            this.initializeDynamicObjectLayouts(type);
        }
        access.rescanRoot(this.layoutInfoMapField);
        access.rescanRoot(this.layoutMapField);
        access.rescanRoot(this.libraryFactoryCacheField);
    }

    public void afterCompilation(Feature.AfterCompilationAccess access) {
        FeatureImpl.AfterCompilationAccessImpl config = (FeatureImpl.AfterCompilationAccessImpl)access;
        this.graalObjectReplacer.updateSubstrateDataAfterCompilation(config.getUniverse(), config.getProviders().getConstantFieldProvider());
        this.graalObjectReplacer.registerImmutableObjects((Feature.CompilationAccess)access);
    }

    private void registerUnsafeAccess(Feature.DuringAnalysisAccess access, Class<? extends Node> clazz) {
        if (this.registeredClasses.contains(clazz)) {
            return;
        }
        this.registeredClasses.add(clazz);
        NodeClass nodeClass = NodeClass.get(clazz);
        for (NodeFieldAccessor accessor : nodeClass.getFields()) {
            Field field;
            try {
                field = accessor.getDeclaringClass().getDeclaredField(accessor.getName());
            }
            catch (NoSuchFieldException ex) {
                throw VMError.shouldNotReachHere(ex);
            }
            if (accessor.getKind() == NodeFieldAccessor.NodeFieldKind.PARENT || accessor.getKind() == NodeFieldAccessor.NodeFieldKind.CHILD || accessor.getKind() == NodeFieldAccessor.NodeFieldKind.CHILDREN) {
                access.registerAsUnsafeAccessed(field);
            }
            if (accessor.getKind() == NodeFieldAccessor.NodeFieldKind.DATA && NodeCloneable.class.isAssignableFrom(accessor.getType())) {
                access.registerAsUnsafeAccessed(field);
            }
            access.registerAsAccessed(field);
        }
        access.requireAnalysisIteration();
    }

    private static void initializeTruffleLibrariesAtBuildTime(AnalysisType type) {
        if (type.isAnnotationPresent(GenerateLibrary.class)) {
            LibraryFactory factory = LibraryFactory.resolve(type.getJavaClass().asSubclass(Library.class));
            factory.getUncached();
        }
        if (((ExportLibrary[])type.getDeclaredAnnotationsByType(ExportLibrary.class)).length != 0) {
            TruffleBaseFeature.invokeStaticMethod("com.oracle.truffle.api.library.LibraryFactory$ResolvedDispatch", "lookup", Collections.singleton(Class.class), type.getJavaClass());
        }
    }

    private void initializeDynamicObjectLayouts(AnalysisType type) {
        Class javaClass;
        if (type.isInstantiated() && DynamicObject.class.isAssignableFrom(javaClass = type.getJavaClass()) && this.dynamicObjectClasses.add(javaClass)) {
            Layout.newLayout().type(javaClass.asSubclass(DynamicObject.class)).build();
        }
    }

    private static void registerDynamicObjectFields(FeatureImpl.BeforeAnalysisAccessImpl config) {
        Class<?> dynamicFieldClass = config.findClassByName(DynamicObject.class.getName().concat("$DynamicField"));
        if (dynamicFieldClass == null) {
            throw VMError.shouldNotReachHere("DynamicObject.DynamicField annotation not found.");
        }
        for (Field field : config.findAnnotatedFields(dynamicFieldClass.asSubclass(Annotation.class))) {
            config.registerAsUnsafeAccessed(field);
        }
    }

    private static final class StaticObjectSupport {
        private static final Method STORAGE_CLASS_NAME = ReflectionUtil.lookupMethod(StaticShape.Builder.class, (String)"storageClassName", (Class[])new Class[0]);
        private static final Class<?> GENERATOR_CLASS_LOADER_CLASS = StaticObjectSupport.loadClass("com.oracle.truffle.api.staticobject.GeneratorClassLoader");
        private static final Constructor<?> GENERATOR_CLASS_LOADER_CONSTRUCTOR = ReflectionUtil.lookupConstructor(GENERATOR_CLASS_LOADER_CLASS, (Class[])new Class[]{Class.class});
        private static final Class<?> SHAPE_GENERATOR = StaticObjectSupport.loadClass("com.oracle.truffle.api.staticobject.ArrayBasedShapeGenerator");
        private static final Method GET_SHAPE_GENERATOR = ReflectionUtil.lookupMethod(SHAPE_GENERATOR, (String)"getShapeGenerator", (Class[])new Class[]{TruffleLanguage.class, GENERATOR_CLASS_LOADER_CLASS, Class.class, Class.class, String.class});
        private static final Method VALIDATE_CLASSES = ReflectionUtil.lookupMethod(StaticShape.Builder.class, (String)"validateClasses", (Class[])new Class[]{Class.class, Class.class});
        private static final Map<Class<?>, ClassLoader> CLASS_LOADERS = new ConcurrentHashMap();
        private static Feature.BeforeAnalysisAccess beforeAnalysisAccess;
        private static final IdentityHashMap<Object, Object> registeredShapeGenerators;

        private StaticObjectSupport() {
        }

        static void beforeAnalysis(Feature.BeforeAnalysisAccess access) {
            beforeAnalysisAccess = access;
        }

        static void registerInvocationPlugins(GraphBuilderConfiguration.Plugins plugins, ParsingReason reason) {
            if (reason == ParsingReason.PointsToAnalysis) {
                InvocationPlugins.Registration r = new InvocationPlugins.Registration(plugins.getInvocationPlugins(), StaticShape.Builder.class);
                r.register((InvocationPlugin)new InvocationPlugin.RequiredInlineOnlyInvocationPlugin("build", new Type[]{InvocationPlugin.Receiver.class, Class.class, Class.class}){

                    public boolean apply(GraphBuilderContext b, ResolvedJavaMethod targetMethod, InvocationPlugin.Receiver receiver, ValueNode arg1, ValueNode arg2) {
                        Class<?> superClass = StaticObjectSupport.getArgumentClass(b, targetMethod, 1, arg1);
                        Class<?> factoryInterface = StaticObjectSupport.getArgumentClass(b, targetMethod, 2, arg2);
                        StaticObjectSupport.generate(superClass, factoryInterface, beforeAnalysisAccess);
                        return false;
                    }
                });
            }
        }

        static void duringAnalysis(Feature.DuringAnalysisAccess access) {
            boolean requiresIteration = false;
            ConcurrentHashMap generatorCache = (ConcurrentHashMap)ReflectionUtil.readStaticField(SHAPE_GENERATOR, (String)"generatorCache");
            for (Map.Entry entry : generatorCache.entrySet()) {
                Object shapeGenerator = entry.getValue();
                if (registeredShapeGenerators.containsKey(shapeGenerator)) continue;
                registeredShapeGenerators.put(shapeGenerator, shapeGenerator);
                requiresIteration = true;
                Class storageClass = (Class)ReflectionUtil.readField(SHAPE_GENERATOR, (String)"generatedStorageClass", shapeGenerator);
                Class factoryClass = (Class)ReflectionUtil.readField(SHAPE_GENERATOR, (String)"generatedFactoryClass", shapeGenerator);
                for (Constructor<?> c : factoryClass.getDeclaredConstructors()) {
                    RuntimeReflection.register((Executable[])new Executable[]{c});
                }
                for (String fieldName : new String[]{"primitive", "object", "shape"}) {
                    beforeAnalysisAccess.registerAsUnsafeAccessed(ReflectionUtil.lookupField((Class)storageClass, (String)fieldName));
                }
            }
            if (requiresIteration) {
                access.requireAnalysisIteration();
            }
        }

        private static Class<?> getArgumentClass(GraphBuilderContext b, ResolvedJavaMethod targetMethod, int parameterIndex, ValueNode arg) {
            SubstrateGraphBuilderPlugins.checkParameterUsage(arg.isConstant(), b, targetMethod, parameterIndex, "parameter is not a compile time constant");
            return OriginalClassProvider.getJavaClass((SnippetReflectionProvider)GraalAccess.getOriginalSnippetReflection(), (ResolvedJavaType)b.getConstantReflection().asJavaType((Constant)arg.asJavaConstant()));
        }

        private static void generate(Class<?> storageSuperClass, Class<?> factoryInterface, Feature.BeforeAnalysisAccess access) {
            try {
                StaticObjectSupport.validateClasses(storageSuperClass, factoryInterface);
                ClassLoader generatorCL = StaticObjectSupport.getGeneratorClassLoader(factoryInterface);
                StaticObjectSupport.getGetShapeGenerator(generatorCL, storageSuperClass, factoryInterface);
            }
            catch (ReflectiveOperationException e) {
                if (e instanceof InvocationTargetException && e.getCause() instanceof IllegalArgumentException) {
                    Target_com_oracle_truffle_api_staticobject_StaticShape_Builder.ExceptionCache.set(storageSuperClass, factoryInterface, (IllegalArgumentException)e.getCause());
                }
                throw VMError.shouldNotReachHere(e);
            }
        }

        private static void validateClasses(Class<?> storageSuperClass, Class<?> factoryInterface) throws ReflectiveOperationException {
            VALIDATE_CLASSES.invoke(null, storageSuperClass, factoryInterface);
        }

        private static ClassLoader getGeneratorClassLoader(Class<?> factoryInterface) throws ReflectiveOperationException {
            ClassLoader newCL;
            ClassLoader cl = CLASS_LOADERS.get(factoryInterface);
            if (cl == null && (cl = CLASS_LOADERS.putIfAbsent(factoryInterface, newCL = (ClassLoader)GENERATOR_CLASS_LOADER_CONSTRUCTOR.newInstance(factoryInterface))) == null) {
                cl = newCL;
            }
            return cl;
        }

        private static void getGetShapeGenerator(ClassLoader generatorCL, Class<?> storageSuperClass, Class<?> factoryInterface) throws ReflectiveOperationException {
            String storageClassName = (String)STORAGE_CLASS_NAME.invoke(null, new Object[0]);
            GET_SHAPE_GENERATOR.invoke(null, null, generatorCL, storageSuperClass, factoryInterface, storageClassName);
        }

        private static Class<?> loadClass(String name) {
            try {
                return Class.forName(name);
            }
            catch (ClassNotFoundException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        static {
            registeredShapeGenerators = new IdentityHashMap();
        }
    }

    public static final class IsCreateProcessDisabled
    implements BooleanSupplier {
        static final boolean ALLOW_CREATE_PROCESS = IsCreateProcessDisabled.query();

        static boolean query() {
            try {
                Class<?> clazz = Class.forName("com.oracle.truffle.polyglot.PolyglotEngineImpl");
                boolean allowCreateProcess = (Boolean)ReflectionUtil.readField(clazz, (String)"ALLOW_CREATE_PROCESS", null);
                return !allowCreateProcess;
            }
            catch (ReflectiveOperationException e) {
                throw VMError.shouldNotReachHere(e);
            }
        }

        @Override
        public boolean getAsBoolean() {
            return ALLOW_CREATE_PROCESS;
        }
    }

    public static final class IsEnabled
    implements BooleanSupplier {
        @Override
        public boolean getAsBoolean() {
            return ImageSingletons.contains(TruffleBaseFeature.class);
        }
    }
}

