/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.enterprise.builtins.modules.StructModuleBuiltinsClinicProviders;
import com.oracle.graal.python.enterprise.builtins.modules.StructModuleBuiltinsFactory;
import com.oracle.graal.python.enterprise.builtins.nodes.EnterpriseErrorMessages;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatAlignment;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatCode;
import com.oracle.graal.python.enterprise.builtins.objects.struct.FormatDef;
import com.oracle.graal.python.enterprise.builtins.objects.struct.PStruct;
import com.oracle.graal.python.enterprise.builtins.objects.struct.StructBuiltins;
import com.oracle.graal.python.enterprise.builtins.runtime.object.EnterprisePythonObjectFactory;
import com.oracle.graal.python.enterprise.builtins.util.ASCIIUtils;
import com.oracle.graal.python.enterprise.builtins.util.LRUCache;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

@CoreFunctions(defineModule="_struct", isEager=true)
public class StructModuleBuiltins
extends PythonBuiltins {
    private static final int DEFAULT_CACHE_SIZE = 100;
    private static final HiddenKey CACHE_KEY = new HiddenKey("cache");
    private static final TruffleString T_ERROR = PythonUtils.tsLiteral((String)"error");
    private final LRUStructCache cache = new LRUStructCache(100);

    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StructModuleBuiltinsFactory.getFactories();
    }

    public void initialize(Python3Core core) {
        this.addBuiltinConstant(CACHE_KEY, PNone.NO_VALUE);
        this.addBuiltinConstant(T_ERROR, PythonErrorType.StructError);
        super.initialize(core);
    }

    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonModule structModule = core.lookupBuiltinModule(BuiltinNames.T__STRUCT);
        structModule.setAttribute((Object)CACHE_KEY, (Object)this.cache);
        core.lookupType(PythonBuiltinClassType.PStruct).setAttribute((Object)CACHE_KEY, (Object)this.cache);
    }

    protected static PStruct getStruct(PythonModule structModule, Object format, ConstructStructNode constructStructNode, ReadAttributeFromObjectNode readNode) {
        LRUStructCache cache = (LRUStructCache)readNode.execute((Object)structModule, (Object)CACHE_KEY);
        PStruct pStruct = (PStruct)((Object)cache.get(format));
        if (pStruct == null) {
            pStruct = constructStructNode.execute(format);
            cache.put(format, pStruct);
        }
        return pStruct;
    }

    public static boolean containsNullCharacter(byte[] value) {
        for (byte b : value) {
            if (b != 0) continue;
            return true;
        }
        return false;
    }

    static class LRUStructCache
    extends LRUCache<Object, PStruct> {
        public LRUStructCache(int size) {
            super(size);
        }
    }

    @Builtin(name="Struct", minNumOfPositionalArgs=2, constructsClass=PythonBuiltinClassType.PStruct)
    @ImportStatic(value={ASCIIUtils.class})
    @GenerateNodeFactory
    public static abstract class ConstructStructNode
    extends PythonBinaryBuiltinNode {
        public static final int NUM_BYTES_LIMIT;
        private static final char ALIGNMENT_NATIVE_NATIVE = '@';
        private static final char ALIGNMENT_NATIVE_STD = '=';
        private static final char ALIGNMENT_LE_STD = '<';
        private static final char ALIGNMENT_BE_STD = '>';
        private static final char ALIGNMENT_NET_BE_STD = '!';
        private static final char DEFAULT_ALIGNMENT = '@';
        private static final FormatDef[] FMT_TABLE;
        private static final FormatDef[] FMT_TABLE_NATIVE;

        static void setFormatDefEntry(FormatDef[] table, char format, TruffleString label, int size, Set<Integer> numBytes) {
            ConstructStructNode.setFormatDefEntry(table, format, label, size, 0);
            numBytes.add(size);
        }

        static void setFormatDefEntry(FormatDef[] table, char format, TruffleString label, int size, int alignment) {
            table[format] = new FormatDef(format, label, size, alignment);
        }

        public final PStruct execute(Object format) {
            return this.execute(PythonBuiltinClassType.PStruct, format);
        }

        public abstract PStruct execute(Object var1, Object var2);

        @Specialization(guards={"isAscii(format, getCodeRangeNode)"})
        PStruct struct(Object cls, TruffleString format, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            byte[] fmt = ASCIIUtils.getAsciiBytes(format, copyToByteArrayNode, switchEncodingNode);
            return EnterprisePythonObjectFactory.createStruct(this.factory(), this.createStructInternal(fmt));
        }

        @Specialization
        PStruct struct(Object cls, PString format, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return this.struct(cls, castToTruffleStringNode.execute(inliningTarget, (Object)format), copyToByteArrayNode, switchEncodingNode, getCodeRangeNode);
        }

        @Specialization(limit="1")
        PStruct struct(Object cls, PBytes format, @CachedLibrary(value="format") PythonBufferAccessLibrary bufferLib) {
            byte[] fmt = bufferLib.getCopiedByteArray((Object)format);
            return EnterprisePythonObjectFactory.createStruct(this.factory(), this.createStructInternal(fmt));
        }

        @Specialization(guards={"!isPBytes(format)", "!isPString(format)", "!isAsciiTruffleString(format, getCodeRangeNode)"})
        PStruct fallback(Object cls, Object format, @Cached TruffleString.GetCodeRangeNode getCodeRangeNode) {
            throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.ARG_MUST_BE_STR_OR_BYTES, new Object[]{"Struct()", format});
        }

        protected static boolean isAsciiTruffleString(Object o, TruffleString.GetCodeRangeNode getCodeRangeNode) {
            return o instanceof TruffleString && ASCIIUtils.isAscii((TruffleString)o, getCodeRangeNode);
        }

        @CompilerDirectives.TruffleBoundary
        private PStruct.StructInfo createStructInternal(byte[] format) {
            int num;
            int size = 0;
            int len = 0;
            int nCodes = 0;
            if (StructModuleBuiltins.containsNullCharacter(format)) {
                throw this.raise(PythonBuiltinClassType.StructError, ErrorMessages.EMBEDDED_NULL_CHARACTER);
            }
            char alignment = '@';
            int start = 0;
            if (format.length > 0 && ConstructStructNode.isAlignment((char)format[0])) {
                alignment = (char)format[0];
                start = 1;
            }
            FormatAlignment formatAlignment = ConstructStructNode.whichAlignment(alignment);
            FormatDef[] formatTable = formatAlignment.nativeSizing ? FMT_TABLE_NATIVE : FMT_TABLE;
            for (int i = start; i < format.length; ++i) {
                char c = (char)format[i];
                if (c == ' ') continue;
                if ('0' <= c && c <= '9') {
                    num = c - 48;
                    while (++i < format.length && '0' <= (c = (char)format[i]) && c <= '9') {
                        if (num >= 0xCCCCCCC && (num > 0xCCCCCCC || c - 48 > 7)) {
                            throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_SIZE_TOO_LONG);
                        }
                        num = num * 10 + (c - 48);
                    }
                    if (i == format.length) {
                        throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.REPEAT_COUNT_WITHOUT_FMT);
                    }
                } else {
                    num = 1;
                }
                FormatDef formatDef = this.getEntry(c, formatTable);
                switch (c) {
                    case 'p': 
                    case 's': {
                        ++len;
                        ++nCodes;
                        break;
                    }
                    case 'x': {
                        break;
                    }
                    default: {
                        len += num;
                        if (num == 0) break;
                        ++nCodes;
                    }
                }
                int itemSize = formatDef.size;
                size = ConstructStructNode.align(size, c, formatDef);
                if (size == -1) {
                    throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_SIZE_TOO_LONG);
                }
                if (num > (Integer.MAX_VALUE - size) / itemSize) {
                    throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.STRUCT_SIZE_TOO_LONG);
                }
                size += num * itemSize;
            }
            FormatCode[] codes = new FormatCode[nCodes];
            int structSize = size;
            int structLen = len;
            int j = 0;
            size = 0;
            for (int i = start; i < format.length; ++i) {
                char c = (char)format[i];
                if (c == ' ') continue;
                if ('0' <= c && c <= '9') {
                    num = c - 48;
                    while (++i < format.length && '0' <= (c = (char)format[i]) && c <= '9') {
                        num = num * 10 + (c - 48);
                    }
                } else {
                    num = 1;
                }
                FormatDef formatDef = this.getEntry(c, formatTable);
                size = ConstructStructNode.align(size, c, formatDef);
                if (c == 's' || c == 'p') {
                    codes[j++] = new FormatCode(formatDef, size, num, 1);
                    size += num;
                    continue;
                }
                if (c == 'x') {
                    size += num;
                    continue;
                }
                if (num == 0) continue;
                codes[j++] = new FormatCode(formatDef, size, formatDef.size, num);
                size += formatDef.size * num;
            }
            return new PStruct.StructInfo(format, structSize, structLen, formatAlignment, codes);
        }

        private FormatDef getEntry(char format, FormatDef[] table) {
            FormatDef formatDef = table[format];
            if (formatDef != null) {
                return formatDef;
            }
            throw this.raise(PythonErrorType.StructError, EnterpriseErrorMessages.BAD_CHR_IN_STRUCT_FMT, new Object[]{Character.valueOf(format)});
        }

        private static boolean isAlignment(char alignment) {
            return alignment == '<' || alignment == '>' || alignment == '!' || alignment == '=' || alignment == '@';
        }

        private static FormatAlignment whichAlignment(char alignment) {
            switch (alignment) {
                case '<': {
                    return new FormatAlignment(false, false);
                }
                case '!': 
                case '>': {
                    return new FormatAlignment(true, false);
                }
                case '=': {
                    return new FormatAlignment(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN, false);
                }
            }
            return new FormatAlignment(ByteOrder.nativeOrder() == ByteOrder.BIG_ENDIAN, true);
        }

        private static int align(int size, char c, FormatDef formatDef) {
            int alignedSize = size;
            if (formatDef.format == c && formatDef.alignment > 0 && alignedSize > 0) {
                int extra = formatDef.alignment - 1 - (alignedSize - 1) % formatDef.alignment;
                if (extra > Integer.MAX_VALUE - alignedSize) {
                    return -1;
                }
                alignedSize += extra;
            }
            return alignedSize;
        }

        static {
            FMT_TABLE = new FormatDef[128];
            FMT_TABLE_NATIVE = new FormatDef[128];
            HashSet<Integer> numBytes = new HashSet<Integer>();
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'x', FormatCode.T_LBL_PAD_BYTE, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'b', FormatCode.T_LBL_SIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'B', FormatCode.T_LBL_UNSIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'c', FormatCode.T_LBL_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 's', FormatCode.T_LBL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'p', FormatCode.T_LBL_PASCAL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'h', FormatCode.T_LBL_SHORT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'H', FormatCode.T_LBL_UNSIGNED_SHORT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'i', FormatCode.T_LBL_INT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'I', FormatCode.T_LBL_UNSIGNED_INT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'l', FormatCode.T_LBL_LONG, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'L', FormatCode.T_LBL_UNSIGNED_LONG, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'q', FormatCode.T_LBL_LONG_LONG, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'Q', FormatCode.T_LBL_UNSIGNED_LONG_LONG, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, '?', FormatCode.T_LBL_BOOL, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'e', FormatCode.T_LBL_HALF_FLOAT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'f', FormatCode.T_LBL_FLOAT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE, 'd', FormatCode.T_LBL_DOUBLE, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'x', FormatCode.T_LBL_PAD_BYTE, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'b', FormatCode.T_LBL_SIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'B', FormatCode.T_LBL_UNSIGNED_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'c', FormatCode.T_LBL_CHAR, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 's', FormatCode.T_LBL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'p', FormatCode.T_LBL_PASCAL_STRING, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'h', FormatCode.T_LBL_SHORT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'H', FormatCode.T_LBL_UNSIGNED_SHORT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'i', FormatCode.T_LBL_INT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'I', FormatCode.T_LBL_UNSIGNED_INT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'l', FormatCode.T_LBL_LONG, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 4 : 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'L', FormatCode.T_LBL_UNSIGNED_LONG, PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 4 : 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'q', FormatCode.T_LBL_LONG_LONG, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'Q', FormatCode.T_LBL_UNSIGNED_LONG_LONG, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, '?', FormatCode.T_LBL_BOOL, 1, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'e', FormatCode.T_LBL_HALF_FLOAT, 2, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'f', FormatCode.T_LBL_FLOAT, 4, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'd', FormatCode.T_LBL_DOUBLE, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'n', FormatCode.T_LBL_SIZE_T, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'N', FormatCode.T_LBL_UNSIGNED_SIZE_T, 8, numBytes);
            ConstructStructNode.setFormatDefEntry(FMT_TABLE_NATIVE, 'P', FormatCode.T_LBL_VOID_PTR, 8, numBytes);
            NUM_BYTES_LIMIT = numBytes.size();
        }
    }

    @Builtin(name="_clearcache", minNumOfPositionalArgs=1, parameterNames={"$self"}, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class ClearCacheNode
    extends PythonUnaryBuiltinNode {
        ClearCacheNode() {
        }

        @Specialization
        Object clearCache(PythonModule self, @Cached ReadAttributeFromObjectNode readNode) {
            LRUStructCache cache = (LRUStructCache)readNode.execute((Object)self, (Object)CACHE_KEY);
            cache.clear();
            return PNone.NONE;
        }
    }

    @Builtin(name="calcsize", minNumOfPositionalArgs=2, parameterNames={"$self", "format"}, declaresExplicitSelf=true, forceSplitDirectCalls=true)
    @GenerateNodeFactory
    static abstract class CalcSizeNode
    extends PythonBinaryBuiltinNode {
        CalcSizeNode() {
        }

        @Specialization
        Object calcSize(PythonModule self, Object format, @Cached ConstructStructNode constructStructNode, @Cached GetStructNode getStructNode) {
            PStruct struct = getStructNode.execute(self, format, constructStructNode);
            return struct.getSize();
        }
    }

    @Builtin(name="unpack_from", minNumOfPositionalArgs=3, parameterNames={"$self", "format", "buffer", "offset"}, declaresExplicitSelf=true, forceSplitDirectCalls=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="0")})
    @GenerateNodeFactory
    static abstract class UnpackFromNode
    extends PythonQuaternaryClinicBuiltinNode {
        UnpackFromNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructModuleBuiltinsClinicProviders.UnpackFromNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object unpackFrom(VirtualFrame frame, PythonModule self, Object format, Object buffer, int offset, @Cached ConstructStructNode constructStructNode, @Cached GetStructNode getStructNode, @Cached StructBuiltins.StructUnpackFromNode structUnpackNode) {
            PStruct struct = getStructNode.execute(self, format, constructStructNode);
            return structUnpackNode.execute(frame, struct, buffer, offset);
        }
    }

    @Builtin(name="iter_unpack", minNumOfPositionalArgs=3, parameterNames={"$self", "format", "buffer"}, declaresExplicitSelf=true, forceSplitDirectCalls=true)
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class IterUnpackNode
    extends PythonTernaryClinicBuiltinNode {
        IterUnpackNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructModuleBuiltinsClinicProviders.IterUnpackNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object iterUnpack(VirtualFrame frame, PythonModule self, Object format, Object buffer, @Cached ConstructStructNode constructStructNode, @Cached GetStructNode getStructNode, @Cached StructBuiltins.StructIterUnpackNode iterUnpackNode) {
            PStruct struct = getStructNode.execute(self, format, constructStructNode);
            return iterUnpackNode.execute(frame, struct, buffer);
        }
    }

    @Builtin(name="unpack", minNumOfPositionalArgs=3, parameterNames={"$self", "format", "buffer"}, declaresExplicitSelf=true, forceSplitDirectCalls=true)
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    static abstract class UnpackNode
    extends PythonTernaryClinicBuiltinNode {
        UnpackNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructModuleBuiltinsClinicProviders.UnpackNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static Object unpack(VirtualFrame frame, PythonModule self, Object format, Object buffer, @Cached GetStructNode getStructNode, @Cached ConstructStructNode constructStructNode, @Cached StructBuiltins.StructUnpackNode structUnpackNode) {
            PStruct struct = getStructNode.execute(self, format, constructStructNode);
            return structUnpackNode.execute(frame, struct, buffer);
        }
    }

    @Builtin(name="pack_into", minNumOfPositionalArgs=4, parameterNames={"$self", "format", "buffer", "offset"}, declaresExplicitSelf=true, takesVarArgs=true, forceSplitDirectCalls=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="offset", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class PackIntoNode
    extends PythonClinicBuiltinNode {
        PackIntoNode() {
        }

        protected ArgumentClinicProvider getArgumentClinic() {
            return StructModuleBuiltinsClinicProviders.PackIntoNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object packInto(VirtualFrame frame, PythonModule self, Object format, Object buffer, int offset, Object[] args, @Cached ConstructStructNode constructStructNode, @Cached GetStructNode getStructNode, @Cached StructBuiltins.StructPackIntoNode structPackNode) {
            PStruct struct = getStructNode.execute(self, format, constructStructNode);
            return structPackNode.execute(frame, struct, buffer, offset, args);
        }
    }

    @Builtin(name="pack", minNumOfPositionalArgs=2, parameterNames={"$self", "format"}, takesVarArgs=true, declaresExplicitSelf=true, forceSplitDirectCalls=true)
    @GenerateNodeFactory
    static abstract class PackNode
    extends PythonBuiltinNode {
        PackNode() {
        }

        @Specialization
        Object pack(VirtualFrame frame, PythonModule self, Object format, Object[] args, @Cached ConstructStructNode constructStructNode, @Cached GetStructNode getStructNode, @Cached StructBuiltins.StructPackNode structPackNode) {
            PStruct struct = getStructNode.execute(self, format, constructStructNode);
            return structPackNode.execute(frame, struct, args);
        }
    }

    @ImportStatic(value={Arrays.class})
    static abstract class GetStructNode
    extends PNodeWithContext {
        GetStructNode() {
        }

        abstract PStruct execute(PythonModule var1, Object var2, ConstructStructNode var3);

        protected PStruct getStructInternal(PythonModule module, Object format, ConstructStructNode constructStructNode) {
            return StructModuleBuiltins.getStruct(module, format, constructStructNode, ReadAttributeFromObjectNode.getUncached());
        }

        protected boolean eq(TruffleString s1, TruffleString s2, TruffleString.EqualNode eqNode) {
            return eqNode.execute((AbstractTruffleString)s1, (AbstractTruffleString)s2, PythonUtils.TS_ENCODING);
        }

        @Specialization(guards={"isSingleContext()", "eq(format, cachedFormat, eqNode)"}, limit="1")
        PStruct doCachedString(PythonModule module, TruffleString format, ConstructStructNode constructStructNode, @Cached(value="format") TruffleString cachedFormat, @Cached TruffleString.EqualNode eqNode, @Cached(value="getStructInternal(module, format, constructStructNode)", weak=true) PStruct cachedStruct) {
            return cachedStruct;
        }

        @Specialization(guards={"isSingleContext()", "equals(bufferLib.getCopiedByteArray(format), cachedFormat)"}, limit="1")
        PStruct doCachedBytes(PythonModule module, PBytes format, ConstructStructNode constructStructNode, @CachedLibrary(value="format") PythonBufferAccessLibrary bufferLib, @Cached(value="bufferLib.getCopiedByteArray(format)", dimensions=1) byte[] cachedFormat, @Cached(value="getStructInternal(module, format, constructStructNode)", weak=true) PStruct cachedStruct) {
            return cachedStruct;
        }

        @Specialization(replaces={"doCachedString", "doCachedBytes"})
        PStruct doGeneric(PythonModule module, Object format, ConstructStructNode constructStructNode, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode) {
            return StructModuleBuiltins.getStruct(module, format, constructStructNode, readAttributeFromObjectNode);
        }
    }
}

