/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.pickle;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.MemoTable;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PPicklerMemoProxy;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PicklerMemoProxyBuiltinsFactory;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import java.util.LinkedHashMap;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PicklerMemoProxy})
public class PicklerMemoProxyBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PicklerMemoProxyBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(VirtualFrame frame, PPicklerMemoProxy self, @Cached PicklerMemoCopyImplNode copyImplNode) {
            MemoTable memoTable = self.getPickler().getMemo();
            PDict dictMemoCopy = copyImplNode.execute((Frame)frame, memoTable);
            PTuple dictArgs = this.factory().createTuple(new Object[]{dictMemoCopy});
            return this.factory().createTuple(new Object[]{PythonBuiltinClassType.PDict, dictArgs});
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object copy(VirtualFrame frame, PPicklerMemoProxy self, @Cached PicklerMemoCopyImplNode copyImplNode) {
            MemoTable memoTable = self.getPickler().getMemo();
            return copyImplNode.execute((Frame)frame, memoTable);
        }
    }

    public static abstract class PicklerMemoCopyImplNode
    extends PNodeWithContext {
        public abstract PDict execute(Frame var1, MemoTable var2);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public PDict doCopy(MemoTable memoTable) {
            PythonObjectSlowPathFactory factory = this.getContext().factory();
            LinkedHashMap<Integer, PTuple> copy = new LinkedHashMap<Integer, PTuple>();
            MemoTable.MemoIterator iterator = memoTable.iterator();
            while (iterator.advance()) {
                copy.put(System.identityHashCode(iterator.key()), factory.createTuple(new Object[]{iterator.value(), iterator.key()}));
            }
            return factory.createDictFromMapGeneric(copy);
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class PicklerMemoProxyClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object clear(PPicklerMemoProxy self) {
            MemoTable memoTable = self.getPickler().getMemo();
            memoTable.clear();
            return PNone.NONE;
        }
    }
}

