/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.enterprise.builtins.objects.pickle;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.PUnpicklerMemoProxy;
import com.oracle.graal.python.enterprise.builtins.objects.pickle.UnpicklerMemoProxyBuiltinsFactory;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.UnpicklerMemoProxy})
public class UnpicklerMemoProxyBuiltins
extends PythonBuiltins {
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return UnpicklerMemoProxyBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoProxyReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(PUnpicklerMemoProxy self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            PDict dictMemoCopy = this.factory().createDict(self.getUnpickler().copyMemoToHashingStorage(inliningTarget, setItem));
            PTuple constructorArgs = this.factory().createTuple(new Object[]{dictMemoCopy});
            return this.factory().createTuple(new Object[]{PythonBuiltinClassType.PDict, constructorArgs});
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoProxyCopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object copy(PUnpicklerMemoProxy self, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            return this.factory().createDict(self.getUnpickler().copyMemoToHashingStorage(inliningTarget, setItem));
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class UnpicklerMemoProxyClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object clear(PUnpicklerMemoProxy self) {
            self.getUnpickler().clearMemo();
            return PNone.NONE;
        }
    }
}

