// CheckStyle: start generated
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.DetachNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.EncodingNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.ErrorsNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.NewlinesNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.ReadNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.ReadlineNode;
import com.oracle.graal.python.builtins.modules.io.TextIOBaseBuiltins.WriteNode;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import java.util.Arrays;
import java.util.List;

@GeneratedBy(TextIOBaseBuiltins.class)
@SuppressWarnings("javadoc")
public final class TextIOBaseBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(DetachNodeFactory.getInstance(), ReadNodeFactory.getInstance(), ReadlineNodeFactory.getInstance(), WriteNodeFactory.getInstance(), EncodingNodeFactory.getInstance(), NewlinesNodeFactory.getInstance(), ErrorsNodeFactory.getInstance());
    }

    @GeneratedBy(DetachNode.class)
    static final class DetachNodeFactory implements NodeFactory<DetachNode> {

        private static final DetachNodeFactory DETACH_NODE_FACTORY_INSTANCE = new DetachNodeFactory();

        private DetachNodeFactory() {
        }

        @Override
        public Class<DetachNode> getNodeClass() {
            return DetachNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public DetachNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<DetachNode> getInstance() {
            return DETACH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DetachNode create(ReadArgumentNode[] arguments) {
            return new DetachNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DetachNode#detach}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(DetachNode.class)
        @SuppressWarnings("javadoc")
        static final class DetachNodeGen extends DetachNode {

            @Child private ReadArgumentNode arguments0_;

            private DetachNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                return detach(arguments0Value_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(ReadNode.class)
    static final class ReadNodeFactory implements NodeFactory<ReadNode> {

        private static final ReadNodeFactory READ_NODE_FACTORY_INSTANCE = new ReadNodeFactory();

        private ReadNodeFactory() {
        }

        @Override
        public Class<ReadNode> getNodeClass() {
            return ReadNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public ReadNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReadNode> getInstance() {
            return READ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReadNode create(ReadArgumentNode[] arguments) {
            return new ReadNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReadNode#read}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ReadNode.class)
        @SuppressWarnings("javadoc")
        static final class ReadNodeGen extends ReadNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;

            private ReadNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return read(arguments0Value_, arguments1Value_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(ReadlineNode.class)
    static final class ReadlineNodeFactory implements NodeFactory<ReadlineNode> {

        private static final ReadlineNodeFactory READLINE_NODE_FACTORY_INSTANCE = new ReadlineNodeFactory();

        private ReadlineNodeFactory() {
        }

        @Override
        public Class<ReadlineNode> getNodeClass() {
            return ReadlineNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public ReadlineNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReadlineNode> getInstance() {
            return READLINE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReadlineNode create(ReadArgumentNode[] arguments) {
            return new ReadlineNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReadlineNode#read}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ReadlineNode.class)
        @SuppressWarnings("javadoc")
        static final class ReadlineNodeGen extends ReadlineNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;

            private ReadlineNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return read(arguments0Value_, arguments1Value_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(WriteNode.class)
    static final class WriteNodeFactory implements NodeFactory<WriteNode> {

        private static final WriteNodeFactory WRITE_NODE_FACTORY_INSTANCE = new WriteNodeFactory();

        private WriteNodeFactory() {
        }

        @Override
        public Class<WriteNode> getNodeClass() {
            return WriteNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class, ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public WriteNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<WriteNode> getInstance() {
            return WRITE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static WriteNode create(ReadArgumentNode[] arguments) {
            return new WriteNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link WriteNode#write}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(WriteNode.class)
        @SuppressWarnings("javadoc")
        static final class WriteNodeGen extends WriteNode {

            @Child private ReadArgumentNode arguments0_;
            @Child private ReadArgumentNode arguments1_;

            private WriteNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
                this.arguments1_ = arguments != null && 1 < arguments.length ? arguments[1] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                Object arguments1Value_ = this.arguments1_.execute(frameValue);
                return write(arguments0Value_, arguments1Value_);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(EncodingNode.class)
    static final class EncodingNodeFactory implements NodeFactory<EncodingNode> {

        private static final EncodingNodeFactory ENCODING_NODE_FACTORY_INSTANCE = new EncodingNodeFactory();

        private EncodingNodeFactory() {
        }

        @Override
        public Class<EncodingNode> getNodeClass() {
            return EncodingNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public EncodingNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<EncodingNode> getInstance() {
            return ENCODING_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EncodingNode create() {
            return new EncodingNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EncodingNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(EncodingNode.class)
        @SuppressWarnings("javadoc")
        static final class EncodingNodeGen extends EncodingNode {

            private EncodingNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return EncodingNode.doit(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(NewlinesNode.class)
    static final class NewlinesNodeFactory implements NodeFactory<NewlinesNode> {

        private static final NewlinesNodeFactory NEWLINES_NODE_FACTORY_INSTANCE = new NewlinesNodeFactory();

        private NewlinesNodeFactory() {
        }

        @Override
        public Class<NewlinesNode> getNodeClass() {
            return NewlinesNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public NewlinesNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NewlinesNode> getInstance() {
            return NEWLINES_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NewlinesNode create() {
            return new NewlinesNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NewlinesNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(NewlinesNode.class)
        @SuppressWarnings("javadoc")
        static final class NewlinesNodeGen extends NewlinesNode {

            private NewlinesNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return NewlinesNode.doit(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(ErrorsNode.class)
    static final class ErrorsNodeFactory implements NodeFactory<ErrorsNode> {

        private static final ErrorsNodeFactory ERRORS_NODE_FACTORY_INSTANCE = new ErrorsNodeFactory();

        private ErrorsNodeFactory() {
        }

        @Override
        public Class<ErrorsNode> getNodeClass() {
            return ErrorsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ErrorsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ErrorsNode> getInstance() {
            return ERRORS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ErrorsNode create() {
            return new ErrorsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ErrorsNode#doit}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ErrorsNode.class)
        @SuppressWarnings("javadoc")
        static final class ErrorsNodeGen extends ErrorsNode {

            private ErrorsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                return ErrorsNode.doit(arg0Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
}
