// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.NodeCost;

@GeneratedBy(GraalHPyNativeContext.class)
public final class GraalHPyNativeContextGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(GraalHPyNativeContext.class, new InteropLibraryExports());
    }

    private GraalHPyNativeContextGen() {
    }

    @GeneratedBy(GraalHPyNativeContext.class)
    public static class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, GraalHPyNativeContext.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof GraalHPyNativeContext;
            InteropLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof GraalHPyNativeContext;
            return new Cached(receiver);
        }

        @GeneratedBy(GraalHPyNativeContext.class)
        public static class Cached extends InteropLibrary {

            private final Class<? extends GraalHPyNativeContext> receiverClass_;

            protected Cached(Object receiver) {
                GraalHPyNativeContext castReceiver = ((GraalHPyNativeContext) receiver) ;
                this.receiverClass_ = castReceiver.getClass();
            }

            @Override
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public void toNative(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                (CompilerDirectives.castExact(receiver, receiverClass_)).toNative();
                return;
            }

        }
        @GeneratedBy(GraalHPyNativeContext.class)
        public static class Uncached extends InteropLibrary {

            private final Class<? extends GraalHPyNativeContext> receiverClass_;

            protected Uncached(Object receiver) {
                this.receiverClass_ = ((GraalHPyNativeContext) receiver).getClass();
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert receiver.getClass() != this.receiverClass_ || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return CompilerDirectives.isExact(receiver, this.receiverClass_);
            }

            @Override
            public final boolean isAdoptable() {
                return false;
            }

            @Override
            public final NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void toNative(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                ((GraalHPyNativeContext) receiver) .toNative();
                return;
            }

        }
    }
}
