// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.complex;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess.ReadDoubleNode;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.AbsNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.AddNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.BoolNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ConjugateNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.DivNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.EqNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.FormatNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.GeNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.GetNewArgsNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.GtNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.HashNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ImagNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.LeNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.LtNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.MulNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.NeNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.NegNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.PosNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.PowerNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.RealNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.StrNode;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins.SubNode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.argument.ReadArgumentNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.graal.python.nodes.util.CoerceToComplexNode;
import com.oracle.graal.python.nodes.util.CoerceToComplexNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(ComplexBuiltins.class)
@SuppressWarnings("javadoc")
public final class ComplexBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(AbsNodeFactory.getInstance(), AddNodeFactory.getInstance(), DivNodeFactory.getInstance(), MulNodeFactory.getInstance(), SubNodeFactory.getInstance(), PowerNodeFactory.getInstance(), EqNodeFactory.getInstance(), GeNodeFactory.getInstance(), GtNodeFactory.getInstance(), LtNodeFactory.getInstance(), LeNodeFactory.getInstance(), NeNodeFactory.getInstance(), ReprNodeFactory.getInstance(), StrNodeFactory.getInstance(), FormatNodeFactory.getInstance(), BoolNodeFactory.getInstance(), NegNodeFactory.getInstance(), PosNodeFactory.getInstance(), GetNewArgsNodeFactory.getInstance(), RealNodeFactory.getInstance(), ImagNodeFactory.getInstance(), HashNodeFactory.getInstance(), ConjugateNodeFactory.getInstance());
    }

    @GeneratedBy(AbsNode.class)
    public static final class AbsNodeFactory implements NodeFactory<AbsNode> {

        private static final AbsNodeFactory ABS_NODE_FACTORY_INSTANCE = new AbsNodeFactory();

        private AbsNodeFactory() {
        }

        @Override
        public Class<AbsNode> getNodeClass() {
            return AbsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public AbsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<AbsNode> getInstance() {
            return ABS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AbsNode create() {
            return new AbsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AbsNode#abs(PComplex)}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(AbsNode.class)
        @SuppressWarnings("javadoc")
        public static final class AbsNodeGen extends AbsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AbsNode#abs(PComplex)}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private AbsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.AbsNode.abs(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return abs(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            @Override
            public double executeDouble(Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.AbsNode.abs(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return abs(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private double executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.AbsNode.abs(PComplex)] */;
                    this.state_0_ = state_0;
                    return abs(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(AddNode.class)
    static final class AddNodeFactory implements NodeFactory<AddNode> {

        private static final AddNodeFactory ADD_NODE_FACTORY_INSTANCE = new AddNodeFactory();

        private AddNodeFactory() {
        }

        @Override
        public Class<AddNode> getNodeClass() {
            return AddNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public AddNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<AddNode> getInstance() {
            return ADD_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static AddNode create() {
            return new AddNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link AddNode#doComplexLong}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link AddNode#doComplexPInt}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link AddNode#doComplexDouble}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link AddNode#doComplex(PComplex, PComplex)}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link AddNode#doComplex(Object, Object)}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(AddNode.class)
        @SuppressWarnings("javadoc")
        static final class AddNodeGen extends AddNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link AddNode#doComplexLong}
             *   1: SpecializationActive {@link AddNode#doComplexPInt}
             *   2: SpecializationActive {@link AddNode#doComplexDouble}
             *   3: SpecializationActive {@link AddNode#doComplex(PComplex, PComplex)}
             *   4: SpecializationActive {@link AddNode#doComplex(Object, Object)}
             *   5-7: ImplicitCast[type=long, index=1]
             *   8-9: ImplicitCast[type=double, index=1]
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private AddNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg0Value instanceof PComplex) {
                    if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplexPInt(PComplex, PInt)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplex(PComplex, PComplex)] */) && arg1Value instanceof PComplex) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplexLong(PComplex, long)] || SpecializationActive[ComplexBuiltins.AddNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.AddNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.AddNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.AddNode.doComplex(Object, Object)] */) {
                    if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplexLong(PComplex, long)] || SpecializationActive[ComplexBuiltins.AddNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.AddNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.AddNode.doComplex(PComplex, PComplex)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplexLong(PComplex, long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            return doComplexLong(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplexPInt(PComplex, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return doComplexPInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplexDouble(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplex(PComplex, PComplex)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            return doComplex(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.AddNode.doComplex(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return AddNode.doComplex(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private PythonAbstractObject executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    {
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                            state_0 = (state_0 | (longCast1 << 5) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.AddNode.doComplexLong(PComplex, long)] */;
                            this.state_0_ = state_0;
                            return doComplexLong(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.AddNode.doComplexPInt(PComplex, PInt)] */;
                        this.state_0_ = state_0;
                        return doComplexPInt(arg0Value_, arg1Value_);
                    }
                    {
                        int doubleCast1;
                        if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                            state_0 = (state_0 | (doubleCast1 << 8) /* set-int ImplicitCast[type=double, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.AddNode.doComplexDouble(PComplex, double)] */;
                            this.state_0_ = state_0;
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.AddNode.doComplex(PComplex, PComplex)] */;
                        this.state_0_ = state_0;
                        return doComplex(arg0Value_, arg1Value_);
                    }
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.AddNode.doComplex(Object, Object)] */;
                this.state_0_ = state_0;
                return AddNode.doComplex(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(DivNode.class)
    public static final class DivNodeFactory implements NodeFactory<DivNode> {

        private static final DivNodeFactory DIV_NODE_FACTORY_INSTANCE = new DivNodeFactory();

        private DivNodeFactory() {
        }

        @Override
        public Class<DivNode> getNodeClass() {
            return DivNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public DivNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<DivNode> getInstance() {
            return DIV_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static DivNode create() {
            return new DivNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link DivNode#doComplexDouble(PComplex, double)}
         *     Activation probability: 0.21250
         *     With/without class size: 6/0 bytes
         *   Specialization {@link DivNode#doComplexInt(PComplex, long)}
         *     Activation probability: 0.18750
         *     With/without class size: 6/0 bytes
         *   Specialization {@link DivNode#doComplexPInt(PComplex, PInt)}
         *     Activation probability: 0.16250
         *     With/without class size: 5/0 bytes
         *   Specialization {@link DivNode#doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)}
         *     Activation probability: 0.13750
         *     With/without class size: 6/1 bytes
         *   Specialization {@link DivNode#doComplexDouble(double, PComplex)}
         *     Activation probability: 0.11250
         *     With/without class size: 5/0 bytes
         *   Specialization {@link DivNode#doComplexInt(long, PComplex)}
         *     Activation probability: 0.08750
         *     With/without class size: 5/0 bytes
         *   Specialization {@link DivNode#doComplexPInt(PInt, PComplex)}
         *     Activation probability: 0.06250
         *     With/without class size: 4/0 bytes
         *   Specialization {@link DivNode#doComplex(Object, Object)}
         *     Activation probability: 0.03750
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(DivNode.class)
        @SuppressWarnings("javadoc")
        public static final class DivNodeGen extends DivNode {

            private static final StateField STATE_0_DivNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} topConditionProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_COMPLEX_TOP_CONDITION_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_DivNode_UPDATER.subUpdater(18, 2)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link DivNode#doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} zeroDivisionProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_COMPLEX_ZERO_DIVISION_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_DivNode_UPDATER.subUpdater(20, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link DivNode#doComplexDouble(PComplex, double)}
             *   1: SpecializationActive {@link DivNode#doComplexInt(PComplex, long)}
             *   2: SpecializationActive {@link DivNode#doComplexPInt(PComplex, PInt)}
             *   3: SpecializationActive {@link DivNode#doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)}
             *   4: SpecializationActive {@link DivNode#doComplexDouble(double, PComplex)}
             *   5: SpecializationActive {@link DivNode#doComplexInt(long, PComplex)}
             *   6: SpecializationActive {@link DivNode#doComplexPInt(PInt, PComplex)}
             *   7: SpecializationActive {@link DivNode#doComplex(Object, Object)}
             *   8-9: ImplicitCast[type=double, index=1]
             *   10-12: ImplicitCast[type=long, index=1]
             *   13-14: ImplicitCast[type=double, index=0]
             *   15-17: ImplicitCast[type=long, index=0]
             *   18-19: InlinedCache
             *        Specialization: {@link DivNode#doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} topConditionProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             *   20-21: InlinedCache
             *        Specialization: {@link DivNode#doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} zeroDivisionProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private DivNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg0Value instanceof PComplex) {
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                    if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] */) && arg1Value instanceof PComplex) {
                        return false;
                    }
                }
                if (arg1Value instanceof PComplex) {
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg0Value)) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b1000000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */) && arg0Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111111) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplex(Object, Object)] */) {
                    if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            return doComplexInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return doComplexPInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            {
                                Node inliningTarget__ = (this);
                                return doComplex(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX_TOP_CONDITION_PROFILE_, INLINED_COMPLEX_ZERO_DIVISION_PROFILE_);
                            }
                        }
                    }
                    if ((state_0 & 0b1110000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */ && arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x38000) >>> 15 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x38000) >>> 15 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return doComplexInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            return doComplexPInt(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplex(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return DivNode.doComplex(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            @Override
            public PComplex executeComplex(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1111111) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */) {
                    if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000000) >>> 10 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            return doComplexInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return doComplexPInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            {
                                Node inliningTarget__ = (this);
                                return doComplex(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX_TOP_CONDITION_PROFILE_, INLINED_COMPLEX_ZERO_DIVISION_PROFILE_);
                            }
                        }
                    }
                    if ((state_0 & 0b1110000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] || SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */ && arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b110000000000000) >>> 13 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0x38000) >>> 15 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0x38000) >>> 15 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return doComplexInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */ && arg0Value instanceof PInt) {
                            PInt arg0Value_ = (PInt) arg0Value;
                            return doComplexPInt(arg0Value_, arg1Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return (PComplex) executeAndSpecialize(arg0Value, arg1Value);
            }

            private PythonAbstractObject executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    {
                        int doubleCast1;
                        if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                            state_0 = (state_0 | (doubleCast1 << 8) /* set-int ImplicitCast[type=double, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(PComplex, double)] */;
                            this.state_0_ = state_0;
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                    }
                    {
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                            state_0 = (state_0 | (longCast1 << 10) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(PComplex, long)] */;
                            this.state_0_ = state_0;
                            return doComplexInt(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PComplex, PInt)] */;
                        this.state_0_ = state_0;
                        return doComplexPInt(arg0Value_, arg1Value_);
                    }
                    {
                        Node inliningTarget__ = null;
                        if (arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplex(PComplex, PComplex, Node, InlinedConditionProfile, InlinedConditionProfile)] */;
                            this.state_0_ = state_0;
                            return doComplex(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX_TOP_CONDITION_PROFILE_, INLINED_COMPLEX_ZERO_DIVISION_PROFILE_);
                        }
                    }
                }
                if (arg1Value instanceof PComplex) {
                    PComplex arg1Value_ = (PComplex) arg1Value;
                    {
                        int doubleCast0;
                        if ((doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                            state_0 = (state_0 | (doubleCast0 << 13) /* set-int ImplicitCast[type=double, index=0] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplexDouble(double, PComplex)] */;
                            this.state_0_ = state_0;
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                    }
                    {
                        int longCast0;
                        if ((longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                            state_0 = (state_0 | (longCast0 << 15) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b100000 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplexInt(long, PComplex)] */;
                            this.state_0_ = state_0;
                            return doComplexInt(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg0Value instanceof PInt) {
                        PInt arg0Value_ = (PInt) arg0Value;
                        state_0 = state_0 | 0b1000000 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplexPInt(PInt, PComplex)] */;
                        this.state_0_ = state_0;
                        return doComplexPInt(arg0Value_, arg1Value_);
                    }
                }
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[ComplexBuiltins.DivNode.doComplex(Object, Object)] */;
                this.state_0_ = state_0;
                return DivNode.doComplex(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11111111) & ((state_0 & 0b11111111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(MulNode.class)
    static final class MulNodeFactory implements NodeFactory<MulNode> {

        private static final MulNodeFactory MUL_NODE_FACTORY_INSTANCE = new MulNodeFactory();

        private MulNodeFactory() {
        }

        @Override
        public Class<MulNode> getNodeClass() {
            return MulNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public MulNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<MulNode> getInstance() {
            return MUL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static MulNode create() {
            return new MulNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link MulNode#doComplexDouble}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link MulNode#doComplex}
         *     Activation probability: 0.26000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link MulNode#doComplexLong}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link MulNode#doComplexPInt}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link MulNode#doGeneric}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(MulNode.class)
        @SuppressWarnings("javadoc")
        static final class MulNodeGen extends MulNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link MulNode#doComplexDouble}
             *   1: SpecializationActive {@link MulNode#doComplex}
             *   2: SpecializationActive {@link MulNode#doComplexLong}
             *   3: SpecializationActive {@link MulNode#doComplexPInt}
             *   4: SpecializationActive {@link MulNode#doGeneric}
             *   5-6: ImplicitCast[type=double, index=1]
             *   7-9: ImplicitCast[type=long, index=1]
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private MulNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg0Value instanceof PComplex) {
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplex(PComplex, PComplex)] */) && arg1Value instanceof PComplex) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplexPInt(PComplex, PInt)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.MulNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.MulNode.doComplexLong(PComplex, long)] || SpecializationActive[ComplexBuiltins.MulNode.doComplexPInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.MulNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.MulNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.MulNode.doComplexLong(PComplex, long)] || SpecializationActive[ComplexBuiltins.MulNode.doComplexPInt(PComplex, PInt)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplexDouble(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000) >>> 5 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplex(PComplex, PComplex)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            return doComplex(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplexLong(PComplex, long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000) >>> 7 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            return doComplexLong(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doComplexPInt(PComplex, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return doComplexPInt(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.MulNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return MulNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private PythonAbstractObject executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    {
                        int doubleCast1;
                        if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                            state_0 = (state_0 | (doubleCast1 << 5) /* set-int ImplicitCast[type=double, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.MulNode.doComplexDouble(PComplex, double)] */;
                            this.state_0_ = state_0;
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.MulNode.doComplex(PComplex, PComplex)] */;
                        this.state_0_ = state_0;
                        return doComplex(arg0Value_, arg1Value_);
                    }
                    {
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                            state_0 = (state_0 | (longCast1 << 7) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.MulNode.doComplexLong(PComplex, long)] */;
                            this.state_0_ = state_0;
                            return doComplexLong(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.MulNode.doComplexPInt(PComplex, PInt)] */;
                        this.state_0_ = state_0;
                        return doComplexPInt(arg0Value_, arg1Value_);
                    }
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.MulNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return MulNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(SubNode.class)
    static final class SubNodeFactory implements NodeFactory<SubNode> {

        private static final SubNodeFactory SUB_NODE_FACTORY_INSTANCE = new SubNodeFactory();

        private SubNodeFactory() {
        }

        @Override
        public Class<SubNode> getNodeClass() {
            return SubNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public SubNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<SubNode> getInstance() {
            return SUB_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SubNode create() {
            return new SubNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SubNode#doComplexDouble(PComplex, double)}
         *     Activation probability: 0.27381
         *     With/without class size: 7/0 bytes
         *   Specialization {@link SubNode#doComplex(PComplex, PComplex)}
         *     Activation probability: 0.23095
         *     With/without class size: 6/0 bytes
         *   Specialization {@link SubNode#doComplex(PComplex, long)}
         *     Activation probability: 0.18810
         *     With/without class size: 6/0 bytes
         *   Specialization {@link SubNode#doComplexDouble(double, PComplex)}
         *     Activation probability: 0.14524
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doComplex(long, PComplex)}
         *     Activation probability: 0.10238
         *     With/without class size: 5/0 bytes
         *   Specialization {@link SubNode#doComplex(Object, Object)}
         *     Activation probability: 0.05952
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(SubNode.class)
        @SuppressWarnings("javadoc")
        static final class SubNodeGen extends SubNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SubNode#doComplexDouble(PComplex, double)}
             *   1: SpecializationActive {@link SubNode#doComplex(PComplex, PComplex)}
             *   2: SpecializationActive {@link SubNode#doComplex(PComplex, long)}
             *   3: SpecializationActive {@link SubNode#doComplexDouble(double, PComplex)}
             *   4: SpecializationActive {@link SubNode#doComplex(long, PComplex)}
             *   5: SpecializationActive {@link SubNode#doComplex(Object, Object)}
             *   6-7: ImplicitCast[type=double, index=1]
             *   8-10: ImplicitCast[type=long, index=1]
             *   11-12: ImplicitCast[type=double, index=0]
             *   13-15: ImplicitCast[type=long, index=0]
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private SubNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg0Value instanceof PComplex) {
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, PComplex)] */) && arg1Value instanceof PComplex) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                }
                if (arg1Value instanceof PComplex) {
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg0Value)) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg0Value)) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, long)] || SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(double, PComplex)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(long, PComplex)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(Object, Object)] */) {
                    if ((state_0 & 0b111) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(PComplex, double)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, long)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b11000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b11000000) >>> 6 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, PComplex)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            return doComplex(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100000000) >>> 8 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100000000) >>> 8 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            return doComplex(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b11000) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(double, PComplex)] || SpecializationActive[ComplexBuiltins.SubNode.doComplex(long, PComplex)] */ && arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(double, PComplex)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, arg0Value)) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000000000) >>> 11 /* get-int ImplicitCast[type=double, index=0] */, arg0Value);
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(long, PComplex)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=long, index=0] */, arg0Value)) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=long, index=0] */, arg0Value);
                            return doComplex(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.SubNode.doComplex(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return SubNode.doComplex(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private PythonAbstractObject executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    {
                        int doubleCast1;
                        if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                            state_0 = (state_0 | (doubleCast1 << 6) /* set-int ImplicitCast[type=double, index=1] */);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(PComplex, double)] */;
                            this.state_0_ = state_0;
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                    }
                    if (arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, PComplex)] */;
                        this.state_0_ = state_0;
                        return doComplex(arg0Value_, arg1Value_);
                    }
                    {
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                            state_0 = (state_0 | (longCast1 << 8) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplex(PComplex, long)] */;
                            this.state_0_ = state_0;
                            return doComplex(arg0Value_, arg1Value_);
                        }
                    }
                }
                if (arg1Value instanceof PComplex) {
                    PComplex arg1Value_ = (PComplex) arg1Value;
                    {
                        int doubleCast0;
                        if ((doubleCast0 = PythonArithmeticTypesGen.specializeImplicitDouble(arg0Value)) != 0) {
                            double arg0Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast0, arg0Value);
                            state_0 = (state_0 | (doubleCast0 << 11) /* set-int ImplicitCast[type=double, index=0] */);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplexDouble(double, PComplex)] */;
                            this.state_0_ = state_0;
                            return doComplexDouble(arg0Value_, arg1Value_);
                        }
                    }
                    {
                        int longCast0;
                        if ((longCast0 = PythonArithmeticTypesGen.specializeImplicitLong(arg0Value)) != 0) {
                            long arg0Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast0, arg0Value);
                            state_0 = (state_0 | (longCast0 << 13) /* set-int ImplicitCast[type=long, index=0] */);
                            state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplex(long, PComplex)] */;
                            this.state_0_ = state_0;
                            return doComplex(arg0Value_, arg1Value_);
                        }
                    }
                }
                state_0 = state_0 | 0b100000 /* add SpecializationActive[ComplexBuiltins.SubNode.doComplex(Object, Object)] */;
                this.state_0_ = state_0;
                return SubNode.doComplex(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111111) & ((state_0 & 0b111111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(PowerNode.class)
    static final class PowerNodeFactory implements NodeFactory<PowerNode> {

        private static final PowerNodeFactory POWER_NODE_FACTORY_INSTANCE = new PowerNodeFactory();

        private PowerNodeFactory() {
        }

        @Override
        public Class<PowerNode> getNodeClass() {
            return PowerNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public PowerNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<PowerNode> getInstance() {
            return POWER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PowerNode create() {
            return new PowerNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PowerNode#doComplexLongSmallPos}
         *     Activation probability: 0.27381
         *     With/without class size: 7/0 bytes
         *   Specialization {@link PowerNode#doComplexLongSmallNeg}
         *     Activation probability: 0.23095
         *     With/without class size: 6/0 bytes
         *   Specialization {@link PowerNode#doComplexLong}
         *     Activation probability: 0.18810
         *     With/without class size: 6/0 bytes
         *   Specialization {@link PowerNode#doComplexComplex}
         *     Activation probability: 0.14524
         *     With/without class size: 5/0 bytes
         *   Specialization {@link PowerNode#doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)}
         *     Activation probability: 0.10238
         *     With/without class size: 6/8 bytes
         *   Specialization {@link PowerNode#doGeneric(Object, Object, Object)}
         *     Activation probability: 0.05952
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(PowerNode.class)
        @SuppressWarnings("javadoc")
        static final class PowerNodeGen extends PowerNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PowerNode#doComplexLongSmallPos}
             *   1: SpecializationActive {@link PowerNode#doComplexLongSmallNeg}
             *   2: SpecializationActive {@link PowerNode#doComplexLong}
             *   3: SpecializationActive {@link PowerNode#doComplexComplex}
             *   4: SpecializationActive {@link PowerNode#doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)}
             *   5: SpecializationActive {@link PowerNode#doGeneric(Object, Object, Object)}
             *   6-8: ImplicitCast[type=long, index=1]
             * </pre>
             */
            @CompilationFinal private int state_0_;
            @Child private Generic0Data generic0_cache;

            private PowerNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] || SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, Object)] */) {
                    if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] */ && arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone) arg2Value;
                        if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] */ && arg0Value instanceof PComplex) {
                            PComplex arg0Value_ = (PComplex) arg0Value;
                            if ((state_0 & 0b111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] */) {
                                    if ((PowerNode.isSmallPositive(arg1Value_))) {
                                        return doComplexLongSmallPos(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] */) {
                                    if ((PowerNode.isSmallNegative(arg1Value_))) {
                                        return doComplexLongSmallNeg(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] */) {
                                    if ((!(PowerNode.isSmallPositive(arg1Value_)) || !(PowerNode.isSmallNegative(arg1Value_)))) {
                                        return doComplexLong(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] */ && arg1Value instanceof PComplex) {
                                PComplex arg1Value_ = (PComplex) arg1Value;
                                return doComplexComplex(arg0Value_, arg1Value_, arg2Value_);
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] */) {
                            Generic0Data s4_ = this.generic0_cache;
                            if (s4_ != null) {
                                return doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, s4_.coerceLeft_, s4_.coerceRight_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, Object)] */) {
                        if ((!(PGuards.isPNone(arg2Value)))) {
                            return doGeneric(arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            @Override
            protected Object execute1(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] || SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, Object)] */) {
                    if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] */ && arg2Value instanceof PNone) {
                        PNone arg2Value_ = (PNone) arg2Value;
                        if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] */ && arg0Value instanceof PComplex) {
                            PComplex arg0Value_ = (PComplex) arg0Value;
                            if ((state_0 & 0b111) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] || SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b111000000) >>> 6 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                                if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] */) {
                                    if ((PowerNode.isSmallPositive(arg1Value_))) {
                                        return doComplexLongSmallPos(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] */) {
                                    if ((PowerNode.isSmallNegative(arg1Value_))) {
                                        return doComplexLongSmallNeg(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                                if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] */) {
                                    if ((!(PowerNode.isSmallPositive(arg1Value_)) || !(PowerNode.isSmallNegative(arg1Value_)))) {
                                        return doComplexLong(arg0Value_, arg1Value_, arg2Value_);
                                    }
                                }
                            }
                            if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] */ && arg1Value instanceof PComplex) {
                                PComplex arg1Value_ = (PComplex) arg1Value;
                                return doComplexComplex(arg0Value_, arg1Value_, arg2Value_);
                            }
                        }
                        if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] */) {
                            Generic0Data s4_ = this.generic0_cache;
                            if (s4_ != null) {
                                return doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, s4_.coerceLeft_, s4_.coerceRight_);
                            }
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, Object)] */) {
                        if ((!(PGuards.isPNone(arg2Value)))) {
                            return doGeneric(arg0Value, arg1Value, arg2Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value, arg2Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value, Object arg2Value) {
                int state_0 = this.state_0_;
                if (arg2Value instanceof PNone) {
                    PNone arg2Value_ = (PNone) arg2Value;
                    if (arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        {
                            int longCast1;
                            if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                                if ((PowerNode.isSmallPositive(arg1Value_))) {
                                    state_0 = (state_0 | (longCast1 << 6) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallPos(PComplex, long, PNone)] */;
                                    this.state_0_ = state_0;
                                    return doComplexLongSmallPos(arg0Value_, arg1Value_, arg2Value_);
                                }
                                if ((PowerNode.isSmallNegative(arg1Value_))) {
                                    state_0 = (state_0 | (longCast1 << 6) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.PowerNode.doComplexLongSmallNeg(PComplex, long, PNone)] */;
                                    this.state_0_ = state_0;
                                    return doComplexLongSmallNeg(arg0Value_, arg1Value_, arg2Value_);
                                }
                                if ((!(PowerNode.isSmallPositive(arg1Value_)) || !(PowerNode.isSmallNegative(arg1Value_)))) {
                                    state_0 = (state_0 | (longCast1 << 6) /* set-int ImplicitCast[type=long, index=1] */);
                                    state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.PowerNode.doComplexLong(PComplex, long, PNone)] */;
                                    this.state_0_ = state_0;
                                    return doComplexLong(arg0Value_, arg1Value_, arg2Value_);
                                }
                            }
                        }
                        if (arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.PowerNode.doComplexComplex(PComplex, PComplex, PNone)] */;
                            this.state_0_ = state_0;
                            return doComplexComplex(arg0Value_, arg1Value_, arg2Value_);
                        }
                    }
                    Generic0Data s4_ = this.insert(new Generic0Data());
                    CoerceToComplexNode coerceLeft__ = s4_.insert((CoerceToComplexNodeGen.create()));
                    Objects.requireNonNull(coerceLeft__, "Specialization 'doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)' cache 'coerceLeft' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s4_.coerceLeft_ = coerceLeft__;
                    CoerceToComplexNode coerceRight__ = s4_.insert((CoerceToComplexNodeGen.create()));
                    Objects.requireNonNull(coerceRight__, "Specialization 'doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)' cache 'coerceRight' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    s4_.coerceRight_ = coerceRight__;
                    VarHandle.storeStoreFence();
                    this.generic0_cache = s4_;
                    state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)] */;
                    this.state_0_ = state_0;
                    return doGeneric(frameValue, arg0Value, arg1Value, arg2Value_, coerceLeft__, coerceRight__);
                }
                if ((!(PGuards.isPNone(arg2Value)))) {
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[ComplexBuiltins.PowerNode.doGeneric(Object, Object, Object)] */;
                    this.state_0_ = state_0;
                    return doGeneric(arg0Value, arg1Value, arg2Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b111111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b111111) & ((state_0 & 0b111111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(PowerNode.class)
            @DenyReplace
            private static final class Generic0Data extends Node implements SpecializationDataNode {

                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PowerNode#doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)}
                 *   Parameter: {@link CoerceToComplexNode} coerceLeft</pre>
                 */
                @Child CoerceToComplexNode coerceLeft_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link PowerNode#doGeneric(VirtualFrame, Object, Object, PNone, CoerceToComplexNode, CoerceToComplexNode)}
                 *   Parameter: {@link CoerceToComplexNode} coerceRight</pre>
                 */
                @Child CoerceToComplexNode coerceRight_;

                Generic0Data() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

            }
        }
    }
    @GeneratedBy(EqNode.class)
    static final class EqNodeFactory implements NodeFactory<EqNode> {

        private static final EqNodeFactory EQ_NODE_FACTORY_INSTANCE = new EqNodeFactory();

        private EqNodeFactory() {
        }

        @Override
        public Class<EqNode> getNodeClass() {
            return EqNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public EqNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<EqNode> getInstance() {
            return EQ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static EqNode create() {
            return new EqNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link EqNode#doComplex}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link EqNode#doComplexInt(PComplex, long, Node, InlinedConditionProfile)}
         *     Activation probability: 0.26000
         *     With/without class size: 9/1 bytes
         *   Specialization {@link EqNode#doComplexInt(PComplex, PInt)}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link EqNode#doComplexInt(PComplex, double)}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link EqNode#doGeneric}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(EqNode.class)
        @SuppressWarnings("javadoc")
        static final class EqNodeGen extends EqNode {

            private static final StateField STATE_0_EqNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link EqNode#doComplexInt(PComplex, long, Node, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} longFitsToDoubleProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_COMPLEX_INT0_LONG_FITS_TO_DOUBLE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_EqNode_UPDATER.subUpdater(10, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link EqNode#doComplex}
             *   1: SpecializationActive {@link EqNode#doComplexInt(PComplex, long, Node, InlinedConditionProfile)}
             *   2: SpecializationActive {@link EqNode#doComplexInt(PComplex, PInt)}
             *   3: SpecializationActive {@link EqNode#doComplexInt(PComplex, double)}
             *   4: SpecializationActive {@link EqNode#doGeneric}
             *   5-7: ImplicitCast[type=long, index=1]
             *   8-9: ImplicitCast[type=double, index=1]
             *   10-11: InlinedCache
             *        Specialization: {@link EqNode#doComplexInt(PComplex, long, Node, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} longFitsToDoubleProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private EqNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg0Value instanceof PComplex) {
                    if (!((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplex(PComplex, PComplex)] */) && arg1Value instanceof PComplex) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, PInt)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, long, Node, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, double)] || SpecializationActive[ComplexBuiltins.EqNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, long, Node, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, double)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplex(PComplex, PComplex)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            return EqNode.doComplex(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, long, Node, InlinedConditionProfile)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__ = (this);
                                return EqNode.doComplexInt(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX_INT0_LONG_FITS_TO_DOUBLE_PROFILE_);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return EqNode.doComplexInt(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return EqNode.doComplexInt(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.EqNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return EqNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    if (arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.EqNode.doComplex(PComplex, PComplex)] */;
                        this.state_0_ = state_0;
                        return EqNode.doComplex(arg0Value_, arg1Value_);
                    }
                    {
                        Node inliningTarget__ = null;
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (longCast1 << 5) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, long, Node, InlinedConditionProfile)] */;
                            this.state_0_ = state_0;
                            return EqNode.doComplexInt(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX_INT0_LONG_FITS_TO_DOUBLE_PROFILE_);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, PInt)] */;
                        this.state_0_ = state_0;
                        return EqNode.doComplexInt(arg0Value_, arg1Value_);
                    }
                    {
                        int doubleCast1;
                        if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                            state_0 = (state_0 | (doubleCast1 << 8) /* set-int ImplicitCast[type=double, index=1] */);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.EqNode.doComplexInt(PComplex, double)] */;
                            this.state_0_ = state_0;
                            return EqNode.doComplexInt(arg0Value_, arg1Value_);
                        }
                    }
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.EqNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return EqNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(GeNode.class)
    static final class GeNodeFactory implements NodeFactory<GeNode> {

        private static final GeNodeFactory GE_NODE_FACTORY_INSTANCE = new GeNodeFactory();

        private GeNodeFactory() {
        }

        @Override
        public Class<GeNode> getNodeClass() {
            return GeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GeNode> getInstance() {
            return GE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GeNode create() {
            return new GeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GeNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GeNode.class)
        @SuppressWarnings("javadoc")
        static final class GeNodeGen extends GeNode {

            private GeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return GeNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(GtNode.class)
    static final class GtNodeFactory implements NodeFactory<GtNode> {

        private static final GtNodeFactory GT_NODE_FACTORY_INSTANCE = new GtNodeFactory();

        private GtNodeFactory() {
        }

        @Override
        public Class<GtNode> getNodeClass() {
            return GtNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GtNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GtNode> getInstance() {
            return GT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GtNode create() {
            return new GtNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GtNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GtNode.class)
        @SuppressWarnings("javadoc")
        static final class GtNodeGen extends GtNode {

            private GtNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return GtNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(LtNode.class)
    static final class LtNodeFactory implements NodeFactory<LtNode> {

        private static final LtNodeFactory LT_NODE_FACTORY_INSTANCE = new LtNodeFactory();

        private LtNodeFactory() {
        }

        @Override
        public Class<LtNode> getNodeClass() {
            return LtNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public LtNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<LtNode> getInstance() {
            return LT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LtNode create() {
            return new LtNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LtNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(LtNode.class)
        @SuppressWarnings("javadoc")
        static final class LtNodeGen extends LtNode {

            private LtNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return LtNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(LeNode.class)
    static final class LeNodeFactory implements NodeFactory<LeNode> {

        private static final LeNodeFactory LE_NODE_FACTORY_INSTANCE = new LeNodeFactory();

        private LeNodeFactory() {
        }

        @Override
        public Class<LeNode> getNodeClass() {
            return LeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public LeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<LeNode> getInstance() {
            return LE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static LeNode create() {
            return new LeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link LeNode#doGeneric}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(LeNode.class)
        @SuppressWarnings("javadoc")
        static final class LeNodeGen extends LeNode {

            private LeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                return LeNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MONOMORPHIC;
            }

        }
    }
    @GeneratedBy(NeNode.class)
    static final class NeNodeFactory implements NodeFactory<NeNode> {

        private static final NeNodeFactory NE_NODE_FACTORY_INSTANCE = new NeNodeFactory();

        private NeNodeFactory() {
        }

        @Override
        public Class<NeNode> getNodeClass() {
            return NeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public NeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NeNode> getInstance() {
            return NE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NeNode create() {
            return new NeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NeNode#doComplex(PComplex, PComplex)}
         *     Activation probability: 0.32000
         *     With/without class size: 7/0 bytes
         *   Specialization {@link NeNode#doComplex(PComplex, long, Node, InlinedConditionProfile)}
         *     Activation probability: 0.26000
         *     With/without class size: 9/1 bytes
         *   Specialization {@link NeNode#doComplex(PComplex, PInt)}
         *     Activation probability: 0.20000
         *     With/without class size: 6/0 bytes
         *   Specialization {@link NeNode#doComplex(PComplex, double)}
         *     Activation probability: 0.14000
         *     With/without class size: 5/0 bytes
         *   Specialization {@link NeNode#doGeneric}
         *     Activation probability: 0.08000
         *     With/without class size: 4/0 bytes
         * </pre>
         */
        @GeneratedBy(NeNode.class)
        @SuppressWarnings("javadoc")
        static final class NeNodeGen extends NeNode {

            private static final StateField STATE_0_NeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link NeNode#doComplex(PComplex, long, Node, InlinedConditionProfile)}
             *   Parameter: {@link InlinedConditionProfile} longFitsToDoubleProfile
             *   Inline method: {@link InlinedConditionProfile#inline}</pre>
             */
            private static final InlinedConditionProfile INLINED_COMPLEX1_LONG_FITS_TO_DOUBLE_PROFILE_ = InlinedConditionProfile.inline(InlineTarget.create(InlinedConditionProfile.class, STATE_0_NeNode_UPDATER.subUpdater(10, 2)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NeNode#doComplex(PComplex, PComplex)}
             *   1: SpecializationActive {@link NeNode#doComplex(PComplex, long, Node, InlinedConditionProfile)}
             *   2: SpecializationActive {@link NeNode#doComplex(PComplex, PInt)}
             *   3: SpecializationActive {@link NeNode#doComplex(PComplex, double)}
             *   4: SpecializationActive {@link NeNode#doGeneric}
             *   5-7: ImplicitCast[type=long, index=1]
             *   8-9: ImplicitCast[type=double, index=1]
             *   10-11: InlinedCache
             *        Specialization: {@link NeNode#doComplex(PComplex, long, Node, InlinedConditionProfile)}
             *        Parameter: {@link InlinedConditionProfile} longFitsToDoubleProfile
             *        Inline method: {@link InlinedConditionProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;

            private NeNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (arg0Value instanceof PComplex) {
                    if (!((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PComplex)] */) && arg1Value instanceof PComplex) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                        return false;
                    }
                    if (!((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PInt)] */) && arg1Value instanceof PInt) {
                        return false;
                    }
                    if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                        return false;
                    }
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, long, Node, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, double)] || SpecializationActive[ComplexBuiltins.NeNode.doGeneric(Object, Object)] */) {
                    if ((state_0 & 0b1111) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PComplex)] || SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, long, Node, InlinedConditionProfile)] || SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PInt)] || SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, double)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PComplex)] */ && arg1Value instanceof PComplex) {
                            PComplex arg1Value_ = (PComplex) arg1Value;
                            return NeNode.doComplex(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, long, Node, InlinedConditionProfile)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b11100000) >>> 5 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                            {
                                Node inliningTarget__ = (this);
                                return NeNode.doComplex(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX1_LONG_FITS_TO_DOUBLE_PROFILE_);
                            }
                        }
                        if ((state_0 & 0b100) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PInt)] */ && arg1Value instanceof PInt) {
                            PInt arg1Value_ = (PInt) arg1Value;
                            return NeNode.doComplex(arg0Value_, arg1Value_);
                        }
                        if ((state_0 & 0b1000) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b1100000000) >>> 8 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                            return NeNode.doComplex(arg0Value_, arg1Value_);
                        }
                    }
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[ComplexBuiltins.NeNode.doGeneric(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return NeNode.doGeneric(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    if (arg1Value instanceof PComplex) {
                        PComplex arg1Value_ = (PComplex) arg1Value;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PComplex)] */;
                        this.state_0_ = state_0;
                        return NeNode.doComplex(arg0Value_, arg1Value_);
                    }
                    {
                        Node inliningTarget__ = null;
                        int longCast1;
                        if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                            long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                            inliningTarget__ = (this);
                            state_0 = (state_0 | (longCast1 << 5) /* set-int ImplicitCast[type=long, index=1] */);
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, long, Node, InlinedConditionProfile)] */;
                            this.state_0_ = state_0;
                            return NeNode.doComplex(arg0Value_, arg1Value_, inliningTarget__, INLINED_COMPLEX1_LONG_FITS_TO_DOUBLE_PROFILE_);
                        }
                    }
                    if (arg1Value instanceof PInt) {
                        PInt arg1Value_ = (PInt) arg1Value;
                        state_0 = state_0 | 0b100 /* add SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, PInt)] */;
                        this.state_0_ = state_0;
                        return NeNode.doComplex(arg0Value_, arg1Value_);
                    }
                    {
                        int doubleCast1;
                        if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                            double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                            state_0 = (state_0 | (doubleCast1 << 8) /* set-int ImplicitCast[type=double, index=1] */);
                            state_0 = state_0 | 0b1000 /* add SpecializationActive[ComplexBuiltins.NeNode.doComplex(PComplex, double)] */;
                            this.state_0_ = state_0;
                            return NeNode.doComplex(arg0Value_, arg1Value_);
                        }
                    }
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[ComplexBuiltins.NeNode.doGeneric(Object, Object)] */;
                this.state_0_ = state_0;
                return NeNode.doGeneric(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11111) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11111) & ((state_0 & 0b11111) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(ReprNode.class)
    static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#repr(PComplex)}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        static final class ReprNodeGen extends ReprNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReprNode#repr(PComplex)}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.ReprNode.repr(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return repr(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ReprNode.repr(PComplex)] */;
                    this.state_0_ = state_0;
                    return repr(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(StrNode.class)
    static final class StrNodeFactory implements NodeFactory<StrNode> {

        private static final StrNodeFactory STR_NODE_FACTORY_INSTANCE = new StrNodeFactory();

        private StrNodeFactory() {
        }

        @Override
        public Class<StrNode> getNodeClass() {
            return StrNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public StrNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<StrNode> getInstance() {
            return STR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static StrNode create() {
            return new StrNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#repr(PComplex)}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(StrNode.class)
        @SuppressWarnings("javadoc")
        static final class StrNodeGen extends StrNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReprNode#repr(PComplex)}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private StrNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.ReprNode.repr(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return repr(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private TruffleString executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ReprNode.repr(PComplex)] */;
                    this.state_0_ = state_0;
                    return repr(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(FormatNode.class)
    static final class FormatNodeFactory implements NodeFactory<FormatNode> {

        private static final FormatNodeFactory FORMAT_NODE_FACTORY_INSTANCE = new FormatNodeFactory();

        private FormatNodeFactory() {
        }

        @Override
        public Class<FormatNode> getNodeClass() {
            return FormatNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public FormatNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<FormatNode> getInstance() {
            return FORMAT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static FormatNode create() {
            return new FormatNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link FormatNodeBase#formatEmptyString}
         *     Activation probability: 0.65000
         *     With/without class size: 17/4 bytes
         *   Specialization {@link FormatNode#format}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(FormatNode.class)
        @SuppressWarnings("javadoc")
        static final class FormatNodeGen extends FormatNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FormatNodeBase#formatEmptyString}
             *   1: SpecializationActive {@link FormatNode#format}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FormatNodeBase#formatEmptyString}
             *   Parameter: {@link LookupAndCallUnaryNode} lookupAndCallNode</pre>
             */
            @Child private LookupAndCallUnaryNode formatEmptyString_lookupAndCallNode_;

            private FormatNodeGen() {
            }

            @Override
            protected Object executeWithoutClinic(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)] || SpecializationActive[ComplexBuiltins.FormatNode.format(PComplex, TruffleString)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)] */) {
                        {
                            LookupAndCallUnaryNode lookupAndCallNode__ = this.formatEmptyString_lookupAndCallNode_;
                            if (lookupAndCallNode__ != null) {
                                if ((arg1Value_.isEmpty())) {
                                    return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, lookupAndCallNode__);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.FormatNode.format(PComplex, TruffleString)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((!(arg1Value_.isEmpty()))) {
                            return format(arg0Value_, arg1Value_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    if ((arg1Value_.isEmpty())) {
                        LookupAndCallUnaryNode lookupAndCallNode__ = this.insert((LookupAndCallUnaryNode.create(SpecialMethodSlot.Str)));
                        Objects.requireNonNull(lookupAndCallNode__, "Specialization 'formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)' cache 'lookupAndCallNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.formatEmptyString_lookupAndCallNode_ = lookupAndCallNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[com.oracle.graal.python.builtins.objects.common.FormatNodeBase.formatEmptyString(VirtualFrame, Object, TruffleString, LookupAndCallUnaryNode)] */;
                        this.state_0_ = state_0;
                        return FormatNodeBase.formatEmptyString(frameValue, arg0Value, arg1Value_, lookupAndCallNode__);
                    }
                    if (arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        if ((!(arg1Value_.isEmpty()))) {
                            state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.FormatNode.format(PComplex, TruffleString)] */;
                            this.state_0_ = state_0;
                            return format(arg0Value_, arg1Value_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(BoolNode.class)
    static final class BoolNodeFactory implements NodeFactory<BoolNode> {

        private static final BoolNodeFactory BOOL_NODE_FACTORY_INSTANCE = new BoolNodeFactory();

        private BoolNodeFactory() {
        }

        @Override
        public Class<BoolNode> getNodeClass() {
            return BoolNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public BoolNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<BoolNode> getInstance() {
            return BOOL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static BoolNode create() {
            return new BoolNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link BoolNode#bool}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(BoolNode.class)
        @SuppressWarnings("javadoc")
        static final class BoolNodeGen extends BoolNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link BoolNode#bool}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private BoolNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.BoolNode.bool(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return BoolNode.bool(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private boolean executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.BoolNode.bool(PComplex)] */;
                    this.state_0_ = state_0;
                    return BoolNode.bool(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(NegNode.class)
    static final class NegNodeFactory implements NodeFactory<NegNode> {

        private static final NegNodeFactory NEG_NODE_FACTORY_INSTANCE = new NegNodeFactory();

        private NegNodeFactory() {
        }

        @Override
        public Class<NegNode> getNodeClass() {
            return NegNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public NegNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<NegNode> getInstance() {
            return NEG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static NegNode create() {
            return new NegNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link NegNode#neg}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(NegNode.class)
        @SuppressWarnings("javadoc")
        static final class NegNodeGen extends NegNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link NegNode#neg}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private NegNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.NegNode.neg(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return neg(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PComplex executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.NegNode.neg(PComplex)] */;
                    this.state_0_ = state_0;
                    return neg(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(PosNode.class)
    static final class PosNodeFactory implements NodeFactory<PosNode> {

        private static final PosNodeFactory POS_NODE_FACTORY_INSTANCE = new PosNodeFactory();

        private PosNodeFactory() {
        }

        @Override
        public Class<PosNode> getNodeClass() {
            return PosNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public PosNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<PosNode> getInstance() {
            return POS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static PosNode create() {
            return new PosNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link PosNode#pos}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(PosNode.class)
        @SuppressWarnings("javadoc")
        static final class PosNodeGen extends PosNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link PosNode#pos}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private PosNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.PosNode.pos(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return pos(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PComplex executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.PosNode.pos(PComplex)] */;
                    this.state_0_ = state_0;
                    return pos(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(GetNewArgsNode.class)
    static final class GetNewArgsNodeFactory implements NodeFactory<GetNewArgsNode> {

        private static final GetNewArgsNodeFactory GET_NEW_ARGS_NODE_FACTORY_INSTANCE = new GetNewArgsNodeFactory();

        private GetNewArgsNodeFactory() {
        }

        @Override
        public Class<GetNewArgsNode> getNodeClass() {
            return GetNewArgsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetNewArgsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetNewArgsNode> getInstance() {
            return GET_NEW_ARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetNewArgsNode create() {
            return new GetNewArgsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetNewArgsNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetNewArgsNode.class)
        @SuppressWarnings("javadoc")
        static final class GetNewArgsNodeGen extends GetNewArgsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetNewArgsNode#get}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetNewArgsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.GetNewArgsNode.get(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return get(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PTuple executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.GetNewArgsNode.get(PComplex)] */;
                    this.state_0_ = state_0;
                    return get(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(RealNode.class)
    static final class RealNodeFactory implements NodeFactory<RealNode> {

        private static final RealNodeFactory REAL_NODE_FACTORY_INSTANCE = new RealNodeFactory();

        private RealNodeFactory() {
        }

        @Override
        public Class<RealNode> getNodeClass() {
            return RealNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public RealNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<RealNode> getInstance() {
            return REAL_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static RealNode create(ReadArgumentNode[] arguments) {
            return new RealNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link RealNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(RealNode.class)
        @SuppressWarnings("javadoc")
        static final class RealNodeGen extends RealNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link RealNode#get}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private RealNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.RealNode.get(PComplex)] */ && arguments0Value_ instanceof PComplex) {
                    PComplex arguments0Value__ = (PComplex) arguments0Value_;
                    return RealNode.get(arguments0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private double executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PComplex) {
                    PComplex arguments0Value_ = (PComplex) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.RealNode.get(PComplex)] */;
                    this.state_0_ = state_0;
                    return RealNode.get(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ImagNode.class)
    static final class ImagNodeFactory implements NodeFactory<ImagNode> {

        private static final ImagNodeFactory IMAG_NODE_FACTORY_INSTANCE = new ImagNodeFactory();

        private ImagNodeFactory() {
        }

        @Override
        public Class<ImagNode> getNodeClass() {
            return ImagNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(ReadArgumentNode.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList(ReadArgumentNode[].class));
        }

        @Override
        public ImagNode createNode(Object... arguments) {
            if (arguments.length == 1 && (arguments[0] == null || arguments[0] instanceof ReadArgumentNode[])) {
                return create((ReadArgumentNode[]) arguments[0]);
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ImagNode> getInstance() {
            return IMAG_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ImagNode create(ReadArgumentNode[] arguments) {
            return new ImagNodeGen(arguments);
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ImagNode#get}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ImagNode.class)
        @SuppressWarnings("javadoc")
        static final class ImagNodeGen extends ImagNode {

            @Child private ReadArgumentNode arguments0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ImagNode#get}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ImagNodeGen(ReadArgumentNode[] arguments) {
                this.arguments0_ = arguments != null && 0 < arguments.length ? arguments[0] : null;
            }

            @Override
            public Object execute(VirtualFrame frameValue) {
                int state_0 = this.state_0_;
                Object arguments0Value_ = this.arguments0_.execute(frameValue);
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.ImagNode.get(PComplex)] */ && arguments0Value_ instanceof PComplex) {
                    PComplex arguments0Value__ = (PComplex) arguments0Value_;
                    return ImagNode.get(arguments0Value__);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arguments0Value_);
            }

            private double executeAndSpecialize(Object arguments0Value) {
                int state_0 = this.state_0_;
                if (arguments0Value instanceof PComplex) {
                    PComplex arguments0Value_ = (PComplex) arguments0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ImagNode.get(PComplex)] */;
                    this.state_0_ = state_0;
                    return ImagNode.get(arguments0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {this.arguments0_}, arguments0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(HashNode.class)
    static final class HashNodeFactory implements NodeFactory<HashNode> {

        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        @Override
        public Class<HashNode> getNodeClass() {
            return HashNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public HashNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNode create() {
            return new HashNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HashNode#doPComplex}
         *     Activation probability: 0.65000
         *     With/without class size: 11/0 bytes
         *   Specialization {@link HashNode#doNative}
         *     Activation probability: 0.35000
         *     With/without class size: 11/4 bytes
         * </pre>
         */
        @GeneratedBy(HashNode.class)
        @SuppressWarnings("javadoc")
        static final class HashNodeGen extends HashNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HashNode#doPComplex}
             *   1: SpecializationActive {@link HashNode#doNative}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#doNative}
             *   Parameter: {@link ReadDoubleNode} read</pre>
             */
            @Child private ReadDoubleNode native_read_;

            private HashNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.HashNode.doPComplex(PComplex)] || SpecializationActive[ComplexBuiltins.HashNode.doNative(PythonAbstractNativeObject, ReadDoubleNode)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[ComplexBuiltins.HashNode.doPComplex(PComplex)] */ && arg0Value instanceof PComplex) {
                        PComplex arg0Value_ = (PComplex) arg0Value;
                        return HashNode.doPComplex(arg0Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[ComplexBuiltins.HashNode.doNative(PythonAbstractNativeObject, ReadDoubleNode)] */ && arg0Value instanceof PythonAbstractNativeObject) {
                        PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject) arg0Value;
                        {
                            ReadDoubleNode read__ = this.native_read_;
                            if (read__ != null) {
                                return HashNode.doNative(arg0Value_, read__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private long executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.HashNode.doPComplex(PComplex)] */;
                    this.state_0_ = state_0;
                    return HashNode.doPComplex(arg0Value_);
                }
                if (arg0Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg0Value_ = (PythonAbstractNativeObject) arg0Value;
                    ReadDoubleNode read__ = this.insert((ReadDoubleNode.create()));
                    Objects.requireNonNull(read__, "Specialization 'doNative(PythonAbstractNativeObject, ReadDoubleNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.native_read_ = read__;
                    state_0 = state_0 | 0b10 /* add SpecializationActive[ComplexBuiltins.HashNode.doNative(PythonAbstractNativeObject, ReadDoubleNode)] */;
                    this.state_0_ = state_0;
                    return HashNode.doNative(arg0Value_, read__);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if ((state_0 & (state_0 - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(ConjugateNode.class)
    static final class ConjugateNodeFactory implements NodeFactory<ConjugateNode> {

        private static final ConjugateNodeFactory CONJUGATE_NODE_FACTORY_INSTANCE = new ConjugateNodeFactory();

        private ConjugateNodeFactory() {
        }

        @Override
        public Class<ConjugateNode> getNodeClass() {
            return ConjugateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ConjugateNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ConjugateNode> getInstance() {
            return CONJUGATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ConjugateNode create() {
            return new ConjugateNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ConjugateNode#hash}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ConjugateNode.class)
        @SuppressWarnings("javadoc")
        static final class ConjugateNodeGen extends ConjugateNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ConjugateNode#hash}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ConjugateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[ComplexBuiltins.ConjugateNode.hash(PComplex)] */ && arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    return hash(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private PComplex executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PComplex) {
                    PComplex arg0Value_ = (PComplex) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[ComplexBuiltins.ConjugateNode.hash(PComplex)] */;
                    this.state_0_ = state_0;
                    return hash(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
