// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.ToArrayNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.ToArrayNodeGen;
import com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.IterNode;
import com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.ReduceNode;
import com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.SetStateNode;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.GetItemNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins.LenNode;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory.GetItemNodeFactory;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltinsFactory.LenNodeFactory;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNodeGen;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectGetIterNodeGen;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttrNodeGen;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles.IsBuiltinObjectProfile;
import com.oracle.graal.python.nodes.object.BuiltinClassProfilesFactory.IsBuiltinObjectProfileNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(CycleBuiltins.class)
@SuppressWarnings("javadoc")
public final class CycleBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(IterNodeFactory.getInstance(), NextNodeFactory.getInstance(), ReduceNodeFactory.getInstance(), SetStateNodeFactory.getInstance());
    }

    @GeneratedBy(IterNode.class)
    public static final class IterNodeFactory implements NodeFactory<IterNode> {

        private static final IterNodeFactory ITER_NODE_FACTORY_INSTANCE = new IterNodeFactory();

        private IterNodeFactory() {
        }

        @Override
        public Class<IterNode> getNodeClass() {
            return IterNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public IterNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<IterNode> getInstance() {
            return ITER_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static IterNode create() {
            return new IterNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link IterNode#iter}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(IterNode.class)
        @SuppressWarnings("javadoc")
        public static final class IterNodeGen extends IterNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IterNode#iter}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private IterNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[CycleBuiltins.IterNode.iter(PCycle)] */ && arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    return IterNode.iter(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CycleBuiltins.IterNode.iter(PCycle)] */;
                    this.state_0_ = state_0;
                    return IterNode.iter(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode.class)
    public static final class NextNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode> {

        private static final com.oracle.graal.python.builtins.objects.itertools.CycleBuiltinsFactory.NextNodeFactory NEXT_NODE_FACTORY_INSTANCE = new NextNodeFactory();

        private NextNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode> getInstance() {
            return NEXT_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode create() {
            return new NextNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
         *     Activation probability: 1.00000
         *     With/without class size: 32/11 bytes
         * </pre>
         */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode.class)
        @SuppressWarnings("javadoc")
        public static final class NextNodeGen extends com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode {

            private static final StateField STATE_0_NextNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *   Parameter: {@link IsBuiltinObjectProfile} isStopIterationProfile
             *   Inline method: {@link IsBuiltinObjectProfileNodeGen#inline}</pre>
             */
            private static final IsBuiltinObjectProfile INLINED_IS_STOP_ITERATION_PROFILE_ = IsBuiltinObjectProfileNodeGen.inline(InlineTarget.create(IsBuiltinObjectProfile.class, STATE_0_NextNode_UPDATER.subUpdater(1, 20), ReferenceField.create(MethodHandles.lookup(), "isStopIterationProfile__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *   Parameter: {@link InlinedBranchProfile} iterableProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_ITERABLE_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_NextNode_UPDATER.subUpdater(21, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *   Parameter: {@link InlinedBranchProfile} firstPassProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_FIRST_PASS_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_0_NextNode_UPDATER.subUpdater(22, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *   1-20: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *        Parameter: {@link IsBuiltinObjectProfile} isStopIterationProfile
             *        Inline method: {@link IsBuiltinObjectProfileNodeGen#inline}
             *   21: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *        Parameter: {@link InlinedBranchProfile} iterableProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   22: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *        Parameter: {@link InlinedBranchProfile} firstPassProfile
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *   Parameter: {@link com.oracle.graal.python.builtins.modules.BuiltinFunctions.NextNode} nextNode</pre>
             */
            @Child private com.oracle.graal.python.builtins.modules.BuiltinFunctions.NextNode nextNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.itertools.CycleBuiltins.NextNode#next}
             *   Parameter: {@link IsBuiltinObjectProfile} isStopIterationProfile
             *   Inline method: {@link IsBuiltinObjectProfileNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node isStopIterationProfile__field1_;

            private NextNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CycleBuiltins.NextNode.next(VirtualFrame, PCycle, Node, NextNode, IsBuiltinObjectProfile, InlinedBranchProfile, InlinedBranchProfile)] */ && arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    {
                        com.oracle.graal.python.builtins.modules.BuiltinFunctions.NextNode nextNode__ = this.nextNode_;
                        if (nextNode__ != null) {
                            Node inliningTarget__ = (this);
                            return next(frameValue, arg0Value_, inliningTarget__, nextNode__, INLINED_IS_STOP_ITERATION_PROFILE_, INLINED_ITERABLE_PROFILE_, INLINED_FIRST_PASS_PROFILE_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PCycle) {
                        PCycle arg0Value_ = (PCycle) arg0Value;
                        inliningTarget__ = (this);
                        com.oracle.graal.python.builtins.modules.BuiltinFunctions.NextNode nextNode__ = this.insert((com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory.NextNodeFactory.create()));
                        Objects.requireNonNull(nextNode__, "Specialization 'next(VirtualFrame, PCycle, Node, NextNode, IsBuiltinObjectProfile, InlinedBranchProfile, InlinedBranchProfile)' cache 'nextNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.nextNode_ = nextNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[CycleBuiltins.NextNode.next(VirtualFrame, PCycle, Node, NextNode, IsBuiltinObjectProfile, InlinedBranchProfile, InlinedBranchProfile)] */;
                        this.state_0_ = state_0;
                        return next(frameValue, arg0Value_, inliningTarget__, nextNode__, INLINED_IS_STOP_ITERATION_PROFILE_, INLINED_ITERABLE_PROFILE_, INLINED_FIRST_PASS_PROFILE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ReduceNode.class)
    public static final class ReduceNodeFactory implements NodeFactory<ReduceNode> {

        private static final ReduceNodeFactory REDUCE_NODE_FACTORY_INSTANCE = new ReduceNodeFactory();

        private ReduceNodeFactory() {
        }

        @Override
        public Class<ReduceNode> getNodeClass() {
            return ReduceNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReduceNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<ReduceNode> getInstance() {
            return REDUCE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReduceNode create() {
            return new ReduceNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReduceNode#reduce}
         *     Activation probability: 0.65000
         *     With/without class size: 19/7 bytes
         *   Specialization {@link ReduceNode#reduceNoIterable}
         *     Activation probability: 0.35000
         *     With/without class size: 30/60 bytes
         * </pre>
         */
        @GeneratedBy(ReduceNode.class)
        @SuppressWarnings("javadoc")
        public static final class ReduceNodeGen extends ReduceNode {

            private static final StateField STATE_0_ReduceNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField REDUCE_NO_ITERABLE__REDUCE_NODE_REDUCE_NO_ITERABLE_STATE_0_UPDATER = StateField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduce}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_REDUCE_GET_CLASS_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_0_ReduceNode_UPDATER.subUpdater(2, 17), ReferenceField.create(MethodHandles.lookup(), "reduce_getClass__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduceNoIterable}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_REDUCE_NO_ITERABLE_GET_CLASS_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, REDUCE_NO_ITERABLE__REDUCE_NODE_REDUCE_NO_ITERABLE_STATE_0_UPDATER.subUpdater(0, 17), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_getClass__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduceNoIterable}
             *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
             *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}</pre>
             */
            private static final PyObjectLookupAttr INLINED_REDUCE_NO_ITERABLE_LOOKUP_ATTR_NODE_ = PyObjectLookupAttrNodeGen.inline(InlineTarget.create(PyObjectLookupAttr.class, REDUCE_NO_ITERABLE__REDUCE_NODE_REDUCE_NO_ITERABLE_STATE_0_UPDATER.subUpdater(17, 5), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field1_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field2_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field3_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field4_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field5_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field6_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field7_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field8_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field9_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_lookupAttrNode__field10_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduceNoIterable}
             *   Parameter: {@link PyObjectGetIter} getIterNode
             *   Inline method: {@link PyObjectGetIterNodeGen#inline}</pre>
             */
            private static final PyObjectGetIter INLINED_REDUCE_NO_ITERABLE_GET_ITER_NODE_ = PyObjectGetIterNodeGen.inline(InlineTarget.create(PyObjectGetIter.class, REDUCE_NO_ITERABLE__REDUCE_NODE_REDUCE_NO_ITERABLE_STATE_0_UPDATER.subUpdater(22, 2), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_getIterNode__field1_", Node.class), ReferenceField.create(ReduceNoIterableData.lookup_(), "reduceNoIterable_getIterNode__field2_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduceNoIterable}
             *   Parameter: {@link InlinedBranchProfile} indexProfile
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_REDUCE_NO_ITERABLE_INDEX_PROFILE_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, REDUCE_NO_ITERABLE__REDUCE_NODE_REDUCE_NO_ITERABLE_STATE_0_UPDATER.subUpdater(24, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReduceNode#reduce}
             *   1: SpecializationActive {@link ReduceNode#reduceNoIterable}
             *   2-18: InlinedCache
             *        Specialization: {@link ReduceNode#reduce}
             *        Parameter: {@link GetClassNode} getClass
             *        Inline method: {@link GetClassNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReduceNode#reduce}
             *   Parameter: {@link GetClassNode} getClass
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduce_getClass__field1_;
            @Child private ReduceNoIterableData reduceNoIterable_cache;

            private ReduceNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[CycleBuiltins.ReduceNode.reduce(PCycle, Node, GetClassNode)] || SpecializationActive[CycleBuiltins.ReduceNode.reduceNoIterable(VirtualFrame, PCycle, Node, GetClassNode, PyObjectLookupAttr, CallUnaryMethodNode, PyObjectGetIter, InlinedBranchProfile)] */ && arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[CycleBuiltins.ReduceNode.reduce(PCycle, Node, GetClassNode)] */) {
                        if ((hasIterable(arg0Value_))) {
                            Node inliningTarget__ = (this);
                            return reduce(arg0Value_, inliningTarget__, INLINED_REDUCE_GET_CLASS_);
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[CycleBuiltins.ReduceNode.reduceNoIterable(VirtualFrame, PCycle, Node, GetClassNode, PyObjectLookupAttr, CallUnaryMethodNode, PyObjectGetIter, InlinedBranchProfile)] */) {
                        ReduceNoIterableData s1_ = this.reduceNoIterable_cache;
                        if (s1_ != null) {
                            if ((!(hasIterable(arg0Value_)))) {
                                Node inliningTarget__1 = (s1_);
                                return reduceNoIterable(frameValue, arg0Value_, inliningTarget__1, INLINED_REDUCE_NO_ITERABLE_GET_CLASS_, INLINED_REDUCE_NO_ITERABLE_LOOKUP_ATTR_NODE_, s1_.callNode_, INLINED_REDUCE_NO_ITERABLE_GET_ITER_NODE_, INLINED_REDUCE_NO_ITERABLE_INDEX_PROFILE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    {
                        Node inliningTarget__ = null;
                        if ((hasIterable(arg0Value_))) {
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[CycleBuiltins.ReduceNode.reduce(PCycle, Node, GetClassNode)] */;
                            this.state_0_ = state_0;
                            return reduce(arg0Value_, inliningTarget__, INLINED_REDUCE_GET_CLASS_);
                        }
                    }
                    {
                        Node inliningTarget__1 = null;
                        if ((!(hasIterable(arg0Value_)))) {
                            ReduceNoIterableData s1_ = this.insert(new ReduceNoIterableData());
                            inliningTarget__1 = (s1_);
                            CallUnaryMethodNode callNode__ = s1_.insert((CallUnaryMethodNode.create()));
                            Objects.requireNonNull(callNode__, "Specialization 'reduceNoIterable(VirtualFrame, PCycle, Node, GetClassNode, PyObjectLookupAttr, CallUnaryMethodNode, PyObjectGetIter, InlinedBranchProfile)' cache 'callNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                            s1_.callNode_ = callNode__;
                            VarHandle.storeStoreFence();
                            this.reduceNoIterable_cache = s1_;
                            state_0 = state_0 | 0b10 /* add SpecializationActive[CycleBuiltins.ReduceNode.reduceNoIterable(VirtualFrame, PCycle, Node, GetClassNode, PyObjectLookupAttr, CallUnaryMethodNode, PyObjectGetIter, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return reduceNoIterable(frameValue, arg0Value_, inliningTarget__1, INLINED_REDUCE_NO_ITERABLE_GET_CLASS_, INLINED_REDUCE_NO_ITERABLE_LOOKUP_ATTR_NODE_, callNode__, INLINED_REDUCE_NO_ITERABLE_GET_ITER_NODE_, INLINED_REDUCE_NO_ITERABLE_INDEX_PROFILE_);
                        }
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            @GeneratedBy(ReduceNode.class)
            @DenyReplace
            private static final class ReduceNoIterableData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-16: InlinedCache
                 *        Specialization: {@link ReduceNode#reduceNoIterable}
                 *        Parameter: {@link GetClassNode} getClass
                 *        Inline method: {@link GetClassNodeGen#inline}
                 *   17-21: InlinedCache
                 *        Specialization: {@link ReduceNode#reduceNoIterable}
                 *        Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *        Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   22-23: InlinedCache
                 *        Specialization: {@link ReduceNode#reduceNoIterable}
                 *        Parameter: {@link PyObjectGetIter} getIterNode
                 *        Inline method: {@link PyObjectGetIterNodeGen#inline}
                 *   24: InlinedCache
                 *        Specialization: {@link ReduceNode#reduceNoIterable}
                 *        Parameter: {@link InlinedBranchProfile} indexProfile
                 *        Inline method: {@link InlinedBranchProfile#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int reduceNoIterable_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link GetClassNode} getClass
                 *   Inline method: {@link GetClassNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_getClass__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field2_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field3</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field3_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field4</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field4_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field5</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field5_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field6</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field6_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field7</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field7_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field8</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field8_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field9</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field9_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectLookupAttr} lookupAttrNode
                 *   Inline method: {@link PyObjectLookupAttrNodeGen#inline}
                 *   Inline field: {@link Node} field10</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_lookupAttrNode__field10_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link CallUnaryMethodNode} callNode</pre>
                 */
                @Child CallUnaryMethodNode callNode_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectGetIter} getIterNode
                 *   Inline method: {@link PyObjectGetIterNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_getIterNode__field1_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link ReduceNode#reduceNoIterable}
                 *   Parameter: {@link PyObjectGetIter} getIterNode
                 *   Inline method: {@link PyObjectGetIterNodeGen#inline}
                 *   Inline field: {@link Node} field2</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node reduceNoIterable_getIterNode__field2_;

                ReduceNoIterableData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
    }
    @GeneratedBy(SetStateNode.class)
    public static final class SetStateNodeFactory implements NodeFactory<SetStateNode> {

        private static final SetStateNodeFactory SET_STATE_NODE_FACTORY_INSTANCE = new SetStateNodeFactory();

        private SetStateNodeFactory() {
        }

        @Override
        public Class<SetStateNode> getNodeClass() {
            return SetStateNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public SetStateNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        public static NodeFactory<SetStateNode> getInstance() {
            return SET_STATE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SetStateNode create() {
            return new SetStateNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SetStateNode#setState}
         *     Activation probability: 1.00000
         *     With/without class size: 48/28 bytes
         * </pre>
         */
        @GeneratedBy(SetStateNode.class)
        @SuppressWarnings("javadoc")
        public static final class SetStateNodeGen extends SetStateNode {

            private static final StateField STATE_0_SetStateNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link IsBuiltinObjectProfile} isTypeErrorProfile
             *   Inline method: {@link IsBuiltinObjectProfileNodeGen#inline}</pre>
             */
            private static final IsBuiltinObjectProfile INLINED_IS_TYPE_ERROR_PROFILE_ = IsBuiltinObjectProfileNodeGen.inline(InlineTarget.create(IsBuiltinObjectProfile.class, STATE_0_SetStateNode_UPDATER.subUpdater(1, 20), ReferenceField.create(MethodHandles.lookup(), "isTypeErrorProfile__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link ToArrayNode} toArrayNode
             *   Inline method: {@link ToArrayNodeGen#inline}</pre>
             */
            private static final ToArrayNode INLINED_TO_ARRAY_NODE_ = ToArrayNodeGen.inline(InlineTarget.create(ToArrayNode.class, STATE_0_SetStateNode_UPDATER.subUpdater(21, 4), ReferenceField.create(MethodHandles.lookup(), "toArrayNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}</pre>
             */
            private static final PyNumberAsSizeNode INLINED_AS_SIZE_NODE_ = PyNumberAsSizeNodeGen.inline(InlineTarget.create(PyNumberAsSizeNode.class, STATE_0_SetStateNode_UPDATER.subUpdater(25, 5), ReferenceField.create(MethodHandles.lookup(), "asSizeNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "asSizeNode__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SetStateNode#setState}
             *   1-20: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link IsBuiltinObjectProfile} isTypeErrorProfile
             *        Inline method: {@link IsBuiltinObjectProfileNodeGen#inline}
             *   21-24: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link ToArrayNode} toArrayNode
             *        Inline method: {@link ToArrayNodeGen#inline}
             *   25-29: InlinedCache
             *        Specialization: {@link SetStateNode#setState}
             *        Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *        Inline method: {@link PyNumberAsSizeNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link LenNode} lenNode</pre>
             */
            @Child private LenNode lenNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link GetItemNode} getItemNode</pre>
             */
            @Child private GetItemNode getItemNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link IsBuiltinObjectProfile} isTypeErrorProfile
             *   Inline method: {@link IsBuiltinObjectProfileNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node isTypeErrorProfile__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link ToArrayNode} toArrayNode
             *   Inline method: {@link ToArrayNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toArrayNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SetStateNode#setState}
             *   Parameter: {@link PyNumberAsSizeNode} asSizeNode
             *   Inline method: {@link PyNumberAsSizeNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node asSizeNode__field2_;

            private SetStateNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CycleBuiltins.SetStateNode.setState(VirtualFrame, PCycle, Object, Node, LenNode, GetItemNode, IsBuiltinObjectProfile, ToArrayNode, PyNumberAsSizeNode)] */ && arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    {
                        LenNode lenNode__ = this.lenNode_;
                        if (lenNode__ != null) {
                            GetItemNode getItemNode__ = this.getItemNode_;
                            if (getItemNode__ != null) {
                                Node inliningTarget__ = (this);
                                return setState(frameValue, arg0Value_, arg1Value, inliningTarget__, lenNode__, getItemNode__, INLINED_IS_TYPE_ERROR_PROFILE_, INLINED_TO_ARRAY_NODE_, INLINED_AS_SIZE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            @Override
            Object execute(VirtualFrame frameValue, PythonObject arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CycleBuiltins.SetStateNode.setState(VirtualFrame, PCycle, Object, Node, LenNode, GetItemNode, IsBuiltinObjectProfile, ToArrayNode, PyNumberAsSizeNode)] */ && arg0Value instanceof PCycle) {
                    PCycle arg0Value_ = (PCycle) arg0Value;
                    {
                        LenNode lenNode__ = this.lenNode_;
                        if (lenNode__ != null) {
                            GetItemNode getItemNode__ = this.getItemNode_;
                            if (getItemNode__ != null) {
                                Node inliningTarget__ = (this);
                                return setState(frameValue, arg0Value_, arg1Value, inliningTarget__, lenNode__, getItemNode__, INLINED_IS_TYPE_ERROR_PROFILE_, INLINED_TO_ARRAY_NODE_, INLINED_AS_SIZE_NODE_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PCycle) {
                        PCycle arg0Value_ = (PCycle) arg0Value;
                        inliningTarget__ = (this);
                        LenNode lenNode__ = this.insert((LenNodeFactory.create()));
                        Objects.requireNonNull(lenNode__, "Specialization 'setState(VirtualFrame, PCycle, Object, Node, LenNode, GetItemNode, IsBuiltinObjectProfile, ToArrayNode, PyNumberAsSizeNode)' cache 'lenNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.lenNode_ = lenNode__;
                        GetItemNode getItemNode__ = this.insert((GetItemNodeFactory.create()));
                        Objects.requireNonNull(getItemNode__, "Specialization 'setState(VirtualFrame, PCycle, Object, Node, LenNode, GetItemNode, IsBuiltinObjectProfile, ToArrayNode, PyNumberAsSizeNode)' cache 'getItemNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.getItemNode_ = getItemNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[CycleBuiltins.SetStateNode.setState(VirtualFrame, PCycle, Object, Node, LenNode, GetItemNode, IsBuiltinObjectProfile, ToArrayNode, PyNumberAsSizeNode)] */;
                        this.state_0_ = state_0;
                        return setState(frameValue, arg0Value_, arg1Value, inliningTarget__, lenNode__, getItemNode__, INLINED_IS_TYPE_ERROR_PROFILE_, INLINED_TO_ARRAY_NODE_, INLINED_AS_SIZE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
