// CheckStyle: start generated
package com.oracle.graal.python.builtins.objects.types;

import com.oracle.graal.python.builtins.modules.BuiltinFunctions.IsInstanceNode;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions.IsSubClassNode;
import com.oracle.graal.python.builtins.modules.BuiltinFunctionsFactory.IsInstanceNodeFactory;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodes.GetClonedHashingStorageNode;
import com.oracle.graal.python.builtins.objects.common.HashingCollectionNodesFactory.GetClonedHashingStorageNodeGen;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes.GetItemScalarNode;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodesFactory.GetItemScalarNodeGen;
import com.oracle.graal.python.builtins.objects.type.TypeNodes.IsTypeNode;
import com.oracle.graal.python.builtins.objects.type.TypeNodesFactory.IsTypeNodeGen;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodes.UnionTypeOrNode;
import com.oracle.graal.python.builtins.objects.types.GenericTypeNodesFactory.UnionTypeOrNodeGen;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.ArgsNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetItemNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.HashNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.InstanceCheckNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.OrNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.ParametersNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.ReprNode;
import com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.SubclassCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrNodeGen;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectHashNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNodeGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString.EqualNode;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

@GeneratedBy(UnionTypeBuiltins.class)
@SuppressWarnings("javadoc")
public final class UnionTypeBuiltinsFactory {

    public static List<NodeFactory<? extends PythonBuiltinBaseNode>> getFactories() {
        return Arrays.asList(ArgsNodeFactory.getInstance(), ParametersNodeFactory.getInstance(), OrNodeFactory.getInstance(), ReprNodeFactory.getInstance(), HashNodeFactory.getInstance(), GetAttributeNodeFactory.getInstance(), InstanceCheckNodeFactory.getInstance(), SubclassCheckNodeFactory.getInstance(), EqNodeFactory.getInstance(), GetItemNodeFactory.getInstance());
    }

    @GeneratedBy(ArgsNode.class)
    static final class ArgsNodeFactory implements NodeFactory<ArgsNode> {

        private static final ArgsNodeFactory ARGS_NODE_FACTORY_INSTANCE = new ArgsNodeFactory();

        private ArgsNodeFactory() {
        }

        @Override
        public Class<ArgsNode> getNodeClass() {
            return ArgsNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ArgsNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ArgsNode> getInstance() {
            return ARGS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ArgsNode create() {
            return new ArgsNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ArgsNode#args}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ArgsNode.class)
        @SuppressWarnings("javadoc")
        static final class ArgsNodeGen extends ArgsNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ArgsNode#args}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ArgsNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnionTypeBuiltins.ArgsNode.args(PUnionType)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    return args(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.ArgsNode.args(PUnionType)] */;
                    this.state_0_ = state_0;
                    return args(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ParametersNode.class)
    static final class ParametersNodeFactory implements NodeFactory<ParametersNode> {

        private static final ParametersNodeFactory PARAMETERS_NODE_FACTORY_INSTANCE = new ParametersNodeFactory();

        private ParametersNodeFactory() {
        }

        @Override
        public Class<ParametersNode> getNodeClass() {
            return ParametersNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ParametersNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ParametersNode> getInstance() {
            return PARAMETERS_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ParametersNode create() {
            return new ParametersNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ParametersNode#parameters}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ParametersNode.class)
        @SuppressWarnings("javadoc")
        static final class ParametersNodeGen extends ParametersNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ParametersNode#parameters}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ParametersNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnionTypeBuiltins.ParametersNode.parameters(PUnionType)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    return parameters(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.ParametersNode.parameters(PUnionType)] */;
                    this.state_0_ = state_0;
                    return parameters(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(OrNode.class)
    static final class OrNodeFactory implements NodeFactory<OrNode> {

        private static final OrNodeFactory OR_NODE_FACTORY_INSTANCE = new OrNodeFactory();

        private OrNodeFactory() {
        }

        @Override
        public Class<OrNode> getNodeClass() {
            return OrNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public OrNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<OrNode> getInstance() {
            return OR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static OrNode create() {
            return new OrNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link OrNode#union}
         *     Activation probability: 1.00000
         *     With/without class size: 24/4 bytes
         * </pre>
         */
        @GeneratedBy(OrNode.class)
        @SuppressWarnings("javadoc")
        static final class OrNodeGen extends OrNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link OrNode#union}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link OrNode#union}
             *   Parameter: {@link UnionTypeOrNode} orNode</pre>
             */
            @Child private UnionTypeOrNode orNode_;

            private OrNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnionTypeBuiltins.OrNode.union(Object, Object, UnionTypeOrNode)] */) {
                    {
                        UnionTypeOrNode orNode__ = this.orNode_;
                        if (orNode__ != null) {
                            return union(arg0Value, arg1Value, orNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                UnionTypeOrNode orNode__ = this.insert((UnionTypeOrNodeGen.create()));
                Objects.requireNonNull(orNode__, "Specialization 'union(Object, Object, UnionTypeOrNode)' cache 'orNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.orNode_ = orNode__;
                state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.OrNode.union(Object, Object, UnionTypeOrNode)] */;
                this.state_0_ = state_0;
                return union(arg0Value, arg1Value, orNode__);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(ReprNode.class)
    static final class ReprNodeFactory implements NodeFactory<ReprNode> {

        private static final ReprNodeFactory REPR_NODE_FACTORY_INSTANCE = new ReprNodeFactory();

        private ReprNodeFactory() {
        }

        @Override
        public Class<ReprNode> getNodeClass() {
            return ReprNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public ReprNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<ReprNode> getInstance() {
            return REPR_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static ReprNode create() {
            return new ReprNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link ReprNode#repr}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(ReprNode.class)
        @SuppressWarnings("javadoc")
        static final class ReprNodeGen extends ReprNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link ReprNode#repr}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private ReprNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnionTypeBuiltins.ReprNode.repr(PUnionType)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    return repr(arg0Value_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(arg0Value);
            }

            private Object executeAndSpecialize(Object arg0Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.ReprNode.repr(PUnionType)] */;
                    this.state_0_ = state_0;
                    return repr(arg0Value_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(HashNode.class)
    static final class HashNodeFactory implements NodeFactory<HashNode> {

        private static final HashNodeFactory HASH_NODE_FACTORY_INSTANCE = new HashNodeFactory();

        private HashNodeFactory() {
        }

        @Override
        public Class<HashNode> getNodeClass() {
            return HashNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public HashNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<HashNode> getInstance() {
            return HASH_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static HashNode create() {
            return new HashNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link HashNode#hash}
         *     Activation probability: 1.00000
         *     With/without class size: 60/39 bytes
         * </pre>
         */
        @GeneratedBy(HashNode.class)
        @SuppressWarnings("javadoc")
        static final class HashNodeGen extends HashNode {

            private static final StateField STATE_0_HashNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}</pre>
             */
            private static final PyObjectHashNode INLINED_HASH_NODE_ = PyObjectHashNodeGen.inline(InlineTarget.create(PyObjectHashNode.class, STATE_0_HashNode_UPDATER.subUpdater(1, 7), ReferenceField.create(MethodHandles.lookup(), "hashNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hashNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hashNode__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}</pre>
             */
            private static final GetClonedHashingStorageNode INLINED_GET_HASHING_STORAGE_NODE_ = GetClonedHashingStorageNodeGen.inline(InlineTarget.create(GetClonedHashingStorageNode.class, STATE_0_HashNode_UPDATER.subUpdater(8, 13), ReferenceField.create(MethodHandles.lookup(), "getHashingStorageNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getHashingStorageNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getHashingStorageNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getHashingStorageNode__field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getHashingStorageNode__field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getHashingStorageNode__field6_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HashNode#hash}
             *   1-7: InlinedCache
             *        Specialization: {@link HashNode#hash}
             *        Parameter: {@link PyObjectHashNode} hashNode
             *        Inline method: {@link PyObjectHashNodeGen#inline}
             *   8-20: InlinedCache
             *        Specialization: {@link HashNode#hash}
             *        Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *        Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hashNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hashNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link PyObjectHashNode} hashNode
             *   Inline method: {@link PyObjectHashNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hashNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getHashingStorageNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getHashingStorageNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getHashingStorageNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getHashingStorageNode__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field5</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getHashingStorageNode__field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HashNode#hash}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field6</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getHashingStorageNode__field6_;

            private HashNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnionTypeBuiltins.HashNode.hash(VirtualFrame, PUnionType, Node, PyObjectHashNode, GetClonedHashingStorageNode)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    {
                        Node inliningTarget__ = (this);
                        return hash(frameValue, arg0Value_, inliningTarget__, INLINED_HASH_NODE_, INLINED_GET_HASHING_STORAGE_NODE_);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value);
            }

            private long executeAndSpecialize(VirtualFrame frameValue, Object arg0Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PUnionType) {
                        PUnionType arg0Value_ = (PUnionType) arg0Value;
                        inliningTarget__ = (this);
                        state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.HashNode.hash(VirtualFrame, PUnionType, Node, PyObjectHashNode, GetClonedHashingStorageNode)] */;
                        this.state_0_ = state_0;
                        return hash(frameValue, arg0Value_, inliningTarget__, INLINED_HASH_NODE_, INLINED_GET_HASHING_STORAGE_NODE_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode.class)
    static final class GetAttributeNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode> {

        private static final GetAttributeNodeFactory GET_ATTRIBUTE_NODE_FACTORY_INSTANCE = new GetAttributeNodeFactory();

        private GetAttributeNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode> getInstance() {
            return GET_ATTRIBUTE_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode create() {
            return new GetAttributeNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
         *     Activation probability: 1.00000
         *     With/without class size: 56/36 bytes
         * </pre>
         */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode.class)
        @SuppressWarnings("javadoc")
        static final class GetAttributeNodeGen extends com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode {

            private static final StateField STATE_0_GetAttributeNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}</pre>
             */
            private static final CastToTruffleStringNode INLINED_CAST_ = CastToTruffleStringNodeGen.inline(InlineTarget.create(CastToTruffleStringNode.class, STATE_0_GetAttributeNode_UPDATER.subUpdater(1, 8), ReferenceField.create(MethodHandles.lookup(), "cast__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "cast__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "cast__field3_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}</pre>
             */
            private static final GetClassNode INLINED_GET_CLASS_NODE_ = GetClassNodeGen.inline(InlineTarget.create(GetClassNode.class, STATE_0_GetAttributeNode_UPDATER.subUpdater(9, 17), ReferenceField.create(MethodHandles.lookup(), "getClassNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link PyObjectGetAttr} getAttr
             *   Inline method: {@link PyObjectGetAttrNodeGen#inline}</pre>
             */
            private static final PyObjectGetAttr INLINED_GET_ATTR_ = PyObjectGetAttrNodeGen.inline(InlineTarget.create(PyObjectGetAttr.class, STATE_0_GetAttributeNode_UPDATER.subUpdater(26, 2), ReferenceField.create(MethodHandles.lookup(), "getAttr__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "getAttr__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   1-8: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *        Parameter: {@link CastToTruffleStringNode} cast
             *        Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   9-25: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *        Parameter: {@link GetClassNode} getClassNode
             *        Inline method: {@link GetClassNodeGen#inline}
             *   26-27: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *        Parameter: {@link PyObjectGetAttr} getAttr
             *        Inline method: {@link PyObjectGetAttrNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cast__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cast__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link CastToTruffleStringNode} cast
             *   Inline method: {@link CastToTruffleStringNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node cast__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link EqualNode} equalNode</pre>
             */
            @Child private EqualNode equalNode_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link GetClassNode} getClassNode
             *   Inline method: {@link GetClassNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getClassNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link PyObjectGetAttr} getAttr
             *   Inline method: {@link PyObjectGetAttrNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getAttr__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link PyObjectGetAttr} getAttr
             *   Inline method: {@link PyObjectGetAttrNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getAttr__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.GetAttributeNode#getattribute}
             *   Parameter: {@link com.oracle.graal.python.builtins.objects.object.ObjectBuiltins.GetAttributeNode} genericGetAttribute</pre>
             */
            @Child private com.oracle.graal.python.builtins.objects.object.ObjectBuiltins.GetAttributeNode genericGetAttribute_;

            private GetAttributeNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnionTypeBuiltins.GetAttributeNode.getattribute(VirtualFrame, PUnionType, Object, Node, CastToTruffleStringNode, EqualNode, GetClassNode, PyObjectGetAttr, GetAttributeNode)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    {
                        EqualNode equalNode__ = this.equalNode_;
                        if (equalNode__ != null) {
                            com.oracle.graal.python.builtins.objects.object.ObjectBuiltins.GetAttributeNode genericGetAttribute__ = this.genericGetAttribute_;
                            if (genericGetAttribute__ != null) {
                                Node inliningTarget__ = (this);
                                return getattribute(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_CAST_, equalNode__, INLINED_GET_CLASS_NODE_, INLINED_GET_ATTR_, genericGetAttribute__);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PUnionType) {
                        PUnionType arg0Value_ = (PUnionType) arg0Value;
                        inliningTarget__ = (this);
                        EqualNode equalNode__ = this.insert((EqualNode.create()));
                        Objects.requireNonNull(equalNode__, "Specialization 'getattribute(VirtualFrame, PUnionType, Object, Node, CastToTruffleStringNode, EqualNode, GetClassNode, PyObjectGetAttr, GetAttributeNode)' cache 'equalNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.equalNode_ = equalNode__;
                        com.oracle.graal.python.builtins.objects.object.ObjectBuiltins.GetAttributeNode genericGetAttribute__ = this.insert((com.oracle.graal.python.builtins.objects.object.ObjectBuiltins.GetAttributeNode.create()));
                        Objects.requireNonNull(genericGetAttribute__, "Specialization 'getattribute(VirtualFrame, PUnionType, Object, Node, CastToTruffleStringNode, EqualNode, GetClassNode, PyObjectGetAttr, GetAttributeNode)' cache 'genericGetAttribute' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.genericGetAttribute_ = genericGetAttribute__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.GetAttributeNode.getattribute(VirtualFrame, PUnionType, Object, Node, CastToTruffleStringNode, EqualNode, GetClassNode, PyObjectGetAttr, GetAttributeNode)] */;
                        this.state_0_ = state_0;
                        return getattribute(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_CAST_, equalNode__, INLINED_GET_CLASS_NODE_, INLINED_GET_ATTR_, genericGetAttribute__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(InstanceCheckNode.class)
    static final class InstanceCheckNodeFactory implements NodeFactory<InstanceCheckNode> {

        private static final InstanceCheckNodeFactory INSTANCE_CHECK_NODE_FACTORY_INSTANCE = new InstanceCheckNodeFactory();

        private InstanceCheckNodeFactory() {
        }

        @Override
        public Class<InstanceCheckNode> getNodeClass() {
            return InstanceCheckNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public InstanceCheckNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<InstanceCheckNode> getInstance() {
            return INSTANCE_CHECK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static InstanceCheckNode create() {
            return new InstanceCheckNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link InstanceCheckNode#check}
         *     Activation probability: 1.00000
         *     With/without class size: 32/9 bytes
         * </pre>
         */
        @GeneratedBy(InstanceCheckNode.class)
        @SuppressWarnings("javadoc")
        static final class InstanceCheckNodeGen extends InstanceCheckNode {

            private static final StateField STATE_0_InstanceCheckNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link InstanceCheckNode#check}
             *   Parameter: {@link GetItemScalarNode} getItem
             *   Inline method: {@link GetItemScalarNodeGen#inline}</pre>
             */
            private static final GetItemScalarNode INLINED_GET_ITEM_ = GetItemScalarNodeGen.inline(InlineTarget.create(GetItemScalarNode.class, STATE_0_InstanceCheckNode_UPDATER.subUpdater(1, 8), ReferenceField.create(MethodHandles.lookup(), "getItem__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link InstanceCheckNode#check}
             *   1-8: InlinedCache
             *        Specialization: {@link InstanceCheckNode#check}
             *        Parameter: {@link GetItemScalarNode} getItem
             *        Inline method: {@link GetItemScalarNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InstanceCheckNode#check}
             *   Parameter: {@link GetItemScalarNode} getItem
             *   Inline method: {@link GetItemScalarNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link InstanceCheckNode#check}
             *   Parameter: {@link IsInstanceNode} isInstanceNode</pre>
             */
            @Child private IsInstanceNode isInstanceNode_;

            private InstanceCheckNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnionTypeBuiltins.InstanceCheckNode.check(VirtualFrame, PUnionType, Object, Node, GetItemScalarNode, IsInstanceNode)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    {
                        IsInstanceNode isInstanceNode__ = this.isInstanceNode_;
                        if (isInstanceNode__ != null) {
                            Node inliningTarget__ = (this);
                            return check(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_GET_ITEM_, isInstanceNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PUnionType) {
                        PUnionType arg0Value_ = (PUnionType) arg0Value;
                        inliningTarget__ = (this);
                        IsInstanceNode isInstanceNode__ = this.insert((IsInstanceNodeFactory.create()));
                        Objects.requireNonNull(isInstanceNode__, "Specialization 'check(VirtualFrame, PUnionType, Object, Node, GetItemScalarNode, IsInstanceNode)' cache 'isInstanceNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.isInstanceNode_ = isInstanceNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.InstanceCheckNode.check(VirtualFrame, PUnionType, Object, Node, GetItemScalarNode, IsInstanceNode)] */;
                        this.state_0_ = state_0;
                        return check(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_GET_ITEM_, isInstanceNode__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(SubclassCheckNode.class)
    static final class SubclassCheckNodeFactory implements NodeFactory<SubclassCheckNode> {

        private static final SubclassCheckNodeFactory SUBCLASS_CHECK_NODE_FACTORY_INSTANCE = new SubclassCheckNodeFactory();

        private SubclassCheckNodeFactory() {
        }

        @Override
        public Class<SubclassCheckNode> getNodeClass() {
            return SubclassCheckNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public SubclassCheckNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<SubclassCheckNode> getInstance() {
            return SUBCLASS_CHECK_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static SubclassCheckNode create() {
            return new SubclassCheckNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link SubclassCheckNode#check}
         *     Activation probability: 1.00000
         *     With/without class size: 36/14 bytes
         * </pre>
         */
        @GeneratedBy(SubclassCheckNode.class)
        @SuppressWarnings("javadoc")
        static final class SubclassCheckNodeGen extends SubclassCheckNode {

            private static final StateField STATE_0_SubclassCheckNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubclassCheckNode#check}
             *   Parameter: {@link IsTypeNode} isTypeNode
             *   Inline method: {@link IsTypeNodeGen#inline}</pre>
             */
            private static final IsTypeNode INLINED_IS_TYPE_NODE_ = IsTypeNodeGen.inline(InlineTarget.create(IsTypeNode.class, STATE_0_SubclassCheckNode_UPDATER.subUpdater(1, 5), ReferenceField.create(MethodHandles.lookup(), "isTypeNode__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubclassCheckNode#check}
             *   Parameter: {@link GetItemScalarNode} getItem
             *   Inline method: {@link GetItemScalarNodeGen#inline}</pre>
             */
            private static final GetItemScalarNode INLINED_GET_ITEM_ = GetItemScalarNodeGen.inline(InlineTarget.create(GetItemScalarNode.class, STATE_0_SubclassCheckNode_UPDATER.subUpdater(6, 8), ReferenceField.create(MethodHandles.lookup(), "getItem__field1_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link SubclassCheckNode#check}
             *   1-5: InlinedCache
             *        Specialization: {@link SubclassCheckNode#check}
             *        Parameter: {@link IsTypeNode} isTypeNode
             *        Inline method: {@link IsTypeNodeGen#inline}
             *   6-13: InlinedCache
             *        Specialization: {@link SubclassCheckNode#check}
             *        Parameter: {@link GetItemScalarNode} getItem
             *        Inline method: {@link GetItemScalarNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubclassCheckNode#check}
             *   Parameter: {@link IsTypeNode} isTypeNode
             *   Inline method: {@link IsTypeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node isTypeNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubclassCheckNode#check}
             *   Parameter: {@link GetItemScalarNode} getItem
             *   Inline method: {@link GetItemScalarNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node getItem__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link SubclassCheckNode#check}
             *   Parameter: {@link IsSubClassNode} isSubClassNode</pre>
             */
            @Child private IsSubClassNode isSubClassNode_;

            private SubclassCheckNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnionTypeBuiltins.SubclassCheckNode.check(VirtualFrame, PUnionType, Object, Node, IsTypeNode, GetItemScalarNode, IsSubClassNode)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    {
                        IsSubClassNode isSubClassNode__ = this.isSubClassNode_;
                        if (isSubClassNode__ != null) {
                            Node inliningTarget__ = (this);
                            return check(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_IS_TYPE_NODE_, INLINED_GET_ITEM_, isSubClassNode__);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private boolean executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PUnionType) {
                        PUnionType arg0Value_ = (PUnionType) arg0Value;
                        inliningTarget__ = (this);
                        IsSubClassNode isSubClassNode__ = this.insert((IsSubClassNode.create()));
                        Objects.requireNonNull(isSubClassNode__, "Specialization 'check(VirtualFrame, PUnionType, Object, Node, IsTypeNode, GetItemScalarNode, IsSubClassNode)' cache 'isSubClassNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.isSubClassNode_ = isSubClassNode__;
                        state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.SubclassCheckNode.check(VirtualFrame, PUnionType, Object, Node, IsTypeNode, GetItemScalarNode, IsSubClassNode)] */;
                        this.state_0_ = state_0;
                        return check(frameValue, arg0Value_, arg1Value, inliningTarget__, INLINED_IS_TYPE_NODE_, INLINED_GET_ITEM_, isSubClassNode__);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b1) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
    @GeneratedBy(com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode.class)
    static final class EqNodeFactory implements NodeFactory<com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode> {

        private static final EqNodeFactory EQ_NODE_FACTORY_INSTANCE = new EqNodeFactory();

        private EqNodeFactory() {
        }

        @Override
        public Class<com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode> getNodeClass() {
            return com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode> getInstance() {
            return EQ_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode create() {
            return new com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltinsFactory.EqNodeFactory.EqNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
         *     Activation probability: 0.65000
         *     With/without class size: 40/37 bytes
         *   Specialization {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(Object, Object)}
         *     Activation probability: 0.35000
         *     With/without class size: 8/0 bytes
         * </pre>
         */
        @GeneratedBy(com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode.class)
        @SuppressWarnings("javadoc")
        static final class EqNodeGen extends com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode {

            private static final StateField STATE_0_EqNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_0_");
            private static final StateField STATE_1_EqNode_UPDATER = StateField.create(MethodHandles.lookup(), "state_1_");
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}</pre>
             */
            private static final GetClonedHashingStorageNode INLINED_EQ_GET_HASHING_STORAGE_NODE_ = GetClonedHashingStorageNodeGen.inline(InlineTarget.create(GetClonedHashingStorageNode.class, STATE_0_EqNode_UPDATER.subUpdater(2, 13), ReferenceField.create(MethodHandles.lookup(), "eq_getHashingStorageNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_getHashingStorageNode__field2_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_getHashingStorageNode__field3_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_getHashingStorageNode__field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_getHashingStorageNode__field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_getHashingStorageNode__field6_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *   Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}</pre>
             */
            private static final com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode INLINED_EQ_EQ_NODE_ = com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen.inline(InlineTarget.create(com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode.class, STATE_1_EqNode_UPDATER.subUpdater(0, 25), ReferenceField.create(MethodHandles.lookup(), "eq_eqNode__field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "eq_eqNode__field2_", Node.class)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   1: SpecializationActive {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(Object, Object)}
             *   2-14: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *        Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *        Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_0_;
            /**
             * State Info: <pre>
             *   0-24: InlinedCache
             *        Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *        Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *        Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_getHashingStorageNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_getHashingStorageNode__field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field3</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_getHashingStorageNode__field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_getHashingStorageNode__field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field5</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_getHashingStorageNode__field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link GetClonedHashingStorageNode} getHashingStorageNode
             *   Inline method: {@link GetClonedHashingStorageNodeGen#inline}
             *   Inline field: {@link Node} field6</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_getHashingStorageNode__field6_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *   Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_eqNode__field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link com.oracle.graal.python.builtins.objects.types.UnionTypeBuiltins.EqNode#eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode)}
             *   Parameter: {@link com.oracle.graal.python.lib.PyObjectRichCompareBool.EqNode} eqNode
             *   Inline method: {@link com.oracle.graal.python.lib.PyObjectRichCompareBoolFactory.EqNodeGen#inline}
             *   Inline field: {@link Node} field2</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node eq_eqNode__field2_;

            private EqNodeGen() {
            }

            @SuppressWarnings("static-method")
            private boolean fallbackGuard_(int state_0, Object arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[UnionTypeBuiltins.EqNode.eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, EqNode)] */) && arg0Value instanceof PUnionType && arg1Value instanceof PUnionType) {
                    return false;
                }
                return true;
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[UnionTypeBuiltins.EqNode.eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, EqNode)] || SpecializationActive[UnionTypeBuiltins.EqNode.eq(Object, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[UnionTypeBuiltins.EqNode.eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, EqNode)] */ && arg0Value instanceof PUnionType) {
                        PUnionType arg0Value_ = (PUnionType) arg0Value;
                        if (arg1Value instanceof PUnionType) {
                            PUnionType arg1Value_ = (PUnionType) arg1Value;
                            {
                                Node inliningTarget__ = (this);
                                return eq(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_EQ_GET_HASHING_STORAGE_NODE_, INLINED_EQ_EQ_NODE_);
                            }
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[UnionTypeBuiltins.EqNode.eq(Object, Object)] */) {
                        if (fallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return eq(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                {
                    Node inliningTarget__ = null;
                    if (arg0Value instanceof PUnionType) {
                        PUnionType arg0Value_ = (PUnionType) arg0Value;
                        if (arg1Value instanceof PUnionType) {
                            PUnionType arg1Value_ = (PUnionType) arg1Value;
                            inliningTarget__ = (this);
                            state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.EqNode.eq(VirtualFrame, PUnionType, PUnionType, Node, GetClonedHashingStorageNode, EqNode)] */;
                            this.state_0_ = state_0;
                            return eq(frameValue, arg0Value_, arg1Value_, inliningTarget__, INLINED_EQ_GET_HASHING_STORAGE_NODE_, INLINED_EQ_EQ_NODE_);
                        }
                    }
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[UnionTypeBuiltins.EqNode.eq(Object, Object)] */;
                this.state_0_ = state_0;
                return eq(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    int counter = 0;
                    counter += Integer.bitCount((state_0 & 0b11));
                    if (counter == 1) {
                        return NodeCost.MONOMORPHIC;
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

        }
    }
    @GeneratedBy(GetItemNode.class)
    static final class GetItemNodeFactory implements NodeFactory<GetItemNode> {

        private static final GetItemNodeFactory GET_ITEM_NODE_FACTORY_INSTANCE = new GetItemNodeFactory();

        private GetItemNodeFactory() {
        }

        @Override
        public Class<GetItemNode> getNodeClass() {
            return GetItemNode.class;
        }

        @Override
        public List<Class<? extends Node>> getExecutionSignature() {
            return Arrays.asList(Node.class, Node.class);
        }

        @Override
        public List<List<Class<?>>> getNodeSignatures() {
            return Arrays.asList(Arrays.asList());
        }

        @Override
        public GetItemNode createNode(Object... arguments) {
            if (arguments.length == 0) {
                return create();
            } else {
                throw new IllegalArgumentException("Invalid create signature.");
            }
        }

        static NodeFactory<GetItemNode> getInstance() {
            return GET_ITEM_NODE_FACTORY_INSTANCE;
        }

        @NeverDefault
        public static GetItemNode create() {
            return new GetItemNodeGen();
        }

        /**
         * Debug Info: <pre>
         *   Specialization {@link GetItemNode#getitem}
         *     Activation probability: 1.00000
         *     With/without class size: 16/0 bytes
         * </pre>
         */
        @GeneratedBy(GetItemNode.class)
        @SuppressWarnings("javadoc")
        static final class GetItemNodeGen extends GetItemNode {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetItemNode#getitem}
             * </pre>
             */
            @CompilationFinal private int state_0_;

            private GetItemNodeGen() {
            }

            @Override
            public Object execute(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (state_0 != 0 /* is SpecializationActive[UnionTypeBuiltins.GetItemNode.getitem(VirtualFrame, PUnionType, Object)] */ && arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    return getitem(frameValue, arg0Value_, arg1Value);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeAndSpecialize(frameValue, arg0Value, arg1Value);
            }

            private Object executeAndSpecialize(VirtualFrame frameValue, Object arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg0Value instanceof PUnionType) {
                    PUnionType arg0Value_ = (PUnionType) arg0Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[UnionTypeBuiltins.GetItemNode.getitem(VirtualFrame, PUnionType, Object)] */;
                    this.state_0_ = state_0;
                    return getitem(frameValue, arg0Value_, arg1Value);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if (state_0 == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    return NodeCost.MONOMORPHIC;
                }
            }

        }
    }
}
