// CheckStyle: start generated
package com.oracle.graal.python.nodes.util;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess.ReadDoubleNode;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PRaiseNode.Lazy;
import com.oracle.graal.python.nodes.PRaiseNodeGen.LazyNodeGen;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode.GetPythonObjectClassNode;
import com.oracle.graal.python.nodes.object.GetClassNodeGen.GetPythonObjectClassNodeGen;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypesGen;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.RequiredField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.util.Objects;

/**
 * Debug Info: <pre>
 *   Specialization {@link CastToJavaDoubleNode#toDouble}
 *     Activation probability: 0.19111
 *     With/without class size: 6/0 bytes
 *   Specialization {@link CastToJavaDoubleNode#doBoolean}
 *     Activation probability: 0.17111
 *     With/without class size: 6/0 bytes
 *   Specialization {@link CastToJavaDoubleNode#doInt}
 *     Activation probability: 0.15111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaDoubleNode#doLong}
 *     Activation probability: 0.13111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaDoubleNode#doPInt}
 *     Activation probability: 0.11111
 *     With/without class size: 6/5 bytes
 *   Specialization {@link CastToJavaDoubleNode#doString}
 *     Activation probability: 0.09111
 *     With/without class size: 5/0 bytes
 *   Specialization {@link CastToJavaDoubleNode#doPBCT}
 *     Activation probability: 0.07111
 *     With/without class size: 4/0 bytes
 *   Specialization {@link CastToJavaDoubleNode#doNativeObject}
 *     Activation probability: 0.05111
 *     With/without class size: 6/21 bytes
 *   Specialization {@link CastToJavaDoubleNode#doGeneric}
 *     Activation probability: 0.03111
 *     With/without class size: 4/4 bytes
 * </pre>
 */
@GeneratedBy(CastToJavaDoubleNode.class)
@SuppressWarnings("javadoc")
public final class CastToJavaDoubleNodeGen {

    private static final StateField NATIVE_OBJECT__CAST_TO_JAVA_DOUBLE_NODE_NATIVE_OBJECT_STATE_0_UPDATER = StateField.create(NativeObjectData.lookup_(), "nativeObject_state_0_");
    private static final Uncached UNCACHED = new Uncached();
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    @NeverDefault
    public static CastToJavaDoubleNode getUncached() {
        return CastToJavaDoubleNodeGen.UNCACHED;
    }

    /**
     * Required Fields: <ul>
     * <li>{@link Inlined#state_0_}
     * <li>{@link Inlined#pInt_raise__field1_}
     * <li>{@link Inlined#nativeObject_cache}
     * <li>{@link Inlined#generic_interopLibrary_}
     * </ul>
     */
    @NeverDefault
    public static CastToJavaDoubleNode inline(@RequiredField(bits = 17, value = StateField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class)@RequiredField(type = Node.class, value = ReferenceField.class) InlineTarget target) {
        return new CastToJavaDoubleNodeGen.Inlined(target);
    }

    @GeneratedBy(CastToJavaDoubleNode.class)
    @DenyReplace
    private static final class Inlined extends CastToJavaDoubleNode {

        /**
         * State Info: <pre>
         *   0: SpecializationActive {@link CastToJavaDoubleNode#toDouble}
         *   1: SpecializationActive {@link CastToJavaDoubleNode#doBoolean}
         *   2: SpecializationActive {@link CastToJavaDoubleNode#doInt}
         *   3: SpecializationActive {@link CastToJavaDoubleNode#doLong}
         *   4: SpecializationActive {@link CastToJavaDoubleNode#doPInt}
         *   5: SpecializationActive {@link CastToJavaDoubleNode#doString}
         *   6: SpecializationActive {@link CastToJavaDoubleNode#doPBCT}
         *   7: SpecializationActive {@link CastToJavaDoubleNode#doNativeObject}
         *   8: SpecializationActive {@link CastToJavaDoubleNode#doGeneric}
         *   9-10: ImplicitCast[type=double, index=1]
         *   11-12: ImplicitCast[type=int, index=1]
         *   13-15: ImplicitCast[type=long, index=1]
         *   16: InlinedCache
         *        Specialization: {@link CastToJavaDoubleNode#doPInt}
         *        Parameter: {@link Lazy} raise
         *        Inline method: {@link LazyNodeGen#inline}
         * </pre>
         */
        private final StateField state_0_;
        private final ReferenceField<Node> pInt_raise__field1_;
        private final ReferenceField<NativeObjectData> nativeObject_cache;
        private final ReferenceField<InteropLibrary> generic_interopLibrary_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doPInt}
         *   Parameter: {@link Lazy} raise
         *   Inline method: {@link LazyNodeGen#inline}</pre>
         */
        private final Lazy pInt_raise_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *   Parameter: {@link GetPythonObjectClassNode} getClassNode
         *   Inline method: {@link GetPythonObjectClassNodeGen#inline}</pre>
         */
        private final GetPythonObjectClassNode nativeObject_getClassNode_;

        @SuppressWarnings("unchecked")
        private Inlined(InlineTarget target) {
            assert target.getTargetClass().isAssignableFrom(CastToJavaDoubleNode.class);
            this.state_0_ = target.getState(0, 17);
            this.pInt_raise__field1_ = target.getReference(1, Node.class);
            this.nativeObject_cache = target.getReference(2, NativeObjectData.class);
            this.generic_interopLibrary_ = target.getReference(3, InteropLibrary.class);
            this.pInt_raise_ = LazyNodeGen.inline(InlineTarget.create(Lazy.class, state_0_.subUpdater(16, 1), pInt_raise__field1_));
            this.nativeObject_getClassNode_ = GetPythonObjectClassNodeGen.inline(InlineTarget.create(GetPythonObjectClassNode.class, NATIVE_OBJECT__CAST_TO_JAVA_DOUBLE_NODE_NATIVE_OBJECT_STATE_0_UPDATER.subUpdater(0, 4), ReferenceField.create(NativeObjectData.lookup_(), "nativeObject_getClassNode__field1_", Object.class), ReferenceField.create(NativeObjectData.lookup_(), "nativeObject_getClassNode__field2_", Node.class), ReferenceField.create(NativeObjectData.lookup_(), "nativeObject_getClassNode__field3_", Node.class)));
        }

        @Override
        public double execute(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            if ((state_0 & 0b111111111) != 0 /* is SpecializationActive[CastToJavaDoubleNode.toDouble(double)] || SpecializationActive[CastToJavaDoubleNode.doBoolean(boolean)] || SpecializationActive[CastToJavaDoubleNode.doInt(int)] || SpecializationActive[CastToJavaDoubleNode.doLong(long)] || SpecializationActive[CastToJavaDoubleNode.doPInt(Node, PInt, Lazy)] || SpecializationActive[CastToJavaDoubleNode.doString(TruffleString)] || SpecializationActive[CastToJavaDoubleNode.doPBCT(PythonBuiltinClassType)] || SpecializationActive[CastToJavaDoubleNode.doNativeObject(Node, PythonAbstractNativeObject, GetPythonObjectClassNode, IsSubtypeNode, ReadDoubleNode)] || SpecializationActive[CastToJavaDoubleNode.doGeneric(Object, InteropLibrary)] */) {
                if ((state_0 & 0b1) != 0 /* is SpecializationActive[CastToJavaDoubleNode.toDouble(double)] */ && PythonArithmeticTypesGen.isImplicitDouble((state_0 & 0b11000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, arg1Value)) {
                    double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble((state_0 & 0b11000000000) >>> 9 /* get-int ImplicitCast[type=double, index=1] */, arg1Value);
                    return CastToJavaDoubleNode.toDouble(arg1Value_);
                }
                if ((state_0 & 0b10) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doBoolean(boolean)] */ && arg1Value instanceof Boolean) {
                    boolean arg1Value_ = (boolean) arg1Value;
                    return CastToJavaDoubleNode.doBoolean(arg1Value_);
                }
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doInt(int)] */ && PythonArithmeticTypesGen.isImplicitInteger((state_0 & 0b1100000000000) >>> 11 /* get-int ImplicitCast[type=int, index=1] */, arg1Value)) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger((state_0 & 0b1100000000000) >>> 11 /* get-int ImplicitCast[type=int, index=1] */, arg1Value);
                    return CastToJavaDoubleNode.doInt(arg1Value_);
                }
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doLong(long)] */ && PythonArithmeticTypesGen.isImplicitLong((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=long, index=1] */, arg1Value)) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong((state_0 & 0b1110000000000000) >>> 13 /* get-int ImplicitCast[type=long, index=1] */, arg1Value);
                    return CastToJavaDoubleNode.doLong(arg1Value_);
                }
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doPInt(Node, PInt, Lazy)] */ && arg1Value instanceof PInt) {
                    PInt arg1Value_ = (PInt) arg1Value;
                    assert InlineSupport.validate(arg0Value, this.state_0_, this.pInt_raise__field1_);
                    return CastToJavaDoubleNode.doPInt(arg0Value, arg1Value_, this.pInt_raise_);
                }
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doString(TruffleString)] */ && arg1Value instanceof TruffleString) {
                    TruffleString arg1Value_ = (TruffleString) arg1Value;
                    return CastToJavaDoubleNode.doString(arg1Value_);
                }
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doPBCT(PythonBuiltinClassType)] */ && arg1Value instanceof PythonBuiltinClassType) {
                    PythonBuiltinClassType arg1Value_ = (PythonBuiltinClassType) arg1Value;
                    return CastToJavaDoubleNode.doPBCT(arg1Value_);
                }
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doNativeObject(Node, PythonAbstractNativeObject, GetPythonObjectClassNode, IsSubtypeNode, ReadDoubleNode)] */ && arg1Value instanceof PythonAbstractNativeObject) {
                    PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                    NativeObjectData s7_ = this.nativeObject_cache.get(arg0Value);
                    if (s7_ != null) {
                        return CastToJavaDoubleNode.doNativeObject(s7_, arg1Value_, this.nativeObject_getClassNode_, s7_.isSubtypeNode_, s7_.read_);
                    }
                }
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[CastToJavaDoubleNode.doGeneric(Object, InteropLibrary)] */) {
                    {
                        InteropLibrary interopLibrary__ = this.generic_interopLibrary_.get(arg0Value);
                        if (interopLibrary__ != null) {
                            if ((!(MathGuards.isNumber(arg1Value)))) {
                                return CastToJavaDoubleNode.doGeneric(arg1Value, interopLibrary__);
                            }
                        }
                    }
                }
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            return executeAndSpecialize(arg0Value, arg1Value);
        }

        private double executeAndSpecialize(Node arg0Value, Object arg1Value) {
            int state_0 = this.state_0_.get(arg0Value);
            {
                int doubleCast1;
                if ((doubleCast1 = PythonArithmeticTypesGen.specializeImplicitDouble(arg1Value)) != 0) {
                    double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(doubleCast1, arg1Value);
                    state_0 = (state_0 | (doubleCast1 << 9) /* set-int ImplicitCast[type=double, index=1] */);
                    state_0 = state_0 | 0b1 /* add SpecializationActive[CastToJavaDoubleNode.toDouble(double)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CastToJavaDoubleNode.toDouble(arg1Value_);
                }
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                state_0 = state_0 | 0b10 /* add SpecializationActive[CastToJavaDoubleNode.doBoolean(boolean)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaDoubleNode.doBoolean(arg1Value_);
            }
            {
                int intCast1;
                if ((intCast1 = PythonArithmeticTypesGen.specializeImplicitInteger(arg1Value)) != 0) {
                    int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(intCast1, arg1Value);
                    state_0 = (state_0 | (intCast1 << 11) /* set-int ImplicitCast[type=int, index=1] */);
                    state_0 = state_0 | 0b100 /* add SpecializationActive[CastToJavaDoubleNode.doInt(int)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CastToJavaDoubleNode.doInt(arg1Value_);
                }
            }
            {
                int longCast1;
                if ((longCast1 = PythonArithmeticTypesGen.specializeImplicitLong(arg1Value)) != 0) {
                    long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(longCast1, arg1Value);
                    state_0 = (state_0 | (longCast1 << 13) /* set-int ImplicitCast[type=long, index=1] */);
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[CastToJavaDoubleNode.doLong(long)] */;
                    this.state_0_.set(arg0Value, state_0);
                    return CastToJavaDoubleNode.doLong(arg1Value_);
                }
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                state_0 = state_0 | 0b10000 /* add SpecializationActive[CastToJavaDoubleNode.doPInt(Node, PInt, Lazy)] */;
                this.state_0_.set(arg0Value, state_0);
                assert InlineSupport.validate(arg0Value, this.state_0_, this.pInt_raise__field1_);
                return CastToJavaDoubleNode.doPInt(arg0Value, arg1Value_, this.pInt_raise_);
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[CastToJavaDoubleNode.doString(TruffleString)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaDoubleNode.doString(arg1Value_);
            }
            if (arg1Value instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType arg1Value_ = (PythonBuiltinClassType) arg1Value;
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[CastToJavaDoubleNode.doPBCT(PythonBuiltinClassType)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaDoubleNode.doPBCT(arg1Value_);
            }
            if (arg1Value instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                NativeObjectData s7_ = arg0Value.insert(new NativeObjectData());
                IsSubtypeNode isSubtypeNode__ = s7_.insert((IsSubtypeNode.create()));
                Objects.requireNonNull(isSubtypeNode__, "Specialization 'doNativeObject(Node, PythonAbstractNativeObject, GetPythonObjectClassNode, IsSubtypeNode, ReadDoubleNode)' cache 'isSubtypeNode' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s7_.isSubtypeNode_ = isSubtypeNode__;
                ReadDoubleNode read__ = s7_.insert((ReadDoubleNode.create()));
                Objects.requireNonNull(read__, "Specialization 'doNativeObject(Node, PythonAbstractNativeObject, GetPythonObjectClassNode, IsSubtypeNode, ReadDoubleNode)' cache 'read' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                s7_.read_ = read__;
                VarHandle.storeStoreFence();
                this.nativeObject_cache.set(arg0Value, s7_);
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[CastToJavaDoubleNode.doNativeObject(Node, PythonAbstractNativeObject, GetPythonObjectClassNode, IsSubtypeNode, ReadDoubleNode)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaDoubleNode.doNativeObject(s7_, arg1Value_, this.nativeObject_getClassNode_, isSubtypeNode__, read__);
            }
            if ((!(MathGuards.isNumber(arg1Value)))) {
                InteropLibrary interopLibrary__ = arg0Value.insert((INTEROP_LIBRARY_.createDispatched(3)));
                Objects.requireNonNull(interopLibrary__, "Specialization 'doGeneric(Object, InteropLibrary)' cache 'interopLibrary' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                VarHandle.storeStoreFence();
                this.generic_interopLibrary_.set(arg0Value, interopLibrary__);
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[CastToJavaDoubleNode.doGeneric(Object, InteropLibrary)] */;
                this.state_0_.set(arg0Value, state_0);
                return CastToJavaDoubleNode.doGeneric(arg1Value, interopLibrary__);
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(CastToJavaDoubleNode.class)
    @DenyReplace
    private static final class NativeObjectData extends Node implements SpecializationDataNode {

        /**
         * State Info: <pre>
         *   0-3: InlinedCache
         *        Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *        Parameter: {@link GetPythonObjectClassNode} getClassNode
         *        Inline method: {@link GetPythonObjectClassNodeGen#inline}
         * </pre>
         */
        @CompilationFinal @UnsafeAccessedField private int nativeObject_state_0_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *   Parameter: {@link GetPythonObjectClassNode} getClassNode
         *   Inline method: {@link GetPythonObjectClassNodeGen#inline}
         *   Inline field: {@link Object} field1</pre>
         */
        @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object nativeObject_getClassNode__field1_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *   Parameter: {@link GetPythonObjectClassNode} getClassNode
         *   Inline method: {@link GetPythonObjectClassNodeGen#inline}
         *   Inline field: {@link Node} field2</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeObject_getClassNode__field2_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *   Parameter: {@link GetPythonObjectClassNode} getClassNode
         *   Inline method: {@link GetPythonObjectClassNodeGen#inline}
         *   Inline field: {@link Node} field3</pre>
         */
        @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node nativeObject_getClassNode__field3_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *   Parameter: {@link IsSubtypeNode} isSubtypeNode</pre>
         */
        @Child IsSubtypeNode isSubtypeNode_;
        /**
         * Source Info: <pre>
         *   Specialization: {@link CastToJavaDoubleNode#doNativeObject}
         *   Parameter: {@link ReadDoubleNode} read</pre>
         */
        @Child ReadDoubleNode read_;

        NativeObjectData() {
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        private static Lookup lookup_() {
            return MethodHandles.lookup();
        }

    }
    @GeneratedBy(CastToJavaDoubleNode.class)
    @DenyReplace
    private static final class Uncached extends CastToJavaDoubleNode {

        @TruffleBoundary
        @Override
        public double execute(Node arg0Value, Object arg1Value) {
            if (PythonArithmeticTypesGen.isImplicitDouble(arg1Value)) {
                double arg1Value_ = PythonArithmeticTypesGen.asImplicitDouble(arg1Value);
                return CastToJavaDoubleNode.toDouble(arg1Value_);
            }
            if (arg1Value instanceof Boolean) {
                boolean arg1Value_ = (boolean) arg1Value;
                return CastToJavaDoubleNode.doBoolean(arg1Value_);
            }
            if (PythonArithmeticTypesGen.isImplicitInteger(arg1Value)) {
                int arg1Value_ = PythonArithmeticTypesGen.asImplicitInteger(arg1Value);
                return CastToJavaDoubleNode.doInt(arg1Value_);
            }
            if (PythonArithmeticTypesGen.isImplicitLong(arg1Value)) {
                long arg1Value_ = PythonArithmeticTypesGen.asImplicitLong(arg1Value);
                return CastToJavaDoubleNode.doLong(arg1Value_);
            }
            if (arg1Value instanceof PInt) {
                PInt arg1Value_ = (PInt) arg1Value;
                return CastToJavaDoubleNode.doPInt(arg0Value, arg1Value_, (Lazy.getUncached()));
            }
            if (arg1Value instanceof TruffleString) {
                TruffleString arg1Value_ = (TruffleString) arg1Value;
                return CastToJavaDoubleNode.doString(arg1Value_);
            }
            if (arg1Value instanceof PythonBuiltinClassType) {
                PythonBuiltinClassType arg1Value_ = (PythonBuiltinClassType) arg1Value;
                return CastToJavaDoubleNode.doPBCT(arg1Value_);
            }
            if (arg1Value instanceof PythonAbstractNativeObject) {
                PythonAbstractNativeObject arg1Value_ = (PythonAbstractNativeObject) arg1Value;
                return CastToJavaDoubleNode.doNativeObject(arg0Value, arg1Value_, (GetPythonObjectClassNodeGen.getUncached()), (IsSubtypeNode.getUncached()), (ReadDoubleNode.getUncached()));
            }
            if ((!(MathGuards.isNumber(arg1Value)))) {
                return CastToJavaDoubleNode.doGeneric(arg1Value, (INTEROP_LIBRARY_.getUncached()));
            }
            throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
}
