// CheckStyle: start generated
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PosixSupportLibrary.AddrInfoCursor;
import com.oracle.graal.python.runtime.PosixSupportLibrary.AddrInfoCursorLibrary;
import com.oracle.graal.python.runtime.PosixSupportLibrary.UniversalSockAddr;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.library.Message;
import com.oracle.truffle.api.library.ReflectionLibrary;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.EncapsulatingNodeReference;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.utilities.FinalBitSet;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.concurrent.locks.Lock;

@GeneratedBy(AddrInfoCursorLibrary.class)
final class AddrInfoCursorLibraryGen extends LibraryFactory<AddrInfoCursorLibrary> {

    private static final Class<AddrInfoCursorLibrary> LIBRARY_CLASS = AddrInfoCursorLibraryGen.lazyLibraryClass();
    private static final Message RELEASE = new MessageImpl("release", 0, false, void.class, AddrInfoCursor.class);
    private static final Message NEXT = new MessageImpl("next", 1, false, boolean.class, AddrInfoCursor.class);
    private static final Message GET_FLAGS = new MessageImpl("getFlags", 2, false, int.class, AddrInfoCursor.class);
    private static final Message GET_FAMILY = new MessageImpl("getFamily", 3, false, int.class, AddrInfoCursor.class);
    private static final Message GET_SOCK_TYPE = new MessageImpl("getSockType", 4, false, int.class, AddrInfoCursor.class);
    private static final Message GET_PROTOCOL = new MessageImpl("getProtocol", 5, false, int.class, AddrInfoCursor.class);
    private static final Message GET_CANON_NAME = new MessageImpl("getCanonName", 6, false, Object.class, AddrInfoCursor.class);
    private static final Message GET_SOCK_ADDR = new MessageImpl("getSockAddr", 7, false, UniversalSockAddr.class, AddrInfoCursor.class);
    private static final AddrInfoCursorLibraryGen INSTANCE = new AddrInfoCursorLibraryGen();
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    static  {
        LibraryExport.register(AddrInfoCursorLibraryGen.LIBRARY_CLASS, new Default());
        LibraryFactory.register(AddrInfoCursorLibraryGen.LIBRARY_CLASS, INSTANCE);
    }

    private AddrInfoCursorLibraryGen() {
        super(AddrInfoCursorLibraryGen.LIBRARY_CLASS, Collections.unmodifiableList(Arrays.asList(AddrInfoCursorLibraryGen.RELEASE, AddrInfoCursorLibraryGen.NEXT, AddrInfoCursorLibraryGen.GET_FLAGS, AddrInfoCursorLibraryGen.GET_FAMILY, AddrInfoCursorLibraryGen.GET_SOCK_TYPE, AddrInfoCursorLibraryGen.GET_PROTOCOL, AddrInfoCursorLibraryGen.GET_CANON_NAME, AddrInfoCursorLibraryGen.GET_SOCK_ADDR)));
    }

    @Override
    protected Class<?> getDefaultClass(Object receiver) {
        return AddrInfoCursorLibrary.class;
    }

    @Override
    protected AddrInfoCursorLibrary createProxy(ReflectionLibrary library) {
        return new Proxy(library);
    }

    @Override
    protected FinalBitSet createMessageBitSet(Message... messages) {
        BitSet bitSet = new BitSet(2);
        for (Message message : messages) {
            bitSet.set(message.getId());
        }
        return FinalBitSet.valueOf(bitSet);
    }

    @Override
    protected AddrInfoCursorLibrary createDelegate(AddrInfoCursorLibrary delegateLibrary) {
        return new Delegate(delegateLibrary);
    }

    @Override
    protected Object genericDispatch(Library originalLib, Object receiver, Message message, Object[] args, int offset) throws Exception {
        AddrInfoCursorLibrary lib = (AddrInfoCursorLibrary) originalLib;
        if (message.getParameterCount() - 1 != args.length - offset) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalArgumentException("Invalid number of arguments.");
        }
        switch (message.getId()) {
            case 0 :
                lib.release((AddrInfoCursor) receiver);
                return null;
            case 1 :
                return lib.next((AddrInfoCursor) receiver);
            case 2 :
                return lib.getFlags((AddrInfoCursor) receiver);
            case 3 :
                return lib.getFamily((AddrInfoCursor) receiver);
            case 4 :
                return lib.getSockType((AddrInfoCursor) receiver);
            case 5 :
                return lib.getProtocol((AddrInfoCursor) receiver);
            case 6 :
                return lib.getCanonName((AddrInfoCursor) receiver);
            case 7 :
                return lib.getSockAddr((AddrInfoCursor) receiver);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw new AbstractMethodError(message.toString());
    }

    @Override
    protected AddrInfoCursorLibrary createDispatchImpl(int limit) {
        return new CachedDispatchFirst(null, null, limit);
    }

    @Override
    protected AddrInfoCursorLibrary createUncachedDispatch() {
        return new UncachedDispatch();
    }

    @SuppressWarnings("unchecked")
    private static Class<AddrInfoCursorLibrary> lazyLibraryClass() {
        try {
            return (Class<AddrInfoCursorLibrary>) Class.forName("com.oracle.graal.python.runtime.PosixSupportLibrary$AddrInfoCursorLibrary", false, AddrInfoCursorLibraryGen.class.getClassLoader());
        } catch (ClassNotFoundException e) {
            throw CompilerDirectives.shouldNotReachHere(e);
        }
    }

    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static final class Default extends LibraryExport<AddrInfoCursorLibrary> {

        private Default() {
            super(AddrInfoCursorLibrary.class, AddrInfoCursor.class, false, false, 0);
        }

        @Override
        protected AddrInfoCursorLibrary createUncached(Object receiver) {
            assert receiver instanceof AddrInfoCursor;
            AddrInfoCursorLibrary uncached = new Uncached(receiver);
            return uncached;
        }

        @Override
        protected AddrInfoCursorLibrary createCached(Object receiver) {
            assert receiver instanceof AddrInfoCursor;
            return new Cached(receiver);
        }

        @GeneratedBy(AddrInfoCursorLibrary.class)
        private static final class Cached extends AddrInfoCursorLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Cached(Object receiver) {
                this.dynamicDispatch_ = insert(DYNAMIC_DISPATCH_LIBRARY_.create(receiver));
                this.dynamicDispatchTarget_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver).dispatch(receiver);
            }

            @Override
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @TruffleBoundary
            @Override
            public void release(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public boolean next(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getFlags(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getFamily(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getSockType(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getProtocol(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object getCanonName(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public UniversalSockAddr getSockAddr(AddrInfoCursor receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
        @GeneratedBy(AddrInfoCursorLibrary.class)
        @DenyReplace
        private static final class Uncached extends AddrInfoCursorLibrary {

            @Child private DynamicDispatchLibrary dynamicDispatch_;
            private final Class<?> dynamicDispatchTarget_;

            protected Uncached(Object receiver) {
                this.dynamicDispatch_ = DYNAMIC_DISPATCH_LIBRARY_.getUncached(receiver);
                this.dynamicDispatchTarget_ = dynamicDispatch_.dispatch(receiver);
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                return dynamicDispatch_.accepts(receiver) && dynamicDispatch_.dispatch(receiver) == dynamicDispatchTarget_;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public void release(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public boolean next(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getFlags(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getFamily(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getSockType(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public int getProtocol(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public Object getCanonName(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

            @TruffleBoundary
            @Override
            public UniversalSockAddr getSockAddr(AddrInfoCursor receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                throw new AbstractMethodError();
            }

        }
    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static class MessageImpl extends Message {

        MessageImpl(String name, int index, boolean deprecated, Class<?> returnType, Class<?>... parameters) {
            super(AddrInfoCursorLibraryGen.LIBRARY_CLASS, name, index, deprecated, returnType, parameters);
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static final class Proxy extends AddrInfoCursorLibrary {

        @Child private ReflectionLibrary lib;

        Proxy(ReflectionLibrary lib) {
            this.lib = lib;
        }

        @Override
        public void release(AddrInfoCursor receiver_) {
            try {
                lib.send(receiver_, AddrInfoCursorLibraryGen.RELEASE);
                return;
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean next(AddrInfoCursor receiver_) {
            try {
                return (boolean) lib.send(receiver_, AddrInfoCursorLibraryGen.NEXT);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getFlags(AddrInfoCursor receiver_) {
            try {
                return (int) lib.send(receiver_, AddrInfoCursorLibraryGen.GET_FLAGS);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getFamily(AddrInfoCursor receiver_) {
            try {
                return (int) lib.send(receiver_, AddrInfoCursorLibraryGen.GET_FAMILY);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getSockType(AddrInfoCursor receiver_) {
            try {
                return (int) lib.send(receiver_, AddrInfoCursorLibraryGen.GET_SOCK_TYPE);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public int getProtocol(AddrInfoCursor receiver_) {
            try {
                return (int) lib.send(receiver_, AddrInfoCursorLibraryGen.GET_PROTOCOL);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public Object getCanonName(AddrInfoCursor receiver_) {
            try {
                return lib.send(receiver_, AddrInfoCursorLibraryGen.GET_CANON_NAME);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public UniversalSockAddr getSockAddr(AddrInfoCursor receiver_) {
            try {
                return (UniversalSockAddr) lib.send(receiver_, AddrInfoCursorLibraryGen.GET_SOCK_ADDR);
            } catch (RuntimeException e_) {
                throw e_;
            } catch (Exception e_) {
                throw CompilerDirectives.shouldNotReachHere(e_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return lib.accepts(receiver_);
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static final class Delegate extends AddrInfoCursorLibrary {

        @Child private AddrInfoCursorLibrary delegateLibrary;

        Delegate(AddrInfoCursorLibrary delegateLibrary) {
            this.delegateLibrary = delegateLibrary;
        }

        @Override
        public void release(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 0)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).release((AddrInfoCursor) delegate);
                return;
            } else {
                this.delegateLibrary.release(receiver_);
                return;
            }
        }

        @Override
        public boolean next(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 1)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).next((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.next(receiver_);
            }
        }

        @Override
        public int getFlags(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 2)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getFlags((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.getFlags(receiver_);
            }
        }

        @Override
        public int getFamily(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 3)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getFamily((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.getFamily(receiver_);
            }
        }

        @Override
        public int getSockType(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 4)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getSockType((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.getSockType(receiver_);
            }
        }

        @Override
        public int getProtocol(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 5)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getProtocol((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.getProtocol(receiver_);
            }
        }

        @Override
        public Object getCanonName(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 6)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getCanonName((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.getCanonName(receiver_);
            }
        }

        @Override
        public UniversalSockAddr getSockAddr(AddrInfoCursor receiver_) {
            if (LibraryFactory.isDelegated(delegateLibrary, 7)) {
                Object delegate = LibraryFactory.readDelegate(this.delegateLibrary, receiver_);
                return LibraryFactory.getDelegateLibrary(this.delegateLibrary, delegate).getSockAddr((AddrInfoCursor) delegate);
            } else {
                return this.delegateLibrary.getSockAddr(receiver_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return delegateLibrary.accepts(receiver_);
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

        @Override
        public boolean isAdoptable() {
            return this.delegateLibrary.isAdoptable();
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static final class CachedToUncachedDispatch extends AddrInfoCursorLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void release(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                INSTANCE.getUncached(receiver_).release(receiver_);
                return;
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public boolean next(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).next(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getFlags(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getFlags(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getFamily(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getFamily(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getSockType(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getSockType(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public int getProtocol(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getProtocol(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public Object getCanonName(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getCanonName(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @TruffleBoundary
        @Override
        public UniversalSockAddr getSockAddr(AddrInfoCursor receiver_) {
            assert assertAdopted(this);
            EncapsulatingNodeReference encapsulating_ = EncapsulatingNodeReference.getCurrent();
            Node prev_ = encapsulating_.set(getParent());
            try {
                return INSTANCE.getUncached(receiver_).getSockAddr(receiver_);
            } finally {
                encapsulating_.set(prev_);
            }
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    @DenyReplace
    private static final class UncachedDispatch extends AddrInfoCursorLibrary {

        @Override
        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        @TruffleBoundary
        @Override
        public void release(AddrInfoCursor receiver_) {
            INSTANCE.getUncached(receiver_).release(receiver_);
            return;
        }

        @TruffleBoundary
        @Override
        public boolean next(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).next(receiver_);
        }

        @TruffleBoundary
        @Override
        public int getFlags(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).getFlags(receiver_);
        }

        @TruffleBoundary
        @Override
        public int getFamily(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).getFamily(receiver_);
        }

        @TruffleBoundary
        @Override
        public int getSockType(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).getSockType(receiver_);
        }

        @TruffleBoundary
        @Override
        public int getProtocol(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).getProtocol(receiver_);
        }

        @TruffleBoundary
        @Override
        public Object getCanonName(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).getCanonName(receiver_);
        }

        @TruffleBoundary
        @Override
        public UniversalSockAddr getSockAddr(AddrInfoCursor receiver_) {
            return INSTANCE.getUncached(receiver_).getSockAddr(receiver_);
        }

        @TruffleBoundary
        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        @Override
        public boolean isAdoptable() {
            return false;
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static final class CachedDispatchNext extends CachedDispatch {

        CachedDispatchNext(AddrInfoCursorLibrary library, CachedDispatch next) {
            super(library, next);
        }

        @Override
        int getLimit() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Override
        public NodeCost getCost() {
            return NodeCost.NONE;
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private static final class CachedDispatchFirst extends CachedDispatch {

        private final int limit_;

        CachedDispatchFirst(AddrInfoCursorLibrary library, CachedDispatch next, int limit_) {
            super(library, next);
            this.limit_ = limit_;
        }

        @Override
        int getLimit() {
            return this.limit_;
        }

        @Override
        public NodeCost getCost() {
            if (this.library instanceof CachedToUncachedDispatch) {
                return NodeCost.MEGAMORPHIC;
            }
            CachedDispatch current = this;
            int count = 0;
            do {
                if (current.library != null) {
                    count++;
                }
                current = current.next;
            } while (current != null);
            return NodeCost.fromCount(count);
        }

    }
    @GeneratedBy(AddrInfoCursorLibrary.class)
    private abstract static class CachedDispatch extends AddrInfoCursorLibrary {

        @Child AddrInfoCursorLibrary library;
        @Child CachedDispatch next;

        CachedDispatch(AddrInfoCursorLibrary library, CachedDispatch next) {
            this.library = library;
            this.next = next;
        }

        abstract int getLimit();

        @ExplodeLoop
        @Override
        public void release(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        thisLibrary.release(receiver_);
                        return;
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public boolean next(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.next(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getFlags(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getFlags(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getFamily(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getFamily(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getSockType(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getSockType(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public int getProtocol(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getProtocol(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public Object getCanonName(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getCanonName(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @ExplodeLoop
        @Override
        public UniversalSockAddr getSockAddr(AddrInfoCursor receiver_) {
            do {
                CachedDispatch current = this;
                do {
                    AddrInfoCursorLibrary thisLibrary = current.library;
                    if (thisLibrary != null && thisLibrary.accepts(receiver_)) {
                        return thisLibrary.getSockAddr(receiver_);
                    }
                    current = current.next;
                } while (current != null);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                specialize(receiver_);
            } while (true);
        }

        @Override
        public boolean accepts(Object receiver_) {
            return true;
        }

        private void specialize(AddrInfoCursor receiver_) {
            Lock lock = getLock();
            lock.lock();
            try {
                CachedDispatch current = this;
                AddrInfoCursorLibrary thisLibrary = current.library;
                if (thisLibrary == null) {
                    this.library = insert(INSTANCE.create(receiver_));
                } else {
                    int count = 0;
                    do {
                        AddrInfoCursorLibrary currentLibrary = current.library;
                        if (currentLibrary != null && currentLibrary.accepts(receiver_)) {
                            return;
                        }
                        count++;
                        current = current.next;
                    } while (current != null);
                    if (count >= getLimit()) {
                        this.library = insert(new CachedToUncachedDispatch());
                        this.next = null;
                    } else {
                        this.next = insert(new CachedDispatchNext(INSTANCE.create(receiver_), next));
                    }
                }
            } finally {
                lock.unlock();
            }
        }

    }
}
