/*
 * Copyright (c) 2021, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * The Universal Permissive License (UPL), Version 1.0
 *
 * Subject to the condition set forth below, permission is hereby granted to any
 * person obtaining a copy of this software, associated documentation and/or
 * data (collectively the "Software"), free of charge and under any and all
 * copyright rights in the Software, and any and all patent rights owned or
 * freely licensable by each licensor hereunder covering either (i) the
 * unmodified Software as contributed to or provided by such licensor, or (ii)
 * the Larger Works (as defined below), to deal in both
 *
 * (a) the Software, and
 *
 * (b) any piece of software and/or hardware listed in the lrgrwrks.txt file if
 * one is included with the Software each a "Larger Work" to which the Software
 * is contributed by such licensors),
 *
 * without restriction, including without limitation the rights to copy, create
 * derivative works of, display, perform, and distribute the Software and make,
 * use, sell, offer for sale, import, export, have made, and have sold the
 * Software and the Larger Work(s), and to sublicense the foregoing rights on
 * either these or other terms.
 *
 * This license is subject to the following condition:
 *
 * The above copyright notice and either this complete permission notice or at a
 * minimum a reference to the UPL must be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */
package com.oracle.graal.python.runtime;

// Auto generated by gen_native_cfg.py at 2023-05-26 12:43:41.748991
// on Linux arisu 6.2.15-200.fc37.x86_64 #1 SMP PREEMPT_DYNAMIC Thu May 11 15:56:33 UTC 2023 x86_64 x86_64
class PosixConstantsLinux {

    private PosixConstantsLinux() {
    }

    static void getConstants(PosixConstants.Registry constants) {
        constants.put("HAVE_FUTIMENS", true);
        constants.put("HAVE_UTIMENSAT", true);
        constants.put("FD_SETSIZE", 1024);
        constants.put("PATH_MAX", 4096);
        constants.put("L_ctermid", 9);
        constants.put("INET_ADDRSTRLEN", 16);
        constants.put("INET6_ADDRSTRLEN", 46);
        constants.put("HOST_NAME_MAX", 64);
        constants.put("_POSIX_HOST_NAME_MAX", 255);
        constants.put("SOL_SOCKET", 1);
        constants.put("NI_MAXHOST", 1025);
        constants.put("NI_MAXSERV", 32);
        constants.put("AT_FDCWD", -100);
        constants.put("AT_SYMLINK_FOLLOW", 1024);
        constants.put("SEEK_SET", 0);
        constants.put("SEEK_CUR", 1);
        constants.put("SEEK_END", 2);
        constants.put("SEEK_DATA", 3);
        constants.put("SEEK_HOLE", 4);
        constants.put("SOMAXCONN", 4096);
        constants.put("PIPE_BUF", 4096);
        constants.put("O_ACCMODE", 0x00000003);
        constants.put("O_RDONLY", 0x00000000);
        constants.put("O_WRONLY", 0x00000001);
        constants.put("O_RDWR", 0x00000002);
        constants.put("O_CREAT", 0x00000040);
        constants.put("O_EXCL", 0x00000080);
        constants.put("O_TRUNC", 0x00000200);
        constants.put("O_APPEND", 0x00000400);
        constants.put("O_NONBLOCK", 0x00000800);
        constants.put("O_NOCTTY", 0x00000100);
        constants.put("O_NDELAY", 0x00000800);
        constants.put("O_DSYNC", 0x00001000);
        constants.put("O_CLOEXEC", 0x00080000);
        constants.put("O_SYNC", 0x00101000);
        constants.put("O_DIRECT", 0x00004000);
        constants.put("O_RSYNC", 0x00101000);
        constants.put("O_TMPFILE", 0x00410000);
        constants.put("O_DIRECTORY", 0x00010000);
        constants.put("O_LARGEFILE", 0x00000000);
        constants.put("O_PATH", 0x00200000);
        constants.put("S_IFMT", 0x0000F000);
        constants.put("S_IFSOCK", 0x0000C000);
        constants.put("S_IFLNK", 0x0000A000);
        constants.put("S_IFREG", 0x00008000);
        constants.put("S_IFBLK", 0x00006000);
        constants.put("S_IFDIR", 0x00004000);
        constants.put("S_IFCHR", 0x00002000);
        constants.put("S_IFIFO", 0x00001000);
        constants.put("MAP_SHARED", 0x00000001);
        constants.put("MAP_PRIVATE", 0x00000002);
        constants.put("MAP_ANONYMOUS", 0x00000020);
        constants.put("MAP_DENYWRITE", 0x00000800);
        constants.put("MAP_EXECUTABLE", 0x00001000);
        constants.put("PROT_NONE", 0x00000000);
        constants.put("PROT_READ", 0x00000001);
        constants.put("PROT_WRITE", 0x00000002);
        constants.put("PROT_EXEC", 0x00000004);
        constants.put("LOCK_SH", 0x00000001);
        constants.put("LOCK_EX", 0x00000002);
        constants.put("LOCK_NB", 0x00000004);
        constants.put("LOCK_UN", 0x00000008);
        constants.put("F_RDLCK", 0);
        constants.put("F_WRLCK", 1);
        constants.put("F_UNLCK", 2);
        constants.put("DT_UNKNOWN", 0);
        constants.put("DT_FIFO", 1);
        constants.put("DT_CHR", 2);
        constants.put("DT_DIR", 4);
        constants.put("DT_BLK", 6);
        constants.put("DT_REG", 8);
        constants.put("DT_LNK", 10);
        constants.put("DT_SOCK", 12);
        constants.put("DT_WHT", 14);
        constants.put("WNOHANG", 1);
        constants.put("WUNTRACED", 2);
        constants.put("R_OK", 0x00000004);
        constants.put("W_OK", 0x00000002);
        constants.put("X_OK", 0x00000001);
        constants.put("F_OK", 0x00000000);
        constants.put("EX_OK", 0);
        constants.put("EX_USAGE", 64);
        constants.put("EX_DATAERR", 65);
        constants.put("EX_NOINPUT", 66);
        constants.put("EX_NOUSER", 67);
        constants.put("EX_NOHOST", 68);
        constants.put("EX_UNAVAILABLE", 69);
        constants.put("EX_SOFTWARE", 70);
        constants.put("EX_OSERR", 71);
        constants.put("EX_OSFILE", 72);
        constants.put("EX_CANTCREAT", 73);
        constants.put("EX_IOERR", 74);
        constants.put("EX_TEMPFAIL", 75);
        constants.put("EX_PROTOCOL", 76);
        constants.put("EX_NOPERM", 77);
        constants.put("EX_CONFIG", 78);
        constants.put("RTLD_LAZY", 0x00000001);
        constants.put("RTLD_NOW", 0x00000002);
        constants.put("RTLD_GLOBAL", 0x00000100);
        constants.put("RTLD_LOCAL", 0x00000000);
        constants.put("AF_UNSPEC", 0);
        constants.put("AF_INET", 2);
        constants.put("AF_INET6", 10);
        constants.put("AF_PACKET", 17);
        constants.put("AF_UNIX", 1);
        constants.put("SOCK_DGRAM", 2);
        constants.put("SOCK_STREAM", 1);
        constants.put("INADDR_ANY", 0x00000000);
        constants.put("INADDR_BROADCAST", 0xFFFFFFFF);
        constants.put("INADDR_NONE", 0xFFFFFFFF);
        constants.put("INADDR_LOOPBACK", 0x7F000001);
        constants.put("INADDR_ALLHOSTS_GROUP", 0xE0000001);
        constants.put("INADDR_MAX_LOCAL_GROUP", 0xE00000FF);
        constants.put("INADDR_UNSPEC_GROUP", 0xE0000000);
        constants.put("AI_PASSIVE", 0x00000001);
        constants.put("AI_CANONNAME", 0x00000002);
        constants.put("AI_NUMERICHOST", 0x00000004);
        constants.put("AI_V4MAPPED", 0x00000008);
        constants.put("AI_ALL", 0x00000010);
        constants.put("AI_ADDRCONFIG", 0x00000020);
        constants.put("AI_IDN", 0x00000040);
        constants.put("AI_CANONIDN", 0x00000080);
        constants.put("AI_NUMERICSERV", 0x00000400);
        constants.put("EAI_BADFLAGS", -1);
        constants.put("EAI_NONAME", -2);
        constants.put("EAI_AGAIN", -3);
        constants.put("EAI_FAIL", -4);
        constants.put("EAI_FAMILY", -6);
        constants.put("EAI_SOCKTYPE", -7);
        constants.put("EAI_SERVICE", -8);
        constants.put("EAI_MEMORY", -10);
        constants.put("EAI_SYSTEM", -11);
        constants.put("EAI_OVERFLOW", -12);
        constants.put("EAI_NODATA", -5);
        constants.put("EAI_ADDRFAMILY", -9);
        constants.put("EAI_INPROGRESS", -100);
        constants.put("EAI_CANCELED", -101);
        constants.put("EAI_NOTCANCELED", -102);
        constants.put("EAI_ALLDONE", -103);
        constants.put("EAI_INTR", -104);
        constants.put("EAI_IDN_ENCODE", -105);
        constants.put("NI_NUMERICHOST", 1);
        constants.put("NI_NUMERICSERV", 2);
        constants.put("NI_NOFQDN", 4);
        constants.put("NI_NAMEREQD", 8);
        constants.put("NI_DGRAM", 16);
        constants.put("NI_IDN", 32);
        constants.put("IPPROTO_IP", 0);
        constants.put("IPPROTO_ICMP", 1);
        constants.put("IPPROTO_IGMP", 2);
        constants.put("IPPROTO_IPIP", 4);
        constants.put("IPPROTO_TCP", 6);
        constants.put("IPPROTO_EGP", 8);
        constants.put("IPPROTO_PUP", 12);
        constants.put("IPPROTO_UDP", 17);
        constants.put("IPPROTO_IDP", 22);
        constants.put("IPPROTO_TP", 29);
        constants.put("IPPROTO_IPV6", 41);
        constants.put("IPPROTO_RSVP", 46);
        constants.put("IPPROTO_GRE", 47);
        constants.put("IPPROTO_ESP", 50);
        constants.put("IPPROTO_AH", 51);
        constants.put("IPPROTO_MTP", 92);
        constants.put("IPPROTO_ENCAP", 98);
        constants.put("IPPROTO_PIM", 103);
        constants.put("IPPROTO_SCTP", 132);
        constants.put("IPPROTO_RAW", 255);
        constants.put("SHUT_RD", 0);
        constants.put("SHUT_WR", 1);
        constants.put("SHUT_RDWR", 2);
        constants.put("SO_DEBUG", 1);
        constants.put("SO_ACCEPTCONN", 30);
        constants.put("SO_REUSEADDR", 2);
        constants.put("SO_KEEPALIVE", 9);
        constants.put("SO_DONTROUTE", 5);
        constants.put("SO_BROADCAST", 6);
        constants.put("SO_LINGER", 13);
        constants.put("SO_OOBINLINE", 10);
        constants.put("SO_REUSEPORT", 15);
        constants.put("SO_SNDBUF", 7);
        constants.put("SO_RCVBUF", 8);
        constants.put("SO_SNDLOWAT", 19);
        constants.put("SO_RCVLOWAT", 18);
        constants.put("SO_SNDTIMEO", 21);
        constants.put("SO_RCVTIMEO", 20);
        constants.put("SO_ERROR", 4);
        constants.put("SO_TYPE", 3);
        constants.put("SO_PASSCRED", 16);
        constants.put("SO_PEERCRED", 17);
        constants.put("SO_PASSSEC", 34);
        constants.put("SO_PEERSEC", 31);
        constants.put("SO_BINDTODEVICE", 25);
        constants.put("SO_PRIORITY", 12);
        constants.put("SO_MARK", 36);
        constants.put("SO_DOMAIN", 39);
        constants.put("SO_PROTOCOL", 38);
        constants.put("TCP_NODELAY", 1);
        constants.put("TCP_MAXSEG", 2);
        constants.put("TCP_CORK", 3);
        constants.put("TCP_KEEPIDLE", 4);
        constants.put("TCP_KEEPINTVL", 5);
        constants.put("TCP_KEEPCNT", 6);
        constants.put("TCP_SYNCNT", 7);
        constants.put("TCP_LINGER2", 8);
        constants.put("TCP_DEFER_ACCEPT", 9);
        constants.put("TCP_WINDOW_CLAMP", 10);
        constants.put("TCP_INFO", 11);
        constants.put("TCP_QUICKACK", 12);
        constants.put("TCP_FASTOPEN", 23);
        constants.put("TCP_CONGESTION", 13);
        constants.put("TCP_USER_TIMEOUT", 18);
        constants.put("TCP_NOTSENT_LOWAT", 25);
        constants.put("IPV6_JOIN_GROUP", 20);
        constants.put("IPV6_LEAVE_GROUP", 21);
        constants.put("IPV6_MULTICAST_HOPS", 18);
        constants.put("IPV6_MULTICAST_IF", 17);
        constants.put("IPV6_MULTICAST_LOOP", 19);
        constants.put("IPV6_UNICAST_HOPS", 16);
        constants.put("IPV6_V6ONLY", 26);
        constants.put("IPV6_CHECKSUM", 7);
        constants.put("IPV6_DONTFRAG", 62);
        constants.put("IPV6_DSTOPTS", 59);
        constants.put("IPV6_HOPLIMIT", 52);
        constants.put("IPV6_HOPOPTS", 54);
        constants.put("IPV6_NEXTHOP", 9);
        constants.put("IPV6_PATHMTU", 61);
        constants.put("IPV6_PKTINFO", 50);
        constants.put("IPV6_RECVDSTOPTS", 58);
        constants.put("IPV6_RECVHOPLIMIT", 51);
        constants.put("IPV6_RECVHOPOPTS", 53);
        constants.put("IPV6_RECVPKTINFO", 49);
        constants.put("IPV6_RECVRTHDR", 56);
        constants.put("IPV6_RECVTCLASS", 66);
        constants.put("IPV6_RTHDR", 57);
        constants.put("IPV6_RTHDRDSTOPTS", 55);
        constants.put("IPV6_RTHDR_TYPE_0", 0);
        constants.put("IPV6_RECVPATHMTU", 60);
        constants.put("IPV6_TCLASS", 67);
        constants.put("SIZEOF_STRUCT_SOCKADDR_STORAGE", 128);
        constants.put("SIZEOF_STRUCT_SOCKADDR_IN", 16);
        constants.put("OFFSETOF_STRUCT_SOCKADDR_IN_SIN_FAMILY", 0);
        constants.put("SIZEOF_STRUCT_SOCKADDR_IN_SIN_FAMILY", 2);
        constants.put("OFFSETOF_STRUCT_SOCKADDR_IN_SIN_PORT", 2);
        constants.put("SIZEOF_STRUCT_SOCKADDR_IN_SIN_PORT", 2);
        constants.put("OFFSETOF_STRUCT_SOCKADDR_IN_SIN_ADDR", 4);
        constants.put("SIZEOF_STRUCT_SOCKADDR_IN_SIN_ADDR", 4);
        constants.put("SIZEOF_STRUCT_SOCKADDR_IN6", 28);
        constants.put("SIZEOF_STRUCT_IN_ADDR", 4);
        constants.put("OFFSETOF_STRUCT_IN_ADDR_S_ADDR", 0);
        constants.put("SIZEOF_STRUCT_IN_ADDR_S_ADDR", 4);
        constants.put("SIZEOF_STRUCT_SOCKADDR_UN", 110);
        constants.put("OFFSETOF_STRUCT_SOCKADDR_UN_SUN_PATH", 2);
        constants.put("SIZEOF_STRUCT_SOCKADDR_UN_SUN_PATH", 108);
    }
}
