/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CmathModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.modules.MathModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.complex.ComplexBuiltins;
import com.oracle.graal.python.builtins.objects.complex.PComplex;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CoerceToComplexNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="cmath")
public final class CmathModuleBuiltins
extends PythonBuiltins {
    static final double INF = Double.POSITIVE_INFINITY;
    static final double NAN = Double.NaN;
    static final double P = Math.PI;
    static final double P14 = 0.7853981633974483;
    static final double P12 = 1.5707963267948966;
    static final double P34 = 2.356194490192345;
    static final double LARGE_DOUBLE = 4.4942328371557893E307;
    static final double LOG_LARGE_DOUBLE = Math.log(4.4942328371557893E307);
    static final double LN_2 = 0.6931471805599453;
    static final double LN_10 = 2.302585092994046;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CmathModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("pi", (Object)Math.PI);
        this.addBuiltinConstant("e", (Object)Math.E);
        this.addBuiltinConstant("tau", (Object)(Math.PI * 2));
        this.addBuiltinConstant("inf", (Object)Double.POSITIVE_INFINITY);
        this.addBuiltinConstant("nan", (Object)Double.NaN);
        this.addBuiltinConstant("infj", (Object)core.factory().createComplex(0.0, Double.POSITIVE_INFINITY));
        this.addBuiltinConstant("nanj", (Object)core.factory().createComplex(0.0, Double.NaN));
        super.initialize(core);
    }

    static PComplex specialValue(PythonObjectFactory factory, ComplexConstant[][] table, double real, double imag) {
        if (!Double.isFinite(real) || !Double.isFinite(imag)) {
            ComplexConstant c = table[SpecialType.ofDouble(real).ordinal()][SpecialType.ofDouble(imag).ordinal()];
            if (c == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException("should not be reached");
            }
            return factory.createComplex(c.real, c.imag);
        }
        return null;
    }

    static ComplexConstant C(double real, double imag) {
        return new ComplexConstant(real, imag);
    }

    static enum SpecialType {
        NINF,
        NEG,
        NZERO,
        PZERO,
        POS,
        PINF,
        NAN;


        @CompilerDirectives.TruffleBoundary
        static SpecialType ofDouble(double d) {
            if (Double.isFinite(d)) {
                if (d != 0.0) {
                    if (Math.copySign(1.0, d) == 1.0) {
                        return POS;
                    }
                    return NEG;
                }
                if (Math.copySign(1.0, d) == 1.0) {
                    return PZERO;
                }
                return NZERO;
            }
            if (Double.isNaN(d)) {
                return NAN;
            }
            if (Math.copySign(1.0, d) == 1.0) {
                return PINF;
            }
            return NINF;
        }
    }

    static class ComplexConstant {
        final double real;
        final double imag;

        ComplexConstant(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }
    }

    @Builtin(name="isclose", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=2, varArgsMarker=true, keywordOnlyNames={"rel_tol", "abs_tol"})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class IsCloseNode
    extends PythonBuiltinNode {
        private static final double DEFAULT_REL_TOL = 1.0E-9;
        private static final double DEFAULT_ABS_TOL = 0.0;
        @Node.Child
        ComplexBuiltins.AbsNode abs = ComplexBuiltins.AbsNode.create();

        IsCloseNode() {
        }

        @Specialization
        boolean doCCDD(PComplex a, PComplex b, double relTolObj, double absTolObj) {
            return this.isClose(a, b, relTolObj, absTolObj);
        }

        @Specialization
        boolean doCCNN(PComplex a, PComplex b, PNone relTolObj, PNone absTolObj) {
            return this.isClose(a, b, 1.0E-9, 0.0);
        }

        @Specialization
        boolean doGeneral(VirtualFrame frame, Object aObj, Object bObj, Object relTolObj, Object absTolObj, @Bind(value="this") Node inliningTarget, @Cached CoerceToComplexNode coerceAToComplex, @Cached CoerceToComplexNode coerceBToComplex, @Cached PyFloatAsDoubleNode relAsDoubleNode, @Cached PyFloatAsDoubleNode absAsDoubleNode) {
            PComplex a = coerceAToComplex.execute(frame, aObj);
            PComplex b = coerceBToComplex.execute(frame, bObj);
            double relTol = PGuards.isNoValue(relTolObj) ? 1.0E-9 : relAsDoubleNode.execute(frame, inliningTarget, relTolObj);
            double absTol = PGuards.isPNone(absTolObj) ? 0.0 : absAsDoubleNode.execute(frame, inliningTarget, absTolObj);
            return this.isClose(a, b, relTol, absTol);
        }

        private boolean isClose(PComplex a, PComplex b, double relTol, double absTol) {
            if (relTol < 0.0 || absTol < 0.0) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.TOLERANCE_MUST_NON_NEGATIVE);
            }
            if (a.getReal() == b.getReal() && a.getImag() == b.getImag()) {
                return true;
            }
            if (Double.isInfinite(a.getReal()) || Double.isInfinite(a.getImag()) || Double.isInfinite(b.getReal()) || Double.isInfinite(b.getImag())) {
                return false;
            }
            PComplex diff = this.factory().createComplex(a.getReal() - b.getReal(), a.getImag() - b.getImag());
            double len = this.abs.executeDouble(diff);
            return len <= absTol || len <= relTol * this.abs.executeDouble(b) || len <= relTol * this.abs.executeDouble(a);
        }
    }

    @Builtin(name="tanh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TanhNode
    extends CmathComplexUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(-1.0, 0.0), null, CmathModuleBuiltins.C(-1.0, -0.0), CmathModuleBuiltins.C(-1.0, 0.0), null, CmathModuleBuiltins.C(-1.0, 0.0), CmathModuleBuiltins.C(-1.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(1.0, 0.0), CmathModuleBuiltins.C(1.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        TanhNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                if (Double.isInfinite(imag) && Double.isFinite(real)) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0) {
                    return this.factory().createComplex(real > 0.0 ? 1.0 : -1.0, Math.copySign(0.0, 2.0 * Math.sin(imag) * Math.cos(imag)));
                }
                return CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            }
            if (Math.abs(real) > LOG_LARGE_DOUBLE) {
                return this.factory().createComplex(Math.copySign(1.0, real), 4.0 * Math.sin(imag) * Math.cos(imag) * Math.exp(-20.0 * Math.abs(real)));
            }
            double tx = Math.tanh(real);
            double ty = Math.tan(imag);
            double cx = 1.0 / Math.cosh(real);
            double txty = tx * ty;
            double denom = 1.0 + txty * txty;
            return this.factory().createComplex(tx * (1.0 + ty * ty) / denom, ty / denom * cx * cx);
        }

        static TanhNode create() {
            return CmathModuleBuiltinsFactory.TanhNodeFactory.create();
        }
    }

    @Builtin(name="tan", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TanNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private TanhNode tanhNode = TanhNode.create();

        TanNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            PComplex s = this.tanhNode.executeComplex(frame, this.factory().createComplex(-imag, real));
            return this.factory().createComplex(s.getImag(), -s.getReal());
        }
    }

    @Builtin(name="sinh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SinhNode
    extends CmathComplexUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.0, Double.NaN), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(0.0, Double.NaN), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, Double.NaN), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, Double.NaN), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        SinhNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double rimag;
            double rreal;
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                if (Double.isInfinite(imag) && !Double.isNaN(real)) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0) {
                    double r = Math.copySign(Double.POSITIVE_INFINITY, Math.cos(imag));
                    return this.factory().createComplex(real > 0.0 ? r : -r, Math.copySign(Double.POSITIVE_INFINITY, Math.sin(imag)));
                }
                return CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            }
            if (Math.abs(real) > LOG_LARGE_DOUBLE) {
                double x_minus_one = real - Math.copySign(1.0, real);
                rreal = Math.cos(imag) * Math.sinh(x_minus_one) * Math.E;
                rimag = Math.sin(imag) * Math.cosh(x_minus_one) * Math.E;
            } else {
                rreal = Math.cos(imag) * Math.sinh(real);
                rimag = Math.sin(imag) * Math.cosh(real);
            }
            if (Double.isInfinite(rreal) || Double.isInfinite(rimag)) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return this.factory().createComplex(rreal, rimag);
        }

        static SinhNode create() {
            return CmathModuleBuiltinsFactory.SinhNodeFactory.create();
        }
    }

    @Builtin(name="sin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SinNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private SinhNode sinhNode = SinhNode.create();

        SinNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            PComplex s = this.sinhNode.executeComplex(frame, this.factory().createComplex(-imag, real));
            return this.factory().createComplex(s.getImag(), -s.getReal());
        }
    }

    @Builtin(name="cosh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CoshNode
    extends CmathComplexUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, 0.0), null, CmathModuleBuiltins.C(1.0, 0.0), CmathModuleBuiltins.C(1.0, -0.0), null, CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, 0.0), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        CoshNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double rimag;
            double rreal;
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                if (Double.isInfinite(imag) && !Double.isNaN(real)) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0) {
                    double r = Math.copySign(Double.POSITIVE_INFINITY, Math.sin(imag));
                    return this.factory().createComplex(Math.copySign(Double.POSITIVE_INFINITY, Math.cos(imag)), real > 0.0 ? r : -r);
                }
                return CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            }
            if (Math.abs(real) > LOG_LARGE_DOUBLE) {
                double x_minus_one = real - Math.copySign(1.0, real);
                rreal = Math.cos(imag) * Math.cosh(x_minus_one) * Math.E;
                rimag = Math.sin(imag) * Math.sinh(x_minus_one) * Math.E;
            } else {
                rreal = Math.cos(imag) * Math.cosh(real);
                rimag = Math.sin(imag) * Math.sinh(real);
            }
            if (Double.isInfinite(rreal) || Double.isInfinite(rimag)) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return this.factory().createComplex(rreal, rimag);
        }

        static CoshNode create() {
            return CmathModuleBuiltinsFactory.CoshNodeFactory.create();
        }
    }

    @Builtin(name="cos", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CosNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private CoshNode coshNode = CoshNode.create();

        CosNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            return this.coshNode.executeComplex(frame, this.factory().createComplex(-imag, real));
        }
    }

    @Builtin(name="exp", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ExpNode
    extends CmathComplexUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, 0.0), CmathModuleBuiltins.C(0.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, CmathModuleBuiltins.C(1.0, -0.0), CmathModuleBuiltins.C(1.0, 0.0), null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        ExpNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double rimag;
            double rreal;
            if (!Double.isFinite(real) || !Double.isFinite(imag)) {
                PComplex r = Double.isInfinite(real) && Double.isFinite(imag) && imag != 0.0 ? (real > 0.0 ? this.factory().createComplex(Math.copySign(Double.POSITIVE_INFINITY, Math.cos(imag)), Math.copySign(Double.POSITIVE_INFINITY, Math.sin(imag))) : this.factory().createComplex(Math.copySign(0.0, Math.cos(imag)), Math.copySign(0.0, Math.sin(imag)))) : CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
                if (Double.isInfinite(imag) && (Double.isFinite(real) || Double.isInfinite(real) && real > 0.0)) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                return r;
            }
            if (real > LOG_LARGE_DOUBLE) {
                double l = Math.exp(real - 1.0);
                rreal = l * Math.cos(imag) * Math.E;
                rimag = l * Math.sin(imag) * Math.E;
            } else {
                double l = Math.exp(real);
                rreal = l * Math.cos(imag);
                rimag = l * Math.sin(imag);
            }
            if (Double.isInfinite(rreal) || Double.isInfinite(rimag)) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.MATH_RANGE_ERROR);
            }
            return this.factory().createComplex(rreal, rimag);
        }
    }

    @Builtin(name="atanh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AtanhNode
    extends CmathComplexUnaryBuiltinNode {
        static final double SQRT_LARGE_DOUBLE = Math.sqrt(4.4942328371557893E307);
        static final double CM_SQRT_DBL_MIN = Math.sqrt(Double.MIN_NORMAL);
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(-0.0, -1.5707963267948966), CmathModuleBuiltins.C(-0.0, -1.5707963267948966), CmathModuleBuiltins.C(-0.0, -1.5707963267948966), CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, Double.NaN)}, {CmathModuleBuiltins.C(-0.0, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(-0.0, -1.5707963267948966), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(-0.0, 1.5707963267948966), CmathModuleBuiltins.C(-0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(0.0, Double.NaN)}, {CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(0.0, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AtanhNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            PComplex result = CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (real < 0.0) {
                return this.computeWithRealPositive(-real, -imag, -1.0);
            }
            return this.computeWithRealPositive(real, imag, 1.0);
        }

        private PComplex computeWithRealPositive(double real, double imag, double resultScale) {
            double rimag;
            double rreal;
            double ay = Math.abs(imag);
            if (real > SQRT_LARGE_DOUBLE || ay > SQRT_LARGE_DOUBLE) {
                double h = Math.hypot(real / 2.0, imag / 2.0);
                rreal = real / 4.0 / h / h;
                rimag = -Math.copySign(1.5707963267948966, -imag);
            } else if (real == 1.0 && ay < CM_SQRT_DBL_MIN) {
                if (ay == 0.0) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                rreal = -Math.log(Math.sqrt(ay) / Math.sqrt(Math.hypot(ay, 2.0)));
                rimag = Math.copySign(Math.atan2(2.0, -ay) / 2.0, imag);
            } else {
                rreal = Math.log1p(4.0 * real / ((1.0 - real) * (1.0 - real) + ay * ay)) / 4.0;
                rimag = -Math.atan2(-2.0 * imag, (1.0 - real) * (1.0 + real) - ay * ay) / 2.0;
            }
            return this.factory().createComplex(resultScale * rreal, resultScale * rimag);
        }

        static AtanhNode create() {
            return CmathModuleBuiltinsFactory.AtanhNodeFactory.create();
        }
    }

    @Builtin(name="atan", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AtanNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private AtanhNode atanhNode = AtanhNode.create();

        AtanNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            PComplex s = this.atanhNode.executeComplex(frame, this.factory().createComplex(-imag, real));
            return this.factory().createComplex(s.getImag(), -s.getReal());
        }
    }

    @Builtin(name="asinh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsinhNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private SqrtNode sqrtNode = SqrtNode.create();
        @Node.Child
        private MathModuleBuiltins.AsinhNode realAsinhNode = MathModuleBuiltins.AsinhNode.create();
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(-0.0, -0.0), CmathModuleBuiltins.C(-0.0, 0.0), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, -0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AsinhNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double rimag;
            double rreal;
            PComplex result = CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (Math.abs(real) > 4.4942328371557893E307 || Math.abs(imag) > 4.4942328371557893E307) {
                double s = Math.log(Math.hypot(real / 2.0, imag / 2.0)) + 1.3862943611198906;
                rreal = imag >= 0.0 ? Math.copySign(s, real) : -Math.copySign(s, -real);
                rimag = Math.atan2(imag, Math.abs(real));
            } else {
                PComplex s1 = this.sqrtNode.executeComplex(frame, this.factory().createComplex(1.0 + imag, -real));
                PComplex s2 = this.sqrtNode.executeComplex(frame, this.factory().createComplex(1.0 - imag, real));
                rreal = this.realAsinhNode.executeObject(frame, s1.getReal() * s2.getImag() - s2.getReal() * s1.getImag());
                rimag = Math.atan2(imag, s1.getReal() * s2.getReal() - s1.getImag() * s2.getImag());
            }
            return this.factory().createComplex(rreal, rimag);
        }

        static AsinhNode create() {
            return CmathModuleBuiltinsFactory.AsinhNodeFactory.create();
        }
    }

    @Builtin(name="asin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AsinNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private AsinhNode asinhNode = AsinhNode.create();

        AsinNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            PComplex s = this.asinhNode.executeComplex(frame, this.factory().createComplex(-imag, real));
            return this.factory().createComplex(s.getImag(), -s.getReal());
        }
    }

    @Builtin(name="acosh", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AcoshNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private SqrtNode sqrtNode = SqrtNode.create();
        @Node.Child
        private MathModuleBuiltins.AsinhNode realAsinhNode = MathModuleBuiltins.AsinhNode.create();
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(0.0, -1.5707963267948966), CmathModuleBuiltins.C(0.0, 1.5707963267948966), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AcoshNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double rimag;
            double rreal;
            PComplex result = CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (Math.abs(real) > 4.4942328371557893E307 || Math.abs(imag) > 4.4942328371557893E307) {
                rreal = Math.log(Math.hypot(real / 2.0, imag / 2.0)) + 1.3862943611198906;
                rimag = Math.atan2(imag, real);
            } else {
                PComplex s1 = this.sqrtNode.executeComplex(frame, this.factory().createComplex(real - 1.0, imag));
                PComplex s2 = this.sqrtNode.executeComplex(frame, this.factory().createComplex(real + 1.0, imag));
                rreal = this.realAsinhNode.executeObject(frame, s1.getReal() * s2.getReal() + s1.getImag() * s2.getImag());
                rimag = 2.0 * Math.atan2(s1.getImag(), s2.getReal());
            }
            return this.factory().createComplex(rreal, rimag);
        }
    }

    @Builtin(name="acos", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class AcosNode
    extends CmathComplexUnaryBuiltinNode {
        @Node.Child
        private SqrtNode sqrtNode = SqrtNode.create();
        @Node.Child
        private MathModuleBuiltins.AsinhNode realAsinhNode = MathModuleBuiltins.AsinhNode.create();
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(2.356194490192345, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Math.PI, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(2.356194490192345, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, CmathModuleBuiltins.C(1.5707963267948966, 0.0), CmathModuleBuiltins.C(1.5707963267948966, -0.0), null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(1.5707963267948966, Double.NaN)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, CmathModuleBuiltins.C(1.5707963267948966, 0.0), CmathModuleBuiltins.C(1.5707963267948966, -0.0), null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(1.5707963267948966, Double.NaN)}, {CmathModuleBuiltins.C(1.5707963267948966, Double.POSITIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(1.5707963267948966, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.7853981633974483, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.7853981633974483, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY)}, {CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        AcosNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double rimag;
            double rreal;
            PComplex result = CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (Math.abs(real) > 4.4942328371557893E307 || Math.abs(imag) > 4.4942328371557893E307) {
                rreal = Math.atan2(Math.abs(imag), real);
                double s = Math.log(Math.hypot(real / 2.0, imag / 2.0)) + 1.3862943611198906;
                rimag = real < 0.0 ? -Math.copySign(s, imag) : Math.copySign(s, -imag);
            } else {
                PComplex s1 = this.sqrtNode.executeComplex(frame, this.factory().createComplex(1.0 - real, -imag));
                PComplex s2 = this.sqrtNode.executeComplex(frame, this.factory().createComplex(1.0 + real, imag));
                rreal = 2.0 * Math.atan2(s1.getReal(), s2.getReal());
                rimag = this.realAsinhNode.executeObject(frame, s2.getReal() * s1.getImag() - s2.getImag() * s1.getReal());
            }
            return this.factory().createComplex(rreal, rimag);
        }
    }

    @Builtin(name="sqrt", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SqrtNode
    extends CmathComplexUnaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(0.0, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.POSITIVE_INFINITY)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        SqrtNode() {
        }

        @Override
        PComplex compute(VirtualFrame frame, double real, double imag) {
            double s;
            PComplex result = CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, real, imag);
            if (result != null) {
                return result;
            }
            if (real == 0.0 && imag == 0.0) {
                return this.factory().createComplex(0.0, imag);
            }
            double ax = Math.abs(real);
            double ay = Math.abs(imag);
            if (ax < Double.MIN_NORMAL && ay < Double.MIN_NORMAL && (ax > 0.0 || ay > 0.0)) {
                double scaleUp = 9.007199254740992E15;
                double scaleDown = 7.450580596923828E-9;
                s = Math.sqrt((ax *= 9.007199254740992E15) + Math.hypot(ax, ay * 9.007199254740992E15)) * 7.450580596923828E-9;
            } else {
                s = 2.0 * Math.sqrt((ax /= 8.0) + Math.hypot(ax, ay / 8.0));
            }
            double d = ay / (2.0 * s);
            if (real >= 0.0) {
                return this.factory().createComplex(s, Math.copySign(d, imag));
            }
            return this.factory().createComplex(d, Math.copySign(s, imag));
        }

        static SqrtNode create() {
            return CmathModuleBuiltinsFactory.SqrtNodeFactory.create();
        }
    }

    @Builtin(name="log10", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class Log10Node
    extends PythonUnaryBuiltinNode {
        @Node.Child
        LogNode logNode = LogNode.create();

        Log10Node() {
        }

        @Specialization
        PComplex doComplex(VirtualFrame frame, PComplex z) {
            PComplex r = this.logNode.executeComplex(frame, z, PNone.NO_VALUE);
            return this.factory().createComplex(r.getReal() / 2.302585092994046, r.getImag() / 2.302585092994046);
        }

        @Specialization
        PComplex doGeneral(VirtualFrame frame, Object zObj, @Cached CoerceToComplexNode coerceXToComplex) {
            return this.doComplex(frame, coerceXToComplex.execute(frame, zObj));
        }
    }

    @Builtin(name="log", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class LogNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Math.PI), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 2.356194490192345), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -Math.PI), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, Math.PI), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -1.5707963267948966), null, null, null, null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 1.5707963267948966), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.7853981633974483), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        LogNode() {
        }

        abstract PComplex executeComplex(VirtualFrame var1, Object var2, Object var3);

        static LogNode create() {
            return CmathModuleBuiltinsFactory.LogNodeFactory.create();
        }

        @Specialization(guards={"isNoValue(y)"})
        PComplex doComplexNone(PComplex x, PNone y) {
            return this.log(x);
        }

        @Specialization
        PComplex doComplexComplex(VirtualFrame frame, PComplex x, PComplex y, @Cached.Shared @Cached ComplexBuiltins.DivNode divNode) {
            return divNode.executeComplex(frame, this.log(x), this.log(y));
        }

        @Specialization(guards={"isNoValue(yObj)"})
        PComplex doGeneral(VirtualFrame frame, Object xObj, PNone yObj, @Cached.Shared @Cached CoerceToComplexNode coerceXToComplex) {
            return this.log(coerceXToComplex.execute(frame, xObj));
        }

        @Specialization(guards={"!isNoValue(yObj)"})
        PComplex doGeneral(VirtualFrame frame, Object xObj, Object yObj, @Cached.Shared @Cached CoerceToComplexNode coerceXToComplex, @Cached.Exclusive @Cached CoerceToComplexNode coerceYToComplex, @Cached.Shared @Cached ComplexBuiltins.DivNode divNode) {
            PComplex x = this.log(coerceXToComplex.execute(frame, xObj));
            PComplex y = this.log(coerceYToComplex.execute(frame, yObj));
            return divNode.executeComplex(frame, x, y);
        }

        private PComplex log(PComplex z) {
            PComplex r = CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, z.getReal(), z.getImag());
            if (r != null) {
                return r;
            }
            double real = this.computeRealPart(z.getReal(), z.getImag());
            double imag = Math.atan2(z.getImag(), z.getReal());
            return this.factory().createComplex(real, imag);
        }

        @CompilerDirectives.TruffleBoundary
        private double computeRealPart(double real, double imag) {
            double ax = Math.abs(real);
            double ay = Math.abs(imag);
            if (ax > 4.4942328371557893E307 || ay > 4.4942328371557893E307) {
                return Math.log(Math.hypot(ax / 2.0, ay / 2.0)) + 0.6931471805599453;
            }
            if (ax < Double.MIN_NORMAL && ay < Double.MIN_NORMAL) {
                if (ax > 0.0 || ay > 0.0) {
                    double scaleUp = 9.007199254740992E15;
                    return Math.log(Math.hypot(ax * 9.007199254740992E15, ay * 9.007199254740992E15)) - 36.7368005696771;
                }
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
            }
            double h = Math.hypot(ax, ay);
            if (0.71 <= h && h <= 1.73) {
                double am = Math.max(ax, ay);
                double an = Math.min(ax, ay);
                return Math.log1p((am - 1.0) * (am + 1.0) + an * an) / 2.0;
            }
            return Math.log(h);
        }
    }

    @Builtin(name="rect", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class RectNode
    extends PythonBinaryBuiltinNode {
        @CompilerDirectives.CompilationFinal(dimensions=2)
        private static final ComplexConstant[][] SPECIAL_VALUES = new ComplexConstant[][]{{CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, 0.0), CmathModuleBuiltins.C(Double.NEGATIVE_INFINITY, -0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(-0.0, 0.0), CmathModuleBuiltins.C(-0.0, -0.0), null, CmathModuleBuiltins.C(0.0, 0.0), CmathModuleBuiltins.C(0.0, 0.0)}, {CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, -0.0), CmathModuleBuiltins.C(0.0, 0.0), null, CmathModuleBuiltins.C(0.0, 0.0), CmathModuleBuiltins.C(0.0, 0.0)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), null, null, null, null, CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}, {CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, -0.0), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, 0.0), null, CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN), CmathModuleBuiltins.C(Double.POSITIVE_INFINITY, Double.NaN)}, {CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, 0.0), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN), CmathModuleBuiltins.C(Double.NaN, Double.NaN)}};

        RectNode() {
        }

        @Specialization
        PComplex doLL(long r, long phi) {
            return this.rect(r, phi);
        }

        @Specialization
        PComplex doLD(long r, double phi) {
            return this.rect(r, phi);
        }

        @Specialization
        PComplex doDL(double r, long phi) {
            return this.rect(r, phi);
        }

        @Specialization
        PComplex doDD(double r, double phi) {
            return this.rect(r, phi);
        }

        @Specialization
        PComplex doGeneral(VirtualFrame frame, Object r, Object phi, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode rAsDoubleNode, @Cached PyFloatAsDoubleNode phiAsDoubleNode) {
            return this.rect(rAsDoubleNode.execute(frame, inliningTarget, r), phiAsDoubleNode.execute(frame, inliningTarget, phi));
        }

        @CompilerDirectives.TruffleBoundary
        private PComplex rect(double r, double phi) {
            if (!Double.isFinite(r) || !Double.isFinite(phi)) {
                if (r != 0.0 && !Double.isNaN(r) && Double.isInfinite(phi)) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.MATH_DOMAIN_ERROR);
                }
                if (Double.isInfinite(r) && Double.isFinite(phi) && phi != 0.0) {
                    double real = Math.copySign(Double.POSITIVE_INFINITY, Math.cos(phi));
                    double imag = Math.copySign(Double.POSITIVE_INFINITY, Math.sin(phi));
                    if (r > 0.0) {
                        return this.factory().createComplex(real, imag);
                    }
                    return this.factory().createComplex(-real, -imag);
                }
                return CmathModuleBuiltins.specialValue(this.factory(), SPECIAL_VALUES, r, phi);
            }
            return this.factory().createComplex(r * Math.cos(phi), r * Math.sin(phi));
        }
    }

    @Builtin(name="polar", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class PolarNode
    extends PythonUnaryBuiltinNode {
        PolarNode() {
        }

        @Specialization
        PTuple doL(long value) {
            return this.doD(value);
        }

        @Specialization
        PTuple doD(double value) {
            return this.factory().createTuple(new Object[]{Math.abs(value), value < 0.0 ? Math.PI : 0.0});
        }

        @Specialization
        PTuple doC(PComplex value, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode) {
            return this.toPolar(value, absNode);
        }

        @Specialization
        PTuple doGeneral(VirtualFrame frame, Object value, @Cached CoerceToComplexNode coerceToComplex, @Cached.Shared @Cached ComplexBuiltins.AbsNode absNode) {
            return this.toPolar(coerceToComplex.execute(frame, value), absNode);
        }

        private PTuple toPolar(PComplex value, ComplexBuiltins.AbsNode absNode) {
            double r = absNode.executeDouble(value);
            return this.factory().createTuple(new Object[]{r, Math.atan2(value.getImag(), value.getReal())});
        }
    }

    @Builtin(name="phase", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @GenerateNodeFactory
    static abstract class PhaseNode
    extends PythonUnaryBuiltinNode {
        PhaseNode() {
        }

        @Specialization
        double doL(long value) {
            return value < 0L ? Math.PI : 0.0;
        }

        @Specialization
        double doD(double value) {
            return value < 0.0 ? Math.PI : 0.0;
        }

        @Specialization
        double doC(PComplex value) {
            return Math.atan2(value.getImag(), value.getReal());
        }

        @Specialization
        double doGeneral(VirtualFrame frame, Object value, @Cached CoerceToComplexNode coerceToComplex) {
            return this.doC(coerceToComplex.execute(frame, value));
        }
    }

    @Builtin(name="isfinite", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsFiniteNode
    extends CmathBooleanUnaryBuiltinNode {
        IsFiniteNode() {
        }

        @Override
        boolean compute(double real, double imag) {
            return Double.isFinite(real) && Double.isFinite(imag);
        }
    }

    @Builtin(name="isinf", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsInfNode
    extends CmathBooleanUnaryBuiltinNode {
        IsInfNode() {
        }

        @Override
        boolean compute(double real, double imag) {
            return Double.isInfinite(real) || Double.isInfinite(imag);
        }
    }

    @Builtin(name="isnan", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsNanNode
    extends CmathBooleanUnaryBuiltinNode {
        IsNanNode() {
        }

        @Override
        boolean compute(double real, double imag) {
            return Double.isNaN(real) || Double.isNaN(imag);
        }
    }

    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    static abstract class CmathBooleanUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        CmathBooleanUnaryBuiltinNode() {
        }

        boolean compute(double real, double imag) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not be reached");
        }

        @Specialization
        boolean doL(long value) {
            return this.compute(value, 0.0);
        }

        @Specialization
        boolean doD(double value) {
            return this.compute(value, 0.0);
        }

        @Specialization
        boolean doC(PComplex value) {
            return this.compute(value.getReal(), value.getImag());
        }

        @Specialization
        boolean doGeneral(VirtualFrame frame, Object value, @Cached CoerceToComplexNode coerceToComplex) {
            return this.doC(coerceToComplex.execute(frame, value));
        }
    }

    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    static abstract class CmathComplexUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        CmathComplexUnaryBuiltinNode() {
        }

        public abstract PComplex executeComplex(VirtualFrame var1, Object var2);

        PComplex compute(VirtualFrame frame, double real, double imag) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw new IllegalStateException("should not be reached");
        }

        @Specialization
        PComplex doL(VirtualFrame frame, long value) {
            return this.compute(frame, value, 0.0);
        }

        @Specialization
        PComplex doD(VirtualFrame frame, double value) {
            return this.compute(frame, value, 0.0);
        }

        @Specialization
        PComplex doC(VirtualFrame frame, PComplex value) {
            return this.compute(frame, value.getReal(), value.getImag());
        }

        @Specialization
        PComplex doGeneral(VirtualFrame frame, Object value, @Cached CoerceToComplexNode coerceToComplex) {
            return this.doC(frame, coerceToComplex.execute(frame, value));
        }
    }
}

