/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.CodecsTruffleModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.codecs.CharmapNodes;
import com.oracle.graal.python.builtins.modules.codecs.CodecsRegistry;
import com.oracle.graal.python.builtins.modules.codecs.ErrorHandlers;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuffer;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.UnicodeErrorBuiltins;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyLongAsIntNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.util.List;

@CoreFunctions(defineModule="_codecs")
public final class CodecsModuleBuiltins
extends PythonBuiltins {
    public static final TruffleString T_UTF_7 = PythonUtils.tsLiteral("utf-7");
    public static final TruffleString T_UTF_16 = PythonUtils.tsLiteral("utf-16");
    public static final TruffleString T_UTF_16_LE = PythonUtils.tsLiteral("utf-16-le");
    public static final TruffleString T_UTF_16_BE = PythonUtils.tsLiteral("utf-16-be");
    public static final TruffleString T_UTF_32 = PythonUtils.tsLiteral("utf-32");
    public static final TruffleString T_UTF_32_LE = PythonUtils.tsLiteral("utf-32-le");
    public static final TruffleString T_UTF_32_BE = PythonUtils.tsLiteral("utf-32-be");
    public static final TruffleString T_RAW_UNICODE_ESCAPE = PythonUtils.tsLiteral("raw_unicode_escape");
    public static final TruffleString T_UNICODE_ESCAPE = PythonUtils.tsLiteral("unicode_escape");
    public static final TruffleString T_LATIN_1 = PythonUtils.tsLiteral("latin_1");

    public static CodingErrorAction convertCodingErrorAction(TruffleString errors, TruffleString.EqualNode equalNode) {
        if (equalNode.execute((AbstractTruffleString)StringLiterals.T_IGNORE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
            return CodingErrorAction.IGNORE;
        }
        if (equalNode.execute((AbstractTruffleString)StringLiterals.T_REPLACE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING) || equalNode.execute((AbstractTruffleString)StringLiterals.T_NAMEREPLACE, (AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
            return CodingErrorAction.REPLACE;
        }
        return CodingErrorAction.REPORT;
    }

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CodecsModuleBuiltinsFactory.getFactories();
    }

    private static boolean hasTruffleEncodingNormalized(TruffleString normalizedEncoding) {
        return CharsetMapping.getCharsetNormalized(normalizedEncoding) != null;
    }

    private static boolean isTupleInstanceCheck(VirtualFrame frame, Node inliningTarget, Object result, int len, PyObjectTypeCheck typeCheck, PyObjectSizeNode sizeNode) throws PException {
        return typeCheck.execute(inliningTarget, result, (Object)PythonBuiltinClassType.PTuple) && sizeNode.execute((Frame)frame, inliningTarget, result) == len;
    }

    private static void ensureRegistryInitialized(PythonContext context) {
        CodecsRegistry.ensureRegistryInitialized(context);
    }

    private static Object codec_getItem(VirtualFrame frame, TruffleString encoding, int index, LookupNode lookupNode, SequenceStorageNodes.GetItemNode getItemNode) {
        PTuple t = (PTuple)lookupNode.execute(frame, encoding);
        return getItemNode.execute(t.getSequenceStorage(), index);
    }

    private static Object encoder(VirtualFrame frame, TruffleString encoding, LookupNode lookupNode, SequenceStorageNodes.GetItemNode getItemNode) {
        return CodecsModuleBuiltins.codec_getItem(frame, encoding, 0, lookupNode, getItemNode);
    }

    private static Object decoder(VirtualFrame frame, TruffleString encoding, LookupNode lookupNode, SequenceStorageNodes.GetItemNode getItemNode) {
        return CodecsModuleBuiltins.codec_getItem(frame, encoding, 1, lookupNode, getItemNode);
    }

    @Builtin(name="lookup", minNumOfPositionalArgs=1, parameterNames={"encoding"})
    @ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class LookupNode
    extends PythonUnaryClinicBuiltinNode {
        LookupNode() {
        }

        @Specialization
        static PTuple lookup(VirtualFrame frame, TruffleString encoding, @Bind(value="this") Node inliningTarget, @Cached PyCodecLookupNode lookup) {
            return lookup.execute((Frame)frame, inliningTarget, encoding);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.LookupNodeClinicProviderGen.INSTANCE;
        }
    }

    static class TruffleDecoder {
        private final TruffleString encodingName;
        private final CharsetDecoder decoder;
        private final ByteBuffer inputBuffer;
        private CharBuffer outputBuffer;
        private CoderResult coderResult;

        @CompilerDirectives.TruffleBoundary
        public TruffleDecoder(TruffleString encodingName, Charset charset, byte[] input, int inputLen, CodingErrorAction errorAction) {
            this.encodingName = encodingName;
            this.inputBuffer = ByteBuffer.wrap(input, 0, inputLen);
            this.decoder = charset.newDecoder().onMalformedInput(errorAction).onUnmappableCharacter(errorAction);
            this.outputBuffer = CharBuffer.allocate((int)((float)inputLen * this.decoder.averageCharsPerByte()));
        }

        @CompilerDirectives.TruffleBoundary
        public boolean decodingStep(boolean finalData) {
            while (true) {
                this.coderResult = this.decoder.decode(this.inputBuffer, this.outputBuffer, finalData);
                if (finalData && this.coderResult.isUnderflow()) {
                    this.coderResult = this.decoder.flush(this.outputBuffer);
                }
                if (this.coderResult.isUnderflow()) {
                    this.outputBuffer.flip();
                    return true;
                }
                if (this.coderResult.isOverflow()) {
                    this.grow();
                    continue;
                }
                if (this.coderResult.isError()) break;
            }
            return false;
        }

        private void grow() {
            int newCapacity = 2 * this.outputBuffer.capacity() + 1;
            if (newCapacity < 0) {
                throw new OutOfMemoryError();
            }
            CharBuffer newBuffer = CharBuffer.allocate(newCapacity);
            this.outputBuffer.flip();
            newBuffer.put(this.outputBuffer);
            this.outputBuffer = newBuffer;
        }

        @CompilerDirectives.TruffleBoundary
        private TruffleString getErrorReason() {
            if (this.coderResult.isMalformed()) {
                return ErrorMessages.MALFORMED_INPUT;
            }
            if (this.coderResult.isUnmappable()) {
                return ErrorMessages.UNMAPPABLE_CHARACTER;
            }
            throw new IllegalArgumentException("Unicode error constructed from non-error result");
        }

        @CompilerDirectives.TruffleBoundary
        public int getInputRemaining() {
            return this.inputBuffer.remaining();
        }

        @CompilerDirectives.TruffleBoundary
        public byte[] getInputBytes(int num) {
            byte[] bytes = new byte[num];
            int pos = this.inputBuffer.position();
            this.inputBuffer.get(bytes);
            this.inputBuffer.position(pos);
            return bytes;
        }

        @CompilerDirectives.TruffleBoundary
        public TruffleString getString() {
            return PythonUtils.toTruffleStringUncached(this.outputBuffer.toString());
        }

        @CompilerDirectives.TruffleBoundary
        public int getInputPosition() {
            return this.inputBuffer.position();
        }

        @CompilerDirectives.TruffleBoundary
        public int getErrorLength() {
            return this.coderResult.length();
        }

        public void replace(int skipInput, char[] chars) {
            this.replace(skipInput, chars, 0, chars.length);
        }

        @CompilerDirectives.TruffleBoundary
        public void replace(int skipInput, char[] chars, int offset, int length) {
            while (this.outputBuffer.remaining() < chars.length) {
                this.grow();
            }
            this.outputBuffer.put(chars, offset, length);
            this.inputBuffer.position(this.inputBuffer.position() + skipInput);
        }

        public TruffleString getEncodingName() {
            return this.encodingName;
        }
    }

    static class TruffleEncoder {
        private final TruffleString encodingName;
        private final CharsetEncoder encoder;
        private CharBuffer inputBuffer;
        private ByteBuffer outputBuffer;
        private CoderResult coderResult;

        @CompilerDirectives.TruffleBoundary
        public TruffleEncoder(TruffleString encodingName, Charset charset, String input, CodingErrorAction errorAction) {
            this.encodingName = encodingName;
            this.inputBuffer = CharBuffer.wrap(input);
            this.encoder = charset.newEncoder().onMalformedInput(errorAction).onUnmappableCharacter(errorAction);
            this.outputBuffer = ByteBuffer.allocate((int)((float)input.length() * this.encoder.averageBytesPerChar()));
        }

        @CompilerDirectives.TruffleBoundary
        public boolean encodingStep() {
            while (true) {
                this.coderResult = this.encoder.encode(this.inputBuffer, this.outputBuffer, true);
                if (this.coderResult.isUnderflow()) {
                    this.coderResult = this.encoder.flush(this.outputBuffer);
                }
                if (this.coderResult.isUnderflow()) {
                    this.outputBuffer.flip();
                    return true;
                }
                if (this.coderResult.isOverflow()) {
                    this.grow();
                    continue;
                }
                if (this.coderResult.isError()) break;
            }
            return false;
        }

        private void grow() {
            int newCapacity = 2 * this.outputBuffer.capacity() + 1;
            if (newCapacity < 0) {
                throw new OutOfMemoryError();
            }
            ByteBuffer newBuffer = ByteBuffer.allocate(newCapacity);
            this.outputBuffer.flip();
            newBuffer.put(this.outputBuffer);
            this.outputBuffer = newBuffer;
        }

        @CompilerDirectives.TruffleBoundary
        private TruffleString getErrorReason() {
            if (this.coderResult.isMalformed()) {
                return ErrorMessages.MALFORMED_INPUT;
            }
            if (this.coderResult.isUnmappable()) {
                return ErrorMessages.UNMAPPABLE_CHARACTER;
            }
            throw new IllegalArgumentException("Unicode error constructed from non-error result");
        }

        @CompilerDirectives.TruffleBoundary
        public int getInputPosition() {
            return this.inputBuffer.position();
        }

        @CompilerDirectives.TruffleBoundary
        public int getErrorLength() {
            return this.coderResult.length();
        }

        @CompilerDirectives.TruffleBoundary
        public byte[] getBytes() {
            byte[] data = new byte[this.outputBuffer.remaining()];
            this.outputBuffer.get(data);
            return data;
        }

        @CompilerDirectives.TruffleBoundary
        public int getInputRemaining() {
            return this.inputBuffer.remaining();
        }

        @CompilerDirectives.TruffleBoundary
        public char[] getInputChars(int num) {
            char[] chars = new char[num];
            int pos = this.inputBuffer.position();
            this.inputBuffer.get(chars);
            this.inputBuffer.position(pos);
            return chars;
        }

        @CompilerDirectives.TruffleBoundary
        public void replace(int skipInput, byte[] replacement, int offset, int length) {
            while (this.outputBuffer.remaining() < replacement.length) {
                this.grow();
            }
            this.outputBuffer.put(replacement, offset, length);
            this.inputBuffer.position(this.inputBuffer.position() + skipInput);
        }

        @CompilerDirectives.TruffleBoundary
        public void replace(int skipInput, String replacement) {
            this.inputBuffer.position(this.inputBuffer.position() + skipInput);
            CharBuffer newBuffer = CharBuffer.allocate(this.inputBuffer.remaining() + replacement.length());
            newBuffer.put(replacement);
            newBuffer.put(this.inputBuffer);
            newBuffer.flip();
            this.inputBuffer = newBuffer;
        }

        public TruffleString getEncodingName() {
            return this.encodingName;
        }
    }

    @Builtin(name="EncodingMap", takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PEncodingMap, isPublic=false)
    @GenerateNodeFactory
    static abstract class EncodingMapNode
    extends PythonBuiltinNode {
        EncodingMapNode() {
        }

        @Specialization
        Object encodingMap(Object args, Object kwargs) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CREATE_INSTANCES, "EncodingMap");
        }
    }

    @Builtin(name="charmap_build", minNumOfPositionalArgs=1, parameterNames={"map"})
    @ArgumentClinic(name="map", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class CharmapBuildNode
    extends PythonUnaryClinicBuiltinNode {
        CharmapBuildNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CharmapBuildNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object doIt(VirtualFrame frame, TruffleString map, @Bind(value="this") Node inliningTarget, @Cached CharmapNodes.PyUnicodeBuildEncodingMapNode buildEncodingMapNode) {
            return buildEncodingMapNode.execute(frame, inliningTarget, map);
        }
    }

    @Builtin(name="code_page_decode", minNumOfPositionalArgs=1, parameterNames={"code_page", "string", "errors", "ffinal"})
    @GenerateNodeFactory
    static abstract class CodePageDecodeNode
    extends PythonQuaternaryBuiltinNode {
        CodePageDecodeNode() {
        }

        @Specialization
        Object decode(Object code_page, Object obj, Object errors, Object ffinal) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("code_page_decode"));
        }
    }

    @Builtin(name="code_page_encode", minNumOfPositionalArgs=1, parameterNames={"code_page", "string", "errors"})
    @GenerateNodeFactory
    static abstract class CodePageEncodeNode
    extends PythonTernaryBuiltinNode {
        CodePageEncodeNode() {
        }

        @Specialization
        Object encode(Object code_page, Object string, Object errors) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("code_page_encode"));
        }
    }

    @Builtin(name="oem_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "ffinal"})
    @GenerateNodeFactory
    static abstract class OEMDecodeNode
    extends PythonTernaryBuiltinNode {
        OEMDecodeNode() {
        }

        @Specialization
        Object decode(Object obj, Object errors, Object ffinal) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("oem_decode"));
        }
    }

    @Builtin(name="oem_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class OEMEncodeNode
    extends PythonBinaryBuiltinNode {
        OEMEncodeNode() {
        }

        @Specialization
        Object encode(Object obj, Object errors) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("oem_encode"));
        }
    }

    @Builtin(name="mbcs_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "ffinal"})
    @GenerateNodeFactory
    static abstract class MBCSDecodeNode
    extends PythonTernaryBuiltinNode {
        MBCSDecodeNode() {
        }

        @Specialization
        Object decode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode, @Cached WarningsModuleBuiltins.WarnNode warnNode) {
            warnNode.execute((Frame)frame, null, (Object)PythonBuiltinClassType.RuntimeWarning, PythonUtils.toTruffleStringUncached("mbcs_decode assumes cp437"), 1, new Object[0]);
            return decode.execute(frame, obj, BuiltinNames.T_CP437, errors, ffinal);
        }
    }

    @Builtin(name="mbcs_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class MBCSEncodeNode
    extends PythonBinaryBuiltinNode {
        MBCSEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode, @Cached WarningsModuleBuiltins.WarnNode warnNode) {
            warnNode.execute((Frame)frame, null, (Object)PythonBuiltinClassType.RuntimeWarning, PythonUtils.toTruffleStringUncached("mbcs_encode assumes cp437"), 1, new Object[0]);
            return encode.execute(frame, obj, BuiltinNames.T_CP437, errors);
        }
    }

    @Builtin(name="readbuffer_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class ReadbufferEncodeNode
    extends PythonBinaryBuiltinNode {
        ReadbufferEncodeNode() {
        }

        @Specialization
        Object encode(Object obj, Object errors) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("readbuffer_encode"));
        }
    }

    @Builtin(name="charmap_decode", minNumOfPositionalArgs=1, parameterNames={"data", "errors", "mapping"})
    @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class CharmapDecodeNode
    extends PythonTernaryClinicBuiltinNode {
        CharmapDecodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CharmapDecodeNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object doIt(VirtualFrame frame, Object data, TruffleString errors, Object mapping, @CachedLibrary(value="data") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached CharmapNodes.PyUnicodeDecodeCharmapNode pyUnicodeDecodeCharmapNode) {
            int len;
            Object dataBuffer = bufferAcquireLib.acquireReadonly(data, frame, this.getContext(), this.getLanguage(), this);
            try {
                len = bufferLib.getBufferLength(dataBuffer);
            }
            finally {
                bufferLib.release(dataBuffer, frame, this);
            }
            TruffleString result = len == 0 ? StringLiterals.T_EMPTY_STRING : pyUnicodeDecodeCharmapNode.execute(frame, data, errors, mapping);
            return this.factory().createTuple(new Object[]{result, len});
        }
    }

    @Builtin(name="charmap_encode", minNumOfPositionalArgs=1, parameterNames={"str", "errors", "mapping"})
    @ArgumentsClinic(value={@ArgumentClinic(name="str", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class CharmapEncodeNode
    extends PythonTernaryClinicBuiltinNode {
        CharmapEncodeNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CharmapEncodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object doIt(VirtualFrame frame, TruffleString str, TruffleString errors, Object mapping, @Bind(value="this") Node inliningTarget, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached CharmapNodes.PyUnicodeEncodeCharmapNode encodeCharmapNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
            PBytes result = this.factory().createBytes(encodeCharmapNode.execute(frame, inliningTarget, str, errors, mapping));
            return this.factory().createTuple(new Object[]{result, len});
        }
    }

    @Builtin(name="ascii_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class AsciiDecodeNode
    extends PythonBinaryBuiltinNode {
        AsciiDecodeNode() {
        }

        @Specialization
        Object decode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, BuiltinNames.T_ASCII, errors, true);
        }
    }

    @Builtin(name="ascii_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class AsciiEscapeEncodeNode
    extends PythonBinaryBuiltinNode {
        AsciiEscapeEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, BuiltinNames.T_ASCII, errors);
        }
    }

    @Builtin(name="latin_1_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class Latin1EscapeDecodeNode
    extends PythonBinaryBuiltinNode {
        Latin1EscapeDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_LATIN_1, errors, true);
        }
    }

    @Builtin(name="latin_1_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class Latin1EscapeEncodeNode
    extends PythonBinaryBuiltinNode {
        Latin1EscapeEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_LATIN_1, errors);
        }
    }

    @Builtin(name="unicode_escape_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UnicodeEscapeDecodeNode
    extends PythonBinaryBuiltinNode {
        UnicodeEscapeDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UNICODE_ESCAPE, errors, true);
        }
    }

    @Builtin(name="unicode_escape_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    public static abstract class UnicodeEscapeEncodeNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UNICODE_ESCAPE, errors);
        }
    }

    @Builtin(name="raw_unicode_escape_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class RawUnicodeEscapeDecodeNode
    extends PythonBinaryBuiltinNode {
        RawUnicodeEscapeDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_RAW_UNICODE_ESCAPE, errors, true);
        }
    }

    @Builtin(name="raw_unicode_escape_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class RawUnicodeEscapeEncodeNode
    extends PythonBinaryBuiltinNode {
        RawUnicodeEscapeEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_RAW_UNICODE_ESCAPE, errors);
        }
    }

    @Builtin(name="unicode_internal_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UnicodeInternalDecodeNode
    extends PythonBinaryBuiltinNode {
        UnicodeInternalDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("unicode_internal_decode"));
        }
    }

    @Builtin(name="unicode_internal_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UnicodeInternalEncodeNode
    extends PythonBinaryBuiltinNode {
        UnicodeInternalEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("unicode_internal_encode"));
        }
    }

    @Builtin(name="utf_32_ex_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final", "byteorder"})
    @GenerateNodeFactory
    static abstract class UTF32EXDecodeNode
    extends PythonQuaternaryBuiltinNode {
        UTF32EXDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object byteorder, Object ffinal) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("utf_32_ex_decode"));
        }
    }

    @Builtin(name="utf_32_be_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF32BEDecodeNode
    extends PythonTernaryBuiltinNode {
        UTF32BEDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_32_BE, errors, ffinal);
        }
    }

    @Builtin(name="utf_32_be_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UTF32BEEncodeNode
    extends PythonBinaryBuiltinNode {
        UTF32BEEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_32_BE, errors);
        }
    }

    @Builtin(name="utf_32_le_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF32LEDecodeNode
    extends PythonTernaryBuiltinNode {
        UTF32LEDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_32_LE, errors, ffinal);
        }
    }

    @Builtin(name="utf_32_le_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UTF32LEEncodeNode
    extends PythonBinaryBuiltinNode {
        UTF32LEEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_32_LE, errors);
        }
    }

    @Builtin(name="utf_32_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF32DecodeNode
    extends PythonTernaryBuiltinNode {
        UTF32DecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_32, errors, ffinal);
        }
    }

    @Builtin(name="utf_32_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "byteorder"})
    @GenerateNodeFactory
    static abstract class UTF32EncodeNode
    extends PythonTernaryBuiltinNode {
        UTF32EncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object byteorder, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_32, errors);
        }
    }

    @Builtin(name="utf_16_ex_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "byteorder", "final"})
    @GenerateNodeFactory
    static abstract class UTF16EXDecodeNode
    extends PythonQuaternaryBuiltinNode {
        UTF16EXDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object byteorder, Object ffinal) {
            throw this.raise(PythonBuiltinClassType.NotImplementedError, PythonUtils.toTruffleStringUncached("utf_16_ex_decode"));
        }
    }

    @Builtin(name="utf_16_be_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF16BEDecodeNode
    extends PythonTernaryBuiltinNode {
        UTF16BEDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_16_BE, errors, ffinal);
        }
    }

    @Builtin(name="utf_16_be_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UTF16BEEncodeNode
    extends PythonBinaryBuiltinNode {
        UTF16BEEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_16_BE, errors);
        }
    }

    @Builtin(name="utf_16_le_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF16LEDecodeNode
    extends PythonTernaryBuiltinNode {
        UTF16LEDecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_16_LE, errors, ffinal);
        }
    }

    @Builtin(name="utf_16_le_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UTF16LEEncodeNode
    extends PythonBinaryBuiltinNode {
        UTF16LEEncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_16_LE, errors);
        }
    }

    @Builtin(name="utf_16_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF16DecodeNode
    extends PythonTernaryBuiltinNode {
        UTF16DecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_16, errors, ffinal);
        }
    }

    @Builtin(name="utf_16_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "byteorder"})
    @GenerateNodeFactory
    static abstract class UTF16EncodeNode
    extends PythonTernaryBuiltinNode {
        UTF16EncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object byteorder, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_16, errors);
        }
    }

    @Builtin(name="utf_7_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF7DecodeNode
    extends PythonTernaryBuiltinNode {
        UTF7DecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, T_UTF_7, errors, ffinal);
        }
    }

    @Builtin(name="utf_7_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UTF7EncodeNode
    extends PythonBinaryBuiltinNode {
        UTF7EncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, T_UTF_7, errors);
        }
    }

    @Builtin(name="utf_8_decode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors", "final"})
    @GenerateNodeFactory
    static abstract class UTF8DecodeNode
    extends PythonTernaryBuiltinNode {
        UTF8DecodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, Object ffinal, @Cached CodecsDecodeNode decode) {
            return decode.execute(frame, obj, StringLiterals.T_UTF8, errors, ffinal);
        }
    }

    @Builtin(name="utf_8_encode", minNumOfPositionalArgs=1, parameterNames={"obj", "errors"})
    @GenerateNodeFactory
    static abstract class UTF8EncodeNode
    extends PythonBinaryBuiltinNode {
        UTF8EncodeNode() {
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, Object errors, @Cached CodecsEncodeNode encode) {
            return encode.execute(frame, obj, StringLiterals.T_UTF8, errors);
        }
    }

    @Builtin(name="decode", minNumOfPositionalArgs=1, parameterNames={"obj", "encoding", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_UTF8"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    public static abstract class DecodeNode
    extends PythonTernaryClinicBuiltinNode {
        public abstract Object executeWithStrings(VirtualFrame var1, Object var2, TruffleString var3, TruffleString var4);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.DecodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object decode(VirtualFrame frame, Object obj, TruffleString encoding, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached SequenceStorageNodes.GetItemNode getResultItemNode, @Cached LookupNode lookupNode, @Cached CallBinaryMethodNode callEncoderNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectTypeCheck typeCheck, @Cached InlinedConditionProfile isTupleProfile) {
            Object decoder = CodecsModuleBuiltins.decoder(frame, encoding, lookupNode, getItemNode);
            Object result = callEncoderNode.executeObject(decoder, obj, errors);
            if (isTupleProfile.profile(inliningTarget, !CodecsModuleBuiltins.isTupleInstanceCheck(frame, inliningTarget, result, 2, typeCheck, sizeNode))) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_MUST_RETURN_TUPLE, "decoder");
            }
            return getResultItemNode.execute(((PTuple)result).getSequenceStorage(), 0);
        }
    }

    @Builtin(name="encode", minNumOfPositionalArgs=1, parameterNames={"obj", "encoding", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_UTF8"), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT")})
    @GenerateNodeFactory
    public static abstract class EncodeNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.EncodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object encode(VirtualFrame frame, Object obj, TruffleString encoding, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached SequenceStorageNodes.GetItemNode getResultItemNode, @Cached LookupNode lookupNode, @Cached CallBinaryMethodNode callEncoderNode, @Cached PyObjectSizeNode sizeNode, @Cached PyObjectTypeCheck typeCheck, @Cached InlinedConditionProfile isTupleProfile) {
            Object encoder = CodecsModuleBuiltins.encoder(frame, encoding, lookupNode, getItemNode);
            Object result = callEncoderNode.executeObject(encoder, obj, errors);
            if (isTupleProfile.profile(inliningTarget, !CodecsModuleBuiltins.isTupleInstanceCheck(frame, inliningTarget, result, 2, typeCheck, sizeNode))) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.S_MUST_RETURN_TUPLE, "encoder");
            }
            return getResultItemNode.execute(((PTuple)result).getSequenceStorage(), 0);
        }
    }

    @Builtin(name="lookup_error", minNumOfPositionalArgs=1, parameterNames={"name"})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class LookupErrorNode
    extends PythonUnaryClinicBuiltinNode {
        LookupErrorNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.LookupErrorNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object lookup(TruffleString name, @Bind(value="this") Node inliningTarget, @Cached CodecsRegistry.PyCodecLookupErrorNode errorNode) {
            return errorNode.execute(inliningTarget, name);
        }
    }

    @Builtin(name="register_error", minNumOfPositionalArgs=2, parameterNames={"name", "handler"})
    @ArgumentClinic(name="name", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class RegisterErrorNode
    extends PythonBinaryClinicBuiltinNode {
        RegisterErrorNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.RegisterErrorNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        Object register(TruffleString name, Object handler, @Bind(value="this") Node inliningTarget, @Cached CodecsRegistry.PyCodecRegisterErrorNode registerErrorNode) {
            registerErrorNode.execute(inliningTarget, name, handler);
            return PNone.NONE;
        }
    }

    @Builtin(name="_forget_codec", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ForgetCodecNode
    extends PythonUnaryBuiltinNode {
        ForgetCodecNode() {
        }

        @Specialization
        Object forget(VirtualFrame frame, PBytesLike encoding, @Cached AsciiDecodeNode asciiDecodeNode) {
            this.forget((TruffleString)((PTuple)asciiDecodeNode.execute(frame, encoding, PNone.NO_VALUE)).getSequenceStorage().getInternalArray()[0]);
            return PNone.NONE;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object forget(TruffleString encoding) {
            PythonContext.get(this).getCodecSearchCache().remove(encoding);
            return PNone.NONE;
        }
    }

    @Builtin(name="unregister", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class UnregisterNode
    extends PythonUnaryBuiltinNode {
        UnregisterNode() {
        }

        @Specialization
        Object unregister(Object searchFunction) {
            PythonContext context = PythonContext.get(this);
            UnregisterNode.remove(context, searchFunction);
            return PNone.NONE;
        }

        @CompilerDirectives.TruffleBoundary
        private static void remove(PythonContext context, Object searchFunction) {
            context.getCodecSearchPath().remove(searchFunction);
            context.getCodecSearchCache().clear();
        }
    }

    @Builtin(name="register", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class RegisterNode
    extends PythonUnaryBuiltinNode {
        RegisterNode() {
        }

        @Specialization
        Object lookup(Object searchFunction, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheckNode) {
            if (callableCheckNode.execute(inliningTarget, searchFunction)) {
                PythonContext context = PythonContext.get(this);
                CodecsModuleBuiltins.ensureRegistryInitialized(context);
                RegisterNode.add(context, searchFunction);
                return PNone.NONE;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.ARG_MUST_BE_CALLABLE);
        }

        @CompilerDirectives.TruffleBoundary
        private static void add(PythonContext context, Object searchFunction) {
            context.getCodecSearchPath().add(searchFunction);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyCodecLookupNode
    extends PNodeWithContext {
        public abstract PTuple execute(Frame var1, Node var2, TruffleString var3);

        @Specialization
        static PTuple lookup(VirtualFrame frame, Node inliningTarget, TruffleString encoding, @Cached(inline=false) CallUnaryMethodNode callNode, @Cached PyObjectTypeCheck typeCheck, @Cached(inline=false) PyObjectSizeNode sizeNode, @Cached InlinedConditionProfile hasSearchPathProfile, @Cached InlinedConditionProfile hasTruffleEncodingProfile, @Cached InlinedConditionProfile isTupleProfile, @Cached CharsetMapping.NormalizeEncodingNameNode normalizeEncodingNameNode, @Cached PRaiseNode.Lazy raiseNode) {
            TruffleString normalizedEncoding = normalizeEncodingNameNode.execute(inliningTarget, encoding);
            PythonContext context = PythonContext.get(inliningTarget);
            CodecsModuleBuiltins.ensureRegistryInitialized(context);
            PTuple result = PyCodecLookupNode.getSearchPath(context, normalizedEncoding);
            if (hasSearchPathProfile.profile(inliningTarget, result != null)) {
                return result;
            }
            if (hasTruffleEncodingProfile.profile(inliningTarget, CodecsModuleBuiltins.hasTruffleEncodingNormalized(normalizedEncoding))) {
                PythonModule codecs = context.lookupBuiltinModule(BuiltinNames.T__CODECS_TRUFFLE);
                result = CodecsTruffleModuleBuiltins.codecsInfo(codecs, encoding, context, context.factory());
            } else {
                Object[] searchPaths;
                for (Object func : searchPaths = PyCodecLookupNode.getSearchPaths(context)) {
                    Object obj = callNode.executeObject(func, normalizedEncoding);
                    if (obj == PNone.NONE) continue;
                    if (isTupleProfile.profile(inliningTarget, !CodecsModuleBuiltins.isTupleInstanceCheck(frame, inliningTarget, obj, 4, typeCheck, sizeNode))) {
                        throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.CODEC_SEARCH_MUST_RETURN_4);
                    }
                    result = (PTuple)obj;
                    break;
                }
            }
            if (result != null) {
                PyCodecLookupNode.putSearchPath(context, normalizedEncoding, result);
                return result;
            }
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ENCODING, encoding);
        }

        @CompilerDirectives.TruffleBoundary
        private static void putSearchPath(PythonContext ctx, TruffleString key, PTuple value) {
            ctx.getCodecSearchCache().put(key, value);
        }

        @CompilerDirectives.TruffleBoundary
        private static PTuple getSearchPath(PythonContext ctx, TruffleString key) {
            return ctx.getCodecSearchCache().get(key);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] getSearchPaths(PythonContext ctx) {
            List<Object> l = ctx.getCodecSearchPath();
            return ctx.getCodecSearchPath().toArray(new Object[l.size()]);
        }
    }

    @Builtin(name="__truffle_lookup__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CodecsLookupNode
    extends PythonUnaryBuiltinNode {
        CodecsLookupNode() {
        }

        @Specialization
        static Object lookup(TruffleString encoding, @Bind(value="this") Node inliningTarget, @Cached CharsetMapping.NormalizeEncodingNameNode normalizeEncodingNameNode) {
            if (CodecsModuleBuiltins.hasTruffleEncodingNormalized(normalizeEncodingNameNode.execute(inliningTarget, encoding))) {
                return true;
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="escape_encode", minNumOfPositionalArgs=1, parameterNames={"data", "errors"})
    @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class CodecsEscapeEncodeNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CodecsEscapeEncodeNodeClinicProviderGen.INSTANCE;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object encode(PBytes data, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode getInternalByteArrayNode) {
            byte[] bytes = getInternalByteArrayNode.execute(inliningTarget, data.getSequenceStorage());
            int size = bytes.length;
            ByteArrayBuffer buffer = new ByteArrayBuffer();
            for (byte aByte : bytes) {
                char c = (char)aByte;
                if (c == '\'' || c == '\\') {
                    buffer.append(92);
                    buffer.append(c);
                    continue;
                }
                if (c == '\t') {
                    buffer.append(92);
                    buffer.append(116);
                    continue;
                }
                if (c == '\n') {
                    buffer.append(92);
                    buffer.append(110);
                    continue;
                }
                if (c == '\r') {
                    buffer.append(92);
                    buffer.append(114);
                    continue;
                }
                if (c < ' ' || c >= '\u007f') {
                    buffer.append(92);
                    buffer.append(120);
                    buffer.append(BytesUtils.HEXDIGITS[(c & 0xF0) >> 4]);
                    buffer.append(BytesUtils.HEXDIGITS[c & 0xF]);
                    continue;
                }
                buffer.append(c);
            }
            return this.factory().createTuple(new Object[]{this.factory().createBytes(buffer.getByteArray()), size});
        }

        @Fallback
        Object encode(Object data, Object errors) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.BYTESLIKE_OBJ_REQUIRED, data);
        }
    }

    @Builtin(name="escape_decode", minNumOfPositionalArgs=1, parameterNames={"data", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="data", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CodecsEscapeDecodeNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CodecsEscapeDecodeNodeClinicProviderGen.INSTANCE;
        }

        public final Object execute(VirtualFrame frame, byte[] bytes, TruffleString errors) {
            return this.decodeBytes(bytes, bytes.length, errors);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object decode(VirtualFrame frame, Object buffer, TruffleString errors, @CachedLibrary(value="buffer") PythonBufferAccessLibrary bufferLib) {
            try {
                int len = bufferLib.getBufferLength(buffer);
                Object object = this.decodeBytes(bufferLib.getInternalOrCopiedByteArray(buffer), len, errors);
                return object;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        private Object decodeBytes(byte[] bytes, int len, TruffleString errors) {
            ByteArrayBuffer result = this.doDecode(bytes, len, errors);
            return this.factory().createTuple(new Object[]{this.factory().createBytes(result.getInternalBytes(), result.getLength()), len});
        }

        @CompilerDirectives.TruffleBoundary
        private ByteArrayBuffer doDecode(byte[] bytes, int bytesLen, TruffleString errors) {
            ByteArrayBuffer buffer = new ByteArrayBuffer(bytesLen);
            block15: for (int i = 0; i < bytesLen; ++i) {
                char chr = (char)bytes[i];
                if (chr != '\\') {
                    buffer.append(chr);
                    continue;
                }
                if (++i >= bytesLen) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.TRAILING_S_IN_STR, "\\");
                }
                chr = (char)bytes[i];
                switch (chr) {
                    case '\n': {
                        continue block15;
                    }
                    case '\\': {
                        buffer.append(92);
                        continue block15;
                    }
                    case '\'': {
                        buffer.append(39);
                        continue block15;
                    }
                    case '\"': {
                        buffer.append(34);
                        continue block15;
                    }
                    case 'b': {
                        buffer.append(8);
                        continue block15;
                    }
                    case 'f': {
                        buffer.append(12);
                        continue block15;
                    }
                    case 't': {
                        buffer.append(9);
                        continue block15;
                    }
                    case 'n': {
                        buffer.append(10);
                        continue block15;
                    }
                    case 'r': {
                        buffer.append(13);
                        continue block15;
                    }
                    case 'v': {
                        buffer.append(11);
                        continue block15;
                    }
                    case 'a': {
                        buffer.append(7);
                        continue block15;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        char nextChar;
                        int code = chr - 48;
                        if (i + 1 < bytesLen && '0' <= (nextChar = (char)bytes[i + 1]) && nextChar <= '7') {
                            code = (code << 3) + nextChar - 48;
                            if (++i + 1 < bytesLen && '0' <= (nextChar = (char)bytes[i + 1]) && nextChar <= '7') {
                                code = (code << 3) + nextChar - 48;
                                ++i;
                            }
                        }
                        buffer.append((char)code);
                        continue block15;
                    }
                    case 'x': {
                        if (i + 2 < bytesLen) {
                            int digit1 = BytesUtils.digitValue(bytes[i + 1]);
                            int digit2 = BytesUtils.digitValue(bytes[i + 2]);
                            if (digit1 < 16 && digit2 < 16) {
                                buffer.append((digit1 << 4) + digit2);
                                i += 2;
                                continue block15;
                            }
                        }
                        if (StringLiterals.T_STRICT.equalsUncached((AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
                            throw this.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_ESCAPE_AT, "\\x", i - 2);
                        }
                        if (StringLiterals.T_REPLACE.equalsUncached((AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
                            buffer.append(63);
                        } else if (!StringLiterals.T_IGNORE.equalsUncached((AbstractTruffleString)errors, PythonUtils.TS_ENCODING)) {
                            throw this.raise(PythonErrorType.ValueError, ErrorMessages.ENCODING_ERROR_WITH_CODE, errors);
                        }
                        if (i + 1 >= bytesLen || !CodecsEscapeDecodeNode.isHexDigit((char)bytes[i + 1])) continue block15;
                        ++i;
                        continue block15;
                    }
                    default: {
                        buffer.append(92);
                        buffer.append(chr);
                    }
                }
            }
            return buffer;
        }

        private static boolean isHexDigit(char digit) {
            return '0' <= digit && digit <= '9' || 'a' <= digit && digit <= 'f' || 'A' <= digit && digit <= 'F';
        }
    }

    @Builtin(name="__truffle_decode__", minNumOfPositionalArgs=1, parameterNames={"obj", "encoding", "errors", "final"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_UTF8", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true), @ArgumentClinic(name="final", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CodecsDecodeNode
    extends PythonQuaternaryClinicBuiltinNode {
        public final Object call(VirtualFrame frame, Object input, Object encoding, Object errors, Object finalData) {
            return this.execute(frame, input, encoding, errors, finalData);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CodecsDecodeNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(limit="3")
        Object decode(VirtualFrame frame, Object input, TruffleString encoding, TruffleString errors, boolean finalData, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="input") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached TruffleString.EqualNode equalNode, @Cached CharsetMapping.NormalizeEncodingNameNode normalizeEncodingNameNode, @Cached InternErrorAction internErrorAction, @Cached HandleDecodingErrorNode errorHandler, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            Object buffer = acquireLib.acquireReadonly(input, frame, this);
            try {
                TruffleDecoder decoder;
                int len = bufferLib.getBufferLength(buffer);
                byte[] bytes = bufferLib.getInternalOrCopiedByteArray(buffer);
                CodingErrorAction errorAction = CodecsModuleBuiltins.convertCodingErrorAction(errors, equalNode);
                TruffleString normalizedEncoding = normalizeEncodingNameNode.execute(inliningTarget, encoding);
                Charset charset = CharsetMapping.getCharsetForDecodingNormalized(normalizedEncoding, bytes, len);
                if (charset == null) {
                    throw raiseNode.raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ENCODING, encoding);
                }
                try {
                    decoder = new TruffleDecoder(normalizedEncoding, charset, bytes, len, errorAction);
                    while (!decoder.decodingStep(finalData)) {
                        errorHandler.execute(decoder, internErrorAction.execute(inliningTarget, errors), factory.createBytes(bytes, len));
                    }
                }
                catch (OutOfMemoryError e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw raiseNode.raise(PythonErrorType.MemoryError);
                }
                PTuple pTuple = factory.createTuple(new Object[]{decoder.getString(), decoder.getInputPosition()});
                return pTuple;
            }
            finally {
                bufferLib.release(buffer);
            }
        }
    }

    @Builtin(name="__truffle_encode__", minNumOfPositionalArgs=1, parameterNames={"obj", "encoding", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_UTF8", useDefaultForNone=true), @ArgumentClinic(name="errors", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_STRICT", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class CodecsEncodeNode
    extends PythonTernaryClinicBuiltinNode {
        public abstract Object execute(Object var1, Object var2, Object var3);

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return CodecsModuleBuiltinsClinicProviders.CodecsEncodeNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"isString(self)"})
        Object encode(Object self, TruffleString encoding, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached CodecsEncodeToJavaBytesNode encode) {
            TruffleString input = castStr.execute(inliningTarget, self);
            PBytes bytes = this.factory().createBytes(encode.execute(self, encoding, errors));
            return this.factory().createTuple(new Object[]{bytes, codePointLengthNode.execute((AbstractTruffleString)input, PythonUtils.TS_ENCODING)});
        }

        @Fallback
        Object encode(Object str, Object encoding, Object errors) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_CONVERT_TO_STR_IMPLICITLY, str);
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CodecsEncodeToJavaBytesNode
    extends Node {
        public abstract byte[] execute(Object var1, TruffleString var2, TruffleString var3);

        @Specialization
        byte[] encode(Object self, TruffleString encoding, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached CastToJavaStringNode castStr, @Cached TruffleString.EqualNode equalNode, @Cached HandleEncodingErrorNode errorHandler, @Cached PRaiseNode.Lazy raiseNode, @Cached CharsetMapping.NormalizeEncodingNameNode normalizeEncodingNameNode) {
            TruffleEncoder encoder;
            String input = castStr.execute(self);
            CodingErrorAction errorAction = CodecsModuleBuiltins.convertCodingErrorAction(errors, equalNode);
            TruffleString normalizedEncoding = normalizeEncodingNameNode.execute(inliningTarget, encoding);
            Charset charset = CharsetMapping.getCharsetNormalized(normalizedEncoding);
            if (charset == null) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ENCODING, encoding);
            }
            try {
                encoder = new TruffleEncoder(normalizedEncoding, charset, input, errorAction);
                while (!encoder.encodingStep()) {
                    errorHandler.execute(inliningTarget, encoder, errors, self);
                }
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(this, PythonErrorType.MemoryError);
            }
            return encoder.getBytes();
        }
    }

    @ImportStatic(value={StringLiterals.class})
    @GenerateInline(value=false)
    public static abstract class HandleDecodingErrorNode
    extends Node {
        public abstract void execute(TruffleDecoder var1, TruffleString var2, Object var3);

        @Specialization(guards={"errorAction == T_STRICT"})
        static void doStrict(TruffleDecoder decoder, TruffleString errorAction, Object inputObject, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RaiseDecodingErrorNode raiseDecodingErrorNode) {
            raiseDecodingErrorNode.raise(inliningTarget, decoder, inputObject);
        }

        @Specialization(guards={"errorAction == T_BACKSLASHREPLACE"})
        void doBackslashreplace(TruffleDecoder decoder, TruffleString errorAction, Object inputObject, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RaiseDecodingErrorNode raiseDecodingErrorNode) {
            try {
                if (!HandleDecodingErrorNode.backslashreplace(decoder)) {
                    raiseDecodingErrorNode.raise(inliningTarget, decoder, inputObject);
                }
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                PRaiseNode.raiseUncached(this, PythonErrorType.MemoryError);
            }
        }

        @Specialization(guards={"errorAction == T_SURROGATEPASS"})
        static void doSurrogatepass(TruffleDecoder decoder, TruffleString errorAction, Object inputObject, @Bind(value="this") Node inliningTarget, @Cached TruffleString.EqualNode equalNode, @Cached.Shared @Cached RaiseDecodingErrorNode raiseDecodingErrorNode) {
            try {
                if (!HandleDecodingErrorNode.surrogatepass(decoder, equalNode)) {
                    raiseDecodingErrorNode.raise(inliningTarget, decoder, inputObject);
                }
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
            }
        }

        @Specialization(guards={"errorAction == T_SURROGATEESCAPE"})
        static void doSurrogateescape(TruffleDecoder decoder, TruffleString errorAction, Object inputObject, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached RaiseDecodingErrorNode raiseDecodingErrorNode) {
            try {
                if (!HandleDecodingErrorNode.surrogateescape(decoder)) {
                    raiseDecodingErrorNode.raise(inliningTarget, decoder, inputObject);
                }
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
            }
        }

        @Fallback
        static void doCustom(TruffleDecoder decoder, TruffleString errorAction, Object inputObject, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached BaseExceptionAttrNode attrNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached PyLongAsIntNode asIntNode, @Cached.Exclusive @Cached RaiseDecodingErrorNode raiseDecodingErrorNode, @Cached CodecsRegistry.PyCodecLookupErrorNode lookupErrorNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                Object errorHandler = lookupErrorNode.execute(inliningTarget, errorAction);
                if (errorHandler == null) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ERROR_HANDLER, errorAction);
                }
                Object exceptionObject = raiseDecodingErrorNode.makeDecodeException(inliningTarget, decoder, inputObject);
                Object restuple = callNode.execute(errorHandler, exceptionObject);
                Object[] t = null;
                if (PGuards.isPTuple(restuple)) {
                    t = getArray.execute(inliningTarget, ((PTuple)restuple).getSequenceStorage());
                }
                if (t == null || t.length != 2) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.DECODING_ERROR_HANDLER_MUST_RETURN_STR_INT_TUPLE);
                }
                int newpos = asIntNode.execute(null, inliningTarget, t[1]);
                assert (exceptionObject instanceof PBaseException);
                Object obj = attrNode.get((PBaseException)exceptionObject, 1, UnicodeErrorBuiltins.UNICODE_ERROR_ATTR_FACTORY);
                SequenceStorage inputStorage = getBytesStorage.execute(inliningTarget, obj);
                byte[] input = getBytes.execute(inliningTarget, inputStorage);
                int insize = inputStorage.length();
                if (newpos < 0) {
                    newpos = insize + newpos;
                }
                if (newpos < 0 || newpos > insize) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.POSITION_D_FROM_ERROR_HANDLER_OUT_OF_BOUNDS, newpos);
                }
                if (!HandleDecodingErrorNode.custom(decoder, input, insize, newpos)) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.SystemError);
                }
            }
            catch (OutOfMemoryError e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean custom(TruffleDecoder decoder, byte[] input, int insize, int newpos) {
            decoder.inputBuffer.clear();
            if (decoder.inputBuffer.capacity() < insize) {
                return false;
            }
            decoder.inputBuffer.put(input).limit(insize).position(newpos);
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean backslashreplace(TruffleDecoder decoder) {
            byte[] p = decoder.getInputBytes(decoder.getErrorLength());
            char[] replacement = new char[p.length * 4];
            int outp = 0;
            byte[] buf = new byte[4];
            for (byte b : p) {
                BytesUtils.byteEscape(b, 0, buf);
                replacement[outp++] = (char)buf[0];
                replacement[outp++] = (char)buf[1];
                replacement[outp++] = (char)buf[2];
                replacement[outp++] = (char)buf[3];
            }
            decoder.replace(p.length, replacement, 0, outp);
            return true;
        }

        private static boolean surrogatepass(TruffleDecoder decoder, TruffleString.EqualNode equalNode) {
            int codePoint;
            byte[] p;
            if (equalNode.execute((AbstractTruffleString)decoder.getEncodingName(), (AbstractTruffleString)StringLiterals.T_UTF_UNDERSCORE_8, PythonUtils.TS_ENCODING) && decoder.getInputRemaining() >= 3 && ((p = decoder.getInputBytes(3))[0] & 0xF0) == 224 && (p[1] & 0xC0) == 128 && (p[2] & 0xC0) == 128 && 55296 <= (codePoint = ((p[0] & 0xF) << 12) + ((p[1] & 0x3F) << 6) + (p[2] & 0x3F)) && codePoint <= 57343) {
                decoder.replace(3, Character.toChars(codePoint));
                return true;
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean surrogateescape(TruffleDecoder decoder) {
            int b;
            int errorLength = decoder.getErrorLength();
            boolean replaced = false;
            byte[] inputBytes = decoder.getInputBytes(errorLength);
            for (int consumed = 0; consumed < 4 && consumed < errorLength && (b = inputBytes[consumed] & 0xFF) >= 128; ++consumed) {
                int codePoint = 56320 + b;
                decoder.replace(1, Character.toChars(codePoint));
                replaced = true;
            }
            return replaced;
        }
    }

    @GenerateUncached
    @GenerateCached(value=false)
    @GenerateInline
    protected static abstract class InternErrorAction
    extends Node {
        protected InternErrorAction() {
        }

        public abstract TruffleString execute(Node var1, TruffleString var2);

        @Specialization
        public static TruffleString intern(Node inliningTarget, TruffleString errorAction, @Cached InlinedConditionProfile strictProfile, @Cached InlinedConditionProfile backslashreplaceProfile, @Cached InlinedConditionProfile surrogatepassProfile, @Cached InlinedConditionProfile surrogateescapeProfile, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            if (strictProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_STRICT, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                return StringLiterals.T_STRICT;
            }
            if (backslashreplaceProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_BACKSLASHREPLACE, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                return StringLiterals.T_BACKSLASHREPLACE;
            }
            if (surrogatepassProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_SURROGATEPASS, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                return StringLiterals.T_SURROGATEPASS;
            }
            if (surrogateescapeProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_SURROGATEESCAPE, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                return StringLiterals.T_SURROGATEESCAPE;
            }
            return errorAction;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class RaiseDecodingErrorNode
    extends Node {
        protected abstract Object execute(Node var1, TruffleDecoder var2, Object var3, boolean var4);

        public Object makeDecodeException(Node inliningTarget, TruffleDecoder decoder, Object inputObject) {
            return this.execute(inliningTarget, decoder, inputObject, true);
        }

        public Object raise(Node inliningTarget, TruffleDecoder decoder, Object inputObject) {
            return this.execute(inliningTarget, decoder, inputObject, false);
        }

        @Specialization
        static Object doRaise(Node inliningTarget, TruffleDecoder decoder, Object inputObject, boolean justMakeExcept, @Cached(inline=false) CallNode callNode, @Cached PRaiseNode.Lazy raiseNode) {
            int start = decoder.getInputPosition();
            int end = start + decoder.getErrorLength();
            Object exception = callNode.execute((Object)PythonErrorType.UnicodeDecodeError, decoder.getEncodingName(), inputObject, start, end, decoder.getErrorReason());
            if (justMakeExcept) {
                return exception;
            }
            if (exception instanceof PBaseException) {
                throw raiseNode.get(inliningTarget).raiseExceptionObject(exception);
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.TypeError, ErrorMessages.SHOULD_HAVE_RETURNED_EXCEPTION, new Object[]{PythonErrorType.UnicodeDecodeError, exception});
        }
    }

    @GenerateInline
    @GenerateUncached
    @GenerateCached(value=false)
    public static abstract class HandleEncodingErrorNode
    extends Node {
        public abstract void execute(Node var1, TruffleEncoder var2, TruffleString var3, Object var4);

        @Specialization
        static void handle(Node inliningTarget, TruffleEncoder encoder, TruffleString errorAction, Object inputObject, @Cached InlinedConditionProfile strictProfile, @Cached InlinedConditionProfile backslashreplaceProfile, @Cached InlinedConditionProfile surrogatepassProfile, @Cached InlinedConditionProfile surrogateescapeProfile, @Cached InlinedConditionProfile xmlcharrefreplaceProfile, @Cached PRaiseNode.Lazy raiseNode, @Cached(inline=false) TruffleString.EqualNode equalNode, @Cached(inline=false) CallNode lazyCallNode) {
            boolean fixed;
            block9: {
                try {
                    if (strictProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_STRICT, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                        fixed = false;
                        break block9;
                    }
                    if (backslashreplaceProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_BACKSLASHREPLACE, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                        fixed = HandleEncodingErrorNode.backslashreplace(encoder);
                        break block9;
                    }
                    if (surrogatepassProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_SURROGATEPASS, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                        fixed = HandleEncodingErrorNode.surrogatepass(encoder, equalNode);
                        break block9;
                    }
                    if (surrogateescapeProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_SURROGATEESCAPE, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                        fixed = HandleEncodingErrorNode.surrogateescape(encoder);
                        break block9;
                    }
                    if (xmlcharrefreplaceProfile.profile(inliningTarget, equalNode.execute((AbstractTruffleString)StringLiterals.T_XMLCHARREFREPLACE, (AbstractTruffleString)errorAction, PythonUtils.TS_ENCODING))) {
                        fixed = HandleEncodingErrorNode.xmlcharrefreplace(encoder);
                        break block9;
                    }
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ERROR_HANDLER, errorAction);
                }
                catch (OutOfMemoryError e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonErrorType.MemoryError);
                }
            }
            if (!fixed) {
                int start = encoder.getInputPosition();
                int end = start + encoder.getErrorLength();
                Object exception = lazyCallNode.execute((Object)PythonErrorType.UnicodeEncodeError, encoder.getEncodingName(), inputObject, start, end, encoder.getErrorReason());
                if (exception instanceof PBaseException) {
                    throw raiseNode.get(inliningTarget).raiseExceptionObject((PBaseException)exception);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.SHOULD_HAVE_RETURNED_EXCEPTION, new Object[]{PythonErrorType.UnicodeEncodeError, exception});
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean backslashreplace(TruffleEncoder encoder) {
            int ch;
            String p = new String(encoder.getInputChars(encoder.getErrorLength()));
            StringBuilder sb = new StringBuilder();
            byte[] buf = new byte[10];
            for (int i = 0; i < p.length(); i += Character.charCount(ch)) {
                ch = p.codePointAt(i);
                int len = ch < 256 ? BytesUtils.byteEscape(ch, 0, buf) : BytesUtils.unicodeNonAsciiEscape(ch, 0, buf);
                for (int j = 0; j < len; ++j) {
                    sb.append((char)buf[j]);
                }
            }
            encoder.replace(p.length(), sb.toString());
            return true;
        }

        private static boolean surrogatepass(TruffleEncoder encoder, TruffleString.EqualNode equalNode) {
            if (equalNode.execute((AbstractTruffleString)encoder.getEncodingName(), (AbstractTruffleString)StringLiterals.T_UTF_UNDERSCORE_8, PythonUtils.TS_ENCODING)) {
                return HandleEncodingErrorNode.surrogatepassUtf8Boundary(encoder);
            }
            return false;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean surrogatepassUtf8Boundary(TruffleEncoder encoder) {
            int ch;
            String p = new String(encoder.getInputChars(encoder.getErrorLength()));
            byte[] replacement = new byte[p.length() * 3];
            int outp = 0;
            for (int i = 0; i < p.length(); i += Character.charCount(ch)) {
                ch = p.codePointAt(i);
                if (55296 > ch || ch > 57343) {
                    return false;
                }
                replacement[outp++] = (byte)(0xE0 | ch >> 12);
                replacement[outp++] = (byte)(0x80 | ch >> 6 & 0x3F);
                replacement[outp++] = (byte)(0x80 | ch & 0x3F);
            }
            encoder.replace(encoder.getErrorLength(), replacement, 0, outp);
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean surrogateescape(TruffleEncoder encoder) {
            int ch;
            String p = new String(encoder.getInputChars(encoder.getErrorLength()));
            byte[] replacement = new byte[p.length()];
            int outp = 0;
            for (int i = 0; i < p.length(); i += Character.charCount(ch)) {
                ch = p.codePointAt(i);
                if (56448 > ch || ch > 56575) {
                    return false;
                }
                replacement[outp++] = (byte)(ch - 56320);
            }
            encoder.replace(encoder.getErrorLength(), replacement, 0, outp);
            return true;
        }

        @CompilerDirectives.TruffleBoundary
        private static boolean xmlcharrefreplace(TruffleEncoder encoder) {
            String p = new String(encoder.getInputChars(encoder.getErrorLength()));
            int size = 0;
            for (int i = 0; i < encoder.getErrorLength(); ++i) {
                size += ErrorHandlers.getXmlCharRefReplacementLength(p.codePointAt(i));
            }
            byte[] replacement = new byte[size];
            int consumed = 0;
            for (int i = 0; i < p.length(); ++i) {
                consumed = ErrorHandlers.appendXmlCharRefReplacement(replacement, consumed, p.codePointAt(i));
            }
            encoder.replace(encoder.getErrorLength(), replacement, 0, consumed);
            return true;
        }
    }
}

