/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.FcntlModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.FcntlModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.PosixModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(defineModule="fcntl")
public final class FcntlModuleBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return FcntlModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        for (PosixConstants.IntConstant c : PosixConstants.flockOperation) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
        for (PosixConstants.IntConstant c : PosixConstants.flockType) {
            if (!c.defined) continue;
            this.addBuiltinConstant(c.name, (Object)c.getValueIfDefined());
        }
        super.initialize(core);
    }

    @Builtin(name="flock", parameterNames={"fd", "operation"})
    @ArgumentsClinic(value={@ArgumentClinic(name="fd", conversionClass=PosixModuleBuiltins.FileDescriptorConversionNode.class), @ArgumentClinic(name="operation", conversion=ArgumentClinic.ClinicConversion.Int)})
    @GenerateNodeFactory
    static abstract class FlockNode
    extends PythonBinaryClinicBuiltinNode {
        FlockNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return FcntlModuleBuiltinsClinicProviders.FlockNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        synchronized PNone flock(VirtualFrame frame, int fd, int operation, @Bind(value="this") Node inliningTarget, @Cached SysModuleBuiltins.AuditNode auditNode, @CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posix, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            auditNode.audit(inliningTarget, "fcntl.flock", fd, operation);
            try {
                posix.flock(this.getPosixSupport(), fd, operation);
            }
            catch (PosixSupportLibrary.PosixException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSErrorFromPosixException(frame, e);
            }
            return PNone.NONE;
        }
    }
}

