/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.GcModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

@CoreFunctions(defineModule="gc")
public final class GcModuleBuiltins
extends PythonBuiltins {
    protected List<NodeFactory<? extends PythonBuiltinNode>> getNodeFactories() {
        return GcModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("DEBUG_LEAK", (Object)0);
        super.initialize(core);
    }

    @Builtin(name="get_referents", takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class GcGetReferentsNode
    extends PythonBuiltinNode {
        GcGetReferentsNode() {
        }

        @Specialization
        PList getReferents(Object objects) {
            return this.factory().createList();
        }
    }

    @Builtin(name="is_tracked", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GcIsTrackedNode
    extends PythonBuiltinNode {
        GcIsTrackedNode() {
        }

        @Specialization
        public boolean isTracked(PythonNativeObject object) {
            return false;
        }

        @Fallback
        public boolean isTracked(Object object) {
            return true;
        }
    }

    @Builtin(name="get_count", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GcCountNode
    extends PythonBuiltinNode {
        GcCountNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public PTuple count() {
            List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            long count = 0L;
            for (GarbageCollectorMXBean gcbean : garbageCollectorMXBeans) {
                long cc = gcbean.getCollectionCount();
                if (cc <= 0L) continue;
                count += cc;
            }
            return this.factory().createTuple(new Object[]{count, 0, 0});
        }
    }

    @Builtin(name="set_debug", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SetDebugNode
    extends PythonBuiltinNode {
        SetDebugNode() {
        }

        @Specialization
        PNone setDebug(Object ignored) {
            return PNone.NONE;
        }
    }

    @Builtin(name="get_debug", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetDebugNode
    extends PythonBuiltinNode {
        GetDebugNode() {
        }

        @Specialization
        int getDebug() {
            return 0;
        }
    }

    @Builtin(name="enable", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class EnableNode
    extends PythonBuiltinNode {
        EnableNode() {
        }

        @Specialization
        PNone enable() {
            this.getContext().setGcEnabled(true);
            return PNone.NONE;
        }
    }

    @Builtin(name="disable", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class DisableNode
    extends PythonBuiltinNode {
        DisableNode() {
        }

        @Specialization
        PNone disable() {
            this.getContext().setGcEnabled(false);
            return PNone.NONE;
        }
    }

    @Builtin(name="isenabled", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GcIsEnabledNode
    extends PythonBuiltinNode {
        GcIsEnabledNode() {
        }

        @Specialization
        boolean isenabled() {
            return this.getContext().isGcEnabled();
        }
    }

    @Builtin(name="collect", minNumOfPositionalArgs=0, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GcCollectNode
    extends PythonBuiltinNode {
        GcCollectNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        @CompilerDirectives.TruffleBoundary
        int collect(Object level, @Cached GilNode gil) {
            gil.release(true);
            try {
                PythonUtils.forceFullGC();
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                gil.acquire();
            }
            PythonContext.triggerAsyncActions(this);
            CApiTransitions.pollReferenceQueue();
            return 0;
        }
    }
}

