/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.PolyglotModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNodeGen;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.util.List;
import java.util.Map;

@CoreFunctions(defineModule="polyglot")
public final class PolyglotModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString T_READ_SIDE_EFFECTS = PythonUtils.tsLiteral("read-side-effects");
    private static final TruffleString T_WRITE_SIDE_EFFECTS = PythonUtils.tsLiteral("write-side-effects");
    private static final TruffleString T_EXISTS = PythonUtils.tsLiteral("exists");
    private static final TruffleString T_INSERTABLE = PythonUtils.tsLiteral("insertable");
    private static final TruffleString T_REMOVABLE = PythonUtils.tsLiteral("removable");
    private static final TruffleString T_MODIFIABLE = PythonUtils.tsLiteral("modifiable");
    private static final TruffleString T_INVOKABLE = PythonUtils.tsLiteral("invokable");
    private static final TruffleString T_INTERNAL = PythonUtils.tsLiteral("internal");
    @CompilerDirectives.CompilationFinal
    static InteropLibrary UNCACHED_INTEROP;

    protected List<NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PolyglotModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        PythonContext context = core.getContext();
        TruffleLanguage.Env env = context.getEnv();
        TruffleString coreHome = context.getCoreHome();
        try {
            TruffleFile coreDir = env.getInternalTruffleFile(coreHome.toJavaStringUncached());
            TruffleFile docDir = coreDir.resolveSibling("docs");
            if (docDir.exists(new LinkOption[0]) || docDir.getParent() != null && (docDir = coreDir.getParent().resolveSibling("docs")).exists(new LinkOption[0])) {
                this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)new String(docDir.resolve("user").resolve("Interoperability.md").readAllBytes()));
            }
        }
        catch (IOException | SecurityException exception) {
            // empty catch block
        }
    }

    static InteropLibrary getInterop() {
        if (UNCACHED_INTEROP == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            UNCACHED_INTEROP = (InteropLibrary)InteropLibrary.getFactory().getUncached();
        }
        return UNCACHED_INTEROP;
    }

    @Builtin(name="storage", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class StorageNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doSequence(PSequence seq, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, seq);
            return PythonContext.get(this).getEnv().asGuestValue(storage.getInternalArrayObject());
        }

        @Fallback
        Object doError(Object object) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.UNSUPPORTED_OPERAND_P, object);
        }
    }

    @Builtin(name="__element_info__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class ArrayElementInfoNode
    extends PythonBuiltinNode {
        @Specialization
        boolean keyInfo(Object receiver, long member, TruffleString info, @Cached TruffleString.EqualNode equalNode) {
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_EXISTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementExisting(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_READABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementReadable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_WRITABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementWritable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INSERTABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementInsertable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_REMOVABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementRemovable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_MODIFIABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isArrayElementModifiable(receiver, member);
            }
            return false;
        }
    }

    @Builtin(name="__keys__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class KeysNode
    extends PythonBuiltinNode {
        @Specialization
        Object remove(Object receiver) {
            try {
                return PolyglotModuleBuiltins.getInterop().getMembers(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw this.raise(PythonErrorType.TypeError, (Exception)((Object)e));
            }
        }
    }

    @Builtin(name="__key_info__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class KeyInfoNode
    extends PythonBuiltinNode {
        @Specialization
        boolean keyInfo(Object receiver, TruffleString tmember, TruffleString info, @Cached TruffleString.ToJavaStringNode toJavaStringNode, @Cached TruffleString.EqualNode equalNode) {
            String member = toJavaStringNode.execute((AbstractTruffleString)tmember);
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_READ_SIDE_EFFECTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().hasMemberReadSideEffects(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_WRITE_SIDE_EFFECTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().hasMemberWriteSideEffects(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_EXISTS, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberExisting(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_READABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberReadable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)StringLiterals.T_WRITABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberWritable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INSERTABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberInsertable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_REMOVABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberRemovable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_MODIFIABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberModifiable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INVOKABLE, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberInvocable(receiver, member);
            }
            if (equalNode.execute((AbstractTruffleString)info, (AbstractTruffleString)T_INTERNAL, PythonUtils.TS_ENCODING)) {
                return PolyglotModuleBuiltins.getInterop().isMemberInternal(receiver, member);
            }
            return false;
        }
    }

    @Builtin(name="__has_keys__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HasKeysNode
    extends PythonBuiltinNode {
        @Specialization
        boolean hasKeys(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().hasMembers(receiver);
        }
    }

    @Builtin(name="__is_boxed__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsBoxedNode
    extends PythonBuiltinNode {
        @Specialization
        boolean isBoxed(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().isString(receiver) || PolyglotModuleBuiltins.getInterop().fitsInDouble(receiver) || PolyglotModuleBuiltins.getInterop().fitsInLong(receiver);
        }
    }

    @Builtin(name="__get_size__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class GetSizeNode
    extends PythonBuiltinNode {
        @Specialization
        Object getSize(Object receiver) {
            try {
                return PolyglotModuleBuiltins.getInterop().getArraySize(receiver);
            }
            catch (UnsupportedMessageException e) {
                throw this.raise(PythonErrorType.TypeError, (Exception)((Object)e));
            }
        }
    }

    @Builtin(name="__has_size__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class HasSizeNode
    extends PythonBuiltinNode {
        @Specialization
        boolean hasSize(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().hasArrayElements(receiver);
        }
    }

    @Builtin(name="__is_null__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IsNullNode
    extends PythonBuiltinNode {
        @Specialization
        boolean isNull(Object receiver) {
            return PolyglotModuleBuiltins.getInterop().isNull(receiver);
        }
    }

    @Builtin(name="__invoke__", minNumOfPositionalArgs=2, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class invokeNode
    extends PythonBuiltinNode {
        @Specialization
        Object invoke(Object receiver, TruffleString key, Object[] arguments, @Cached TruffleString.ToJavaStringNode toJavaStringNode) {
            try {
                return PolyglotModuleBuiltins.getInterop().invokeMember(receiver, toJavaStringNode.execute((AbstractTruffleString)key), arguments);
            }
            catch (ArityException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw this.raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class newNode
    extends PythonBuiltinNode {
        @Specialization
        Object instantiate(Object receiver, Object[] arguments) {
            try {
                return PolyglotModuleBuiltins.getInterop().instantiate(receiver, arguments);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw this.raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="__execute__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class executeNode
    extends PythonBuiltinNode {
        @Specialization
        Object exec(Object receiver, Object[] arguments) {
            try {
                return PolyglotModuleBuiltins.getInterop().execute(receiver, arguments);
            }
            catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
                throw this.raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="__remove__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class removeNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object remove(Object receiver, Object key) {
            block5: {
                try {
                    if (key instanceof TruffleString) {
                        PolyglotModuleBuiltins.getInterop().removeMember(receiver, ((TruffleString)key).toJavaStringUncached());
                        break block5;
                    }
                    if (TruffleStringMigrationHelpers.isJavaString(key)) {
                        PolyglotModuleBuiltins.getInterop().removeMember(receiver, (String)key);
                        break block5;
                    }
                    if (key instanceof Number) {
                        PolyglotModuleBuiltins.getInterop().removeArrayElement(receiver, ((Number)key).longValue());
                        break block5;
                    }
                    throw this.raise(PythonErrorType.AttributeError, ErrorMessages.UNKNOWN_ATTR, key);
                }
                catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                    throw this.raise(PythonErrorType.AttributeError, (Exception)e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__write__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    public static abstract class WriteNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object write(Object receiver, Object key, Object value) {
            block5: {
                try {
                    if (key instanceof TruffleString) {
                        PolyglotModuleBuiltins.getInterop().writeMember(receiver, ((TruffleString)key).toJavaStringUncached(), value);
                        break block5;
                    }
                    if (TruffleStringMigrationHelpers.isJavaString(key)) {
                        PolyglotModuleBuiltins.getInterop().writeMember(receiver, (String)key, value);
                        break block5;
                    }
                    if (key instanceof Number) {
                        PolyglotModuleBuiltins.getInterop().writeArrayElement(receiver, ((Number)key).longValue(), value);
                        break block5;
                    }
                    throw this.raise(PythonErrorType.AttributeError, ErrorMessages.UNKNOWN_ATTR, key);
                }
                catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException | UnsupportedTypeException e) {
                    throw this.raise(PythonErrorType.AttributeError, (Exception)e);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__read__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReadNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object read(Object receiver, Object key) {
            try {
                if (key instanceof TruffleString) {
                    return PolyglotModuleBuiltins.getInterop().readMember(receiver, ((TruffleString)key).toJavaStringUncached());
                }
                if (TruffleStringMigrationHelpers.isJavaString(key)) {
                    return PolyglotModuleBuiltins.getInterop().readMember(receiver, (String)key);
                }
                if (key instanceof Number) {
                    return PolyglotModuleBuiltins.getInterop().readArrayElement(receiver, ((Number)key).longValue());
                }
                throw this.raise(PythonErrorType.AttributeError, ErrorMessages.UNKNOWN_ATTR, key);
            }
            catch (InvalidArrayIndexException | UnknownIdentifierException | UnsupportedMessageException e) {
                throw this.raise(PythonErrorType.AttributeError, (Exception)e);
            }
        }
    }

    @Builtin(name="export_value", minNumOfPositionalArgs=1, parameterNames={"name", "value"})
    @GenerateNodeFactory
    public static abstract class ExportSymbolNode
    extends PythonBuiltinNode {
        private static final TruffleLogger LOGGER = PythonLanguage.getLogger(ExportSymbolNode.class);
        @Node.Child
        private GetAttributeNode.GetFixedAttributeNode getNameAttributeNode;
        @Node.Child
        private CastToJavaStringNode castToStringNode;

        @Specialization(guards={"!isString(value)"})
        @CompilerDirectives.TruffleBoundary
        public Object exportSymbolKeyValue(TruffleString name, Object value) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(name.toJavaStringUncached(), value);
            return value;
        }

        @Specialization(guards={"!isString(value)"})
        @CompilerDirectives.TruffleBoundary
        public Object exportSymbolValueKey(Object value, TruffleString name) {
            LOGGER.warning("[deprecation] polyglot.export_value(value, name) is deprecated and will be removed. Please swap the arguments.");
            return this.exportSymbolKeyValue(name, value);
        }

        @Specialization(guards={"isString(arg1)"})
        @CompilerDirectives.TruffleBoundary
        public Object exportSymbolAmbiguous(Object arg1, TruffleString arg2) {
            LOGGER.warning("[deprecation] polyglot.export_value(str, str) is ambiguous. In the future, this will default to using the first argument as the name and the second as value, but now it uses the first argument as value and the second as the name.");
            return this.exportSymbolValueKey(arg1, arg2);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object exportSymbol(PFunction fun, PNone name) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(fun.getName().toJavaStringUncached(), (Object)fun);
            return fun;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object exportSymbol(PBuiltinFunction fun, PNone name) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(fun.getName().toJavaStringUncached(), (Object)fun);
            return fun;
        }

        @Specialization(guards={"isModule(fun.getSelf())"})
        Object exportSymbol(VirtualFrame frame, PMethod fun, PNone name) {
            this.export(this.getMethodName(frame, fun), fun);
            return fun;
        }

        @Specialization(guards={"isModule(fun.getSelf())"})
        Object exportSymbol(VirtualFrame frame, PBuiltinMethod fun, PNone name) {
            this.export(this.getMethodName(frame, fun), fun);
            return fun;
        }

        @Fallback
        public Object exportSymbol(Object value, Object name) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_ARG_TYPES_S_S_BUT_NOT_P_P, "function", "object, str", value, name);
        }

        private String getMethodName(VirtualFrame frame, Object o) {
            if (this.getNameAttributeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getNameAttributeNode = (GetAttributeNode.GetFixedAttributeNode)this.insert(GetAttributeNode.GetFixedAttributeNode.create(SpecialAttributeNames.T___NAME__));
            }
            if (this.castToStringNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.castToStringNode = (CastToJavaStringNode)this.insert(CastToJavaStringNodeGen.create());
            }
            Object attrNameValue = this.getNameAttributeNode.executeObject(frame, o);
            try {
                return this.castToStringNode.execute(attrNameValue);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.METHOD_NAME_MUST_BE, attrNameValue);
            }
        }

        protected static boolean isModule(Object o) {
            return o instanceof PythonModule;
        }

        @CompilerDirectives.TruffleBoundary
        private void export(String name, Object obj) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            env.exportSymbol(name, obj);
        }
    }

    @Builtin(name="eval", minNumOfPositionalArgs=0, parameterNames={"path", "string", "language"})
    @GenerateNodeFactory
    static abstract class EvalInteropNode
    extends PythonBuiltinNode {
        EvalInteropNode() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object evalString(PNone path, TruffleString tvalue, TruffleString tlangOrMimeType) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotEvalAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            try {
                String value = tvalue.toJavaStringUncached();
                String langOrMimeType = tlangOrMimeType.toJavaStringUncached();
                boolean mimeType = this.isMimeType(langOrMimeType);
                String lang = mimeType ? EvalInteropNode.findLanguageByMimeType(env, langOrMimeType) : langOrMimeType;
                this.raiseIfInternal(env, lang);
                Source.LiteralBuilder newBuilder = Source.newBuilder((String)lang, (CharSequence)value, (String)value);
                if (mimeType) {
                    newBuilder = newBuilder.mimeType(langOrMimeType);
                }
                return env.parsePublic(newBuilder.build(), new String[0]).call(new Object[0]);
            }
            catch (RuntimeException e) {
                throw this.raise(PythonErrorType.NotImplementedError, e);
            }
        }

        private void raiseIfInternal(TruffleLanguage.Env env, String lang) {
            LanguageInfo languageInfo = (LanguageInfo)env.getPublicLanguages().get(lang);
            if (languageInfo != null && languageInfo.isInternal()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.ACCESS_TO_INTERNAL_LANG_NOT_PERMITTED, lang);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object evalFile(TruffleString tpath, PNone string, TruffleString tlangOrMimeType) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotEvalAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            try {
                String path = tpath.toJavaStringUncached();
                String langOrMimeType = tlangOrMimeType.toJavaStringUncached();
                boolean mimeType = this.isMimeType(langOrMimeType);
                String lang = mimeType ? EvalInteropNode.findLanguageByMimeType(env, langOrMimeType) : langOrMimeType;
                this.raiseIfInternal(env, lang);
                Source.SourceBuilder newBuilder = Source.newBuilder((String)lang, (TruffleFile)env.getPublicTruffleFile(path));
                if (mimeType) {
                    newBuilder = newBuilder.mimeType(langOrMimeType);
                }
                return this.getContext().getEnv().parsePublic(newBuilder.name(path).build(), new String[0]).call(new Object[0]);
            }
            catch (IOException e) {
                throw this.raise(PythonErrorType.OSError, ErrorMessages.S, e);
            }
            catch (RuntimeException e) {
                throw this.raise(PythonErrorType.NotImplementedError, e);
            }
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object evalFile(TruffleString tpath, PNone string, PNone lang) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotEvalAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            try {
                String path = tpath.toJavaStringUncached();
                return this.getContext().getEnv().parsePublic(Source.newBuilder((String)"python", (TruffleFile)env.getPublicTruffleFile(path)).name(path).build(), new String[0]).call(new Object[0]);
            }
            catch (IOException e) {
                throw this.raise(PythonErrorType.OSError, ErrorMessages.S, e);
            }
            catch (RuntimeException e) {
                throw this.raise(PythonErrorType.NotImplementedError, e);
            }
        }

        @Specialization
        Object evalStringWithoutLang(PNone path, TruffleString string, PNone lang) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.POLYGLOT_EVAL_WITH_STRING_MUST_PASS_LANG);
        }

        @Fallback
        Object evalWithoutContent(Object path, Object string, Object lang) {
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.POLYGLOT_EVAL_MUST_PASS_STRINGS);
        }

        @CompilerDirectives.TruffleBoundary(transferToInterpreterOnException=false)
        private static String findLanguageByMimeType(TruffleLanguage.Env env, String mimeType) {
            Map languages = env.getPublicLanguages();
            for (String language : languages.keySet()) {
                for (String registeredMimeType : ((LanguageInfo)languages.get(language)).getMimeTypes()) {
                    if (!mimeType.equals(registeredMimeType)) continue;
                    return language;
                }
            }
            return null;
        }

        protected boolean isMimeType(String lang) {
            return lang.contains("/");
        }
    }

    @Builtin(name="import_value", minNumOfPositionalArgs=1, parameterNames={"name"})
    @GenerateNodeFactory
    public static abstract class ImportNode
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object importSymbol(TruffleString name) {
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!env.isPolyglotBindingsAccessAllowed()) {
                throw this.raise(PythonErrorType.NotImplementedError, ErrorMessages.POLYGLOT_ACCESS_NOT_ALLOWED);
            }
            Object object = env.importSymbol(name.toJavaStringUncached());
            if (object == null) {
                return PNone.NONE;
            }
            return object;
        }
    }
}

