/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.bz2;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.bz2.BZ2Object;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.runtime.NFIBz2Support;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

public class Bz2Nodes {
    protected static final int BZ_RUN = 0;
    protected static final int BZ_FLUSH = 1;
    protected static final int BZ_FINISH = 2;
    protected static final int BZ_OK = 0;
    protected static final int BZ_RUN_OK = 1;
    protected static final int BZ_FLUSH_OK = 2;
    protected static final int BZ_FINISH_OK = 3;
    protected static final int BZ_STREAM_END = 4;
    protected static final int BZ_SEQUENCE_ERROR = -1;
    protected static final int BZ_PARAM_ERROR = -2;
    protected static final int BZ_MEM_ERROR = -3;
    protected static final int BZ_DATA_ERROR = -4;
    protected static final int BZ_DATA_ERROR_MAGIC = -5;
    protected static final int BZ_IO_ERROR = -6;
    protected static final int BZ_UNEXPECTED_EOF = -7;
    protected static final int BZ_OUTBUFF_FULL = -8;
    protected static final int BZ_CONFIG_ERROR = -9;

    protected static void errorHandling(int bzerror, PRaiseNode raise) {
        switch (bzerror) {
            case -2: {
                throw raise.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_PARAMETERS_PASSED_TO_LIBBZIP2);
            }
            case -3: {
                throw raise.raise(PythonErrorType.MemoryError);
            }
            case -5: 
            case -4: {
                throw raise.raise(PythonErrorType.OSError, ErrorMessages.INVALID_DATA_STREAM);
            }
            case -6: {
                throw raise.raise(PythonErrorType.OSError, ErrorMessages.UNKNOWN_IO_ERROR);
            }
            case -7: {
                throw raise.raise(PythonBuiltinClassType.EOFError, ErrorMessages.COMPRESSED_FILE_ENDED_BEFORE_EOS);
            }
            case -1: {
                throw raise.raise(PythonErrorType.RuntimeError, ErrorMessages.INVALID_SEQUENCE_OF_COMMANDS);
            }
            case -9: {
                throw raise.raise(PythonErrorType.ValueError, ErrorMessages.LIBBZIP2_WAS_NOT_COMPILED_CORRECTLY);
            }
        }
        throw raise.raise(PythonErrorType.OSError, ErrorMessages.UNRECOGNIZED_ERROR_FROM_LIBBZIP2_D, bzerror);
    }

    public static abstract class GetOutputNativeBufferNode
    extends PNodeWithRaise {
        public abstract byte[] execute(Object var1, PythonContext var2);

        @Specialization
        byte[] getBuffer(Object bzst, PythonContext context, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction getBufferSize, @Cached NativeLibrary.InvokeNativeFunction getBuffer, @Cached InlinedBranchProfile ofProfile) {
            int size;
            NFIBz2Support bz2Support = context.getNFIBz2Support();
            try {
                size = PInt.intValueExact(bz2Support.getOutputBufferSize(bzst, getBufferSize));
            }
            catch (OverflowException of) {
                ofProfile.enter(inliningTarget);
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.VALUE_TOO_LARGE_TO_FIT_INTO_INDEX);
            }
            if (size == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            byte[] resultArray = new byte[size];
            Object out = context.getEnv().asGuestValue((Object)resultArray);
            bz2Support.getOutputBuffer(bzst, out, getBuffer);
            return resultArray;
        }
    }

    public static abstract class Bz2NativeInternalDecompress
    extends PNodeWithRaise {
        public abstract byte[] execute(BZ2Object.BZ2Decompressor var1, int var2);

        @Specialization
        byte[] nativeInternalDecompress(BZ2Object.BZ2Decompressor self, int maxLength, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction decompress, @Cached NativeLibrary.InvokeNativeFunction getBzsAvailInReal, @Cached NativeLibrary.InvokeNativeFunction getNextInIndex, @Cached GetOutputNativeBufferNode getBuffer, @Cached InlinedConditionProfile errProfile, @Cached InlinedBranchProfile ofProfile) {
            PythonContext context = PythonContext.get(this);
            NFIBz2Support bz2Support = context.getNFIBz2Support();
            Object inGuest = self.getNextInGuest(context);
            int offset = self.getNextInIndex();
            int err = bz2Support.decompress(self.getBzs(), inGuest, offset, maxLength, 8192L, self.getBzsAvailInReal(), decompress);
            long nextInIdx = bz2Support.getNextInIndex(self.getBzs(), getNextInIndex);
            long bzsAvailInReal = bz2Support.getBzsAvailInReal(self.getBzs(), getBzsAvailInReal);
            try {
                self.setNextInIndex(nextInIdx);
                self.setBzsAvailInReal(bzsAvailInReal);
            }
            catch (OverflowException of) {
                ofProfile.enter(inliningTarget);
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.VALUE_TOO_LARGE_TO_FIT_INTO_INDEX);
            }
            if (err == 4) {
                self.setEOF();
            } else if (errProfile.profile(inliningTarget, err != 0)) {
                Bz2Nodes.errorHandling(err, this.getRaiseNode());
            }
            return getBuffer.execute(self.getBzs(), context);
        }
    }

    @GenerateUncached(value=false)
    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class Bz2NativeDecompress
    extends Node {
        public abstract byte[] execute(Node var1, BZ2Object.BZ2Decompressor var2, byte[] var3, int var4, int var5);

        @Specialization
        static byte[] nativeDecompress(Node inliningTarget, BZ2Object.BZ2Decompressor self, byte[] bytes, int len, int maxLength, @Cached InlinedConditionProfile hasNextIntProfile, @Cached InlinedBranchProfile isEofProfile, @Cached InlinedBranchProfile bzsAvailProfile, @Cached InlinedBranchProfile noInputBufferInUseProfile, @Cached(inline=false) Bz2NativeInternalDecompress decompress) {
            boolean inputBufferInUse;
            if (hasNextIntProfile.profile(inliningTarget, self.getNextIn() != null)) {
                int availNow = self.getInputBufferSize() - (self.getNextInIndex() + self.getBzsAvailInReal());
                int availTotal = self.getInputBufferSize() - self.getBzsAvailInReal();
                if (availTotal < len) {
                    int newSize = self.getInputBufferSize() + len - availNow;
                    self.resizeInputBuffer(newSize);
                    self.setNextIn(self.getInputBuffer());
                } else if (availNow < len) {
                    PythonUtils.arraycopy(self.getNextIn(), self.getNextInIndex(), self.getInputBuffer(), 0, self.getBzsAvailInReal());
                    self.setNextIn(self.getInputBuffer());
                    self.setNextInIndex(0);
                }
                PythonUtils.arraycopy(bytes, 0, self.getNextIn(), self.getNextInIndex() + self.getBzsAvailInReal(), len);
                self.incBzsAvailInReal(len);
                inputBufferInUse = true;
            } else {
                self.setNextIn(bytes);
                self.setBzsAvailInReal(len);
                inputBufferInUse = false;
            }
            byte[] result = decompress.execute(self, maxLength);
            if (self.isEOF()) {
                isEofProfile.enter(inliningTarget);
                self.setNeedsInput(false);
                if (self.getBzsAvailInReal() > 0) {
                    self.setUnusedData();
                }
            } else if (self.getBzsAvailInReal() == 0) {
                bzsAvailProfile.enter(inliningTarget);
                self.clearNextIn();
                self.setNextInIndex(0);
                self.setNeedsInput(true);
            } else {
                self.setNeedsInput(false);
                if (!inputBufferInUse) {
                    noInputBufferInUseProfile.enter(inliningTarget);
                    if (self.getInputBuffer() != null && self.getInputBufferSize() < self.getBzsAvailInReal()) {
                        self.discardInputBuffer();
                    }
                    if (self.getInputBuffer() == null) {
                        self.createInputBuffer(self.getBzsAvailInReal());
                    }
                    PythonUtils.arraycopy(self.getNextIn(), self.getNextInIndex(), self.getInputBuffer(), 0, self.getBzsAvailInReal());
                    self.setNextIn(self.getInputBuffer());
                    self.setNextInIndex(0);
                }
            }
            return result;
        }
    }

    public static abstract class Bz2NativeCompress
    extends PNodeWithRaise {
        public abstract byte[] execute(BZ2Object.BZ2Compressor var1, PythonContext var2, byte[] var3, int var4, int var5);

        public byte[] compress(BZ2Object.BZ2Compressor self, PythonContext context, byte[] bytes, int len) {
            return this.execute(self, context, bytes, len, 0);
        }

        public byte[] flush(BZ2Object.BZ2Compressor self, PythonContext context) {
            return this.execute(self, context, PythonUtils.EMPTY_BYTE_ARRAY, -1, 2);
        }

        @Specialization
        byte[] nativeCompress(BZ2Object.BZ2Compressor self, PythonContext context, byte[] bytes, int len, int action, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction compress, @Cached GetOutputNativeBufferNode getBuffer, @Cached InlinedConditionProfile errProfile) {
            NFIBz2Support bz2Support = context.getNFIBz2Support();
            Object inGuest = context.getEnv().asGuestValue((Object)bytes);
            int err = bz2Support.compress(self.getBzs(), inGuest, len, action, 8192L, compress);
            if (errProfile.profile(inliningTarget, err != 0)) {
                Bz2Nodes.errorHandling(err, this.getRaiseNode());
            }
            return getBuffer.execute(self.getBzs(), context);
        }
    }
}

