/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.function.Signature;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.argument.CreateArgumentsNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.frame.GetCurrentFrameRef;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public final class PythonCextCEvalBuiltins {

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class Py_LeaveRecursiveCall
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        Py_LeaveRecursiveCall() {
        }

        @Specialization
        Object doGeneric() {
            PythonLanguage language = PythonLanguage.get(this);
            PythonContext context = PythonContext.get(this);
            PythonContext.PythonThreadState threadState = context.getThreadState(language);
            --threadState.recursionDepth;
            return PNone.NO_VALUE;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.ConstCharPtr}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class Py_EnterRecursiveCall
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        Py_EnterRecursiveCall() {
        }

        @Specialization
        int doGeneric(Object where) {
            PythonLanguage language = PythonLanguage.get(this);
            PythonContext context = PythonContext.get(this);
            PythonContext.PythonThreadState threadState = context.getThreadState(language);
            if (++threadState.recursionDepth > 1000) {
                throw Py_EnterRecursiveCall.raiseRecursionError(this, where);
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        private static PException raiseRecursionError(Node node, Object where) {
            TruffleString msg = CastToTruffleStringNode.executeUncached(CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(where));
            TruffleString.ConcatNode.getUncached().execute((AbstractTruffleString)ErrorMessages.MAXIMUM_RECURSION_DEPTH_EXCEEDED, (AbstractTruffleString)msg, PythonUtils.TS_ENCODING, false);
            throw PRaiseNode.raiseUncached(node, PythonBuiltinClassType.RecursionError, msg);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObjectConstPtr, ArgDescriptor.Int, ArgDescriptor.PyObjectConstPtr, ArgDescriptor.Int, ArgDescriptor.PyObjectConstPtr, ArgDescriptor.Int, ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class _PyTruffleEval_EvalCodeEx
    extends PythonCextBuiltins.CApi11BuiltinNode {
        _PyTruffleEval_EvalCodeEx() {
        }

        @Specialization
        static Object doGeneric(PCode code, Object globals, Object locals, Object argumentArrayPtr, int argumentCount, Object kwsPtr, int kwsCount, Object defaultValueArrayPtr, int defaultValueCount, Object kwdefaultsWrapper, Object closureObj, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadObjectNode readNode, @Cached PythonCextBuiltins.CastKwargsNode castKwargsNode, @Cached CastToTruffleStringNode castToStringNode, @Cached SequenceNodes.GetObjectArrayNode getObjectArrayNode, @Cached CodeNodes.GetCodeSignatureNode getSignatureNode, @Cached CodeNodes.GetCodeCallTargetNode getCallTargetNode, @Cached CreateArgumentsNode.CreateAndCheckArgumentsNode createAndCheckArgumentsNode, @Cached GenericInvokeNode invokeNode2) {
            Object[] defaults = readNode.readPyObjectArray(defaultValueArrayPtr, defaultValueCount);
            PKeyword[] kwdefaults = castKwargsNode.execute(kwdefaultsWrapper);
            PCell[] closure = null;
            if (closureObj != PNone.NO_VALUE) {
                closure = PCell.toCellArray(getObjectArrayNode.execute(inliningTarget, closureObj));
            }
            Object[] kws = readNode.readPyObjectArray(kwsPtr, kwsCount * 2);
            PKeyword[] keywords = PKeyword.create(kws.length / 2);
            for (int i = 0; i < kws.length / 2; i += 2) {
                TruffleString keywordName = castToStringNode.execute(inliningTarget, kws[i]);
                keywords[i] = new PKeyword(keywordName, kws[i + 1]);
            }
            Object[] userArguments = readNode.readPyObjectArray(argumentArrayPtr, argumentCount);
            Signature signature = getSignatureNode.execute(inliningTarget, code);
            Object[] pArguments = createAndCheckArgumentsNode.execute(inliningTarget, code, userArguments, keywords, signature, null, null, defaults, kwdefaults, false);
            if (!(locals instanceof PNone)) {
                PArguments.setSpecialArgument(pArguments, locals);
            }
            PArguments.setClosure(pArguments, closure);
            if (globals instanceof PythonObject) {
                PArguments.setGlobals(pArguments, (PythonObject)globals);
            }
            RootCallTarget rootCallTarget = getCallTargetNode.execute(inliningTarget, code);
            return invokeNode2.execute(rootCallTarget, pArguments);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyFrameObjectTransfer, args={}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyEval_GetFrame
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyEval_GetFrame() {
        }

        @Specialization
        Object getFrame(@Bind(value="this") Node inliningTarget, @Cached GetCurrentFrameRef getCurrentFrameRef, @Cached ReadCallerFrameNode readCallerFrameNode) {
            PFrame.Reference reference = getCurrentFrameRef.execute(null, inliningTarget);
            return readCallerFrameNode.executeWith(reference, 0);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectBorrowed, args={}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyEval_GetBuiltins
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyEval_GetBuiltins() {
        }

        @Specialization
        Object release(@Cached GetDictIfExistsNode getDictNode) {
            PythonModule cext = this.getCore().getBuiltins();
            return getDictNode.execute(cext);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Void, args={ArgDescriptor.PyThreadState}, acquiresGIL=false, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyEval_RestoreThread
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyEval_RestoreThread.class);

        PyEval_RestoreThread() {
        }

        @Specialization
        static PThreadState restore(Object ptr, @Cached GilNode gil) {
            PythonContext context = PythonContext.get(gil);
            PThreadState threadState = PThreadState.getThreadState(PythonLanguage.get(gil), context);
            LOGGER.fine("C extension acquires GIL");
            gil.acquire(context);
            return threadState;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyThreadState, args={}, acquiresGIL=false, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyEval_SaveThread
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        private static final TruffleLogger LOGGER = CApiContext.getLogger(PyEval_SaveThread.class);

        PyEval_SaveThread() {
        }

        @Specialization
        static PThreadState save(@Cached GilNode gil) {
            PythonContext context = PythonContext.get(gil);
            PThreadState threadState = PThreadState.getThreadState(PythonLanguage.get(gil), context);
            LOGGER.fine("C extension releases GIL");
            gil.release(context, true);
            return threadState;
        }
    }
}

