/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.modules.cext.PythonCextUnicodeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.codecs.ErrorHandlers;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.UnicodeObjectNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.ArgDescriptor;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.PMemoryView;
import com.oracle.graal.python.builtins.objects.str.NativeCharSequence;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.lib.PyUnicodeFromEncodedObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromDynamicObjectNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public final class PythonCextUnicodeBuiltins {
    static TruffleString convertEncoding(Object obj) {
        return obj == PNone.NO_VALUE ? StringLiterals.T_UTF8 : (TruffleString)obj;
    }

    static TruffleString convertErrors(Object obj) {
        return obj == PNone.NO_VALUE ? StringLiterals.T_STRICT : (TruffleString)obj;
    }

    static boolean isStringSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PString);
    }

    static boolean isAnyString(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
        return PGuards.isString(obj) || PythonCextUnicodeBuiltins.isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode);
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtr, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicodeDecodeError_Create
    extends PythonCextBuiltins.CApi6BuiltinNode {
        PyUnicodeDecodeError_Create() {
        }

        @Specialization
        Object doit(Object encoding, Object object, int length, int start, int end, Object reason, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached CallNode callNode) {
            PBytes bytes;
            try {
                bytes = this.factory().createBytes(getByteArrayNode.execute(object, length));
            }
            catch (InteropException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
            return callNode.execute((Object)PythonBuiltinClassType.UnicodeDecodeError, encoding, bytes, start, end, reason);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor._PY_ERROR_HANDLER, args={ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _Py_GetErrorHandler
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _Py_GetErrorHandler() {
        }

        @Specialization
        Object doGeneric(TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached ErrorHandlers.GetErrorHandlerNode getErrorHandlerNode) {
            return getErrorHandlerNode.execute(inliningTarget, errors).getNativeValue();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.VA_LIST_PTR}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Unicode_FromFormat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Unicode_FromFormat() {
        }

        @Specialization
        Object doGeneric(TruffleString format, Object vaList, @Cached CExtNodes.UnicodeFromFormatNode unicodeFromFormatNode) {
            return unicodeFromFormatNode.execute(format, vaList);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class PyTruffle_Unicode_AsWideChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyTruffle_Unicode_AsWideChar() {
        }

        @Specialization
        Object doUnicode(Object s, long elementSize, @Bind(value="this") Node inliningTarget, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode, @Cached CastToTruffleStringNode castStr) {
            try {
                PBytes wchars = asWideCharNode.executeLittleEndian(castStr.execute(inliningTarget, s), elementSize);
                if (wchars != null) {
                    return wchars;
                }
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.UNSUPPORTED_SIZE_WAS, "wchar", elementSize);
            }
            catch (IllegalArgumentException e) {
                throw this.raise(PythonErrorType.LookupError, ErrorMessages.M, e);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffle_Unicode_DecodeUTF32
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyTruffle_Unicode_DecodeUTF32() {
        }

        @Specialization
        Object doUnicodeStringErrors(Object o, long size, TruffleString errors, int byteorder, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode) {
            try {
                return this.decodeUTF32(getByteArrayNode.execute(o, size), (int)size, errors, byteorder);
            }
            catch (CharacterCodingException e) {
                throw this.raise(PythonErrorType.UnicodeEncodeError, ErrorMessages.M, e);
            }
            catch (IllegalArgumentException e) {
                TruffleString csName = CExtCommonNodes.Charsets.getUTF32Name(byteorder);
                throw this.raise(PythonErrorType.LookupError, ErrorMessages.UNKNOWN_ENCODING, csName);
            }
            catch (InteropException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.INPUT_TOO_LONG);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private TruffleString decodeUTF32(byte[] data, int size, TruffleString errors, int byteorder) throws CharacterCodingException {
            CharsetDecoder decoder = CExtCommonNodes.Charsets.getUTF32Charset(byteorder).newDecoder();
            CodingErrorAction action = BytesBuiltins.toCodingErrorAction(errors, this, TruffleString.EqualNode.getUncached());
            CharBuffer decode = decoder.onMalformedInput(action).onUnmappableCharacter(action).decode(PyTruffle_Unicode_DecodeUTF32.wrap(data, 0, size));
            return PythonUtils.toTruffleStringUncached(decode.toString());
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTruffle_Unicode_AsUnicodeAndSize_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_Unicode_AsUnicodeAndSize_Size() {
        }

        @Specialization
        Object doUnicode(PString s) {
            return s.getWCharBytes().getSequenceStorage().length() / CStructs.wchar_t.size();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PY_UNICODE_PTR, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTruffle_Unicode_AsUnicodeAndSize_CharPtr
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_Unicode_AsUnicodeAndSize_CharPtr() {
        }

        @Specialization
        Object doUnicode(PString s, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profile, @Cached UnicodeObjectNodes.UnicodeAsWideCharNode asWideCharNode) {
            if (profile.profile(inliningTarget, s.getWCharBytes() == null)) {
                PBytes bytes = asWideCharNode.executeNativeOrder(s, CStructs.wchar_t.size());
                s.setWCharBytes(bytes);
            }
            return PySequenceArrayWrapper.ensureNativeSequence(s.getWCharBytes());
        }

        @Fallback
        Object doError(Object s) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTruffle_Unicode_AsUTF8AndSize_Size
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_Unicode_AsUTF8AndSize_Size() {
        }

        @Specialization
        Object doUnicode(PString s) {
            return s.getUtf8Bytes().getSequenceStorage().length();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.ConstCharPtr, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyTruffle_Unicode_AsUTF8AndSize_CharPtr
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffle_Unicode_AsUTF8AndSize_CharPtr() {
        }

        @Specialization
        static Object doUnicode(PString s, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profile, @Cached _PyUnicode_AsUTF8String asUTF8String) {
            if (profile.profile(inliningTarget, s.getUtf8Bytes() == null)) {
                PBytes bytes = (PBytes)asUTF8String.execute(s, StringLiterals.T_STRICT);
                s.setUtf8Bytes(bytes);
            }
            return PySequenceArrayWrapper.ensureNativeSequence(s.getUtf8Bytes());
        }

        @Fallback
        Object doError(Object s) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyUnicode_AsUTF8String
    extends NativeEncoderNode {
        protected _PyUnicode_AsUTF8String() {
            super(StandardCharsets.UTF_8);
        }

        public static _PyUnicode_AsUTF8String create() {
            return PythonCextUnicodeBuiltinsFactory._PyUnicode_AsUTF8StringNodeGen.create();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyUnicode_AsASCIIString
    extends NativeEncoderNode {
        protected _PyUnicode_AsASCIIString() {
            super(StandardCharsets.US_ASCII);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class _PyUnicode_AsLatin1String
    extends NativeEncoderNode {
        protected _PyUnicode_AsLatin1String() {
            super(StandardCharsets.ISO_8859_1);
        }
    }

    static abstract class NativeEncoderNode
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        private final Charset charset;

        protected NativeEncoderNode(Charset charset) {
            this.charset = charset;
        }

        @Specialization(guards={"isNoValue(errors)"})
        Object doUnicode(PString s, PNone errors, @Cached.Shared(value="encodeNode") @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode) {
            return this.doUnicode(s, StringLiterals.T_STRICT, encodeNativeStringNode);
        }

        @Specialization
        Object doUnicode(PString s, TruffleString errors, @Cached.Shared(value="encodeNode") @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode) {
            return this.factory().createBytes(encodeNativeStringNode.execute(this.charset, s, errors));
        }

        @Fallback
        Object doUnicode(Object s, Object errors) {
            return this.raise(PythonErrorType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObject, args={ArgDescriptor.CONST_WCHAR_PTR, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_FromWideChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_FromWideChar() {
        }

        @Specialization
        Object doInt(Object arr, long size, @Cached CExtCommonNodes.ReadUnicodeArrayNode readArray, @Cached TruffleString.FromIntArrayUTF32Node fromArray) {
            assert (PythonUtils.TS_ENCODING == TruffleString.Encoding.UTF_32) : "needs switch_encoding otherwise";
            return this.factory().createString(fromArray.execute(readArray.execute(arr, this.castToInt(size), CStructs.wchar_t.size())));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_EncodeFSDefault
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_EncodeFSDefault() {
        }

        @Specialization
        PBytes fromObject(TruffleString s, @Cached.Shared(value="encode") @Cached CExtCommonNodes.EncodeNativeStringNode encode) {
            byte[] array = encode.execute(StandardCharsets.UTF_8, s, StringLiterals.T_REPLACE);
            return this.factory().createBytes(array);
        }

        @Specialization
        PBytes fromObject(Object s, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached.Shared(value="encode") @Cached CExtCommonNodes.EncodeNativeStringNode encode) {
            byte[] array = encode.execute(StandardCharsets.UTF_8, castStr.execute(inliningTarget, s), StringLiterals.T_REPLACE);
            return this.factory().createBytes(array);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleUnicode_Decode
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleUnicode_Decode() {
        }

        @Specialization
        Object doDecode(PMemoryView mv, TruffleString encoding, TruffleString errors, @Cached CodecsModuleBuiltins.DecodeNode decodeNode) {
            return decodeNode.executeWithStrings(null, mv, encoding, errors);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleUnicode_DecodeUTF8Stateful
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyTruffleUnicode_DecodeUTF8Stateful() {
        }

        @Specialization
        Object doUtf8Decode(Object cByteArray, long size, TruffleString errors, int reportConsumed, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode) {
            try {
                byte[] bytes = getByteArrayNode.execute(cByteArray, size);
                return this.factory().createTuple(PyTruffleUnicode_DecodeUTF8Stateful.decode(errors, bytes));
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.SystemError, ErrorMessages.INPUT_TOO_LONG);
            }
            catch (InteropException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.M, new Object[]{e});
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static Object[] decode(TruffleString errors, byte[] bytes) {
            TruffleString string;
            ByteBuffer inputBuffer = PyTruffleUnicode_DecodeUTF8Stateful.wrap(bytes);
            int n = inputBuffer.remaining();
            CharBuffer resultBuffer = CharBuffer.allocate(n * 4);
            CharsetDecoder decoder = StandardCharsets.UTF_8.newDecoder();
            CodingErrorAction action = CodecsModuleBuiltins.convertCodingErrorAction(errors, TruffleString.EqualNode.getUncached());
            decoder.onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(action).decode(inputBuffer, resultBuffer, true);
            int len = resultBuffer.position();
            if (len > 0) {
                resultBuffer.rewind();
                string = PythonUtils.toTruffleStringUncached(resultBuffer.subSequence(0, len).toString());
            } else {
                string = StringLiterals.T_EMPTY_STRING;
            }
            return new Object[]{string, n - inputBuffer.remaining()};
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_Split
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_Split() {
        }

        @Specialization
        Object split(Object string, Object sep, Object maxsplit, @Cached StringBuiltins.SplitNode splitNode) {
            return splitNode.execute(null, string, sep, maxsplit);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_Contains
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Contains() {
        }

        @Specialization
        static int contains(Object haystack, Object needle, @Cached StringBuiltins.ContainsNode containsNode) {
            return containsNode.executeBool(haystack, needle) ? 1 : 0;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_DecodeFSDefault
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_DecodeFSDefault() {
        }

        @Specialization
        PString run(TruffleString str) {
            return this.factory().createString(str);
        }

        @Specialization
        static PString run(PString str) {
            return str;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_FromString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromString() {
        }

        @Specialization
        PString run(TruffleString str) {
            return this.factory().createString(str);
        }

        @Specialization
        static PString run(PString str) {
            return str;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleUnicode_FromUTF
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleUnicode_FromUTF() {
        }

        private TruffleString.Encoding encodingFromKind(int kind) throws PException {
            return switch (kind) {
                case 1 -> TruffleString.Encoding.UTF_8;
                case 2 -> TruffleString.Encoding.UTF_16LE;
                case 4 -> TruffleString.Encoding.UTF_32LE;
                default -> throw this.raiseBadInternalCall();
            };
        }

        private PString asPString(TruffleString ts, TruffleString.SwitchEncodingNode switchEncodingNode) {
            return this.factory().createString(switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
        }

        @Specialization(guards={"ptrLib.isPointer(ptr)"})
        Object doNative(Object ptr, long byteLength, int kind, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            try {
                int iByteLength = PInt.intValueExact(byteLength);
                TruffleString.Encoding srcEncoding = this.encodingFromKind(kind);
                TruffleString ts = fromNativePointerNode.execute(ptr, 0, iByteLength, srcEncoding, true);
                return this.asPString(ts, switchEncodingNode);
            }
            catch (OverflowException e) {
                throw this.raise(PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"!ptrLib.isPointer(ptr)"})
        Object doManaged(Object ptr, long byteLength, int kind, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            try {
                TruffleString.Encoding srcEncoding = this.encodingFromKind(kind);
                byte[] ucsBytes = getByteArrayNode.execute(ptr, byteLength);
                TruffleString ts = fromByteArrayNode.execute(ucsBytes, srcEncoding);
                return this.asPString(ts, switchEncodingNode);
            }
            catch (InteropException e) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw this.raise(PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleUnicode_FromUCS
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleUnicode_FromUCS() {
        }

        private TruffleString.Encoding encodingFromKind(int kind) throws PException {
            return switch (kind) {
                case 1 -> TruffleString.Encoding.ISO_8859_1;
                case 2 -> TruffleString.Encoding.UTF_16;
                case 4 -> PythonUtils.TS_ENCODING;
                default -> throw this.raiseBadInternalCall();
            };
        }

        private PString asPString(TruffleString ts, TruffleString.SwitchEncodingNode switchEncodingNode) {
            return this.factory().createString(switchEncodingNode.execute((AbstractTruffleString)ts, PythonUtils.TS_ENCODING));
        }

        @Specialization(guards={"ptrLib.isPointer(ptr)"})
        Object doNative(Object ptr, long byteLength, int kind, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached TruffleString.FromNativePointerNode fromNativePointerNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            try {
                int iByteLength = PInt.intValueExact(byteLength);
                TruffleString.Encoding srcEncoding = this.encodingFromKind(kind);
                TruffleString ts = fromNativePointerNode.execute(ptr, 0, iByteLength, srcEncoding, true);
                return this.asPString(ts, switchEncodingNode);
            }
            catch (OverflowException e) {
                throw this.raise(PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"!ptrLib.isPointer(ptr)"})
        Object doManaged(Object ptr, long byteLength, int kind, @Cached.Shared(value="ptrLib") @CachedLibrary(limit="1") InteropLibrary ptrLib, @Cached CExtCommonNodes.GetByteArrayNode getByteArrayNode, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached.Shared(value="switchEncodingNode") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            try {
                TruffleString.Encoding srcEncoding = this.encodingFromKind(kind);
                byte[] ucsBytes = getByteArrayNode.execute(ptr, byteLength);
                TruffleString ts = fromByteArrayNode.execute(ucsBytes, srcEncoding);
                return this.asPString(ts, switchEncodingNode);
            }
            catch (InteropException e) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.M, new Object[]{e});
            }
            catch (OverflowException e) {
                throw this.raise(PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Pointer, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.PY_UCS4}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleUnicode_New
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyTruffleUnicode_New() {
        }

        @Specialization
        Object doGeneric(Object ptr, long elements, long elementSize, int isAscii) {
            return this.factory().createString(new NativeCharSequence(ptr, (int)elements, (int)elementSize, isAscii != 0));
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PY_UCS4, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_ReadChar
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_ReadChar() {
        }

        @Specialization
        int doGeneric(Object type, long lindex, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToStringNode, @Cached TruffleString.CodePointLengthNode lengthNode, @Cached TruffleString.CodePointAtIndexNode codepointAtIndexNode) {
            try {
                TruffleString s = castToStringNode.execute(inliningTarget, type);
                int index = PInt.intValueExact(lindex);
                if (index < 0 || index >= lengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING)) {
                    throw this.raise(PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
                }
                return codepointAtIndexNode.execute((AbstractTruffleString)s, index, PythonUtils.TS_ENCODING);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            catch (OverflowException e) {
                throw this.raise(PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_AsUnicodeEscapeString
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_AsUnicodeEscapeString() {
        }

        @Specialization(guards={"isString(s)"})
        Object escape(Object s, @Cached CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached TupleBuiltins.GetItemNode getItemNode) {
            return getItemNode.execute(null, encodeNode.execute(null, s, CodecsModuleBuiltins.T_UNICODE_ESCAPE, PNone.NO_VALUE), (Object)0);
        }

        @Specialization(guards={"!isString(s)", "isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)"})
        Object escape(Object s, @Bind(value="this") Node inliningTarget, @Cached CodecsModuleBuiltins.CodecsEncodeNode encodeNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached TupleBuiltins.GetItemNode getItemNode) {
            return this.escape(s, encodeNode, getItemNode);
        }

        @Specialization(guards={"!isString(obj)", "!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        Object escape(Object obj, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Replace
    extends PythonCextBuiltins.CApiQuaternaryBuiltinNode {
        PyUnicode_Replace() {
        }

        @Specialization(guards={"isString(s)", "isString(substr)", "isString(replstr)"})
        Object replace(Object s, Object substr, Object replstr, long count, @Cached StringBuiltins.ReplaceNode replaceNode) {
            return replaceNode.execute(null, s, substr, replstr, count);
        }

        @Specialization(guards={"!isString(s)", "!isString(substr)", "!isString(replstr)", "isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)", "isStringSubtype(inliningTarget, substr, getClassNode, isSubtypeNode)", "isStringSubtype(inliningTarget, replstr, getClassNode, isSubtypeNode)"})
        public Object replace(Object s, Object substr, Object replstr, long count, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.ReplaceNode replaceNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return this.replace(s, substr, replstr, count, replaceNode);
        }

        @Specialization(guards={"!isString(s)", "!isString(substr)", "!isString(replstr)", "!isStringSubtype(inliningTarget, s, getClassNode, isSubtypeNode)", "!isStringSubtype(inliningTarget, substr, getClassNode, isSubtypeNode)", "!isStringSubtype(inliningTarget, replstr, getClassNode, isSubtypeNode)"})
        public Object replace(Object s, Object substr, Object replstr, long count, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return this.getNativeNull();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_AsEncodedString
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_AsEncodedString() {
        }

        @Specialization(guards={"isString(obj) || isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        Object encode(Object obj, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EncodeNode encodeNode) {
            return encodeNode.execute(null, obj, PythonCextUnicodeBuiltins.convertEncoding(encoding), PythonCextUnicodeBuiltins.convertErrors(errors));
        }

        @Specialization(guards={"!isString(obj)", "!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        Object encode(Object obj, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Tailmatch
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyUnicode_Tailmatch() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, string, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)", "direction > 0"})
        static int tailmatch(Object string, Object substring, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode, @Cached StringBuiltins.EndsWithNode endsWith, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, string, SpecialMethodNames.T___GETITEM__);
            Object slice = callNode.execute(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
            return (Boolean)endsWith.execute(null, slice, substring, start, end) != false ? 1 : 0;
        }

        @Specialization(guards={"isAnyString(inliningTarget, string, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)", "direction <= 0"})
        static int tailmatch(Object string, Object substring, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode, @Cached StringBuiltins.StartsWithNode startsWith, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, string, SpecialMethodNames.T___GETITEM__);
            Object slice = callNode.execute(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
            return (Boolean)startsWith.execute(null, slice, substring, start, end) != false ? 1 : 0;
        }

        @Specialization(guards={"!isAnyString(inliningTarget, string, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, substring, getClassNode, isSubtypeNode)"})
        Object find(Object string, Object substring, Object start, Object end, Object direction, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, string);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Compare
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Compare() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, left, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EqNode eqNode, @Cached StringBuiltins.LtNode ltNode, @Cached ConditionProfile eqProfile) {
            if (eqProfile.profile(((Boolean)eqNode.execute(null, left, right)).booleanValue())) {
                return 0;
            }
            return (Boolean)ltNode.execute(null, left, right) != false ? -1 : 1;
        }

        @Specialization(guards={"!isAnyString(inliningTarget, left, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, left, right);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Int, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class _PyUnicode_EqualToASCIIString
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        _PyUnicode_EqualToASCIIString() {
        }

        @Specialization(guards={"isAnyString(inliningTarget, left, getClassNode, isSubtypeNode)", "isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        static Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached StringBuiltins.EqNode eqNode, @Cached PyObjectIsTrueNode isTrue) {
            return PInt.intValue(isTrue.execute(null, inliningTarget, eqNode.execute(null, left, right)));
        }

        @Specialization(guards={"!isAnyString(inliningTarget, left, getClassNode, isSubtypeNode) || !isAnyString(inliningTarget, right, getClassNode, isSubtypeNode)"})
        Object compare(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_COMPARE, left, right);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Join
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Join() {
        }

        @Specialization(guards={"isString(separator) || isStringSubtype(inliningTarget, separator, getClassNode, isSubtypeNode)"})
        Object find(Object separator, Object seq, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.JoinNode joinNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return joinNode.execute(null, separator, seq);
        }

        @Specialization(guards={"!isTruffleString(separator)", "isStringSubtype(inliningTarget, separator, getClassNode, isSubtypeNode)"})
        Object find(Object separator, Object seq, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, separator);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Substring
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_Substring() {
        }

        @Specialization(guards={"isString(s) || isStringSubtype(s, inliningTarget, getClassNode, isSubtypeNode)"})
        static Object doString(Object s, long start, long end, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile profile, @Cached PyObjectLookupAttr lookupAttrNode, @Cached PySliceNew sliceNode, @Cached CallNode callNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            if (profile.profile(inliningTarget, start < 0L || end < 0L)) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
            Object getItemCallable = lookupAttrNode.execute(null, inliningTarget, s, SpecialMethodNames.T___GETITEM__);
            return callNode.execute(getItemCallable, sliceNode.execute(inliningTarget, start, end, PNone.NONE));
        }

        @Specialization(guards={"!isTruffleString(s)", "isStringSubtype(s, inliningTarget, getClassNode, isSubtypeNode)"})
        Object doError(Object s, Object start, Object end, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, s);
        }

        protected static boolean isStringSubtype(Object obj, Node n, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(n, obj), (Object)PythonBuiltinClassType.PString);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.Py_ssize_t, args={ArgDescriptor.PyObject, ArgDescriptor.PY_UCS4, ArgDescriptor.Py_ssize_t, ArgDescriptor.Py_ssize_t, ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @TypeSystemReference(value=PythonTypes.class)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FindChar
    extends PythonCextBuiltins.CApi5BuiltinNode {
        PyUnicode_FindChar() {
        }

        @Specialization(guards={"isString(string) || isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)", "direction > 0"})
        static Object find(Object string, Object c, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.ChrNode chrNode, @Cached StringBuiltins.FindNode findNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return findNode.execute(null, string, chrNode.execute(null, c), start, end);
        }

        @Specialization(guards={"isString(string) || isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)", "direction <= 0"})
        static Object find(Object string, Object c, long start, long end, long direction, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.ChrNode chrNode, @Cached StringBuiltins.RFindNode rFindNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return rFindNode.execute(null, string, chrNode.execute(null, c), start, end);
        }

        @Specialization(guards={"!isTruffleString(string)", "isStringSubtype(inliningTarget, string, getClassNode, isSubtypeNode)"})
        Object find(Object string, Object c, Object start, Object end, Object direction, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, string);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Format
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Format() {
        }

        @Specialization(guards={"isString(format) || isStringSubtype(inliningTarget, format, getClassNode, isSubtypeNode)"})
        Object find(Object format, Object args, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.ModNode modNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            this.checkNonNullArg(format, args);
            return modNode.execute(null, format, args);
        }

        @Specialization(guards={"!isTruffleString(format)", "isStringSubtype(inliningTarget, format, getClassNode, isSubtypeNode)"})
        Object find(Object format, Object args, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            this.checkNonNullArg(format, args);
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, format);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObject, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Ignored)
    static abstract class PyTruffleUnicode_LookupAndIntern
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleUnicode_LookupAndIntern() {
        }

        @Specialization
        Object withTS(TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached StringNodes.InternStringNode internNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            Object interned;
            PDict dict = this.getCApiContext().getInternedUnicode();
            if (dict == null) {
                dict = this.factory().createDict();
                this.getCApiContext().setInternedUnicode(dict);
            }
            if ((interned = getItem.execute(inliningTarget, dict.getDictStorage(), str)) == null) {
                interned = internNode.execute(inliningTarget, str);
                dict.setDictStorage(setItem.execute(inliningTarget, dict.getDictStorage(), str, interned));
            }
            return interned;
        }

        @Specialization
        Object withPString(PString str, @Bind(value="this") Node inliningTarget, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile isBuiltinClassProfile, @Cached ReadAttributeFromDynamicObjectNode readNode, @Cached.Exclusive @Cached StringNodes.InternStringNode internNode, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setItem) {
            boolean isInterned;
            if (!isBuiltinClassProfile.profileObject(inliningTarget, str, PythonBuiltinClassType.PString)) {
                return this.getNativeNull();
            }
            boolean bl = isInterned = readNode.execute((Object)str, PString.INTERNED) != PNone.NO_VALUE;
            if (isInterned) {
                return str;
            }
            return this.withTS(str.getValueUncached(), inliningTarget, internNode, getItem, setItem);
        }

        @Fallback
        Object nil(Object obj) {
            return this.getNativeNull();
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.ConstCharPtrAsTruffleString, ArgDescriptor.ConstCharPtrAsTruffleString}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FromEncodedObject
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyUnicode_FromEncodedObject() {
        }

        @Specialization
        static Object doGeneric(Object obj, Object encodingObj, Object errorsObj, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile encodingProfile, @Cached InlinedExactClassProfile errorsProfile, @Cached InlinedConditionProfile nullProfile, @Cached PyUnicodeFromEncodedObject decodeNode) {
            TruffleString errors;
            TruffleString encoding;
            Object encodingObjProfiled = encodingProfile.profile(inliningTarget, encodingObj);
            if (encodingObjProfiled == PNone.NO_VALUE) {
                encoding = StringLiterals.T_UTF8;
            } else {
                assert (encodingObjProfiled instanceof TruffleString);
                encoding = (TruffleString)encodingObjProfiled;
            }
            Object errorsObjProfiled = errorsProfile.profile(inliningTarget, errorsObj);
            if (errorsObjProfiled == PNone.NO_VALUE) {
                errors = StringLiterals.T_STRICT;
            } else {
                assert (errorsObjProfiled instanceof TruffleString);
                errors = (TruffleString)errorsObjProfiled;
            }
            if (nullProfile.profile(inliningTarget, obj == PNone.NO_VALUE)) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            return decodeNode.execute(null, inliningTarget, obj, encoding, errors);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject, ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_Concat
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyUnicode_Concat() {
        }

        @Specialization(guards={"isString(left) || isStringSubtype(inliningTarget, left, getClassNode, isSubtypeNode)", "isString(right) || isStringSubtype(inliningTarget, right, getClassNode, isSubtypeNode)"})
        Object concat(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached StringBuiltins.AddNode addNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return addNode.execute(null, left, right);
        }

        @Specialization(guards={"!isString(left)", "!isStringSubtype(inliningTarget, left, getClassNode, isSubtypeNode)"})
        Object leftNotString(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, left);
        }

        @Specialization(guards={"!isString(right)", "!isStringSubtype(inliningTarget, right, getClassNode, isSubtypeNode)"})
        Object rightNotString(Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.MUST_BE_STR_NOT_P, right);
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.PyObject}, call=PythonCextBuiltins.CApiCallPath.Direct)
    @ImportStatic(value={PythonCextUnicodeBuiltins.class})
    static abstract class PyUnicode_FromObject
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromObject() {
        }

        @Specialization
        static TruffleString fromObject(TruffleString s) {
            return s;
        }

        @Specialization(guards={"isPStringType(inliningTarget, s, getClassNode)"})
        static PString fromObject(PString s, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode) {
            return s;
        }

        @Specialization(guards={"!isPStringType(inliningTarget, obj, getClassNode)", "isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        Object fromObject(Object obj, @Bind(value="this") Node inliningTarget, @Cached BuiltinConstructors.StrNode strNode, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return strNode.executeWith(obj);
        }

        @Specialization(guards={"!isStringSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        Object fromObject(Object obj, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANT_CONVERT_TO_STR_IMPLICITLY, obj);
        }

        protected boolean isPStringType(Node inliningTarget, Object obj, GetClassNode getClassNode) {
            return getClassNode.execute(inliningTarget, obj) == PythonBuiltinClassType.PString;
        }
    }

    @PythonCextBuiltins.CApiBuiltin(ret=ArgDescriptor.PyObjectTransfer, args={ArgDescriptor.Int}, call=PythonCextBuiltins.CApiCallPath.Direct)
    static abstract class PyUnicode_FromOrdinal
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyUnicode_FromOrdinal() {
        }

        @Specialization
        static Object chr(int value, @Cached BuiltinFunctions.ChrNode chrNode) {
            return chrNode.execute(null, value);
        }
    }
}

