/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesModuleBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.modules.ctypes.memory.Pointer;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerNodes;
import com.oracle.graal.python.builtins.modules.ctypes.memory.PointerReference;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

public class CtypesNodes {
    public static final int WCHAR_T_SIZE = PythonOS.getPythonOS() == PythonOS.PLATFORM_WIN32 ? 2 : 4;
    public static final TruffleString.Encoding WCHAR_T_ENCODING = WCHAR_T_SIZE == 2 ? TruffleString.Encoding.UTF_16 : TruffleString.Encoding.UTF_32;

    protected static Object getValue(FFIType.FFI_TYPES type, byte[] storage, int offset) {
        return switch (type) {
            case FFIType.FFI_TYPES.FFI_TYPE_UINT8, FFIType.FFI_TYPES.FFI_TYPE_SINT8 -> storage[offset];
            case FFIType.FFI_TYPES.FFI_TYPE_UINT16, FFIType.FFI_TYPES.FFI_TYPE_SINT16 -> PythonUtils.ARRAY_ACCESSOR.getShort(storage, offset);
            case FFIType.FFI_TYPES.FFI_TYPE_UINT32, FFIType.FFI_TYPES.FFI_TYPE_SINT32 -> PythonUtils.ARRAY_ACCESSOR.getInt(storage, offset);
            case FFIType.FFI_TYPES.FFI_TYPE_UINT64, FFIType.FFI_TYPES.FFI_TYPE_SINT64, FFIType.FFI_TYPES.FFI_TYPE_POINTER -> PythonUtils.ARRAY_ACCESSOR.getLong(storage, offset);
            case FFIType.FFI_TYPES.FFI_TYPE_FLOAT -> Float.valueOf(PythonUtils.ARRAY_ACCESSOR.getFloat(storage, offset));
            case FFIType.FFI_TYPES.FFI_TYPE_DOUBLE -> PythonUtils.ARRAY_ACCESSOR.getDouble(storage, offset);
            default -> throw CompilerDirectives.shouldNotReachHere((String)"Unexpected value type for getValue");
        };
    }

    protected static void setValue(FFIType.FFI_TYPES type, byte[] storage, int offset, Object value) {
        switch (type) {
            case FFI_TYPE_UINT8: 
            case FFI_TYPE_SINT8: {
                storage[offset] = (Byte)value;
                break;
            }
            case FFI_TYPE_UINT16: 
            case FFI_TYPE_SINT16: {
                PythonUtils.ARRAY_ACCESSOR.putShort(storage, offset, ((Short)value).shortValue());
                break;
            }
            case FFI_TYPE_UINT32: 
            case FFI_TYPE_SINT32: {
                PythonUtils.ARRAY_ACCESSOR.putInt(storage, offset, ((Integer)value).intValue());
                break;
            }
            case FFI_TYPE_UINT64: 
            case FFI_TYPE_SINT64: {
                PythonUtils.ARRAY_ACCESSOR.putLong(storage, offset, ((Long)value).longValue());
                break;
            }
            case FFI_TYPE_FLOAT: {
                PythonUtils.ARRAY_ACCESSOR.putFloat(storage, offset, ((Float)value).floatValue());
                break;
            }
            case FFI_TYPE_DOUBLE: {
                PythonUtils.ARRAY_ACCESSOR.putDouble(storage, offset, ((Double)value).doubleValue());
                break;
            }
            case FFI_TYPE_STRUCT: {
                CtypesNodes.setValue(storage, value, offset);
                break;
            }
            default: {
                throw CompilerDirectives.shouldNotReachHere((String)"Unexpected value type for setValue");
            }
        }
    }

    protected static void setValue(byte[] value, Object v, int idx) {
        TruffleString s;
        if (v instanceof Byte) {
            value[idx] = (Byte)v;
            return;
        }
        if (v instanceof Short) {
            PythonUtils.ARRAY_ACCESSOR.putShort(value, idx, ((Short)v).shortValue());
            return;
        }
        if (v instanceof Integer) {
            PythonUtils.ARRAY_ACCESSOR.putInt(value, idx, ((Integer)v).intValue());
            return;
        }
        if (v instanceof Long) {
            PythonUtils.ARRAY_ACCESSOR.putLong(value, idx, ((Long)v).longValue());
            return;
        }
        if (v instanceof Double) {
            PythonUtils.ARRAY_ACCESSOR.putDouble(value, idx, ((Double)v).doubleValue());
            return;
        }
        if (v instanceof Boolean) {
            value[idx] = (byte)((Boolean)v != false ? 1 : 0);
            return;
        }
        if (v instanceof Float) {
            PythonUtils.ARRAY_ACCESSOR.putFloat(value, idx, ((Float)v).floatValue());
            return;
        }
        if (TruffleStringMigrationHelpers.isJavaString(v)) {
            String s2 = (String)v;
            if (CtypesNodes.length(s2) == 1) {
                value[idx] = (byte)CtypesNodes.charAt(s2, 0);
                return;
            }
        } else if (v instanceof TruffleString && (s = (TruffleString)v).codePointLengthUncached(PythonUtils.TS_ENCODING) == 1) {
            value[idx] = (byte)s.codePointAtIndexUncached(0, PythonUtils.TS_ENCODING);
            return;
        }
        throw CompilerDirectives.shouldNotReachHere((String)"Incompatible value type for ByteArrayStorage");
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static int length(String s) {
        return s.length();
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    public static char charAt(String s, int i) {
        return s.charAt(i);
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GenericPyCDataNewNode
    extends Node {
        public abstract CDataObject execute(Node var1, Object var2, StgDictObject var3);

        @Specialization
        static CDataObject doCreate(Node inliningTarget, Object type, StgDictObject dict, @Cached PyCDataMallocBufferNode mallocBufferNode) {
            CDataObject obj = mallocBufferNode.execute(inliningTarget, type, dict);
            obj.b_length = dict.length;
            dict.flags |= 0x1000;
            return obj;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyCDataMallocBufferNode
    extends Node {
        public abstract CDataObject execute(Node var1, Object var2, StgDictObject var3);

        @Specialization
        static CDataObject doCreate(Node inliningTarget, Object type, StgDictObject dict, @Cached CreateCDataObjectNode createCDataObjectNode) {
            Pointer pointer = dict.size > 0 ? Pointer.allocate(dict.ffi_type_pointer, dict.size) : Pointer.NULL;
            return createCDataObjectNode.execute(inliningTarget, type, pointer, dict.size, true);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class CreateCDataObjectNode
    extends Node {
        public abstract CDataObject execute(Node var1, Object var2, Pointer var3, int var4, boolean var5);

        @Specialization
        static CDataObject doCreate(Node inliningTarget, Object type, Pointer pointer, int size, boolean needsfree, @Cached IsSubtypeNode isSubtypeNode, @Cached PythonObjectFactory factory) {
            CDataObject result = isSubtypeNode.execute(type, (Object)PythonBuiltinClassType.PyCFuncPtr) ? factory.createPyCFuncPtrObject(type, pointer, size, needsfree) : factory.createCDataObject(type, pointer, size, needsfree);
            if (needsfree) {
                new PointerReference((Object)result, pointer, PythonContext.get(inliningTarget).getSharedFinalizer());
            }
            return result;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class PyCDataFromBaseObjNode
    extends Node {
        public abstract CDataObject execute(Node var1, Object var2, CDataObject var3, int var4, Pointer var5);

        @Specialization
        static CDataObject PyCData_FromBaseObj(Node inliningTarget, Object type, CDataObject base, int index, Pointer adr, @Cached PRaiseNode raiseNode, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CreateCDataObjectNode createCDataObjectNode, @Cached PyCDataMallocBufferNode mallocBufferNode, @Cached PointerNodes.MemcpyNode memcpyNode) {
            CDataObject cmem;
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(type, raiseNode);
            dict.flags |= 0x1000;
            if (base != null) {
                cmem = createCDataObjectNode.execute(inliningTarget, type, adr, dict.size, false);
                cmem.b_base = base;
            } else {
                cmem = mallocBufferNode.execute(inliningTarget, type, dict);
                memcpyNode.execute(inliningTarget, cmem.b_ptr, adr, dict.size);
            }
            cmem.b_length = dict.length;
            cmem.b_index = index;
            return cmem;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HandleFromLongNode
    extends Node {
        HandleFromLongNode() {
        }

        abstract Object execute(Node var1, Object var2);

        final CtypesModuleBuiltins.DLHandler getDLHandler(Node inliningTarget, Object pointerObj) {
            Object handle = this.execute(inliningTarget, pointerObj);
            if (handle instanceof CtypesModuleBuiltins.DLHandler) {
                CtypesModuleBuiltins.DLHandler dlHandler = (CtypesModuleBuiltins.DLHandler)handle;
                return dlHandler;
            }
            return null;
        }

        final CtypesModuleBuiltins.NativeFunction getNativeFunction(Node inliningTarget, Object pointerObj) {
            Object handle = this.execute(inliningTarget, pointerObj);
            if (handle instanceof CtypesModuleBuiltins.NativeFunction) {
                CtypesModuleBuiltins.NativeFunction nativeFunction = (CtypesModuleBuiltins.NativeFunction)handle;
                return nativeFunction;
            }
            return null;
        }

        @Specialization
        static Object convert(Node inliningTarget, Object pointerObj, @Cached PointerNodes.PointerFromLongNode pointerFromLongNode, @Cached HandleFromPointerNode handleFromPointerNode) {
            Pointer pointer = pointerFromLongNode.execute(inliningTarget, pointerObj);
            return handleFromPointerNode.execute(inliningTarget, pointer);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HandleFromPointerNode
    extends Node {
        HandleFromPointerNode() {
        }

        abstract Object execute(Node var1, Pointer var2);

        final CtypesModuleBuiltins.DLHandler getDLHandler(Node inliningTarget, Pointer pointer) {
            Object handle = this.execute(inliningTarget, pointer);
            if (handle instanceof CtypesModuleBuiltins.DLHandler) {
                CtypesModuleBuiltins.DLHandler dlHandler = (CtypesModuleBuiltins.DLHandler)handle;
                return dlHandler;
            }
            return null;
        }

        final CtypesModuleBuiltins.NativeFunction getNativeFunction(Node inliningTarget, Pointer pointer) {
            Object handle = this.execute(inliningTarget, pointer);
            if (handle instanceof CtypesModuleBuiltins.NativeFunction) {
                CtypesModuleBuiltins.NativeFunction nativeFunction = (CtypesModuleBuiltins.NativeFunction)handle;
                return nativeFunction;
            }
            return null;
        }

        @Specialization
        static Object convert(Node inliningTarget, Pointer pointer, @Cached PointerNodes.GetPointerValueAsObjectNode getPointerValueAsObjectNode) {
            Object handle = getPointerValueAsObjectNode.execute(inliningTarget, pointer);
            if (handle instanceof Long) {
                Long address = (Long)handle;
                return CtypesModuleBuiltins.getObjectAtAddress(PythonContext.get(inliningTarget), address);
            }
            return handle;
        }
    }

    @GenerateUncached
    protected static abstract class PyTypeCheck
    extends Node {
        protected PyTypeCheck() {
        }

        protected abstract boolean execute(Object var1, Object var2);

        protected final boolean isUnionTypeObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.UnionType);
        }

        protected final boolean isCDataObject(Object obj) {
            return obj instanceof CDataObject && this.execute(obj, (Object)PythonBuiltinClassType.PyCData);
        }

        protected final boolean isPyCArrayTypeObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCArrayType);
        }

        protected final boolean isArrayObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCArray);
        }

        protected final boolean isPyCFuncPtrObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCFuncPtr);
        }

        protected final boolean isPyCFuncPtrTypeObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCFuncPtrType);
        }

        protected final boolean isPyCPointerTypeObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCPointerType);
        }

        protected final boolean isPointerObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCPointer);
        }

        protected final boolean isPyCSimpleTypeObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCSimpleType);
        }

        boolean ctypesSimpleInstance(Node inliningTarget, Object type, TypeNodes.GetBaseClassNode getBaseClassNode, TypeNodes.IsSameTypeNode isSameTypeNode) {
            if (this.isPyCSimpleTypeObject(type)) {
                return !isSameTypeNode.execute(inliningTarget, getBaseClassNode.execute(inliningTarget, type), (Object)PythonBuiltinClassType.SimpleCData);
            }
            return false;
        }

        protected final boolean isPyCStructTypeObject(Object obj) {
            return this.execute(obj, (Object)PythonBuiltinClassType.PyCStructType);
        }

        @Specialization
        static boolean checkType(Object receiver, Object type, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            Object clazz = getClassNode.execute(inliningTarget, receiver);
            return isSubtypeNode.execute(clazz, type);
        }
    }
}

