/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.PyCStructTypeBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.StructUnionTypeBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCStructType})
public final class PyCStructTypeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCStructTypeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setattr__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    protected static abstract class SetattrNode
    extends PythonTernaryBuiltinNode {
        protected SetattrNode() {
        }

        @Specialization
        PNone doStringKey(VirtualFrame frame, Object object, TruffleString key, Object value, @Cached.Shared @Cached TruffleString.EqualNode equalNode, @Cached.Shared @Cached WriteAttributeToObjectNode writeNode, @Cached.Shared @Cached StructUnionTypeBuiltins.PyCStructUnionTypeUpdateStgDict updateStgDict) {
            writeNode.execute(object, key, value);
            if (equalNode.execute((AbstractTruffleString)key, (AbstractTruffleString)StructUnionTypeBuiltins.T__FIELDS_, PythonUtils.TS_ENCODING)) {
                updateStgDict.execute(frame, object, value, true, this.factory());
            }
            return PNone.NONE;
        }

        @Specialization(replaces={"doStringKey"})
        PNone doGenericKey(VirtualFrame frame, Object object, Object keyObject, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached TruffleString.EqualNode equalNode, @Cached.Shared @Cached WriteAttributeToObjectNode writeNode, @Cached.Shared @Cached StructUnionTypeBuiltins.PyCStructUnionTypeUpdateStgDict updateStgDict, @Cached CastToTruffleStringNode castKeyToStringNode) {
            TruffleString key;
            try {
                key = castKeyToStringNode.execute(inliningTarget, keyObject);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_NAME_MUST_BE_STRING, keyObject);
            }
            return this.doStringKey(frame, object, key, value, equalNode, writeNode, updateStgDict);
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends StructUnionTypeBuiltins.StructUnionTypeNewNode {
        protected NewNode() {
        }
    }
}

