/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.io.AbstractBufferedIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedReaderBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.IOBaseBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PBufferedReader})
public final class BufferedReaderBuiltins
extends AbstractBufferedIOBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BufferedReaderBuiltinsFactory.getFactories();
    }

    @Builtin(name="flush", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class FlushNode
    extends AbstractBufferedIOBuiltins.PythonUnaryWithInitErrorBuiltinNode {
        FlushNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static Object doit(VirtualFrame frame, PBuffered self, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod) {
            return callMethod.execute((Frame)frame, inliningTarget, self.getRaw(), IONodes.T_FLUSH, new Object[0]);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2, parameterNames={"self", "raw", "buffer_size"}, raiseErrorName="BufferedReader")
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonBuiltinNode {
        @Specialization
        final Object doIt(VirtualFrame frame, PBuffered self, Object raw, Object bufferSize, @Bind(value="this") Node inliningTarget, @Cached AbstractBufferedIOBuiltins.InitBufferSizeNode initBufferSizeNode, @Cached BufferedReaderInit init) {
            int size = initBufferSizeNode.execute(frame, inliningTarget, bufferSize);
            init.execute(frame, inliningTarget, self, raw, size, this.factory());
            return PNone.NONE;
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class BufferedReaderInit
    extends Node {
        public abstract void execute(VirtualFrame var1, Node var2, PBuffered var3, Object var4, int var5, PythonObjectFactory var6);

        @Specialization
        static void doInit(VirtualFrame frame, Node inliningTarget, PBuffered self, Object raw, int bufferSize, PythonObjectFactory factory, @Cached IOBaseBuiltins.CheckBoolMethodHelperNode checkReadableNode, @Cached AbstractBufferedIOBuiltins.BufferedInitNode bufferedInitNode, @Cached GetClassNode.GetPythonObjectClassNode getSelfClass, @Cached GetClassNode getRawClass) {
            self.setOK(false);
            self.setDetached(false);
            checkReadableNode.checkReadable(frame, inliningTarget, raw);
            self.setRaw(raw, AbstractBufferedIOBuiltins.isFileIO(self, raw, PythonBuiltinClassType.PBufferedReader, inliningTarget, getSelfClass, getRawClass));
            bufferedInitNode.execute(frame, inliningTarget, self, bufferSize, factory);
            self.resetRead();
            self.setOK(true);
        }

        public static void internalInit(PBuffered self, PFileIO raw, int bufferSize, PythonObjectFactory factory, Object posixSupport, PosixSupportLibrary posixLib) {
            self.setDetached(false);
            self.setRaw(raw, true);
            AbstractBufferedIOBuiltins.BufferedInitNode.internalInit(self, bufferSize, factory, posixSupport, posixLib);
            self.resetRead();
            self.setOK(true);
        }
    }
}

