/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.array;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteOrder;

@ExportLibrary.Repeat(value={@ExportLibrary(value=PythonBufferAcquireLibrary.class), @ExportLibrary(value=PythonBufferAccessLibrary.class)})
public final class PArray
extends PythonBuiltinObject {
    private final BufferFormat format;
    private final TruffleString formatString;
    private int length;
    private byte[] buffer;
    private volatile int exports;

    public PArray(Object clazz, Shape instanceShape, TruffleString formatString, BufferFormat format) {
        super(clazz, instanceShape);
        this.formatString = formatString;
        this.format = format;
        this.length = 0;
        this.buffer = new byte[0];
    }

    public PArray(Object clazz, Shape instanceShape, TruffleString formatString, BufferFormat format, int length) throws OverflowException {
        super(clazz, instanceShape);
        this.formatString = formatString;
        this.format = format;
        this.length = length;
        this.buffer = new byte[PythonUtils.multiplyExact(length, format.bytesize)];
    }

    public BufferFormat getFormat() {
        return this.format;
    }

    @ExportMessage.Ignore
    public TruffleString getFormatString() {
        return this.formatString;
    }

    @ExportMessage(name="getFormatString")
    public TruffleString getFormatStringForBuffer() {
        if (BufferFormat.T_UNICODE_TYPE_CODE_U.equalsUncached((AbstractTruffleString)this.formatString, PythonUtils.TS_ENCODING)) {
            return BufferFormat.T_UNICODE_TYPE_CODE_W;
        }
        return this.formatString;
    }

    public byte[] getBuffer() {
        return this.buffer;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        assert (length >= 0);
        this.length = length;
    }

    public int getExports() {
        return this.exports;
    }

    public void setExports(int exports) {
        this.exports = exports;
    }

    public void checkCanResize(PythonBuiltinBaseNode node) {
        if (this.exports != 0) {
            throw node.raise(PythonBuiltinClassType.BufferError, ErrorMessages.EXPORTS_CANNOT_RESIZE);
        }
    }

    private int computeNewSize(int newLength, int itemsize) throws OverflowException {
        int newSize = this.computeNewSizeNoOverflowCheck(newLength, itemsize);
        if (newSize / itemsize < newLength) {
            throw OverflowException.INSTANCE;
        }
        return newSize;
    }

    private int computeNewSizeNoOverflowCheck(int newLength, int itemsize) {
        if (newLength == 0) {
            return 0;
        }
        return ((newLength >> 4) + (this.length < 8 ? 3 : 7) + newLength) * itemsize;
    }

    public void resizeStorage(int newLength) throws OverflowException {
        assert (newLength >= 0);
        int itemsize = this.format.bytesize;
        if (this.buffer.length / itemsize < newLength || this.length + 16 >= newLength) {
            byte[] newBuffer = new byte[this.computeNewSize(newLength, itemsize)];
            PythonUtils.arraycopy(this.buffer, 0, newBuffer, 0, Math.min(this.buffer.length, newBuffer.length));
            this.buffer = newBuffer;
        }
    }

    public void resize(int newLength) throws OverflowException {
        this.resizeStorage(newLength);
        this.length = newLength;
    }

    public void shift(int from, int by) throws OverflowException {
        assert (from >= 0 && from <= this.length);
        assert (by >= 0);
        int itemsize = this.format.bytesize;
        int newLength = PythonUtils.addExact(this.length, by);
        if (this.buffer.length / itemsize < newLength) {
            byte[] newBuffer = new byte[this.computeNewSize(newLength, itemsize)];
            PythonUtils.arraycopy(this.buffer, 0, newBuffer, 0, from * itemsize);
            PythonUtils.arraycopy(this.buffer, from * itemsize, newBuffer, (from + by) * itemsize, (this.length - from) * itemsize);
            this.buffer = newBuffer;
        } else {
            PythonUtils.arraycopy(this.buffer, from * itemsize, this.buffer, (from + by) * itemsize, (this.length - from) * itemsize);
        }
        this.length = newLength;
    }

    public void delSlice(int at, int count) {
        assert (count >= 0);
        assert (at + count <= this.length);
        int newLength = this.length - count;
        assert (newLength >= 0);
        int itemsize = this.format.bytesize;
        if (this.length + 16 >= newLength) {
            byte[] newBuffer = new byte[this.computeNewSizeNoOverflowCheck(newLength, itemsize)];
            PythonUtils.arraycopy(this.buffer, 0, newBuffer, 0, at * itemsize);
            PythonUtils.arraycopy(this.buffer, (at + count) * itemsize, newBuffer, at * itemsize, (this.length - at - count) * itemsize);
            this.buffer = newBuffer;
        } else {
            PythonUtils.arraycopy(this.buffer, (at + count) * itemsize, this.buffer, at * itemsize, (this.length - at - count) * itemsize);
        }
        this.length = newLength;
    }

    @ExportMessage
    boolean hasBuffer() {
        return true;
    }

    @ExportMessage
    boolean isBuffer() {
        return true;
    }

    @ExportMessage
    int getBufferLength() {
        return this.length * this.format.bytesize;
    }

    @ExportMessage
    Object acquire(int flags) {
        return this;
    }

    @ExportMessage
    boolean isReadonly() {
        return false;
    }

    @ExportMessage
    int getItemSize() {
        return this.format.bytesize;
    }

    @ExportMessage
    boolean hasInternalByteArray() {
        return true;
    }

    @ExportMessage
    byte[] getInternalByteArray() {
        return this.buffer;
    }

    @ExportMessage
    byte readByte(int byteOffset) {
        return this.buffer[byteOffset];
    }

    @ExportMessage
    void writeByte(int byteOffset, byte value) {
        this.buffer[byteOffset] = value;
    }

    @ExportMessage
    short readShort(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getShort(this.buffer, byteOffset);
    }

    @ExportMessage
    void writeShort(int byteOffset, short value) {
        PythonUtils.ARRAY_ACCESSOR.putShort(this.buffer, byteOffset, value);
    }

    @ExportMessage
    int readInt(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getInt(this.buffer, byteOffset);
    }

    @ExportMessage
    void writeInt(int byteOffset, int value) {
        PythonUtils.ARRAY_ACCESSOR.putInt(this.buffer, byteOffset, value);
    }

    @ExportMessage
    long readLong(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getLong(this.buffer, byteOffset);
    }

    @ExportMessage
    void writeLong(int byteOffset, long value) {
        PythonUtils.ARRAY_ACCESSOR.putLong(this.buffer, byteOffset, value);
    }

    @ExportMessage
    float readFloat(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getFloat(this.buffer, byteOffset);
    }

    @ExportMessage
    void writeFloat(int byteOffset, float value) {
        PythonUtils.ARRAY_ACCESSOR.putFloat(this.buffer, byteOffset, value);
    }

    @ExportMessage
    double readDouble(int byteOffset) {
        return PythonUtils.ARRAY_ACCESSOR.getDouble(this.buffer, byteOffset);
    }

    @ExportMessage
    void writeDouble(int byteOffset, double value) {
        PythonUtils.ARRAY_ACCESSOR.putDouble(this.buffer, byteOffset, value);
    }

    public static final class MachineFormat
    extends Enum<MachineFormat> {
        public static final /* enum */ MachineFormat UNSIGNED_INT8 = new MachineFormat(0, BufferFormat.UINT_8, null);
        public static final /* enum */ MachineFormat SIGNED_INT8 = new MachineFormat(1, BufferFormat.INT_8, null);
        public static final /* enum */ MachineFormat UNSIGNED_INT16_LE = new MachineFormat(2, BufferFormat.UINT_16, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT16_BE = new MachineFormat(3, BufferFormat.UINT_16, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT16_LE = new MachineFormat(4, BufferFormat.INT_16, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT16_BE = new MachineFormat(5, BufferFormat.INT_16, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT32_LE = new MachineFormat(6, BufferFormat.UINT_32, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT32_BE = new MachineFormat(7, BufferFormat.UINT_32, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT32_LE = new MachineFormat(8, BufferFormat.INT_32, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT32_BE = new MachineFormat(9, BufferFormat.INT_32, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT64_LE = new MachineFormat(10, BufferFormat.UINT_64, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat UNSIGNED_INT64_BE = new MachineFormat(11, BufferFormat.UINT_64, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT64_LE = new MachineFormat(12, BufferFormat.INT_64, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat SIGNED_INT64_BE = new MachineFormat(13, BufferFormat.INT_64, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_FLOAT_LE = new MachineFormat(14, BufferFormat.FLOAT, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_FLOAT_BE = new MachineFormat(15, BufferFormat.FLOAT, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_DOUBLE_LE = new MachineFormat(16, BufferFormat.DOUBLE, ByteOrder.LITTLE_ENDIAN);
        public static final /* enum */ MachineFormat IEEE_754_DOUBLE_BE = new MachineFormat(17, BufferFormat.DOUBLE, ByteOrder.BIG_ENDIAN);
        public static final /* enum */ MachineFormat UTF32_LE = new MachineFormat(20, BufferFormat.UNICODE, ByteOrder.LITTLE_ENDIAN, PythonUtils.tsLiteral("utf-32-le"));
        public static final /* enum */ MachineFormat UTF32_BE = new MachineFormat(21, BufferFormat.UNICODE, ByteOrder.BIG_ENDIAN, PythonUtils.tsLiteral("utf-32-be"));
        public static final /* enum */ MachineFormat UTF16_LE = new MachineFormat(18, BufferFormat.UNICODE, ByteOrder.LITTLE_ENDIAN, PythonUtils.tsLiteral("utf-16-le"));
        public static final /* enum */ MachineFormat UTF16_BE = new MachineFormat(19, BufferFormat.UNICODE, ByteOrder.BIG_ENDIAN, PythonUtils.tsLiteral("utf-16-be"));
        public final int code;
        public final BufferFormat format;
        public final ByteOrder order;
        public final TruffleString unicodeEncoding;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final MachineFormat[] BY_BUFFER_FORMAT;
        @CompilerDirectives.CompilationFinal(dimensions=1)
        private static final MachineFormat[] BY_CODE;
        private static final /* synthetic */ MachineFormat[] $VALUES;

        public static MachineFormat[] values() {
            return (MachineFormat[])$VALUES.clone();
        }

        public static MachineFormat valueOf(String name) {
            return Enum.valueOf(MachineFormat.class, name);
        }

        private MachineFormat(int code, BufferFormat format, ByteOrder order) {
            this(code, format, order, null);
        }

        private MachineFormat(int code, BufferFormat format, ByteOrder order, TruffleString unicodeEncoding) {
            this.code = code;
            this.format = format;
            this.order = order;
            this.unicodeEncoding = unicodeEncoding;
        }

        public static MachineFormat forFormat(BufferFormat format) {
            return BY_BUFFER_FORMAT[format.ordinal()];
        }

        public static MachineFormat fromCode(int code) {
            return code >= 0 && code < BY_CODE.length ? BY_CODE[code] : null;
        }

        private static /* synthetic */ MachineFormat[] $values() {
            return new MachineFormat[]{UNSIGNED_INT8, SIGNED_INT8, UNSIGNED_INT16_LE, UNSIGNED_INT16_BE, SIGNED_INT16_LE, SIGNED_INT16_BE, UNSIGNED_INT32_LE, UNSIGNED_INT32_BE, SIGNED_INT32_LE, SIGNED_INT32_BE, UNSIGNED_INT64_LE, UNSIGNED_INT64_BE, SIGNED_INT64_LE, SIGNED_INT64_BE, IEEE_754_FLOAT_LE, IEEE_754_FLOAT_BE, IEEE_754_DOUBLE_LE, IEEE_754_DOUBLE_BE, UTF32_LE, UTF32_BE, UTF16_LE, UTF16_BE};
        }

        static {
            $VALUES = MachineFormat.$values();
            BY_BUFFER_FORMAT = new MachineFormat[BufferFormat.values().length];
            BY_CODE = new MachineFormat[MachineFormat.values().length];
            for (MachineFormat machineFormat : MachineFormat.values()) {
                BufferFormat bufferFormat = machineFormat.format;
                if (BY_BUFFER_FORMAT[bufferFormat.ordinal()] != null || machineFormat.order != null && machineFormat.order != ByteOrder.nativeOrder()) continue;
                MachineFormat.BY_BUFFER_FORMAT[bufferFormat.ordinal()] = machineFormat;
            }
            for (MachineFormat machineFormat : MachineFormat.values()) {
                assert (BY_CODE[machineFormat.code] == null);
                MachineFormat.BY_CODE[machineFormat.code] = machineFormat;
            }
        }
    }
}

