/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bool;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.bool.BoolBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.Boolean})
public final class BoolBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BoolBuiltinsFactory.getFactories();
    }

    @Builtin(name="__xor__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class XorNode
    extends BaseBoolBinaryNode {
        XorNode() {
        }

        @Specialization
        static Object doBool(boolean self, boolean other) {
            return self ^ other;
        }

        @Specialization(guards={"atLeastOneIsNotBoolean(self, other)"})
        static Object doOther(VirtualFrame frame, Object self, Object other, @Cached IntBuiltins.XorNode xorNode) {
            return xorNode.execute(frame, self, other);
        }
    }

    @Builtin(name="__or__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class OrNode
    extends BaseBoolBinaryNode {
        OrNode() {
        }

        @Specialization
        static Object doBool(boolean self, boolean other) {
            return self || other;
        }

        @Specialization(guards={"atLeastOneIsNotBoolean(self, other)"})
        static Object doOther(VirtualFrame frame, Object self, Object other, @Cached IntBuiltins.OrNode orNode) {
            return orNode.execute(frame, self, other);
        }
    }

    @Builtin(name="__and__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class AndNode
    extends BaseBoolBinaryNode {
        AndNode() {
        }

        @Specialization
        static Object doBool(boolean self, boolean other) {
            return self && other;
        }

        @Specialization(guards={"atLeastOneIsNotBoolean(self, other)"})
        static Object doOther(VirtualFrame frame, Object self, Object other, @Cached IntBuiltins.AndNode andNode) {
            return andNode.execute(frame, self, other);
        }
    }

    static abstract class BaseBoolBinaryNode
    extends PythonBinaryBuiltinNode {
        BaseBoolBinaryNode() {
        }

        static boolean atLeastOneIsNotBoolean(Object self, Object other) {
            return !PGuards.isBoolean(self) || !PGuards.isBoolean(other);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class RepNode
    extends StrNode {
        RepNode() {
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonBuiltinNode {
        StrNode() {
        }

        @Specialization
        public static TruffleString doLong(long self) {
            return self == 1L ? StringLiterals.T_TRUE : StringLiterals.T_FALSE;
        }

        @Specialization
        public static TruffleString doPInt(PInt self) {
            return self.isZero() ? StringLiterals.T_FALSE : StringLiterals.T_TRUE;
        }
    }
}

