/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.bytes;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.bytes.ByteArrayBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.bytes.PByteArray;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.iterator.IteratorNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyByteArrayCheckNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PySliceNew;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToByteNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PByteArray})
public final class ByteArrayBuiltins
extends PythonBuiltins {
    private static final TruffleString T_LATIN_1 = PythonUtils.tsLiteral("latin-1");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ByteArrayBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
        this.addBuiltinConstant(SpecialAttributeNames.T___DOC__, (Object)"bytearray(iterable_of_ints) -> bytearray\nbytearray(string, encoding[, errors]) -> bytearray\nbytearray(bytes_or_buffer) -> mutable copy of bytes_or_buffer\nbytearray(int) -> bytes array of size given by the parameter initialized with null bytes\nbytearray() -> empty bytes array\n\nConstruct a mutable bytearray object from:\n  - an iterable yielding integers in range(256)\n  - a text string encoded using the specified encoding\n  - a bytes or a buffer object\n  - any object implementing the buffer API.\n  - an integer");
        this.addBuiltinConstant(SpecialMethodNames.T___HASH__, (Object)PNone.NONE);
    }

    protected static Object commonReduce(int proto, byte[] bytes, int len, Object clazz, Object dict, PythonObjectFactory factory, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.ToStringNode toStringNode) {
        TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
        BytesUtils.repr(sb, bytes, len, appendCodePointNode);
        TruffleString str = toStringNode.execute(sb);
        PTuple contents = proto < 3 ? factory.createTuple(new Object[]{str, T_LATIN_1}) : (len > 0 ? factory.createTuple(new Object[]{str, len}) : factory.createTuple(new Object[0]));
        return factory.createTuple(new Object[]{clazz, contents, dict});
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends AbstractComparisonNode {
        GeNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult >= 0;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends AbstractComparisonNode {
        GtNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult > 0;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends AbstractComparisonNode {
        LeNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult <= 0;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends AbstractComparisonNode {
        LtNode() {
        }

        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult < 0;
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NeNode
    extends AbstractComparisonNode {
        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult != 0;
        }

        @Override
        protected boolean shortcutLength() {
            return true;
        }

        @Override
        protected boolean shortcutLengthResult() {
            return true;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends AbstractComparisonNode {
        @Override
        protected boolean fromCompareResult(int compareResult) {
            return compareResult == 0;
        }

        @Override
        protected boolean shortcutLength() {
            return true;
        }
    }

    @GenerateCached(value=false)
    static abstract class AbstractComparisonNode
    extends BytesNodes.AbstractComparisonBaseNode {
        AbstractComparisonNode() {
        }

        @Specialization
        boolean cmp(PByteArray self, PBytesLike other, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray) {
            SequenceStorage selfStorage = self.getSequenceStorage();
            SequenceStorage otherStorage = other.getSequenceStorage();
            return this.doCmp(getArray.execute(inliningTarget, selfStorage), selfStorage.length(), getArray.execute(inliningTarget, otherStorage), otherStorage.length());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"check.execute(inliningTarget, self)", "acquireLib.hasBuffer(other)"}, limit="3")
        Object cmp(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyByteArrayCheckNode check, @Cached BytesNodes.GetBytesStorage getBytesStorage, @Cached.Exclusive @Cached SequenceStorageNodes.GetInternalByteArrayNode getArray, @CachedLibrary(value="other") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            SequenceStorage selfStorage = getBytesStorage.execute(inliningTarget, self);
            Object otherBuffer = acquireLib.acquireReadonly(other, frame, this);
            try {
                Boolean bl = this.doCmp(getArray.execute(inliningTarget, selfStorage), selfStorage.length(), bufferLib.getInternalOrCopiedByteArray(otherBuffer), bufferLib.getBufferLength(otherBuffer));
                return bl;
            }
            finally {
                bufferLib.release(otherBuffer);
            }
        }

        @Specialization(guards={"check.execute(inliningTarget, self)", "!acquireLib.hasBuffer(other)"}, limit="1")
        static Object cmp(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyByteArrayCheckNode check, @CachedLibrary(limit="3") PythonBufferAcquireLibrary acquireLib) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"!check.execute(inliningTarget, self)"}, limit="1")
        Object error(VirtualFrame frame, Object self, Object other, @Bind(value="this") Node inliningTarget, @Cached PyByteArrayCheckNode check) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__eq__", "bytearray", self);
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    protected static abstract class BaseReduceNode
    extends PythonUnaryBuiltinNode {
        protected BaseReduceNode() {
        }

        @Specialization
        public Object reduce(VirtualFrame frame, PByteArray self, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached GetClassNode getClassNode, @Cached PyObjectLookupAttr lookupDict, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            byte[] bytes = getBytes.execute(inliningTarget, self.getSequenceStorage());
            int len = self.getSequenceStorage().length();
            Object dict = lookupDict.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___DICT__);
            if (dict == PNone.NO_VALUE) {
                dict = PNone.NONE;
            }
            Object clazz = getClassNode.execute(inliningTarget, self);
            return ByteArrayBuiltins.commonReduce(2, bytes, len, clazz, dict, this.factory(), appendCodePointNode, toStringNode);
        }
    }

    @Builtin(name="__alloc__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class AllocNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public static int alloc(PByteArray byteArray) {
            return byteArray.getSequenceStorage().length() + 1;
        }
    }

    @Builtin(name="translate", minNumOfPositionalArgs=2, parameterNames={"self", "table", "delete"})
    @GenerateNodeFactory
    public static abstract class TranslateNode
    extends BytesBuiltins.BaseTranslateNode {
        @Specialization(guards={"isNoValue(delete)"})
        public PByteArray translate(PByteArray self, PNone table, PNone delete, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] content = toBytesNode.execute(self);
            return this.factory().createByteArray(content);
        }

        @Specialization(guards={"!isNone(table)"})
        PByteArray translate(VirtualFrame frame, PByteArray self, Object table, PNone delete, @Cached.Shared(value="profile") @Cached InlinedConditionProfile isLenTable256Profile, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bTable = toBytesNode.execute(frame, table);
            this.checkLengthOfTable(bTable, isLenTable256Profile);
            byte[] bSelf = toBytesNode.execute(self);
            BytesBuiltins.BaseTranslateNode.Result result = TranslateNode.translate(bSelf, bTable);
            return this.factory().createByteArray(result.array);
        }

        @Specialization(guards={"isNone(table)"})
        PByteArray delete(VirtualFrame frame, PByteArray self, PNone table, Object delete, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bSelf = toBytesNode.execute(self);
            byte[] bDelete = toBytesNode.execute(frame, delete);
            BytesBuiltins.BaseTranslateNode.Result result = TranslateNode.delete(bSelf, bDelete);
            return this.factory().createByteArray(result.array);
        }

        @Specialization(guards={"!isPNone(table)", "!isPNone(delete)"})
        PByteArray translateAndDelete(VirtualFrame frame, PByteArray self, Object table, Object delete, @Cached.Shared(value="profile") @Cached InlinedConditionProfile isLenTable256Profile, @Cached.Shared(value="toBytes") @Cached BytesNodes.ToBytesNode toBytesNode) {
            byte[] bTable = toBytesNode.execute(frame, table);
            this.checkLengthOfTable(bTable, isLenTable256Profile);
            byte[] bDelete = toBytesNode.execute(frame, delete);
            byte[] bSelf = toBytesNode.execute(self);
            BytesBuiltins.BaseTranslateNode.Result result = TranslateNode.translateAndDelete(bSelf, bTable, bDelete);
            return this.factory().createByteArray(result.array);
        }
    }

    @Builtin(name="fromhex", minNumOfPositionalArgs=2, isClassmethod=true, numOfPositionalOnlyArgs=2, parameterNames={"$cls", "string"})
    @ArgumentClinic(name="string", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class FromHexNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization(guards={"isBuiltinBytesType(inliningTarget, cls, isSameType)"})
        PByteArray doBytes(Object cls, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameType, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode) {
            return this.factory().createByteArray(cls, hexStringToBytesNode.execute(str));
        }

        @Specialization(guards={"!isBuiltinBytesType(inliningTarget, cls, isSameType)"})
        Object doGeneric(VirtualFrame frame, Object cls, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="isSameType") @Cached TypeNodes.IsSameTypeNode isSameType, @Cached CallNode callNode, @Cached.Shared(value="hexToBytes") @Cached BytesNodes.HexStringToBytesNode hexStringToBytesNode) {
            PByteArray byteArray = this.factory().createByteArray(hexStringToBytesNode.execute(str));
            return callNode.execute((Frame)frame, cls, new Object[]{byteArray});
        }

        protected static boolean isBuiltinBytesType(Node inliningTarget, Object cls, TypeNodes.IsSameTypeNode isSameTypeNode) {
            return isSameTypeNode.execute(inliningTarget, (Object)PythonBuiltinClassType.PBytes, cls);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ByteArrayBuiltinsClinicProviders.FromHexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="clear", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ClearNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public PNone clear(VirtualFrame frame, PByteArray byteArray, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.DeleteNode deleteNode, @Cached PySliceNew sliceNode) {
            byteArray.checkCanResize(this);
            deleteNode.execute(frame, byteArray.getSequenceStorage(), sliceNode.execute(inliningTarget, PNone.NONE, PNone.NONE, 1));
            return PNone.NONE;
        }
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReverseNode
    extends PythonBuiltinNode {
        @Specialization
        public static PNone reverse(PByteArray byteArray) {
            byteArray.reverse();
            return PNone.NONE;
        }
    }

    @Builtin(name="copy", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonBuiltinNode {
        @Specialization
        public PByteArray copy(PByteArray byteArray, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached SequenceStorageNodes.ToByteArrayNode toByteArray) {
            return this.factory().createByteArray(getClassNode.execute(inliningTarget, byteArray), toByteArray.execute(inliningTarget, byteArray.getSequenceStorage()));
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ExtendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PNone doBytes(VirtualFrame frame, PByteArray self, PBytesLike source, @Bind(value="this") Node inliningTarget, @Cached IteratorNodes.GetLength lenNode, @Cached(value="createExtend()") @Cached.Shared SequenceStorageNodes.ExtendNode extendNode) {
            self.checkCanResize(this);
            int len = lenNode.execute(frame, inliningTarget, source);
            ExtendNode.extend(frame, self, source, len, extendNode);
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isBytes(source)"}, limit="3")
        PNone doGeneric(VirtualFrame frame, PByteArray self, Object source, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="source") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile bufferProfile, @Cached BytesNodes.IterableToByteNode iterableToByteNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached(value="createExtend()") @Cached.Shared SequenceStorageNodes.ExtendNode extendNode) {
            byte[] b;
            self.checkCanResize(this);
            if (bufferProfile.profile(inliningTarget, bufferAcquireLib.hasBuffer(source))) {
                Object buffer = bufferAcquireLib.acquireReadonly(source, frame, this);
                try {
                    b = bufferLib.getCopiedByteArray(buffer);
                }
                finally {
                    bufferLib.release(buffer, frame, this);
                }
            }
            try {
                b = iterableToByteNode.execute(frame, source);
            }
            catch (PException e) {
                e.expect(inliningTarget, PythonErrorType.TypeError, errorProfile);
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_EXTEND_BYTEARRAY_WITH_P, source);
            }
            PByteArray bytes = this.factory().createByteArray(b);
            ExtendNode.extend(frame, self, bytes, b.length, extendNode);
            return PNone.NONE;
        }

        private static void extend(VirtualFrame frame, PByteArray self, Object source, int len, SequenceStorageNodes.ExtendNode extendNode) {
            SequenceStorage execute = extendNode.execute(frame, self.getSequenceStorage(), source, len);
            assert (self.getSequenceStorage() == execute) : "Unexpected storage generalization!";
        }

        @NeverDefault
        protected static SequenceStorageNodes.ExtendNode createExtend() {
            return SequenceStorageNodes.ExtendNode.create(BytesBuiltins.BytesLikeNoGeneralizationNode.SUPPLIER);
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class AppendNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public PNone append(VirtualFrame frame, PByteArray byteArray, Object arg, @Bind(value="this") Node inliningTarget, @Cached(value="createCast()") CastToByteNode toByteNode, @Cached SequenceStorageNodes.AppendNode appendNode) {
            byteArray.checkCanResize(this);
            appendNode.execute(inliningTarget, byteArray.getSequenceStorage(), toByteNode.execute(frame, arg), BytesBuiltins.BytesLikeNoGeneralizationNode.SUPPLIER);
            return PNone.NONE;
        }

        @NeverDefault
        protected CastToByteNode createCast() {
            return CastToByteNode.create(val -> {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
            }, val -> {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "bytes");
            });
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class DelItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        protected PNone doGeneric(VirtualFrame frame, PByteArray self, Object key, @Cached SequenceStorageNodes.DeleteNode deleteNode) {
            self.checkCanResize(this);
            deleteNode.execute(frame, self.getSequenceStorage(), key);
            return PNone.NONE;
        }

        @Fallback
        protected Object doGeneric(Object self, Object idx) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__delitem__", "bytearray", idx);
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class PopNode
    extends PythonBuiltinNode {
        @Specialization
        public Object popLast(VirtualFrame frame, PByteArray self, PNone none, @Cached.Shared(value="getItem") @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached(value="createDelete()") @Cached.Shared SequenceStorageNodes.DeleteNode deleteNode) {
            self.checkCanResize(this);
            SequenceStorage store = self.getSequenceStorage();
            Object ret = getItemNode.execute(store, -1);
            deleteNode.execute(frame, store, -1);
            return ret;
        }

        @Specialization(guards={"!isNoValue(idx)", "!isPSlice(idx)"})
        public Object doIndex(VirtualFrame frame, PByteArray self, Object idx, @Cached.Shared(value="getItem") @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached(value="createDelete()") @Cached.Shared SequenceStorageNodes.DeleteNode deleteNode) {
            self.checkCanResize(this);
            SequenceStorage store = self.getSequenceStorage();
            Object ret = getItemNode.execute(frame, store, idx);
            deleteNode.execute(frame, store, idx);
            return ret;
        }

        @Fallback
        public Object doError(Object self, Object arg) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, arg);
        }

        @NeverDefault
        protected static SequenceStorageNodes.DeleteNode createDelete() {
            return SequenceStorageNodes.DeleteNode.create(PopNode.createNormalize());
        }

        @NeverDefault
        private static IndexNodes.NormalizeIndexNode createNormalize() {
            return IndexNodes.NormalizeIndexNode.create(ErrorMessages.POP_INDEX_OUT_OF_RANGE);
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class RemoveNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PNone remove(VirtualFrame frame, PByteArray self, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="createCast()") CastToByteNode cast, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached SequenceStorageNodes.DeleteNode deleteNode) {
            self.checkCanResize(this);
            SequenceStorage storage = self.getSequenceStorage();
            int len = storage.length();
            int pos = BytesNodes.FindNode.find(getBytes.execute(inliningTarget, self.getSequenceStorage()), len, cast.execute(frame, value), 0, len, false);
            if (pos != -1) {
                deleteNode.execute(frame, storage, pos);
                return PNone.NONE;
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.NOT_IN_BYTEARRAY);
        }

        @NeverDefault
        protected CastToByteNode createCast() {
            return CastToByteNode.create(val -> {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.BYTE_MUST_BE_IN_RANGE);
            }, val -> {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, "bytes");
            });
        }

        @Fallback
        public Object doError(Object self, Object arg) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, arg);
        }
    }

    @Builtin(name="__imul__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IMulNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        public Object mul(VirtualFrame frame, PByteArray self, int times, @Cached @Cached.Shared SequenceStorageNodes.RepeatNode repeatNode) {
            self.checkCanResize(this);
            SequenceStorage res = repeatNode.execute(frame, self.getSequenceStorage(), times);
            self.setSequenceStorage(res);
            return self;
        }

        @Specialization
        public Object mul(VirtualFrame frame, PByteArray self, Object times, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached @Cached.Shared SequenceStorageNodes.RepeatNode repeatNode) {
            self.checkCanResize(this);
            SequenceStorage res = repeatNode.execute(frame, self.getSequenceStorage(), asSizeNode.executeExact((Frame)frame, inliningTarget, times));
            self.setSequenceStorage(res);
            return self;
        }

        @Fallback
        public Object mul(Object self, Object other) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_MULTIPLY_SEQ_BY_NON_INT, other);
        }
    }

    @Builtin(name="__iadd__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class IAddNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        PByteArray add(PByteArray self, PBytesLike other, @Cached @Cached.Shared SequenceStorageNodes.ConcatNode concatNode) {
            self.checkCanResize(this);
            SequenceStorage res = concatNode.execute(self.getSequenceStorage(), other.getSequenceStorage());
            IAddNode.updateSequenceStorage(self, res);
            return self;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!isBytes(other)"}, limit="3")
        PByteArray add(VirtualFrame frame, PByteArray self, Object other, @CachedLibrary(value="other") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached @Cached.Shared SequenceStorageNodes.ConcatNode concatNode) {
            Object buffer;
            try {
                buffer = bufferAcquireLib.acquireReadonly(other, frame, this);
            }
            catch (PException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_CONCAT_P_TO_S, other, "bytearray");
            }
            try {
                self.checkCanResize(this);
                PBytes bytes = this.factory().createBytes(bufferLib.getCopiedByteArray(buffer));
                SequenceStorage res = concatNode.execute(self.getSequenceStorage(), bytes.getSequenceStorage());
                IAddNode.updateSequenceStorage(self, res);
                PByteArray pByteArray = self;
                return pByteArray;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        private static void updateSequenceStorage(PByteArray array, SequenceStorage s) {
            if (array.getSequenceStorage() != s) {
                array.setSequenceStorage(s);
            }
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static Object repr(PByteArray self, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode getBytes, @Cached TypeNodes.GetNameNode getNameNode, @Cached GetClassNode getClassNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            SequenceStorage store = self.getSequenceStorage();
            byte[] bytes = getBytes.execute(inliningTarget, store);
            int len = store.length();
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, self));
            appendStringNode.execute(sb, (AbstractTruffleString)typeName);
            appendCodePointNode.execute(sb, 40, 1, true);
            BytesUtils.reprLoop(sb, bytes, len, appendCodePointNode);
            appendCodePointNode.execute(sb, 41, 1, true);
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3, parameterNames={"$self", "index", "item"}, numOfPositionalOnlyArgs=3)
    @GenerateNodeFactory
    @ArgumentsClinic(value={@ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="item", conversion=ArgumentClinic.ClinicConversion.Index)})
    public static abstract class InsertNode
    extends PythonTernaryClinicBuiltinNode {
        public abstract PNone execute(VirtualFrame var1, PByteArray var2, Object var3, Object var4);

        @Specialization(guards={"isByteStorage(self)"})
        PNone insert(VirtualFrame frame, PByteArray self, int index, int value, @Cached @Cached.Shared CastToByteNode toByteNode) {
            self.checkCanResize(this);
            byte v = toByteNode.execute(frame, value);
            ByteSequenceStorage target = (ByteSequenceStorage)self.getSequenceStorage();
            target.insertByteItem(InsertNode.normalizeIndex(index, target.length()), v);
            return PNone.NONE;
        }

        @Specialization
        PNone insert(VirtualFrame frame, PByteArray self, int index, int value, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.InsertItemNode insertItemNode, @Cached @Cached.Shared CastToByteNode toByteNode) {
            self.checkCanResize(this);
            byte v = toByteNode.execute(frame, value);
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, self);
            insertItemNode.execute(inliningTarget, storage, InsertNode.normalizeIndex(index, storage.length()), v);
            return PNone.NONE;
        }

        private static int normalizeIndex(int index, int len) {
            int idx = index;
            if (idx < 0 && (idx += len) < 0) {
                idx = 0;
            }
            if (idx > len) {
                idx = len;
            }
            return idx;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ByteArrayBuiltinsClinicProviders.InsertNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    @ImportStatic(value={SpecialMethodNames.class})
    static abstract class SetItemNode
    extends PythonTernaryBuiltinNode {
        SetItemNode() {
        }

        @Specialization(guards={"!isPSlice(idx)", "indexCheckNode.execute(this, idx)"}, limit="1")
        static PNone doItem(VirtualFrame frame, PByteArray self, Object idx, Object value, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached(value="createSetItem()") SequenceStorageNodes.SetItemNode setItemNode) {
            setItemNode.execute(frame, self.getSequenceStorage(), idx, value);
            return PNone.NONE;
        }

        @Specialization
        PNone doSliceSequence(VirtualFrame frame, PByteArray self, PSlice slice, PSequence value, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared InlinedConditionProfile differentLenProfile, @Cached @Cached.Shared SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached @Cached.Shared SequenceStorageNodes.SetItemSliceNode setItemSliceNode, @Cached @Cached.Shared SliceNodes.CoerceToIntSlice sliceCast, @Cached @Cached.Shared SliceNodes.SliceUnpack unpack, @Cached @Cached.Shared SliceNodes.AdjustIndices adjustIndices) {
            SequenceStorage storage = self.getSequenceStorage();
            int otherLen = getSequenceStorageNode.execute(inliningTarget, value).length();
            PSlice.SliceInfo unadjusted = unpack.execute(inliningTarget, sliceCast.execute(inliningTarget, slice));
            PSlice.SliceInfo info = adjustIndices.execute(inliningTarget, storage.length(), unadjusted);
            if (differentLenProfile.profile(inliningTarget, info.sliceLength != otherLen)) {
                self.checkCanResize(this);
            }
            setItemSliceNode.execute((Frame)frame, inliningTarget, storage, info, value, false);
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"bufferAcquireLib.hasBuffer(value)"}, limit="3")
        PNone doSliceBuffer(VirtualFrame frame, PByteArray self, PSlice slice, Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="value") PythonBufferAcquireLibrary bufferAcquireLib, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached @Cached.Shared InlinedConditionProfile differentLenProfile, @Cached @Cached.Shared SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached @Cached.Shared SequenceStorageNodes.SetItemSliceNode setItemSliceNode, @Cached @Cached.Shared SliceNodes.CoerceToIntSlice sliceCast, @Cached @Cached.Shared SliceNodes.SliceUnpack unpack, @Cached @Cached.Shared SliceNodes.AdjustIndices adjustIndices) {
            Object buffer = bufferAcquireLib.acquireReadonly(value, frame, this);
            try {
                PBytes bytes = this.factory().createBytes(bufferLib.getCopiedByteArray(value));
                PNone pNone = this.doSliceSequence(frame, self, slice, bytes, inliningTarget, differentLenProfile, getSequenceStorageNode, setItemSliceNode, sliceCast, unpack, adjustIndices);
                return pNone;
            }
            finally {
                bufferLib.release(buffer, frame, this);
            }
        }

        @Specialization(replaces={"doSliceSequence", "doSliceBuffer"})
        PNone doSliceGeneric(VirtualFrame frame, PByteArray self, PSlice slice, Object value, @Bind(value="this") Node inliningTarget, @Cached @Cached.Shared InlinedConditionProfile differentLenProfile, @Cached @Cached.Shared SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached @Cached.Shared SequenceStorageNodes.SetItemSliceNode setItemSliceNode, @Cached @Cached.Shared SliceNodes.CoerceToIntSlice sliceCast, @Cached @Cached.Shared SliceNodes.SliceUnpack unpack, @Cached @Cached.Shared SliceNodes.AdjustIndices adjustIndices, @Cached ListNodes.ConstructListNode constructListNode) {
            PList values = constructListNode.execute((Frame)frame, value);
            return this.doSliceSequence(frame, self, slice, values, inliningTarget, differentLenProfile, getSequenceStorageNode, setItemSliceNode, sliceCast, unpack, adjustIndices);
        }

        @Fallback
        Object error(Object self, Object idx, Object value) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "bytearray", idx);
        }

        @NeverDefault
        protected static SequenceStorageNodes.SetItemNode createSetItem() {
            return SequenceStorageNodes.SetItemNode.create(IndexNodes.NormalizeIndexNode.forBytearray(), ErrorMessages.INTEGER_REQUIRED);
        }
    }

    @Builtin(name="__getitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GetitemNode
    extends PythonBinaryBuiltinNode {
        GetitemNode() {
        }

        @Specialization(guards={"isPSlice(key) || indexCheckNode.execute(inliningTarget, key)"}, limit="1")
        static Object doSlice(VirtualFrame frame, PBytesLike self, Object key, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached(value="createGetItem()") SequenceStorageNodes.GetItemNode getSequenceItemNode) {
            return getSequenceItemNode.execute(frame, self.getSequenceStorage(), key);
        }

        @Fallback
        Object doSlice(VirtualFrame frame, Object self, Object key) {
            return this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_INDEX_MUST_BE_INT_OR_SLICES, "bytearray", key);
        }

        @NeverDefault
        protected static SequenceStorageNodes.GetItemNode createGetItem() {
            return SequenceStorageNodes.GetItemNode.create(IndexNodes.NormalizeIndexNode.create(), (s, f) -> f.createByteArray((SequenceStorage)s));
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "source", "encoding", "errors"})
    @ArgumentsClinic(value={@ArgumentClinic(name="encoding", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytearray()\""}), @ArgumentClinic(name="errors", conversionClass=BytesNodes.ExpectStringNode.class, args={"\"bytearray()\""})})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ByteArrayBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!isNone(source)"})
        public static PNone doInit(VirtualFrame frame, PByteArray self, Object source, Object encoding, Object errors, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.BytesInitNode toBytesNode) {
            self.setSequenceStorage(new ByteSequenceStorage(toBytesNode.execute(frame, inliningTarget, source, encoding, errors)));
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(self)"})
        public PNone doInit(PByteArray self, Object source, Object encoding, Object errors) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANNOT_CONVERT_P_OBJ_TO_S, source, "bytearray");
        }

        @Specialization(guards={"!isBytes(self)"})
        public PNone doInit(Object self, Object source, Object encoding, Object errors) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___INIT__, "bytearray", self);
        }
    }
}

