/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativePointer;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;

public abstract class CApiGuards {
    public static boolean isPrimitiveNativeWrapper(Object object) {
        return object instanceof PrimitiveNativeWrapper;
    }

    public static boolean isNativeWrapper(Object object) {
        return object instanceof PythonNativeWrapper;
    }

    public static boolean isNativeNull(Object object) {
        return object instanceof PythonNativePointer;
    }

    public static boolean isSpecialSingleton(Object delegate) {
        return PythonLanguage.getSingletonNativeWrapperIdx(delegate) != -1;
    }

    public static boolean isSmallInteger(int i) {
        return -5 <= i && i < 257;
    }

    public static boolean isSmallLong(long i) {
        return -5L <= i && i < 257L;
    }

    public static boolean isSmallIntegerWrapper(PrimitiveNativeWrapper nativeWrapper) {
        return nativeWrapper.isIntLike() && CApiGuards.isSmallLong(nativeWrapper.getLong());
    }
}

