/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.common;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesBuiltins;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.NativeCExtSymbol;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaBooleanNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.profiles.ConditionProfile;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.PrintWriter;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;

public abstract class CExtCommonNodes {
    @CompilerDirectives.TruffleBoundary
    public static void fatalError(Node location, PythonContext context, TruffleString prefix, TruffleString msg, int status) {
        CExtCommonNodes.fatalError(location, context, prefix != null ? prefix.toJavaStringUncached() : null, msg.toJavaStringUncached(), status);
    }

    @CompilerDirectives.TruffleBoundary
    public static void fatalError(Node location, PythonContext context, String prefix, String msg, int status) {
        PrintWriter stderr = new PrintWriter(context.getStandardErr());
        stderr.print("Fatal Python error: ");
        if (prefix != null) {
            stderr.print(prefix);
            stderr.print(": ");
        }
        if (msg != null) {
            stderr.print(msg);
        } else {
            stderr.print("<message not set>");
        }
        stderr.println();
        stderr.flush();
        if (status < 0) {
            PosixSupportLibrary posixLib = PosixSupportLibrary.getUncached();
            PosixSupport posixSupport = context.getPosixSupport();
            posixLib.abort(posixSupport);
        }
        throw new PythonExitException(location, status);
    }

    public static abstract class GetIndexNode
    extends Node {
        public abstract int execute(Object var1, Object var2);

        @Specialization
        static int doIt(Object self, Object indexObj, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile indexLt0Branch, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyObjectSizeNode sizeNode, @Cached IndexNodes.NormalizeIndexNode normalizeIndexNode) {
            int index = asSizeNode.executeExact(null, inliningTarget, indexObj);
            if (index < 0) {
                indexLt0Branch.enter(inliningTarget);
                return normalizeIndexNode.execute(index, sizeNode.execute(null, inliningTarget, self));
            }
            return index;
        }

        public static GetIndexNode create() {
            return CExtCommonNodesFactory.GetIndexNodeGen.create();
        }
    }

    public static abstract class AsFixedNativePrimitiveNode
    extends CExtToNativeNode {
        private final int targetTypeSize;
        private final int signed;

        protected AsFixedNativePrimitiveNode(int targetTypeSize, boolean signed) {
            this.targetTypeSize = targetTypeSize;
            this.signed = PInt.intValue(signed);
        }

        @Specialization
        Object doGeneric(Object value, @Cached AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, this.signed, this.targetTypeSize, true);
        }
    }

    @GenerateUncached
    public static abstract class AsNativeBooleanNode
    extends CExtToNativeNode {
        @Specialization
        static byte doGeneric(Object value, @Bind(value="this") Node inliningTarget, @Cached CastToJavaBooleanNode castToJavaBooleanNode, @Cached PRaiseNode raiseNode) {
            try {
                return (byte)PInt.intValue(castToJavaBooleanNode.execute(inliningTarget, value));
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ATTR_VALUE_MUST_BE_BOOL);
            }
        }
    }

    @GenerateUncached
    public static abstract class AsNativeCharNode
    extends CExtToNativeNode {
        public abstract byte executeByte(Object var1);

        @Specialization
        static byte doGeneric(Object value, @Cached EncodeNativeStringNode encodeNativeStringNode, @Cached PRaiseNode raiseNode) {
            byte[] encoded = encodeNativeStringNode.execute(StandardCharsets.UTF_8, value, StringLiterals.T_STRICT);
            if (encoded.length != 1) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            return encoded[0];
        }
    }

    @GenerateUncached
    public static abstract class NativeUnsignedPrimitiveAsPythonObjectNode
    extends CExtToJavaNode {
        @Specialization(guards={"n >= 0"})
        static int doUnsignedIntPositive(int n) {
            return n;
        }

        @Specialization(replaces={"doUnsignedIntPositive"})
        static long doUnsignedInt(int n) {
            if (n < 0) {
                return (long)n & 0xFFFFFFFFL;
            }
            return n;
        }

        @Specialization(guards={"n >= 0"})
        static long doUnsignedLongPositive(long n) {
            return n;
        }

        @Specialization(guards={"n < 0"})
        static Object doUnsignedLongNegative(long n, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return factory.createInt(PInt.longToUnsignedBigInteger(n));
        }

        @Specialization(replaces={"doUnsignedIntPositive", "doUnsignedInt", "doUnsignedLongPositive", "doUnsignedLongNegative"})
        static Object doGeneric(Object n, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            if (n instanceof Integer) {
                int i = (Integer)n;
                if (i >= 0) {
                    return i;
                }
                return NativeUnsignedPrimitiveAsPythonObjectNode.doUnsignedInt(i);
            }
            if (n instanceof Long) {
                long l = (Long)n;
                if (l >= 0L) {
                    return l;
                }
                return NativeUnsignedPrimitiveAsPythonObjectNode.doUnsignedLongNegative(l, factory);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    public static abstract class NativeUnsignedShortNode
    extends CExtToJavaNode {
        @Specialization
        static int doUnsignedIntPositive(int n) {
            return n & 0xFFFF;
        }
    }

    @GenerateUncached
    public static abstract class NativeUnsignedByteNode
    extends CExtToJavaNode {
        @Specialization
        static int doUnsignedIntPositive(int n) {
            return n & 0xFF;
        }
    }

    @GenerateUncached
    public static abstract class NativePrimitiveAsPythonCharNode
    extends CExtToJavaNode {
        @Specialization
        static TruffleString doByte(byte b, @Cached.Shared(value="fromInt") @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayNode, @Cached.Shared(value="switchEnc") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            return switchEncodingNode.execute((AbstractTruffleString)fromIntArrayNode.execute(new int[]{b}), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doShort(short i, @Cached.Shared(value="fromInt") @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayNode, @Cached.Shared(value="switchEnc") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            return switchEncodingNode.execute((AbstractTruffleString)fromIntArrayNode.execute(new int[]{i}, 0, 1), PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doLong(long l, @Cached TruffleString.FromLongNode fromLongNode) {
            return fromLongNode.execute(l, PythonUtils.TS_ENCODING, true);
        }

        @Specialization(replaces={"doByte", "doShort", "doLong"}, limit="1")
        static Object doGeneric(Object n, @CachedLibrary(value="n") InteropLibrary lib, @Cached.Shared(value="fromInt") @Cached TruffleString.FromIntArrayUTF32Node fromIntArrayNode, @Cached.Shared(value="switchEnc") @Cached TruffleString.SwitchEncodingNode switchEncodingNode) {
            if (lib.fitsInShort(n)) {
                try {
                    return switchEncodingNode.execute((AbstractTruffleString)fromIntArrayNode.execute(new int[]{lib.asShort(n)}, 0, 1), PythonUtils.TS_ENCODING);
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    public static abstract class NativePrimitiveAsPythonBooleanNode
    extends CExtToJavaNode {
        @Specialization
        static Object doByte(byte b) {
            return b != 0;
        }

        @Specialization
        static Object doShort(short i) {
            return i != 0;
        }

        @Specialization
        static Object doLong(long l) {
            return l != 0L;
        }

        @Specialization(replaces={"doByte", "doShort", "doLong"}, limit="1")
        static Object doGeneric(Object n, @CachedLibrary(value="n") InteropLibrary lib) {
            if (lib.fitsInLong(n)) {
                try {
                    return lib.asLong(n) != 0L;
                }
                catch (UnsupportedMessageException unsupportedMessageException) {
                    // empty catch block
                }
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @GenerateUncached
    public static abstract class StringAsPythonStringNode
    extends CExtToJavaNode {
        @Specialization
        static TruffleString doJavaString(String value, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(value, PythonUtils.TS_ENCODING);
        }

        @Specialization
        static TruffleString doTruffleString(TruffleString value) {
            return value;
        }

        @Specialization(guards={"interopLib.isNull(value)"}, limit="3")
        static Object doGeneric(Object value, @CachedLibrary(value="value") InteropLibrary interopLib) {
            return PNone.NONE;
        }

        @Specialization
        static TruffleString doNative(Object value, @Cached CExtNodes.FromCharPointerNode fromPtr) {
            return fromPtr.execute(value);
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class, SpecialMethodSlot.class})
    public static abstract class AsNativePrimitiveNode
    extends Node {
        public final int toInt32(Object value, boolean exact) {
            return (Integer)this.execute(value, 1, 4, exact);
        }

        public final int toUInt32(Object value, boolean exact) {
            return (Integer)this.execute(value, 0, 4, exact);
        }

        public final long toInt64(Object value, boolean exact) {
            return (Long)this.execute(value, 1, 8, exact);
        }

        public final long toUInt64(Object value, boolean exact) {
            return (Long)this.execute(value, 0, 8, exact);
        }

        public abstract Object execute(byte var1, int var2, int var3, boolean var4);

        public abstract Object execute(int var1, int var2, int var3, boolean var4);

        public abstract Object execute(long var1, int var3, int var4, boolean var5);

        public abstract Object execute(Object var1, int var2, int var3, boolean var4);

        @Specialization(guards={"targetTypeSize == 4", "signed != 0"})
        static int doIntToInt32(int value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 4", "signed == 0", "value >= 0"})
        static int doIntToUInt32Pos(int value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 4", "signed == 0"}, replaces={"doIntToUInt32Pos"})
        static int doIntToUInt32(int value, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNativeNode") @Cached PRaiseNode raiseNativeNode) {
            if (exact && value < 0) {
                throw AsNativePrimitiveNode.raiseNegativeValue(raiseNativeNode);
            }
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed != 0"})
        static long doIntToInt64(int obj, int signed, int targetTypeSize, boolean exact) {
            return obj;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0", "value >= 0"})
        static long doIntToUInt64Pos(int value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0"}, replaces={"doIntToUInt64Pos"})
        static long doIntToUInt64(int value, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNativeNode") @Cached PRaiseNode raiseNativeNode) {
            if (exact && value < 0) {
                throw AsNativePrimitiveNode.raiseNegativeValue(raiseNativeNode);
            }
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed != 0"})
        static long doLongToInt64(long value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0", "value >= 0"})
        static long doLongToUInt64Pos(long value, int signed, int targetTypeSize, boolean exact) {
            return value;
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0"}, replaces={"doLongToUInt64Pos"})
        static long doLongToUInt64(long value, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNativeNode") @Cached PRaiseNode raiseNativeNode) {
            if (exact && value < 0L) {
                throw AsNativePrimitiveNode.raiseNegativeValue(raiseNativeNode);
            }
            return value;
        }

        @Specialization(guards={"exact", "targetTypeSize == 4", "signed != 0"})
        static int doLongToInt32Exact(long obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return PInt.intValueExact(obj);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
            }
        }

        @Specialization(guards={"exact", "targetTypeSize == 4", "signed == 0", "obj >= 0"})
        static int doLongToUInt32PosExact(long obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                return PInt.intValueExact(obj);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
            }
        }

        @Specialization(guards={"exact", "targetTypeSize == 4", "signed == 0"}, replaces={"doLongToUInt32PosExact"})
        static int doLongToUInt32Exact(long obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            if (obj < 0L) {
                throw AsNativePrimitiveNode.raiseNegativeValue(raiseNode);
            }
            try {
                return PInt.intValueExact(obj);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
            }
        }

        @Specialization(guards={"!exact", "targetTypeSize == 4"})
        static int doLongToInt32Lossy(long obj, int signed, int targetTypeSize, boolean exact) {
            return (int)obj;
        }

        @Specialization(guards={"targetTypeSize == 8"})
        static Object doVoidPtrToI64(PythonNativeVoidPtr obj, int signed, int targetTypeSize, boolean exact) {
            return obj;
        }

        @Specialization(guards={"exact", "targetTypeSize == 4"})
        @CompilerDirectives.TruffleBoundary
        static int doPIntTo32Bit(PInt obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                if (signed != 0) {
                    return obj.intValueExact();
                }
                if (obj.bitLength() <= 32) {
                    if (obj.isNegative()) {
                        throw AsNativePrimitiveNode.raiseNegativeValue(raiseNode);
                    }
                    return obj.intValue();
                }
            }
            catch (OverflowException overflowException) {
                // empty catch block
            }
            throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
        }

        @Specialization(guards={"exact", "targetTypeSize == 8"})
        @CompilerDirectives.TruffleBoundary
        static long doPIntTo64Bit(PInt obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                if (signed != 0) {
                    return obj.longValueExact();
                }
                if (obj.bitLength() <= 64) {
                    if (obj.isNegative()) {
                        throw AsNativePrimitiveNode.raiseNegativeValue(raiseNode);
                    }
                    return obj.longValue();
                }
            }
            catch (OverflowException overflowException) {
                // empty catch block
            }
            throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, targetTypeSize);
        }

        @Specialization(guards={"!exact", "targetTypeSize == 4"})
        static int doPIntToInt32Lossy(PInt obj, int signed, int targetTypeSize, boolean exact) {
            return obj.intValue();
        }

        @Specialization(guards={"!exact", "targetTypeSize == 8"})
        static long doPIntToInt64Lossy(PInt obj, int signed, int targetTypeSize, boolean exact) {
            return obj.longValue();
        }

        @Specialization(guards={"targetTypeSize == 4 || targetTypeSize == 8"}, replaces={"doIntToInt32", "doIntToUInt32Pos", "doIntToUInt32", "doIntToInt64", "doIntToUInt64Pos", "doIntToUInt64", "doLongToInt64", "doLongToUInt64Pos", "doLongToUInt64", "doLongToInt32Exact", "doLongToUInt32PosExact", "doLongToUInt32Exact", "doLongToInt32Lossy", "doVoidPtrToI64", "doPIntTo32Bit", "doPIntTo64Bit", "doPIntToInt32Lossy", "doPIntToInt64Lossy"})
        static Object doGeneric(Object obj, int signed, int targetTypeSize, boolean exact, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached(parameters={"Index"}) LookupSpecialMethodSlotNode lookupIndex, @Cached CallUnaryMethodNode call, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            Object type = getClassNode.execute(inliningTarget, obj);
            Object indexDescr = lookupIndex.execute(null, type, obj);
            if (indexDescr == PNone.NO_VALUE) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED_GOT, obj);
            }
            Object result = call.executeObject(null, indexDescr, obj);
            if (targetTypeSize == 4) {
                return AsNativePrimitiveNode.toInt32(result, signed, exact, raiseNode);
            }
            if (targetTypeSize == 8) {
                return AsNativePrimitiveNode.toInt64(result, signed, exact, raiseNode);
            }
            throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.UNSUPPORTED_TARGET_SIZE, targetTypeSize);
        }

        @Specialization(guards={"targetTypeSize != 4", "targetTypeSize != 8"})
        static int doUnsupportedTargetSize(Object obj, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.SystemError, ErrorMessages.UNSUPPORTED_TARGET_SIZE, targetTypeSize);
        }

        private static PException raiseNegativeValue(PRaiseNode raiseNativeNode) {
            throw raiseNativeNode.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANNOT_CONVERT_NEGATIVE_VALUE_TO_UNSIGNED_INT);
        }

        private static int toInt32(Object object, int signed, boolean exact, PRaiseNode raiseNode) {
            if (object instanceof Integer) {
                int ival = (Integer)object;
                if (signed != 0) {
                    return ival;
                }
                return AsNativePrimitiveNode.doIntToUInt32(ival, signed, 4, exact, raiseNode);
            }
            if (object instanceof Long) {
                long lval = (Long)object;
                if (exact) {
                    if (signed != 0) {
                        return AsNativePrimitiveNode.doLongToInt32Exact(lval, 1, 4, true, raiseNode);
                    }
                    return AsNativePrimitiveNode.doLongToUInt32Exact(lval, signed, 4, true, raiseNode);
                }
                return AsNativePrimitiveNode.doLongToInt32Lossy(lval, 0, 4, false);
            }
            if (object instanceof PInt) {
                PInt pval = (PInt)object;
                if (exact) {
                    return AsNativePrimitiveNode.doPIntTo32Bit(pval, signed, 4, true, raiseNode);
                }
                return AsNativePrimitiveNode.doPIntToInt32Lossy(pval, signed, 4, false);
            }
            if (object instanceof PythonNativeVoidPtr) {
                throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO_C_TYPE, 4);
            }
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INDEX_RETURNED_NON_INT, object);
        }

        private static Object toInt64(Object object, int signed, boolean exact, PRaiseNode raiseNode) {
            if (object instanceof Integer) {
                Integer ival = (Integer)object;
                if (signed != 0) {
                    return ival.longValue();
                }
                return AsNativePrimitiveNode.doIntToUInt64(ival, signed, 8, exact, raiseNode);
            }
            if (object instanceof Long) {
                long lval = (Long)object;
                if (signed != 0) {
                    return AsNativePrimitiveNode.doLongToInt64(lval, 1, 8, exact);
                }
                return AsNativePrimitiveNode.doLongToUInt64(lval, signed, 8, exact, raiseNode);
            }
            if (object instanceof PInt) {
                PInt pval = (PInt)object;
                if (exact) {
                    return AsNativePrimitiveNode.doPIntTo64Bit(pval, signed, 8, true, raiseNode);
                }
                return AsNativePrimitiveNode.doPIntToInt64Lossy(pval, signed, 8, false);
            }
            if (object instanceof PythonNativeVoidPtr) {
                return AsNativePrimitiveNode.doVoidPtrToI64((PythonNativeVoidPtr)object, signed, 8, exact);
            }
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.INDEX_RETURNED_NON_INT, object);
        }
    }

    @GenerateUncached
    public static abstract class GetByteArrayNode
    extends Node {
        public abstract byte[] execute(Object var1, long var2) throws InteropException, OverflowException;

        @Specialization
        static byte[] doCArrayWrapper(CArrayWrappers.CByteArrayWrapper obj, long n) {
            return GetByteArrayNode.subRangeIfNeeded(obj.getByteArray(), n);
        }

        @Specialization
        static byte[] doForeign(Object obj, long n, @Cached CStructAccess.ReadByteNode readNode) {
            return readNode.readByteArray(obj, (int)n);
        }

        private static byte[] subRangeIfNeeded(byte[] bytes, long n) {
            if ((long)bytes.length > n && n >= 0L) {
                return PythonUtils.arrayCopyOf(bytes, (int)n);
            }
            return bytes;
        }
    }

    public static abstract class CheckFunctionResultNode
    extends PNodeWithContext {
        public static void checkFunctionResult(Node node, TruffleString name, boolean indicatesError, boolean strict, PythonLanguage language, PythonContext context, ConditionProfile errOccurredProfile, TruffleString nullButNoErrorMessage, TruffleString resultWithErrorMessage) {
            PythonContext.PythonThreadState threadState = context.getThreadState(language);
            CheckFunctionResultNode.checkFunctionResult(node, threadState, name, indicatesError, strict, errOccurredProfile, nullButNoErrorMessage, resultWithErrorMessage);
        }

        public static void checkFunctionResult(Node node, PythonContext.PythonThreadState threadState, TruffleString name, boolean indicatesError, boolean strict, ConditionProfile errOccurredProfile, TruffleString nullButNoErrorMessage, TruffleString resultWithErrorMessage) {
            PException currentException = threadState.getCurrentException();
            boolean errOccurred = errOccurredProfile.profile(currentException != null);
            if (indicatesError) {
                threadState.setCurrentException(null);
                if (errOccurred) {
                    assert (currentException != null);
                    throw currentException.getExceptionForReraise(false);
                }
                if (strict) {
                    throw CheckFunctionResultNode.raiseNullButNoError(node, name, nullButNoErrorMessage);
                }
            } else if (errOccurred) {
                assert (currentException != null);
                threadState.setCurrentException(null);
                throw CheckFunctionResultNode.raiseResultWithError(node, name, currentException, resultWithErrorMessage);
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static PException raiseNullButNoError(Node node, TruffleString name, TruffleString nullButNoErrorMessage) {
            throw PRaiseNode.raiseUncached(node, PythonErrorType.SystemError, nullButNoErrorMessage, name);
        }

        @CompilerDirectives.TruffleBoundary
        private static PException raiseResultWithError(Node node, TruffleString name, PException currentException, TruffleString resultWithErrorMessage) {
            PBaseException sysExc = PythonObjectFactory.getUncached().createBaseException((Object)PythonErrorType.SystemError, resultWithErrorMessage, new Object[]{name});
            sysExc.setCause(currentException.getEscapedException());
            throw PRaiseNode.raiseExceptionObject(node, sysExc, PythonOptions.isPExceptionWithJavaStacktrace(PythonLanguage.get(null)));
        }

        public abstract Object execute(PythonContext var1, TruffleString var2, Object var3);
    }

    @GenerateUncached
    @ImportStatic(value={SpecialMethodNames.class, CApiGuards.class})
    public static abstract class AsNativeDoubleNode
    extends CExtToNativeNode {
        public abstract double executeDouble(Object var1);

        @Specialization(guards={"!isNativeWrapper(value)"})
        static double runGeneric(Object value, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return asDoubleNode.execute(null, inliningTarget, value);
        }

        @Specialization(guards={"!object.isDouble()"})
        static double doLongNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getLong();
        }

        @Specialization(guards={"object.isDouble()"})
        static double doDoubleNativeWrapper(PrimitiveNativeWrapper object) {
            return object.getDouble();
        }
    }

    @GenerateUncached
    @ImportStatic(value={PGuards.class, CApiGuards.class})
    public static abstract class ConvertPIntToPrimitiveNode
    extends Node {
        public abstract Object execute(Object var1, int var2, int var3, boolean var4);

        public final Object execute(Object o, int signed, int targetTypeSize) {
            return this.execute(o, signed, targetTypeSize, true);
        }

        public final long executeLong(Object o, int signed, int targetTypeSize, boolean exact) throws UnexpectedResultException {
            return PGuards.expectLong(this.execute(o, signed, targetTypeSize, exact));
        }

        public final int executeInt(Object o, int signed, int targetTypeSize, boolean exact) throws UnexpectedResultException {
            return PGuards.expectInteger(this.execute(o, signed, targetTypeSize, exact));
        }

        public final long executeLong(Object o, int signed, int targetTypeSize) throws UnexpectedResultException {
            return PGuards.expectLong(this.execute(o, signed, targetTypeSize, true));
        }

        public final int executeInt(Object o, int signed, int targetTypeSize) throws UnexpectedResultException {
            return PGuards.expectInteger(this.execute(o, signed, targetTypeSize, true));
        }

        @Specialization(guards={"targetTypeSize == 4", "signed != 0", "fitsInInt32(nativeWrapper)"})
        static int doWrapperToInt32(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getInt();
        }

        @Specialization(guards={"targetTypeSize == 4", "signed == 0", "fitsInUInt32(nativeWrapper)"})
        static int doWrapperToUInt32Pos(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getInt();
        }

        @Specialization(guards={"targetTypeSize == 8", "signed != 0", "fitsInInt64(nativeWrapper)"})
        static long doWrapperToInt64(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getLong();
        }

        @Specialization(guards={"targetTypeSize == 8", "signed == 0", "fitsInUInt64(nativeWrapper)"})
        static long doWrapperToUInt64Pos(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact) {
            return nativeWrapper.getLong();
        }

        @Specialization
        static Object doWrapperGeneric(PrimitiveNativeWrapper nativeWrapper, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="asNativePrimitiveNode") @Cached AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(nativeWrapper.getLong(), signed, targetTypeSize, exact);
        }

        @Specialization
        static Object doInt(int value, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="asNativePrimitiveNode") @Cached AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, signed, targetTypeSize, exact);
        }

        @Specialization
        static Object doLong(long value, int signed, int targetTypeSize, boolean exact, @Cached.Shared(value="asNativePrimitiveNode") @Cached AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(value, signed, targetTypeSize, exact);
        }

        @Specialization(guards={"!isPrimitiveNativeWrapper(obj)"}, replaces={"doInt", "doLong"})
        static Object doOther(Object obj, int signed, int targetTypeSize, boolean exact, @Cached AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(obj, signed, targetTypeSize, exact);
        }

        static boolean fitsInInt32(PrimitiveNativeWrapper nativeWrapper) {
            return nativeWrapper.isBool() || nativeWrapper.isInt();
        }

        static boolean fitsInInt64(PrimitiveNativeWrapper nativeWrapper) {
            return nativeWrapper.isIntLike() || nativeWrapper.isBool();
        }

        static boolean fitsInUInt32(PrimitiveNativeWrapper nativeWrapper) {
            return (nativeWrapper.isBool() || nativeWrapper.isInt()) && nativeWrapper.getInt() >= 0;
        }

        static boolean fitsInUInt64(PrimitiveNativeWrapper nativeWrapper) {
            return (nativeWrapper.isIntLike() || nativeWrapper.isBool()) && nativeWrapper.getLong() >= 0L;
        }
    }

    @GenerateUncached
    @ImportStatic(value={CApiGuards.class})
    public static abstract class ReadUnicodeArrayNode
    extends PNodeWithContext {
        public abstract int[] execute(Object var1, int var2, int var3);

        @Specialization(guards={"elementSize == 1"})
        static int[] read1(Object array, int length, int elementSize, @Bind(value="$node") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile calcLength, @Cached CStructAccess.ReadByteNode read) {
            int len = length;
            if (calcLength.profile(inliningTarget, len == -1)) {
                while (read.readArrayElement(array, ++len) != 0) {
                }
            }
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = read.readArrayElement(array, i) & 0xFF;
            }
            return result;
        }

        @Specialization(guards={"elementSize == 2"})
        static int[] read2(Object array, int length, int elementSize, @Bind(value="$node") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile calcLength, @Cached CStructAccess.ReadI16Node read) {
            int len = length;
            if (calcLength.profile(inliningTarget, len == -1)) {
                while (read.readArrayElement(array, ++len) != 0) {
                }
            }
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = read.readArrayElement(array, i) & 0xFFFF;
            }
            return result;
        }

        @Specialization(guards={"elementSize == 4"})
        static int[] read4(Object array, int length, int elementSize, @Bind(value="$node") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile calcLength, @Cached CStructAccess.ReadI32Node read) {
            int len = length;
            if (calcLength.profile(inliningTarget, len == -1)) {
                while (read.readArrayElement(array, ++len) != 0) {
                }
            }
            int[] result = new int[len];
            for (int i = 0; i < len; ++i) {
                result[i] = read.readArrayElement(array, i);
            }
            return result;
        }
    }

    public static abstract class Charsets {
        private static final int NATIVE_ORDER = 0;
        private static Charset UTF32;
        private static Charset UTF32LE;
        private static Charset UTF32BE;
        private static final TruffleString T_UTF_32;
        private static final TruffleString T_UTF_32LE;
        private static final TruffleString T_UTF_32BE;

        @CompilerDirectives.TruffleBoundary
        public static Charset getUTF32Charset(int byteorder) {
            String utf32Name = Charsets.getUTF32Name(byteorder).toJavaStringUncached();
            if (byteorder == 0) {
                if (UTF32 == null) {
                    UTF32 = Charset.forName(utf32Name);
                }
                return UTF32;
            }
            if (byteorder < 0) {
                if (UTF32LE == null) {
                    UTF32LE = Charset.forName(utf32Name);
                }
                return UTF32LE;
            }
            if (UTF32BE == null) {
                UTF32BE = Charset.forName(utf32Name);
            }
            return UTF32BE;
        }

        public static TruffleString getUTF32Name(int byteorder) {
            TruffleString csName = byteorder == 0 ? T_UTF_32 : (byteorder < 0 ? T_UTF_32LE : T_UTF_32BE);
            return csName;
        }

        static {
            T_UTF_32 = PythonUtils.tsLiteral("UTF-32");
            T_UTF_32LE = PythonUtils.tsLiteral("UTF-32LE");
            T_UTF_32BE = PythonUtils.tsLiteral("UTF-32BE");
        }
    }

    @GenerateUncached
    public static abstract class EncodeNativeStringNode
    extends PNodeWithContext {
        public abstract byte[] execute(Charset var1, Object var2, TruffleString var3);

        @Specialization
        static byte[] doString(Charset charset, TruffleString unicodeObject, TruffleString errors, @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                CodingErrorAction action = BytesBuiltins.toCodingErrorAction(errors, raiseNode, eqNode);
                return BytesBuiltins.doEncode(charset, unicodeObject, action);
            }
            catch (CharacterCodingException e) {
                throw raiseNode.raise(PythonErrorType.UnicodeEncodeError, ErrorMessages.M, e);
            }
        }

        @Specialization
        static byte[] doGeneric(Charset charset, Object unicodeObject, TruffleString errors, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.EqualNode eqNode, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            try {
                TruffleString s = castToTruffleStringNode.execute(inliningTarget, unicodeObject);
                return EncodeNativeStringNode.doString(charset, s, errors, eqNode, raiseNode);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.S_MUST_BE_S_NOT_P, "argument", "string", unicodeObject);
            }
        }
    }

    @GenerateUncached
    public static abstract class EnsureTruffleStringNode
    extends Node {
        public abstract Object execute(Object var1);

        @Specialization
        protected TruffleString doString(String s, @Cached TruffleString.FromJavaStringNode fromJavaStringNode) {
            return fromJavaStringNode.execute(s, PythonUtils.TS_ENCODING);
        }

        @Fallback
        protected Object doObj(Object o) {
            return o;
        }
    }

    @GenerateUncached
    public static abstract class ImportCExtSymbolNode
    extends PNodeWithContext {
        public abstract Object execute(CExtContext var1, NativeCExtSymbol var2);

        @Specialization(guards={"isSingleContext()", "cachedSymbol == symbol"}, limit="1")
        static Object doSymbolCached(CExtContext nativeContext, NativeCExtSymbol symbol, @Cached(value="symbol") NativeCExtSymbol cachedSymbol, @Cached(value="importCAPISymbolUncached(nativeContext, symbol)") Object llvmSymbol) {
            return llvmSymbol;
        }

        @Specialization(guards={"isSingleContext()", "nativeContext == cachedNativeContext"}, limit="1", replaces={"doSymbolCached"})
        Object doWithSymbolCacheSingleContext(CExtContext nativeContext, NativeCExtSymbol symbol, @Cached(value="nativeContext") CExtContext cachedNativeContext, @Cached(value="nativeContext.getSymbolCache()") DynamicObject cachedSymbolCache, @CachedLibrary(value="cachedSymbolCache") DynamicObjectLibrary dynamicObjectLib) {
            return this.doWithSymbolCache(cachedNativeContext, symbol, cachedSymbolCache, dynamicObjectLib);
        }

        @Specialization(replaces={"doSymbolCached", "doWithSymbolCacheSingleContext"}, limit="1")
        Object doWithSymbolCache(CExtContext nativeContext, NativeCExtSymbol symbol, @Bind(value="nativeContext.getSymbolCache()") DynamicObject symbolCache, @CachedLibrary(value="symbolCache") DynamicObjectLibrary dynamicObjectLib) {
            Object nativeSymbol = dynamicObjectLib.getOrDefault(symbolCache, (Object)symbol, (Object)PNone.NO_VALUE);
            if (nativeSymbol == PNone.NO_VALUE) {
                nativeSymbol = this.importCAPISymbolUncached(nativeContext, symbol, symbolCache, dynamicObjectLib);
            }
            return nativeSymbol;
        }

        protected Object importCAPISymbolUncached(CExtContext nativeContext, NativeCExtSymbol symbol) {
            CompilerAsserts.neverPartOfCompilation();
            return this.importCAPISymbolUncached(nativeContext, symbol, nativeContext.getSymbolCache(), DynamicObjectLibrary.getUncached());
        }

        @CompilerDirectives.TruffleBoundary
        protected Object importCAPISymbolUncached(CExtContext nativeContext, NativeCExtSymbol symbol, DynamicObject symbolCache, DynamicObjectLibrary dynamicObjectLib) {
            Object llvmLibrary = nativeContext.getLLVMLibrary();
            String name = symbol.getName();
            try {
                Object nativeSymbol = InteropLibrary.getUncached().readMember(llvmLibrary, name);
                nativeSymbol = NativeCExtSymbol.ensureExecutable(nativeSymbol, symbol);
                dynamicObjectLib.put(symbolCache, (Object)symbol, nativeSymbol);
                return nativeSymbol;
            }
            catch (UnknownIdentifierException e) {
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.SystemError, ErrorMessages.INVALID_CAPI_FUNC, symbol.getTsName());
            }
            catch (UnsupportedMessageException e) {
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.SystemError, ErrorMessages.CORRUPTED_CAPI_LIB_OBJ, llvmLibrary);
            }
        }
    }
}

