/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy.llvm;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtAsPythonObjectNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.LoadCExtException;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContextFunctions;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextMember;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextSignatureType;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyMode;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyInitObject;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMCallHelperFunctionNodeGen;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.GraalHPyLLVMNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.llvm.HPyArrayWrappers;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.llvm.spi.NativeTypeLibrary;
import java.io.IOException;
import java.util.HashMap;

@ExportLibrary.Repeat(value={@ExportLibrary(value=InteropLibrary.class), @ExportLibrary(value=NativeTypeLibrary.class, useForAOT=false)})
public final class GraalHPyLLVMContext
extends GraalHPyNativeContext {
    private static final String J_NAME = "HPy Universal ABI (GraalVM LLVM backend)";
    private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyLLVMContext.class);
    public static HashMap<String, HPyContextMember> contextMembersByName;
    private final int[] counts;
    @CompilerDirectives.CompilationFinal
    Object hpyContextNativeTypeID;
    @CompilerDirectives.CompilationFinal
    Object hpyNativeTypeID;
    @CompilerDirectives.CompilationFinal
    Object hpyFieldNativeTypeID;
    @CompilerDirectives.CompilationFinal
    Object hpyArrayNativeTypeID;
    @CompilerDirectives.CompilationFinal
    Object setNativeSpaceFunction;
    @CompilerDirectives.CompilationFinal
    long wcharSize = -1L;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private final Object[] hpyContextMembers;
    Object nativePointer;

    public GraalHPyLLVMContext(GraalHPyContext context, boolean traceUpcalls) {
        super(context, traceUpcalls);
        Object[] ctxMembers = this.createMembers(PythonUtils.tsLiteral(J_NAME));
        if (traceUpcalls) {
            this.counts = new int[HPyContextMember.VALUES.length];
            for (int i = 0; i < ctxMembers.length; ++i) {
                Object m = ctxMembers[i];
                if (!(m instanceof HPyExecuteWrapper)) continue;
                HPyExecuteWrapper executeWrapper = (HPyExecuteWrapper)m;
                ctxMembers[i] = new HPyExecuteWrapperTraceUpcall(this.counts, i, executeWrapper);
            }
        } else {
            this.counts = null;
        }
        for (Object member : ctxMembers) {
            if (!(member instanceof GraalHPyHandle)) continue;
            GraalHPyHandle handle = (GraalHPyHandle)member;
            int id = handle.getIdUncached(context);
            assert (id > 0 && id < 256);
            assert (id > 3 || context.getHPyHandleForObject(handle.getDelegate()) == id);
        }
        this.hpyContextMembers = ctxMembers;
    }

    void setHPyContextNativeType(Object nativeType) {
        this.hpyContextNativeTypeID = nativeType;
    }

    void setHPyNativeType(Object hpyNativeTypeID) {
        assert (this.hpyNativeTypeID == null) : "setting HPy native type ID a second time";
        this.hpyNativeTypeID = hpyNativeTypeID;
    }

    public Object getHPyNativeType() {
        assert (this.hpyNativeTypeID != null) : "HPy native type ID not available";
        return this.hpyNativeTypeID;
    }

    public Object getHPyFieldNativeType() {
        assert (this.hpyNativeTypeID != null) : "HPyField native type ID not available";
        return this.hpyFieldNativeTypeID;
    }

    public void setHPyFieldNativeType(Object hpyFieldNativeTypeID) {
        this.hpyFieldNativeTypeID = hpyFieldNativeTypeID;
    }

    void setHPyArrayNativeType(Object hpyArrayNativeTypeID) {
        assert (this.hpyArrayNativeTypeID == null) : "setting HPy* native type ID a second time";
        this.hpyArrayNativeTypeID = hpyArrayNativeTypeID;
    }

    public Object getHPyArrayNativeType() {
        assert (this.hpyArrayNativeTypeID != null) : "HPy* native type ID not available";
        return this.hpyArrayNativeTypeID;
    }

    @Override
    protected long getWcharSize() {
        assert (this.wcharSize > 0L);
        return this.wcharSize;
    }

    @Override
    protected String getName() {
        return J_NAME;
    }

    public static Object loadLLVMLibrary(PythonContext context) throws IOException {
        CompilerAsserts.neverPartOfCompilation();
        TruffleLanguage.Env env = context.getEnv();
        TruffleFile homePath = env.getInternalTruffleFile(context.getCAPIHome().toJavaStringUncached());
        TruffleFile capiFile = homePath.resolve(context.getLLVMSupportExt("hpy"));
        try {
            LOGGER.fine("Loading HPy LLVM backend from " + capiFile);
            Source.SourceBuilder capiSrcBuilder = Source.newBuilder((String)"llvm", (TruffleFile)capiFile);
            if (!context.getLanguage().getEngineOption(PythonOptions.ExposeInternalSources).booleanValue()) {
                capiSrcBuilder.internal(true);
            }
            return context.getEnv().parseInternal(capiSrcBuilder.build(), new String[0]).call(new Object[0]);
        }
        catch (RuntimeException e) {
            LOGGER.severe(String.format("Fatal error occurred when loading %s", capiFile));
            throw CompilerDirectives.shouldNotReachHere((Throwable)e);
        }
    }

    @Override
    protected Object loadExtensionLibrary(Node location, PythonContext context, TruffleString name, TruffleString path) throws LoadCExtException.ImportException, IOException {
        CompilerAsserts.neverPartOfCompilation();
        return CExtContext.loadLLVMLibrary(location, context, name, path);
    }

    @Override
    protected GraalHPyContext.HPyABIVersion getHPyABIVersion(Object extLib, String getMajorVersionFuncName, String getMinorVersionFuncName) throws InteropException {
        CompilerAsserts.neverPartOfCompilation();
        InteropLibrary lib = InteropLibrary.getUncached((Object)extLib);
        Object majorVersionFun = lib.readMember(extLib, getMajorVersionFuncName);
        Object minorVersionFun = lib.readMember(extLib, getMinorVersionFuncName);
        InteropLibrary funLib = InteropLibrary.getUncached((Object)majorVersionFun);
        assert (funLib.accepts(minorVersionFun));
        int requiredMajorVersion = GraalHPyLLVMContext.expectInt(funLib.execute(majorVersionFun, new Object[0]));
        int requiredMinorVersion = GraalHPyLLVMContext.expectInt(funLib.execute(minorVersionFun, new Object[0]));
        return new GraalHPyContext.HPyABIVersion(requiredMajorVersion, requiredMinorVersion);
    }

    @Override
    protected Object initHPyModule(Object llvmLibrary, String initFuncName, TruffleString name, TruffleString path, HPyMode mode) throws UnsupportedMessageException, ArityException, UnsupportedTypeException, LoadCExtException.ImportException {
        Object initFunction;
        CompilerAsserts.neverPartOfCompilation();
        assert (mode == HPyMode.MODE_UNIVERSAL);
        InteropLibrary lib = InteropLibrary.getUncached((Object)llvmLibrary);
        if (lib.isMemberReadable(llvmLibrary, initFuncName)) {
            try {
                initFunction = lib.readMember(llvmLibrary, initFuncName);
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        } else {
            throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.CANNOT_INITIALIZE_EXT_NO_ENTRY, name, path, initFuncName);
        }
        if (!InteropLibrary.getUncached().isExecutable(initFunction)) {
            throw new LoadCExtException.ImportException(null, name, path, ErrorMessages.NO_FUNCTION_FOUND, "", initFuncName, path);
        }
        return InteropLibrary.getUncached().execute(initFunction, new Object[]{this});
    }

    @Override
    protected void initNativeContext() throws InteropException {
        Object hpyLibrary = this.context.getLLVMLibrary();
        InteropLibrary interopLibrary = (InteropLibrary)InteropLibrary.getFactory().getUncached(hpyLibrary);
        interopLibrary.invokeMember(hpyLibrary, "graal_hpy_init", new Object[]{this.context, new GraalHPyInitObject(this)});
    }

    @Override
    protected void initNativeFastPaths() {
        throw CompilerDirectives.shouldNotReachHere((String)"");
    }

    @Override
    protected GraalHPyContext.HPyUpcall[] getUpcalls() {
        return HPyContextMember.VALUES;
    }

    @Override
    protected int[] getUpcallCounts() {
        return this.counts;
    }

    @Override
    protected void finalizeNativeContext() {
    }

    @Override
    public void initHPyDebugContext() throws LoadCExtException.ApiInitException {
        throw new LoadCExtException.ApiInitException(null, null, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "debug");
    }

    @Override
    public PythonModule getHPyDebugModule() throws LoadCExtException.ImportException {
        throw new LoadCExtException.ImportException(null, null, null, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "debug");
    }

    @Override
    public void initHPyTraceContext() throws LoadCExtException.ApiInitException {
        throw new LoadCExtException.ApiInitException(null, null, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "trace");
    }

    @Override
    public PythonModule getHPyTraceModule() throws LoadCExtException.ImportException {
        throw new LoadCExtException.ImportException(null, null, null, ErrorMessages.HPY_S_MODE_NOT_AVAILABLE, "trace");
    }

    @Override
    protected void setNativeCache(long cachePtr) {
        assert (this.useNativeFastPaths());
        try {
            InteropLibrary.getUncached().execute(this.setNativeSpaceFunction, new Object[]{this.nativePointer, cachePtr});
        }
        catch (ArityException | UnsupportedMessageException | UnsupportedTypeException e) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @Override
    public GraalHPyNodes.HPyCallHelperFunctionNode createCallHelperFunctionNode() {
        return GraalHPyLLVMCallHelperFunctionNodeGen.create();
    }

    @Override
    public GraalHPyNodes.HPyCallHelperFunctionNode getUncachedCallHelperFunctionNode() {
        return GraalHPyLLVMCallHelperFunctionNodeGen.getUncached();
    }

    @Override
    public GraalHPyNodes.HPyFromCharPointerNode createFromCharPointerNode() {
        return GraalHPyLLVMNodesFactory.HPyLLVMFromCharPointerNodeGen.create();
    }

    @Override
    public GraalHPyNodes.HPyFromCharPointerNode getUncachedFromCharPointerNode() {
        return GraalHPyLLVMNodesFactory.HPyLLVMFromCharPointerNodeGen.getUncached();
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativePointer != null;
    }

    @ExportMessage(limit="1")
    long asPointer(@CachedLibrary(value="this.nativePointer") InteropLibrary lib) throws UnsupportedMessageException {
        if (this.isPointer()) {
            return lib.asPointer(this.nativePointer);
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnsupportedMessageException.create();
    }

    @Override
    protected void toNativeInternal() {
        CompilerDirectives.transferToInterpreter();
        assert (!this.isPointer());
        assert (PythonLanguage.get(null).getEngineOption(PythonOptions.HPyBackend) == PythonOptions.HPyBackendMode.LLVM);
        this.nativePointer = GraalHPyNodesFactory.PCallHPyFunctionNodeGen.getUncached().call(this.context, GraalHPyNativeSymbol.GRAAL_HPY_CONTEXT_TO_NATIVE, this);
    }

    @Override
    protected Object createArgumentsArray(Object[] args) {
        return new HPyArrayWrappers.HPyArrayWrapper(this.context, args);
    }

    @Override
    protected void freeArgumentsArray(Object argsArray) {
        if (argsArray instanceof HPyArrayWrappers.HPyArrayWrapper) {
            HPyArrayWrappers.HPyArrayWrapper hpyArrayWrapper = (HPyArrayWrappers.HPyArrayWrapper)argsArray;
            hpyArrayWrapper.close();
        }
    }

    private static int expectInt(Object value) {
        if (value instanceof Integer) {
            Integer i = (Integer)value;
            return i;
        }
        InteropLibrary lib = InteropLibrary.getUncached((Object)value);
        if (lib.fitsInInt(value)) {
            try {
                return lib.asInt(value);
            }
            catch (UnsupportedMessageException unsupportedMessageException) {
                // empty catch block
            }
        }
        throw CompilerDirectives.shouldNotReachHere();
    }

    private static Object createConstant(Object value) {
        return GraalHPyHandle.create(value);
    }

    private Object createBuiltinsConstant() {
        return GraalHPyLLVMContext.createConstant(GetOrCreateDictNode.executeUncached(this.context.getContext().getBuiltins()));
    }

    private static Object createSingletonConstant(Object value, int handle) {
        return GraalHPyHandle.createSingleton(value, handle);
    }

    private Object createTypeConstant(PythonBuiltinClassType value) {
        return GraalHPyHandle.create(this.context.getContext().lookupType(value));
    }

    private static HPyExecuteWrapper createContextFunction(HPyContextMember member) {
        return new HPyExecuteWrapper(member);
    }

    private Object[] createMembers(TruffleString name) {
        Object[] members = new Object[HPyContextMember.VALUES.length];
        members[HPyContextMember.NAME.ordinal()] = new CArrayWrappers.CStringWrapper(name);
        members[HPyContextMember.ABI_VERSION.ordinal()] = 0;
        members[HPyContextMember.H_NONE.ordinal()] = GraalHPyLLVMContext.createSingletonConstant(PNone.NONE, 1);
        members[HPyContextMember.H_TRUE.ordinal()] = GraalHPyLLVMContext.createConstant(this.context.getContext().getTrue());
        members[HPyContextMember.H_FALSE.ordinal()] = GraalHPyLLVMContext.createConstant(this.context.getContext().getFalse());
        members[HPyContextMember.H_NOTIMPLEMENTED.ordinal()] = GraalHPyLLVMContext.createSingletonConstant(PNotImplemented.NOT_IMPLEMENTED, 2);
        members[HPyContextMember.H_ELLIPSIS.ordinal()] = GraalHPyLLVMContext.createSingletonConstant(PEllipsis.INSTANCE, 3);
        members[HPyContextMember.H_BASEEXCEPTION.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PBaseException);
        members[HPyContextMember.H_EXCEPTION.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.Exception);
        members[HPyContextMember.H_STOPASYNCITERATION.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.StopAsyncIteration);
        members[HPyContextMember.H_STOPITERATION.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.StopIteration);
        members[HPyContextMember.H_GENERATOREXIT.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.GeneratorExit);
        members[HPyContextMember.H_ARITHMETICERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ArithmeticError);
        members[HPyContextMember.H_LOOKUPERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.LookupError);
        members[HPyContextMember.H_ASSERTIONERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.AssertionError);
        members[HPyContextMember.H_ATTRIBUTEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.AttributeError);
        members[HPyContextMember.H_BUFFERERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.BufferError);
        members[HPyContextMember.H_EOFERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.EOFError);
        members[HPyContextMember.H_FLOATINGPOINTERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.FloatingPointError);
        members[HPyContextMember.H_OSERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.OSError);
        members[HPyContextMember.H_IMPORTERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ImportError);
        members[HPyContextMember.H_MODULENOTFOUNDERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ModuleNotFoundError);
        members[HPyContextMember.H_INDEXERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.IndexError);
        members[HPyContextMember.H_KEYERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.KeyError);
        members[HPyContextMember.H_KEYBOARDINTERRUPT.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.KeyboardInterrupt);
        members[HPyContextMember.H_MEMORYERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.MemoryError);
        members[HPyContextMember.H_NAMEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.NameError);
        members[HPyContextMember.H_OVERFLOWERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.OverflowError);
        members[HPyContextMember.H_RUNTIMEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.RuntimeError);
        members[HPyContextMember.H_RECURSIONERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.RecursionError);
        members[HPyContextMember.H_NOTIMPLEMENTEDERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.NotImplementedError);
        members[HPyContextMember.H_SYNTAXERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.SyntaxError);
        members[HPyContextMember.H_INDENTATIONERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.IndentationError);
        members[HPyContextMember.H_TABERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.TabError);
        members[HPyContextMember.H_REFERENCEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ReferenceError);
        members[HPyContextMember.H_SYSTEMERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.SystemError);
        members[HPyContextMember.H_SYSTEMEXIT.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.SystemExit);
        members[HPyContextMember.H_TYPEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.TypeError);
        members[HPyContextMember.H_UNBOUNDLOCALERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UnboundLocalError);
        members[HPyContextMember.H_UNICODEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UnicodeError);
        members[HPyContextMember.H_UNICODEENCODEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UnicodeEncodeError);
        members[HPyContextMember.H_UNICODEDECODEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UnicodeDecodeError);
        members[HPyContextMember.H_UNICODETRANSLATEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UnicodeTranslateError);
        members[HPyContextMember.H_VALUEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ValueError);
        members[HPyContextMember.H_ZERODIVISIONERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ZeroDivisionError);
        members[HPyContextMember.H_BLOCKINGIOERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.BlockingIOError);
        members[HPyContextMember.H_BROKENPIPEERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.BrokenPipeError);
        members[HPyContextMember.H_CHILDPROCESSERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ChildProcessError);
        members[HPyContextMember.H_CONNECTIONERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ConnectionError);
        members[HPyContextMember.H_CONNECTIONABORTEDERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ConnectionAbortedError);
        members[HPyContextMember.H_CONNECTIONREFUSEDERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ConnectionRefusedError);
        members[HPyContextMember.H_CONNECTIONRESETERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ConnectionResetError);
        members[HPyContextMember.H_FILEEXISTSERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.FileExistsError);
        members[HPyContextMember.H_FILENOTFOUNDERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.FileNotFoundError);
        members[HPyContextMember.H_INTERRUPTEDERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.InterruptedError);
        members[HPyContextMember.H_ISADIRECTORYERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.IsADirectoryError);
        members[HPyContextMember.H_NOTADIRECTORYERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.NotADirectoryError);
        members[HPyContextMember.H_PERMISSIONERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PermissionError);
        members[HPyContextMember.H_PROCESSLOOKUPERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ProcessLookupError);
        members[HPyContextMember.H_TIMEOUTERROR.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.TimeoutError);
        members[HPyContextMember.H_WARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.Warning);
        members[HPyContextMember.H_USERWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UserWarning);
        members[HPyContextMember.H_DEPRECATIONWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.DeprecationWarning);
        members[HPyContextMember.H_PENDINGDEPRECATIONWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PendingDeprecationWarning);
        members[HPyContextMember.H_SYNTAXWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.SyntaxWarning);
        members[HPyContextMember.H_RUNTIMEWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.RuntimeWarning);
        members[HPyContextMember.H_FUTUREWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.FutureWarning);
        members[HPyContextMember.H_IMPORTWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ImportWarning);
        members[HPyContextMember.H_UNICODEWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.UnicodeWarning);
        members[HPyContextMember.H_BYTESWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.BytesWarning);
        members[HPyContextMember.H_RESOURCEWARNING.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.ResourceWarning);
        members[HPyContextMember.H_BASEOBJECTTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PythonObject);
        members[HPyContextMember.H_TYPETYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PythonClass);
        members[HPyContextMember.H_BOOLTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.Boolean);
        members[HPyContextMember.H_LONGTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PInt);
        members[HPyContextMember.H_FLOATTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PFloat);
        members[HPyContextMember.H_UNICODETYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PString);
        members[HPyContextMember.H_TUPLETYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PTuple);
        members[HPyContextMember.H_LISTTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PList);
        members[HPyContextMember.H_COMPLEXTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PComplex);
        members[HPyContextMember.H_BYTESTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PBytes);
        members[HPyContextMember.H_MEMORYVIEWTYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PMemoryView);
        members[HPyContextMember.H_CAPSULETYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.Capsule);
        members[HPyContextMember.H_SLICETYPE.ordinal()] = this.createTypeConstant(PythonBuiltinClassType.PSlice);
        members[HPyContextMember.H_BUILTINS.ordinal()] = this.createBuiltinsConstant();
        members[HPyContextMember.CTX_DUP.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DUP);
        members[HPyContextMember.CTX_CLOSE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CLOSE);
        members[HPyContextMember.CTX_LONG_FROMINT32_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_FROMINT32_T);
        members[HPyContextMember.CTX_LONG_FROMUINT32_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_FROMUINT32_T);
        members[HPyContextMember.CTX_LONG_FROMINT64_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_FROMINT64_T);
        members[HPyContextMember.CTX_LONG_FROMUINT64_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_FROMUINT64_T);
        members[HPyContextMember.CTX_LONG_FROMSIZE_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_FROMSIZE_T);
        members[HPyContextMember.CTX_LONG_FROMSSIZE_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_FROMSSIZE_T);
        members[HPyContextMember.CTX_LONG_ASINT32_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASINT32_T);
        members[HPyContextMember.CTX_LONG_ASUINT32_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASUINT32_T);
        members[HPyContextMember.CTX_LONG_ASUINT32_TMASK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASUINT32_TMASK);
        members[HPyContextMember.CTX_LONG_ASINT64_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASINT64_T);
        members[HPyContextMember.CTX_LONG_ASUINT64_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASUINT64_T);
        members[HPyContextMember.CTX_LONG_ASUINT64_TMASK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASUINT64_TMASK);
        members[HPyContextMember.CTX_LONG_ASSIZE_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASSIZE_T);
        members[HPyContextMember.CTX_LONG_ASSSIZE_T.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASSSIZE_T);
        members[HPyContextMember.CTX_LONG_ASVOIDPTR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASVOIDPTR);
        members[HPyContextMember.CTX_LONG_ASDOUBLE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG_ASDOUBLE);
        members[HPyContextMember.CTX_FLOAT_FROMDOUBLE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FLOAT_FROMDOUBLE);
        members[HPyContextMember.CTX_FLOAT_ASDOUBLE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FLOAT_ASDOUBLE);
        members[HPyContextMember.CTX_BOOL_FROMBOOL.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BOOL_FROMBOOL);
        members[HPyContextMember.CTX_LENGTH.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LENGTH);
        members[HPyContextMember.CTX_NUMBER_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_NUMBER_CHECK);
        members[HPyContextMember.CTX_ADD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ADD);
        members[HPyContextMember.CTX_SUBTRACT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SUBTRACT);
        members[HPyContextMember.CTX_MULTIPLY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_MULTIPLY);
        members[HPyContextMember.CTX_MATRIXMULTIPLY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_MATRIXMULTIPLY);
        members[HPyContextMember.CTX_FLOORDIVIDE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FLOORDIVIDE);
        members[HPyContextMember.CTX_TRUEDIVIDE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TRUEDIVIDE);
        members[HPyContextMember.CTX_REMAINDER.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_REMAINDER);
        members[HPyContextMember.CTX_DIVMOD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DIVMOD);
        members[HPyContextMember.CTX_POWER.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_POWER);
        members[HPyContextMember.CTX_NEGATIVE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_NEGATIVE);
        members[HPyContextMember.CTX_POSITIVE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_POSITIVE);
        members[HPyContextMember.CTX_ABSOLUTE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ABSOLUTE);
        members[HPyContextMember.CTX_INVERT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INVERT);
        members[HPyContextMember.CTX_LSHIFT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LSHIFT);
        members[HPyContextMember.CTX_RSHIFT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_RSHIFT);
        members[HPyContextMember.CTX_AND.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_AND);
        members[HPyContextMember.CTX_XOR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_XOR);
        members[HPyContextMember.CTX_OR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_OR);
        members[HPyContextMember.CTX_INDEX.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INDEX);
        members[HPyContextMember.CTX_LONG.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LONG);
        members[HPyContextMember.CTX_FLOAT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FLOAT);
        members[HPyContextMember.CTX_INPLACEADD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEADD);
        members[HPyContextMember.CTX_INPLACESUBTRACT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACESUBTRACT);
        members[HPyContextMember.CTX_INPLACEMULTIPLY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEMULTIPLY);
        members[HPyContextMember.CTX_INPLACEMATRIXMULTIPLY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEMATRIXMULTIPLY);
        members[HPyContextMember.CTX_INPLACEFLOORDIVIDE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEFLOORDIVIDE);
        members[HPyContextMember.CTX_INPLACETRUEDIVIDE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACETRUEDIVIDE);
        members[HPyContextMember.CTX_INPLACEREMAINDER.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEREMAINDER);
        members[HPyContextMember.CTX_INPLACEPOWER.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEPOWER);
        members[HPyContextMember.CTX_INPLACELSHIFT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACELSHIFT);
        members[HPyContextMember.CTX_INPLACERSHIFT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACERSHIFT);
        members[HPyContextMember.CTX_INPLACEAND.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEAND);
        members[HPyContextMember.CTX_INPLACEXOR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEXOR);
        members[HPyContextMember.CTX_INPLACEOR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_INPLACEOR);
        members[HPyContextMember.CTX_CALLABLE_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CALLABLE_CHECK);
        members[HPyContextMember.CTX_CALLTUPLEDICT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CALLTUPLEDICT);
        members[HPyContextMember.CTX_CALL.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CALL);
        members[HPyContextMember.CTX_CALLMETHOD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CALLMETHOD);
        members[HPyContextMember.CTX_FATALERROR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FATALERROR);
        members[HPyContextMember.CTX_ERR_SETSTRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_SETSTRING);
        members[HPyContextMember.CTX_ERR_SETOBJECT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_SETOBJECT);
        members[HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAME.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAME);
        members[HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAMEOBJECTS.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAMEOBJECTS);
        members[HPyContextMember.CTX_ERR_OCCURRED.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_OCCURRED);
        members[HPyContextMember.CTX_ERR_EXCEPTIONMATCHES.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_EXCEPTIONMATCHES);
        members[HPyContextMember.CTX_ERR_NOMEMORY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_NOMEMORY);
        members[HPyContextMember.CTX_ERR_CLEAR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_CLEAR);
        members[HPyContextMember.CTX_ERR_NEWEXCEPTION.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_NEWEXCEPTION);
        members[HPyContextMember.CTX_ERR_NEWEXCEPTIONWITHDOC.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_NEWEXCEPTIONWITHDOC);
        members[HPyContextMember.CTX_ERR_WARNEX.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_WARNEX);
        members[HPyContextMember.CTX_ERR_WRITEUNRAISABLE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ERR_WRITEUNRAISABLE);
        members[HPyContextMember.CTX_ISTRUE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ISTRUE);
        members[HPyContextMember.CTX_TYPE_FROMSPEC.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPE_FROMSPEC);
        members[HPyContextMember.CTX_TYPE_GENERICNEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPE_GENERICNEW);
        members[HPyContextMember.CTX_GETATTR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GETATTR);
        members[HPyContextMember.CTX_GETATTR_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GETATTR_S);
        members[HPyContextMember.CTX_HASATTR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_HASATTR);
        members[HPyContextMember.CTX_HASATTR_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_HASATTR_S);
        members[HPyContextMember.CTX_SETATTR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SETATTR);
        members[HPyContextMember.CTX_SETATTR_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SETATTR_S);
        members[HPyContextMember.CTX_GETITEM.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GETITEM);
        members[HPyContextMember.CTX_GETITEM_I.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GETITEM_I);
        members[HPyContextMember.CTX_GETITEM_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GETITEM_S);
        members[HPyContextMember.CTX_CONTAINS.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CONTAINS);
        members[HPyContextMember.CTX_SETITEM.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SETITEM);
        members[HPyContextMember.CTX_SETITEM_I.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SETITEM_I);
        members[HPyContextMember.CTX_SETITEM_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SETITEM_S);
        members[HPyContextMember.CTX_DELITEM.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DELITEM);
        members[HPyContextMember.CTX_DELITEM_I.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DELITEM_I);
        members[HPyContextMember.CTX_DELITEM_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DELITEM_S);
        members[HPyContextMember.CTX_TYPE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPE);
        members[HPyContextMember.CTX_TYPECHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPECHECK);
        members[HPyContextMember.CTX_TYPE_GETNAME.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPE_GETNAME);
        members[HPyContextMember.CTX_TYPE_ISSUBTYPE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPE_ISSUBTYPE);
        members[HPyContextMember.CTX_IS.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_IS);
        members[HPyContextMember.CTX_ASSTRUCT_OBJECT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_OBJECT);
        members[HPyContextMember.CTX_ASSTRUCT_LEGACY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_LEGACY);
        members[HPyContextMember.CTX_ASSTRUCT_TYPE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_TYPE);
        members[HPyContextMember.CTX_ASSTRUCT_LONG.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_LONG);
        members[HPyContextMember.CTX_ASSTRUCT_FLOAT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_FLOAT);
        members[HPyContextMember.CTX_ASSTRUCT_UNICODE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_UNICODE);
        members[HPyContextMember.CTX_ASSTRUCT_TUPLE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_TUPLE);
        members[HPyContextMember.CTX_ASSTRUCT_LIST.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASSTRUCT_LIST);
        members[HPyContextMember.CTX_TYPE_GETBUILTINSHAPE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TYPE_GETBUILTINSHAPE);
        members[HPyContextMember.CTX_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_NEW);
        members[HPyContextMember.CTX_REPR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_REPR);
        members[HPyContextMember.CTX_STR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_STR);
        members[HPyContextMember.CTX_ASCII.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASCII);
        members[HPyContextMember.CTX_BYTES.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES);
        members[HPyContextMember.CTX_RICHCOMPARE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_RICHCOMPARE);
        members[HPyContextMember.CTX_RICHCOMPAREBOOL.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_RICHCOMPAREBOOL);
        members[HPyContextMember.CTX_HASH.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_HASH);
        members[HPyContextMember.CTX_BYTES_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_CHECK);
        members[HPyContextMember.CTX_BYTES_SIZE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_SIZE);
        members[HPyContextMember.CTX_BYTES_GET_SIZE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_GET_SIZE);
        members[HPyContextMember.CTX_BYTES_ASSTRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_ASSTRING);
        members[HPyContextMember.CTX_BYTES_AS_STRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_AS_STRING);
        members[HPyContextMember.CTX_BYTES_FROMSTRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_FROMSTRING);
        members[HPyContextMember.CTX_BYTES_FROMSTRINGANDSIZE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_BYTES_FROMSTRINGANDSIZE);
        members[HPyContextMember.CTX_UNICODE_FROMSTRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_FROMSTRING);
        members[HPyContextMember.CTX_UNICODE_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_CHECK);
        members[HPyContextMember.CTX_UNICODE_ASASCIISTRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_ASASCIISTRING);
        members[HPyContextMember.CTX_UNICODE_ASLATIN1STRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_ASLATIN1STRING);
        members[HPyContextMember.CTX_UNICODE_ASUTF8STRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_ASUTF8STRING);
        members[HPyContextMember.CTX_UNICODE_ASUTF8ANDSIZE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_ASUTF8ANDSIZE);
        members[HPyContextMember.CTX_UNICODE_FROMWIDECHAR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_FROMWIDECHAR);
        members[HPyContextMember.CTX_UNICODE_DECODEFSDEFAULT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_DECODEFSDEFAULT);
        members[HPyContextMember.CTX_UNICODE_DECODEFSDEFAULTANDSIZE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_DECODEFSDEFAULTANDSIZE);
        members[HPyContextMember.CTX_UNICODE_ENCODEFSDEFAULT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_ENCODEFSDEFAULT);
        members[HPyContextMember.CTX_UNICODE_READCHAR.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_READCHAR);
        members[HPyContextMember.CTX_UNICODE_DECODEASCII.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_DECODEASCII);
        members[HPyContextMember.CTX_UNICODE_DECODELATIN1.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_DECODELATIN1);
        members[HPyContextMember.CTX_UNICODE_FROMENCODEDOBJECT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_FROMENCODEDOBJECT);
        members[HPyContextMember.CTX_UNICODE_SUBSTRING.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_UNICODE_SUBSTRING);
        members[HPyContextMember.CTX_LIST_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LIST_CHECK);
        members[HPyContextMember.CTX_LIST_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LIST_NEW);
        members[HPyContextMember.CTX_LIST_APPEND.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LIST_APPEND);
        members[HPyContextMember.CTX_DICT_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DICT_CHECK);
        members[HPyContextMember.CTX_DICT_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DICT_NEW);
        members[HPyContextMember.CTX_DICT_KEYS.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DICT_KEYS);
        members[HPyContextMember.CTX_DICT_COPY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DICT_COPY);
        members[HPyContextMember.CTX_TUPLE_CHECK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TUPLE_CHECK);
        members[HPyContextMember.CTX_TUPLE_FROMARRAY.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TUPLE_FROMARRAY);
        members[HPyContextMember.CTX_SLICE_UNPACK.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SLICE_UNPACK);
        members[HPyContextMember.CTX_IMPORT_IMPORTMODULE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_IMPORT_IMPORTMODULE);
        members[HPyContextMember.CTX_CAPSULE_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CAPSULE_NEW);
        members[HPyContextMember.CTX_CAPSULE_GET.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CAPSULE_GET);
        members[HPyContextMember.CTX_CAPSULE_ISVALID.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CAPSULE_ISVALID);
        members[HPyContextMember.CTX_CAPSULE_SET.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CAPSULE_SET);
        members[HPyContextMember.CTX_FROMPYOBJECT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FROMPYOBJECT);
        members[HPyContextMember.CTX_ASPYOBJECT.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_ASPYOBJECT);
        members[HPyContextMember.CTX_LISTBUILDER_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LISTBUILDER_NEW);
        members[HPyContextMember.CTX_LISTBUILDER_SET.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LISTBUILDER_SET);
        members[HPyContextMember.CTX_LISTBUILDER_BUILD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LISTBUILDER_BUILD);
        members[HPyContextMember.CTX_LISTBUILDER_CANCEL.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LISTBUILDER_CANCEL);
        members[HPyContextMember.CTX_TUPLEBUILDER_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TUPLEBUILDER_NEW);
        members[HPyContextMember.CTX_TUPLEBUILDER_SET.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TUPLEBUILDER_SET);
        members[HPyContextMember.CTX_TUPLEBUILDER_BUILD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TUPLEBUILDER_BUILD);
        members[HPyContextMember.CTX_TUPLEBUILDER_CANCEL.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TUPLEBUILDER_CANCEL);
        members[HPyContextMember.CTX_TRACKER_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TRACKER_NEW);
        members[HPyContextMember.CTX_TRACKER_ADD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TRACKER_ADD);
        members[HPyContextMember.CTX_TRACKER_FORGETALL.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TRACKER_FORGETALL);
        members[HPyContextMember.CTX_TRACKER_CLOSE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_TRACKER_CLOSE);
        members[HPyContextMember.CTX_FIELD_STORE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FIELD_STORE);
        members[HPyContextMember.CTX_FIELD_LOAD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_FIELD_LOAD);
        members[HPyContextMember.CTX_REENTERPYTHONEXECUTION.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_REENTERPYTHONEXECUTION);
        members[HPyContextMember.CTX_LEAVEPYTHONEXECUTION.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_LEAVEPYTHONEXECUTION);
        members[HPyContextMember.CTX_GLOBAL_STORE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GLOBAL_STORE);
        members[HPyContextMember.CTX_GLOBAL_LOAD.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_GLOBAL_LOAD);
        members[HPyContextMember.CTX_DUMP.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_DUMP);
        members[HPyContextMember.CTX_COMPILE_S.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_COMPILE_S);
        members[HPyContextMember.CTX_EVALCODE.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_EVALCODE);
        members[HPyContextMember.CTX_CONTEXTVAR_NEW.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CONTEXTVAR_NEW);
        members[HPyContextMember.CTX_CONTEXTVAR_GET.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CONTEXTVAR_GET);
        members[HPyContextMember.CTX_CONTEXTVAR_SET.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_CONTEXTVAR_SET);
        members[HPyContextMember.CTX_SETCALLFUNCTION.ordinal()] = GraalHPyLLVMContext.createContextFunction(HPyContextMember.CTX_SETCALLFUNCTION);
        return members;
    }

    @CompilerDirectives.TruffleBoundary
    public static int getIndex(String key) {
        HPyContextMember member;
        if (contextMembersByName == null) {
            HashMap<String, HPyContextMember> contextMemberHashMap = new HashMap<String, HPyContextMember>();
            for (HPyContextMember member2 : HPyContextMember.VALUES) {
                contextMemberHashMap.put(member2.getName(), member2);
            }
            contextMembersByName = contextMemberHashMap;
        }
        return (member = contextMembersByName.get(key)) == null ? -1 : member.ordinal();
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        Object[] names = new String[HPyContextMember.VALUES.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = HPyContextMember.VALUES[i].getName();
        }
        return new PythonAbstractObject.Keys(names);
    }

    @ExportMessage
    Object readMember(String key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="readMemberNode") @Cached GraalHPyReadMemberNode readMemberNode) {
        return readMemberNode.execute(inliningTarget, this, key);
    }

    @ExportMessage
    boolean hasNativeType() {
        return true;
    }

    @ExportMessage
    Object getNativeType() {
        return this.hpyContextNativeTypeID;
    }

    @ExportMessage
    boolean isMemberInvocable(String key, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="readMemberNode") @Cached GraalHPyReadMemberNode readMemberNode, @Cached.Shared(value="memberInvokeLib") @CachedLibrary(limit="1") InteropLibrary memberInvokeLib) {
        Object member = readMemberNode.execute(inliningTarget, this, key);
        return member != null && memberInvokeLib.isExecutable(member);
    }

    @ExportMessage
    Object invokeMember(String key, Object[] args, @Bind(value="$node") Node inliningTarget, @Cached.Shared(value="readMemberNode") @Cached GraalHPyReadMemberNode readMemberNode, @Cached.Shared(value="memberInvokeLib") @CachedLibrary(limit="1") InteropLibrary memberInvokeLib) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
        Object member = readMemberNode.execute(inliningTarget, this, key);
        assert (member != null);
        args[0] = this.context;
        return memberInvokeLib.execute(member, args);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class HPyExecuteWrapper
    implements TruffleObject {
        final HPyContextMember member;

        HPyExecuteWrapper(HPyContextMember member) {
            this.member = member;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached HPyExecuteContextFunction call) throws ArityException {
            return call.execute(inliningTarget, this.member, arguments);
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class HPyExecuteWrapperTraceUpcall
    implements TruffleObject {
        private final int[] counts;
        private final int index;
        final HPyExecuteWrapper delegate;

        public HPyExecuteWrapperTraceUpcall(int[] counts, int index, HPyExecuteWrapper delegate) {
            this.counts = counts;
            this.index = index;
            this.delegate = delegate;
        }

        @ExportMessage
        boolean isExecutable() {
            return true;
        }

        @ExportMessage
        Object execute(Object[] arguments, @CachedLibrary(value="this.delegate") InteropLibrary lib) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
            int n = this.index;
            this.counts[n] = this.counts[n] + 1;
            return lib.execute((Object)this.delegate, arguments);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={GraalHPyLLVMContext.class})
    static abstract class GraalHPyReadMemberNode
    extends Node {
        GraalHPyReadMemberNode() {
        }

        public abstract Object execute(Node var1, GraalHPyLLVMContext var2, String var3);

        @Specialization(guards={"cachedKey == key"}, limit="1")
        static Object doMemberCached(GraalHPyLLVMContext backend, String key, @Cached(value="key") String cachedKey, @Cached(value="getIndex(key)") int cachedIdx) {
            Object value;
            if (cachedIdx != -1 && (value = backend.hpyContextMembers[cachedIdx]) != null) {
                return value;
            }
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw CompilerDirectives.shouldNotReachHere((String)PythonUtils.formatJString("context function %s not yet implemented: ", key));
        }

        @Specialization(replaces={"doMemberCached"})
        static Object doMember(GraalHPyLLVMContext backend, String key) {
            return GraalHPyReadMemberNode.doMemberCached(backend, key, key, GraalHPyLLVMContext.getIndex(key));
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class HPyExecuteContextFunction
    extends Node {
        HPyExecuteContextFunction() {
        }

        public abstract Object execute(Node var1, HPyContextMember var2, Object[] var3) throws ArityException;

        @Specialization(guards={"member == cachedMember"}, limit="1")
        static Object doCached(Node inliningTarget, HPyContextMember member, Object[] arguments, @Cached(value="member") HPyContextMember cachedMember, @Cached(parameters={"member"}) GraalHPyContextFunctions.GraalHPyContextFunction contextFunctionNode, @Cached(value="createRetNode(member)") CExtToNativeNode retNode, @Cached(value="createArgNodes(member)") CExtAsPythonObjectNode[] argNodes, @Cached GraalHPyNodes.HPyTransformExceptionToNativeNode transformExceptionToNativeNode) throws ArityException {
            HPyExecuteContextFunction.checkArity(arguments, cachedMember.getSignature().parameterTypes().length);
            try {
                try {
                    Object[] argCast;
                    if (argNodes != null) {
                        argCast = new Object[argNodes.length];
                        HPyExecuteContextFunction.castArguments(arguments, argCast, argNodes);
                    } else {
                        argCast = arguments;
                    }
                    Object result = contextFunctionNode.execute(argCast);
                    if (retNode != null) {
                        result = retNode.execute(result);
                    }
                    return result;
                }
                catch (Throwable t) {
                    throw GraalHPyNativeContext.checkThrowableBeforeNative(t, "HPy context function", cachedMember.getName());
                }
            }
            catch (PException e) {
                transformExceptionToNativeNode.execute(e);
                return HPyExecuteContextFunction.getErrorValue(inliningTarget, cachedMember.getSignature().returnType());
            }
        }

        @Specialization(replaces={"doCached"})
        @CompilerDirectives.TruffleBoundary
        static Object doUncached(Node inliningTarget, HPyContextMember member, Object[] arguments) throws ArityException {
            return HPyExecuteContextFunction.doCached(inliningTarget, member, arguments, member, GraalHPyContextFunctions.GraalHPyContextFunction.getUncached(member), HPyExecuteContextFunction.getUncachedRetNode(member), HPyExecuteContextFunction.getUncachedArgNodes(member), GraalHPyNodesFactory.HPyTransformExceptionToNativeNodeGen.getUncached());
        }

        private static void checkArity(Object[] arguments, int expectedArity) throws ArityException {
            if (arguments.length != expectedArity) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw ArityException.create((int)expectedArity, (int)expectedArity, (int)arguments.length);
            }
        }

        @ExplodeLoop
        private static void castArguments(Object[] arguments, Object[] argCast, CExtAsPythonObjectNode[] argNodes) {
            for (int i = 0; i < argNodes.length; ++i) {
                argCast[i] = argNodes[i] == null ? arguments[i] : argNodes[i].execute(arguments[i]);
            }
        }

        private static Object getErrorValue(Node inliningTarget, HPyContextSignatureType type) {
            return switch (type) {
                case HPyContextSignatureType.Int, HPyContextSignatureType.Int32_t, HPyContextSignatureType.Uint32_t, HPyContextSignatureType.HPy_UCS4 -> -1;
                case HPyContextSignatureType.Int64_t, HPyContextSignatureType.Uint64_t, HPyContextSignatureType.Size_t, HPyContextSignatureType.HPy_ssize_t, HPyContextSignatureType.HPy_hash_t -> -1L;
                case HPyContextSignatureType.CDouble -> -1.0;
                case HPyContextSignatureType.HPy -> GraalHPyHandle.NULL_HANDLE;
                case HPyContextSignatureType.VoidPtr, HPyContextSignatureType.CharPtr, HPyContextSignatureType.ConstCharPtr, HPyContextSignatureType.Cpy_PyObjectPtr -> PythonContext.get(inliningTarget).getNativeNull().getPtr();
                case HPyContextSignatureType.CVoid -> PNone.NO_VALUE;
                default -> throw CompilerDirectives.shouldNotReachHere((String)"unsupported return type");
            };
        }

        static CExtToNativeNode createRetNode(HPyContextMember member) {
            return switch (member.getSignature().returnType()) {
                case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState -> GraalHPyNodesFactory.HPyAsHandleNodeGen.create();
                case HPyContextSignatureType.HPy_ssize_t, HPyContextSignatureType.HPy_hash_t -> GraalHPyNodesFactory.HPyAsNativeInt64NodeGen.create();
                default -> null;
            };
        }

        static CExtToNativeNode getUncachedRetNode(HPyContextMember member) {
            return switch (member.getSignature().returnType()) {
                case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState -> GraalHPyNodesFactory.HPyAsHandleNodeGen.getUncached();
                case HPyContextSignatureType.HPy_ssize_t, HPyContextSignatureType.HPy_hash_t -> GraalHPyNodesFactory.HPyAsNativeInt64NodeGen.getUncached();
                default -> null;
            };
        }

        private static boolean noArgumentConversion(HPyContextMember member) {
            return switch (member) {
                case HPyContextMember.CTX_CLOSE, HPyContextMember.CTX_TRACKER_ADD -> true;
                default -> false;
            };
        }

        static CExtAsPythonObjectNode[] createArgNodes(HPyContextMember member) {
            if (HPyExecuteContextFunction.noArgumentConversion(member)) {
                return null;
            }
            HPyContextSignatureType[] argTypes = member.getSignature().parameterTypes();
            CExtAsPythonObjectNode[] argNodes = new CExtAsPythonObjectNode[argTypes.length];
            for (int i = 0; i < argNodes.length; ++i) {
                argNodes[i] = switch (argTypes[i]) {
                    case HPyContextSignatureType.HPyContextPtr -> GraalHPyNodesFactory.HPyAsContextNodeGen.create();
                    case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState -> GraalHPyNodesFactory.HPyAsPythonObjectNodeGen.create();
                    default -> GraalHPyNodes.HPyDummyToJavaNode.getUncached();
                };
            }
            return argNodes;
        }

        static CExtAsPythonObjectNode[] getUncachedArgNodes(HPyContextMember member) {
            if (HPyExecuteContextFunction.noArgumentConversion(member)) {
                return null;
            }
            HPyContextSignatureType[] argTypes = member.getSignature().parameterTypes();
            CExtAsPythonObjectNode[] argNodes = new CExtAsPythonObjectNode[argTypes.length];
            for (int i = 0; i < argNodes.length; ++i) {
                argNodes[i] = switch (argTypes[i]) {
                    case HPyContextSignatureType.HPyContextPtr -> GraalHPyNodesFactory.HPyAsContextNodeGen.getUncached();
                    case HPyContextSignatureType.HPy, HPyContextSignatureType.HPyThreadState -> GraalHPyNodesFactory.HPyAsPythonObjectNodeGen.getUncached();
                    default -> GraalHPyNodes.HPyDummyToJavaNode.getUncached();
                };
            }
            return argNodes;
        }
    }

    @ExportMessage
    @ImportStatic(value={GraalHPyLLVMContext.class})
    static class IsMemberReadable {
        IsMemberReadable() {
        }

        @Specialization(guards={"cachedKey.equals(key)"}, limit="1")
        static boolean isMemberReadableCached(GraalHPyLLVMContext context, String key, @Cached(value="key") String cachedKey, @Cached(value="getIndex(key)") int cachedIdx) {
            return cachedIdx != -1;
        }

        @Specialization(replaces={"isMemberReadableCached"})
        static boolean isMemberReadable(GraalHPyLLVMContext context, String key) {
            return GraalHPyLLVMContext.getIndex(key) != -1;
        }
    }
}

