/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaUnsignedLongNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class BufferStorageNodes {

    @ImportStatic(value={BufferFormat.class, PGuards.class})
    public static abstract class PackValueNode
    extends Node {
        @Node.Child
        private PRaiseNode raiseNode;

        public abstract void execute(VirtualFrame var1, BufferFormat var2, Object var3, byte[] var4, int var5);

        @Specialization(guards={"format == UINT_8"})
        void packUnsignedByteInt(BufferFormat format, int value, byte[] bytes, int offset) {
            if (value < 0 || value > 255) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            bytes[offset] = (byte)value;
        }

        @Specialization(guards={"format == UINT_8"}, replaces={"packUnsignedByteInt"})
        void packUnsignedByteGeneric(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < 0 || value > 255) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            bytes[offset] = (byte)value;
        }

        @Specialization(guards={"format == INT_8"}, replaces={"packUnsignedByteInt"})
        void packSignedByteGeneric(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < -128 || value > 127) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            bytes[offset] = (byte)value;
        }

        @Specialization(guards={"format == INT_16"})
        void packSignedShortGeneric(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < Short.MIN_VALUE || value > Short.MAX_VALUE) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            PythonUtils.ARRAY_ACCESSOR.putShort(bytes, offset, (short)value);
        }

        @Specialization(guards={"format == UINT_16"})
        void packUnsignedShortGeneric(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            int value = asSizeNode.executeExact((Frame)frame, inliningTarget, object);
            if (value < 0 || value > 65535) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            PythonUtils.ARRAY_ACCESSOR.putShort(bytes, offset, (short)value);
        }

        @Specialization(guards={"format == INT_32"})
        static void packSignedIntInt(BufferFormat format, int value, byte[] bytes, int offset) {
            PythonUtils.ARRAY_ACCESSOR.putInt(bytes, offset, value);
        }

        @Specialization(guards={"format == INT_32"}, replaces={"packSignedIntInt"})
        void packSignedIntGeneric(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberAsSizeNode asSizeNode) {
            PythonUtils.ARRAY_ACCESSOR.putInt(bytes, offset, asSizeNode.executeExact((Frame)frame, inliningTarget, object));
        }

        @Specialization(guards={"format == UINT_32"}, replaces={"packSignedIntInt"})
        void packUnsignedIntGeneric(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached CastToJavaLongExactNode castToLong) {
            long value = castToLong.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, object));
            if (value < 0L || value > 0xFFFFFFFFL) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            PythonUtils.ARRAY_ACCESSOR.putInt(bytes, offset, (int)value);
        }

        @Specialization(guards={"format == INT_64"})
        static void packSignedLong(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached CastToJavaLongExactNode castToLong) {
            PythonUtils.ARRAY_ACCESSOR.putLong(bytes, offset, castToLong.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, object)));
        }

        @Specialization(guards={"format == UINT_64"})
        static void packUnsignedLong(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PyNumberIndexNode indexNode, @Cached CastToJavaUnsignedLongNode castToUnsignedLong) {
            PythonUtils.ARRAY_ACCESSOR.putLong(bytes, offset, castToUnsignedLong.execute(inliningTarget, indexNode.execute((Frame)frame, inliningTarget, object)));
        }

        @Specialization(guards={"format == FLOAT"})
        static void packFloat(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            PythonUtils.ARRAY_ACCESSOR.putInt(bytes, offset, Float.floatToRawIntBits((float)asDoubleNode.execute(frame, inliningTarget, object)));
        }

        @Specialization(guards={"format == DOUBLE"})
        static void packDouble(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyFloatAsDoubleNode asDoubleNode) {
            PythonUtils.ARRAY_ACCESSOR.putLong(bytes, offset, Double.doubleToRawLongBits(asDoubleNode.execute(frame, inliningTarget, object)));
        }

        @Specialization(guards={"format == BOOLEAN"})
        static void packBoolean(VirtualFrame frame, BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrue) {
            bytes[offset] = isTrue.execute((Frame)frame, inliningTarget, object) ? (byte)1 : 0;
        }

        @Specialization(guards={"format == CHAR"}, limit="1")
        void packChar(BufferFormat format, PBytes object, byte[] bytes, int offset, @CachedLibrary(value="object") PythonBufferAccessLibrary bufferLib) {
            if (bufferLib.getBufferLength(object) != 1) {
                throw this.raise(PythonBuiltinClassType.OverflowError);
            }
            bytes[offset] = bufferLib.readByte(object, 0);
        }

        @Specialization(guards={"format == CHAR", "!isBytes(object)"})
        void packChar(BufferFormat format, Object object, byte[] bytes, int offset) {
            throw this.raise(PythonBuiltinClassType.TypeError);
        }

        @Specialization(guards={"format == UNICODE"})
        void packDouble(BufferFormat format, Object object, byte[] bytes, int offset, @Bind(value="this") Node inliningTarget, @Cached StringNodes.CastToTruffleStringCheckedNode cast, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            TruffleString str = cast.cast(inliningTarget, object, ErrorMessages.ARRAY_ITEM_MUST_BE_UNICODE, new Object[0]);
            if (codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING) != 1) {
                throw this.raise(PythonBuiltinClassType.TypeError);
            }
            int codePoint = codePointAtIndexNode.execute((AbstractTruffleString)str, 0, PythonUtils.TS_ENCODING);
            PythonUtils.ARRAY_ACCESSOR.putInt(bytes, offset, codePoint);
        }

        private PException raise(PythonBuiltinClassType type) {
            if (this.raiseNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
            }
            throw this.raiseNode.raise(type);
        }
    }

    @ImportStatic(value={BufferFormat.class})
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class UnpackValueNode
    extends Node {
        public abstract Object execute(Node var1, BufferFormat var2, byte[] var3, int var4);

        @Specialization(guards={"format == UINT_8"})
        static int unpackUnsignedByte(BufferFormat format, byte[] bytes, int offset) {
            return bytes[offset] & 0xFF;
        }

        @Specialization(guards={"format == INT_8"})
        static int unpackSignedByte(BufferFormat format, byte[] bytes, int offset) {
            return bytes[offset];
        }

        @Specialization(guards={"format == INT_16"})
        static int unpackSignedShort(BufferFormat format, byte[] bytes, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getShort(bytes, offset);
        }

        @Specialization(guards={"format == UINT_16"})
        static int unpackUnsignedShort(BufferFormat format, byte[] bytes, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getShort(bytes, offset) & 0xFFFF;
        }

        @Specialization(guards={"format == INT_32"})
        static int unpackSignedInt(BufferFormat format, byte[] bytes, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getInt(bytes, offset);
        }

        @Specialization(guards={"format == UINT_32"})
        static long unpackUnsignedInt(BufferFormat format, byte[] bytes, int offset) {
            return (long)PythonUtils.ARRAY_ACCESSOR.getInt(bytes, offset) & 0xFFFFFFFFL;
        }

        @Specialization(guards={"format == INT_64"})
        static long unpackSignedLong(BufferFormat format, byte[] bytes, int offset) {
            return PythonUtils.ARRAY_ACCESSOR.getLong(bytes, offset);
        }

        @Specialization(guards={"format == UINT_64"})
        static Object unpackUnsignedLong(Node inliningTarget, BufferFormat format, byte[] bytes, int offset, @Cached InlinedConditionProfile needsPIntProfile, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            long signedLong = PythonUtils.ARRAY_ACCESSOR.getLong(bytes, offset);
            if (needsPIntProfile.profile(inliningTarget, signedLong < 0L)) {
                return factory.createInt(PInt.longToUnsignedBigInteger(signedLong));
            }
            return signedLong;
        }

        @Specialization(guards={"format == FLOAT"})
        static double unpackFloat(BufferFormat format, byte[] bytes, int offset) {
            return Float.intBitsToFloat(PythonUtils.ARRAY_ACCESSOR.getInt(bytes, offset));
        }

        @Specialization(guards={"format == DOUBLE"})
        static double unpackDouble(BufferFormat format, byte[] bytes, int offset) {
            return Double.longBitsToDouble(PythonUtils.ARRAY_ACCESSOR.getLong(bytes, offset));
        }

        @Specialization(guards={"format == BOOLEAN"})
        static boolean unpackBoolean(BufferFormat format, byte[] bytes, int offset) {
            return bytes[offset] != 0;
        }

        @Specialization(guards={"format == CHAR"})
        static PBytes unpackChar(BufferFormat format, byte[] bytes, int offset, @Cached.Shared(value="factory") @Cached(inline=false) PythonObjectFactory factory) {
            return factory.createBytes(new byte[]{bytes[offset]});
        }

        @Specialization(guards={"format == UNICODE"})
        static TruffleString unpackUnicode(Node inliningTarget, BufferFormat format, byte[] bytes, int offset, @Cached PRaiseNode.Lazy raiseNode, @Cached(inline=false) TruffleString.FromCodePointNode fromCodePointNode) {
            int codePoint = PythonUtils.ARRAY_ACCESSOR.getInt(bytes, offset);
            if (!Character.isValidCodePoint(codePoint)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNMAPPABLE_CHARACTER);
            }
            return fromCodePointNode.execute(codePoint, PythonUtils.TS_ENCODING, true);
        }
    }
}

