/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.builtins.objects.contextvars.Hamt;
import com.oracle.graal.python.builtins.objects.contextvars.HamtIterator;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsContext;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;

public final class PContextIterator
extends PythonBuiltinObject {
    private final ItemKind kind;
    private final HamtIterator it;

    public PContextIterator(Object cls, Shape instanceShape, PContextVarsContext ctx, ItemKind kind) {
        super(cls, instanceShape);
        this.it = new HamtIterator(ctx.contextVarValues);
        this.kind = kind;
    }

    public Object next(PythonObjectFactory factory) {
        Hamt.Entry item = this.it.next();
        return item == null ? null : this.kind.apply(item, factory);
    }

    public static enum ItemKind {
        KEYS,
        VALUES,
        ITEMS;


        public Object apply(Hamt.Entry item, PythonObjectFactory factory) {
            switch (this) {
                case KEYS: {
                    return item.key;
                }
                case VALUES: {
                    return item.value;
                }
                case ITEMS: {
                    return factory.createTuple(new Object[]{item.key, item.value});
                }
            }
            throw CompilerDirectives.shouldNotReachHere((String)"null ItemKind in PHamtIterator");
        }
    }
}

