/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.SyntaxErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyLongAsLongAndOverflowNode;
import com.oracle.graal.python.lib.PyLongCheckExactNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.builtins.TupleNodes;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.SyntaxError, PythonBuiltinClassType.IndentationError, PythonBuiltinClassType.TabError})
public final class SyntaxErrorBuiltins
extends PythonBuiltins {
    public static final int IDX_MSG = 0;
    public static final int IDX_FILENAME = 1;
    public static final int IDX_LINENO = 2;
    public static final int IDX_OFFSET = 3;
    public static final int IDX_TEXT = 4;
    public static final int IDX_END_LINENO = 5;
    public static final int IDX_END_OFFSET = 6;
    public static final int IDX_PRINT_FILE_AND_LINE = 7;
    public static final int SYNTAX_ERR_NUM_ATTRS = 8;
    public static final BaseExceptionAttrNode.StorageFactory SYNTAX_ERROR_ATTR_FACTORY = (args, factory) -> new Object[8];

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SyntaxErrorBuiltinsFactory.getFactories();
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class SyntaxErrorStrNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        TruffleString str(VirtualFrame frame, PBaseException self, @Bind(value="this") Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached CastToTruffleStringNode castToStringNode, @Cached PyLongAsLongAndOverflowNode pyLongAsLongAndOverflowNode, @Cached PyLongCheckExactNode pyLongCheckExactNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.LastIndexOfStringNode lastIndexOfStringNode, @Cached TruffleString.SubstringNode substringNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            TruffleString result;
            TruffleString filename;
            Object filenameAttrValue = attrNode.get(self, 1, SYNTAX_ERROR_ATTR_FACTORY);
            if (filenameAttrValue != PNone.NONE && PGuards.isString(filenameAttrValue)) {
                filename = castToStringNode.execute(inliningTarget, self.getExceptionAttribute(1));
                filename = this.getLastPathElement(filename, fromJavaStringNode, codePointLengthNode, lastIndexOfStringNode, substringNode);
            } else {
                filename = null;
            }
            Object lineno = attrNode.get(self, 2, SYNTAX_ERROR_ATTR_FACTORY);
            Object msg = attrNode.get(self, 0, SYNTAX_ERROR_ATTR_FACTORY);
            boolean heaveLineNo = lineno != PNone.NONE && pyLongCheckExactNode.execute(inliningTarget, lineno);
            TruffleString msgStr = strNode.execute((Frame)frame, inliningTarget, msg);
            if (filename == null && !heaveLineNo) {
                return msgStr;
            }
            if (filename != null && heaveLineNo) {
                long ln;
                try {
                    ln = pyLongAsLongAndOverflowNode.execute((Frame)frame, inliningTarget, lineno);
                }
                catch (OverflowException e) {
                    ln = -1L;
                }
                result = simpleTruffleStringFormatNode.format("%s (%s, line %d)", msgStr, filename, ln);
            } else if (filename != null) {
                result = simpleTruffleStringFormatNode.format("%s (%s)", msgStr, filename);
            } else {
                long ln;
                try {
                    ln = pyLongAsLongAndOverflowNode.execute((Frame)frame, inliningTarget, lineno);
                }
                catch (OverflowException e) {
                    ln = -1L;
                }
                result = simpleTruffleStringFormatNode.format("%s (line %d)", msgStr, ln);
            }
            return result;
        }

        TruffleString getLastPathElement(TruffleString path, TruffleString.FromJavaStringNode fromJavaStringNode, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.LastIndexOfStringNode lastIndexOfStringNode, TruffleString.SubstringNode substringNode) {
            int len = codePointLengthNode.execute((AbstractTruffleString)path, PythonUtils.TS_ENCODING);
            TruffleString sep = fromJavaStringNode.execute(this.getContext().getEnv().getFileNameSeparator(), PythonUtils.TS_ENCODING);
            int sepIdx = lastIndexOfStringNode.execute((AbstractTruffleString)path, (AbstractTruffleString)sep, len, 0, PythonUtils.TS_ENCODING);
            if (sepIdx < 0) {
                return path;
            }
            return substringNode.execute((AbstractTruffleString)path, sepIdx + 1, len - sepIdx - 1, PythonUtils.TS_ENCODING, true);
        }
    }

    @Builtin(name="print_file_and_line", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception print_file_and_line")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorPrintFileAndLineNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 7, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="end_offset", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception end offset")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorEndColumnNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 6, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="end_lineno", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception end lineno")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorEndLineNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 5, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="text", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception text")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorTextNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 4, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="offset", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception offset")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorOffsetNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 3, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="lineno", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception lineno")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorLinenoNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 2, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="filename", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception filename")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorFilenameNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 1, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="msg", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception msg")
    @GenerateNodeFactory
    public static abstract class SyntaxErrorMsgNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, SYNTAX_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class SyntaxErrorInitNode
    extends PythonBuiltinNode {
        private static final String PREFIX_PRINT = "print ";
        private static final String PREFIX_EXEC = "exec ";
        private static final char CHR_LEFTPAREN = '(';
        private static final char CHR_COLON = ':';
        private static final char CHR_COMMA = ',';
        private static final char CHR_SEMICOLON = ';';

        @CompilerDirectives.TruffleBoundary
        private static String getLegacyPrintStatementMsg(String text) {
            int endPos = text.indexOf(59);
            if (endPos == -1) {
                endPos = text.length();
            }
            String data = text.substring(PREFIX_PRINT.length(), endPos).trim();
            int textLen = data.length();
            String maybeEndArg = "";
            if (textLen > 0 && data.charAt(textLen - 1) == ',') {
                maybeEndArg = " end=\" \"";
            }
            return String.format(ErrorMessages.MISSING_PARENTHESES_IN_CALL_TO_PRINT.toJavaStringUncached(), data, maybeEndArg);
        }

        @CompilerDirectives.TruffleBoundary
        private static Object checkForLegacyStatements(String text, int start) {
            String trimmedText = SyntaxErrorInitNode.trimLeft(text, start);
            if (trimmedText.isEmpty()) {
                return null;
            }
            if (text.startsWith(PREFIX_PRINT)) {
                return SyntaxErrorInitNode.getLegacyPrintStatementMsg(trimmedText);
            }
            if (text.startsWith(PREFIX_EXEC)) {
                return ErrorMessages.MISSING_PARENTHESES_IN_CALL_TO_EXEC;
            }
            return null;
        }

        @CompilerDirectives.TruffleBoundary
        private static Object reportMissingParentheses(Object msg, String text) {
            int colonIndex;
            int leftParenIndex = text.indexOf(40);
            if (leftParenIndex != -1) {
                return msg;
            }
            Object rv = SyntaxErrorInitNode.checkForLegacyStatements(text, 0);
            if (rv == null && (colonIndex = text.indexOf(58)) >= 0 && colonIndex < text.length()) {
                rv = SyntaxErrorInitNode.checkForLegacyStatements(text, colonIndex + 1);
            }
            return rv != null ? rv : msg;
        }

        @CompilerDirectives.TruffleBoundary(allowInlining=true)
        private static String trimLeft(String str, int start) {
            int st;
            int len = str.length();
            for (st = start; st < len && str.charAt(st) <= ' '; ++st) {
            }
            return str.substring(st);
        }

        @Specialization
        Object init(VirtualFrame frame, PBaseException self, Object[] args, @Cached CastToJavaStringNode castToJavaStringNode, @Cached TupleNodes.ConstructTupleNode constructTupleNode, @Cached SequenceStorageNodes.GetItemNode getItemNode, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseExceptionInitNode) {
            baseExceptionInitNode.execute(self, args);
            Object[] attrs = SYNTAX_ERROR_ATTR_FACTORY.create();
            if (args.length >= 1) {
                attrs[0] = args[0];
            }
            if (args.length == 2) {
                PTuple info = constructTupleNode.execute(frame, args[1]);
                SequenceStorage storage = info.getSequenceStorage();
                if (storage.length() != 4) {
                    throw this.raise(PythonBuiltinClassType.IndexError, ErrorMessages.TUPLE_OUT_OF_BOUNDS);
                }
                attrs[1] = getItemNode.execute(storage, 0);
                attrs[2] = getItemNode.execute(storage, 1);
                attrs[3] = getItemNode.execute(storage, 2);
                attrs[4] = getItemNode.execute(storage, 3);
                if (PGuards.isString(attrs[4])) {
                    attrs[0] = SyntaxErrorInitNode.reportMissingParentheses(attrs[0], castToJavaStringNode.execute(attrs[4]));
                }
            }
            self.setExceptionAttributes(attrs);
            return PNone.NONE;
        }
    }
}

